/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionUtils {
    public static <E> Collection<List<E>> selectUpTo(List<E> original, int nb) {
        ArrayList<List<E>> result = new ArrayList<List<E>>();
        for (int i = 1; i <= nb; ++i) {
            result.addAll(CollectionUtils.selectExactly(original, i));
        }
        return Collections.unmodifiableList(result);
    }

    public static <E> Collection<List<E>> selectExactly(List<E> original, int nb) {
        if (nb < 0) {
            throw new IllegalArgumentException();
        }
        if (nb == 0) {
            return Collections.emptyList();
        }
        if (nb == 1) {
            ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>();
            for (E element : original) {
                result.add(Collections.singletonList(element));
            }
            return result;
        }
        if (nb > original.size()) {
            return Collections.emptyList();
        }
        if (nb == original.size()) {
            return Collections.singletonList(original);
        }
        ArrayList<List<E>> result = new ArrayList<List<E>>();
        for (List<E> subList : CollectionUtils.selectExactly(original.subList(1, original.size()), nb - 1)) {
            ArrayList<E> newList = new ArrayList<E>();
            newList.add(original.get(0));
            newList.addAll(subList);
            result.add(Collections.unmodifiableList(newList));
        }
        result.addAll(CollectionUtils.selectExactly(original.subList(1, original.size()), nb));
        return Collections.unmodifiableList(result);
    }
}

