/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public enum HorizontalAlignment {
    LEFT,
    CENTER,
    RIGHT;


    public static HorizontalAlignment fromString(String s) {
        if (LEFT.name().equalsIgnoreCase(s)) {
            return LEFT;
        }
        if (CENTER.name().equalsIgnoreCase(s)) {
            return CENTER;
        }
        if (RIGHT.name().equalsIgnoreCase(s)) {
            return RIGHT;
        }
        return null;
    }

    public static HorizontalAlignment fromString(String s, HorizontalAlignment defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException();
        }
        if (s == null) {
            return defaultValue;
        }
        HorizontalAlignment result = HorizontalAlignment.fromString(s = StringUtils.goUpperCase(s));
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getGraphVizValue() {
        return this.toString().substring(0, 1).toLowerCase();
    }

    public void draw(UGraphic ug, TextBlock tb, double padding, Dimension2D dimTotal) {
        if (this == LEFT) {
            tb.drawU(ug.apply(new UTranslate(padding, padding)));
        } else if (this == RIGHT) {
            Dimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimTb.getWidth() - padding, padding)));
        } else if (this == CENTER) {
            Dimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate((dimTotal.getWidth() - dimTb.getWidth()) / 2.0, padding)));
        }
    }
}

