/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Node;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.ShapePseudoImpl;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class Cluster
implements Moveable {
    private static final String RANK_SAME = "same";
    private static final String RANK_SOURCE = "source";
    private static final String RANK_SINK = "sink";
    private static final String ID_EE = "ee";
    public static final String CENTER_ID = "za";
    private final Cluster parentCluster;
    private final IGroup group;
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleAndAttributeWidth;
    private int titleAndAttributeHeight;
    private TextBlock ztitle;
    private TextBlock zstereo;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private ColorParam border;

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.xTitle += deltaX;
        this.minX += deltaX;
        this.maxX += deltaX;
        this.yTitle += deltaY;
        this.minY += deltaY;
        this.maxY += deltaY;
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (Node sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    public Cluster(ColorSequence colorSequence, ISkinParam skinParam, IGroup root) {
        this(null, colorSequence, skinParam, root);
    }

    private Cluster(Cluster parentCluster, ColorSequence colorSequence, ISkinParam skinParam, IGroup group) {
        if (group == null) {
            throw new IllegalStateException();
        }
        this.parentCluster = parentCluster;
        this.group = group;
        if (group.getUSymbol() != null) {
            this.border = group.getUSymbol().getColorParamBorder();
        }
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = group.getColors(skinParam).mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParentCluster() {
        return this.parentCluster;
    }

    public void addNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.nodes.add(node);
        node.setCluster(this);
    }

    public final List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    private List<Node> getNodesOrderedTop(Collection<Line> lines) {
        ArrayList<Node> firsts = new ArrayList<Node>();
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, Node> shs = new HashMap<String, Node>();
        for (Node node : this.nodes) {
            shs.put(node.getUid(), node);
            if (!node.isTop() || node.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(node);
            tops.add(node.getUid());
        }
        for (Line l : lines) {
            Node sh;
            if (tops.contains(l.getStartUidPrefix()) && (sh = (Node)shs.get(l.getEndUidPrefix())) != null && sh.getEntityPosition() == EntityPosition.NORMAL) {
                firsts.add(0, sh);
            }
            if (!l.isInverted() || (sh = (Node)shs.get(l.getStartUidPrefix())) == null || sh.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(0, sh);
        }
        return firsts;
    }

    private List<Node> getNodesOrderedWithoutTop(Collection<Line> lines) {
        ArrayList<Node> all = new ArrayList<Node>(this.nodes);
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, Node> shs = new HashMap<String, Node>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            Node sh = (Node)it.next();
            if (sh.getEntityPosition() != EntityPosition.NORMAL) {
                it.remove();
                continue;
            }
            shs.put(sh.getUid(), sh);
            if (!sh.isTop()) continue;
            tops.add(sh.getUid());
            it.remove();
        }
        for (Line l : lines) {
            Node sh;
            if (tops.contains(l.getStartUidPrefix()) && (sh = (Node)shs.get(l.getEndUidPrefix())) != null) {
                all.remove(sh);
            }
            if (!l.isInverted() || (sh = (Node)shs.get(l.getStartUidPrefix())) == null) continue;
            all.remove(sh);
        }
        return all;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo, ColorSequence colorSequence, ISkinParam skinParam, IGroup g) {
        Cluster child = new Cluster(this, colorSequence, skinParam, g);
        child.titleAndAttributeWidth = titleAndAttributeWidth;
        child.titleAndAttributeHeight = titleAndAttributeHeight;
        child.ztitle = title;
        child.zstereo = stereo;
        this.children.add(child);
        return child;
    }

    public final Set<IGroup> getGroups() {
        return Collections.singleton(this.group);
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void setTitlePosition(double x, double y) {
        this.xTitle = x;
        this.yTitle = y;
    }

    private static HColor getColor(ColorParam colorParam, ISkinParam skinParam, Stereotype stereotype) {
        return SkinParamUtils.getColor(skinParam, stereotype, colorParam);
    }

    public static StyleSignature getDefaultStyleDefinition(SName styleName) {
        return StyleSignature.of(SName.root, SName.element, styleName, SName.group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, UStroke strokeForState, UmlDiagramType umlDiagramType, ISkinParam skinParam2) {
        HColor borderColor;
        if (this.group.isHidden()) {
            return;
        }
        String fullName = this.group.getCodeGetName();
        if (!fullName.startsWith("##")) {
            ug.draw(new UComment("cluster " + fullName));
        }
        Stereotype stereotype = this.group.getStereotype();
        if (UseStyle.useBetaStyle()) {
            Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(skinParam2.getIHtmlColorSet());
        } else {
            borderColor = umlDiagramType == UmlDiagramType.STATE ? Cluster.getColor(ColorParam.stateBorder, this.skinParam, stereotype) : (umlDiagramType == UmlDiagramType.ACTIVITY ? Cluster.getColor(ColorParam.packageBorder, this.skinParam, stereotype) : Cluster.getColor(ColorParam.packageBorder, this.skinParam, stereotype));
        }
        Url url = this.group.getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        try {
            UStroke stroke;
            double shadowing;
            HColor tmp;
            boolean isState;
            if (this.entityPositionsExceptNormal().size() > 0) {
                this.manageEntryExitPoint(ug.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(umlDiagramType)) {
                this.drawSwinLinesState(ug, borderColor);
                return;
            }
            boolean bl = isState = umlDiagramType == UmlDiagramType.STATE;
            if (isState) {
                if (this.group.getColors(this.skinParam).getSpecificLineStroke() != null) {
                    strokeForState = this.group.getColors(this.skinParam).getSpecificLineStroke();
                }
                if (this.group.getColors(this.skinParam).getColor(ColorType.LINE) != null) {
                    borderColor = this.group.getColors(this.skinParam).getColor(ColorType.LINE);
                }
                this.drawUState(ug, borderColor, skinParam2, strokeForState, umlDiagramType);
                return;
            }
            PackageStyle packageStyle = this.group.getPackageStyle();
            if (packageStyle == null) {
                packageStyle = skinParam2.packageStyle();
            }
            if (this.border != null && (tmp = skinParam2.getHtmlColor(this.border, this.group.getStereotype(), false)) != null) {
                borderColor = tmp;
            }
            if (UseStyle.useBetaStyle()) {
                Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
                shadowing = style.value(PName.Shadowing).asDouble();
                stroke = style.getStroke();
            } else {
                shadowing = this.group.getUSymbol() == null ? (skinParam2.shadowing2(this.group.getStereotype(), USymbol.PACKAGE.getSkinParameter()) ? 3.0 : 0.0) : (skinParam2.shadowing2(this.group.getStereotype(), this.group.getUSymbol().getSkinParameter()) ? 3.0 : 0.0);
                stroke = this.getStrokeInternal(skinParam2);
            }
            HColor backColor = this.getBackColor(umlDiagramType);
            backColor = Cluster.getBackColor(backColor, skinParam2, this.group.getStereotype(), umlDiagramType.getStyleName());
            if (this.ztitle != null || this.zstereo != null) {
                double roundCorner = this.group.getUSymbol() == null ? 0.0 : this.group.getUSymbol().getSkinParameter().getRoundCorner(this.skinParam, stereotype);
                ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.ztitle, this.zstereo, this.minX, this.minY, this.maxX, this.maxY, stroke);
                decoration.drawU(ug, backColor, borderColor, shadowing, roundCorner, skinParam2.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false), skinParam2.getStereotypeAlignment());
                return;
            }
            URectangle rect = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
            rect.setDeltaShadow(shadowing);
            ug = ug.apply(backColor.bg()).apply(borderColor);
            ug.apply(new UStroke(2.0)).apply(new UTranslate(this.minX, this.minY)).draw(rect);
        }
        finally {
            if (url != null) {
                ug.closeUrl();
            }
        }
    }

    private UStroke getStrokeInternal(ISkinParam skinParam) {
        Colors colors = this.group.getColors(skinParam);
        if (colors.getSpecificLineStroke() != null) {
            return colors.getSpecificLineStroke();
        }
        if (this.group.getUSymbol() != null && this.group.getUSymbol() != USymbol.PACKAGE) {
            return this.group.getUSymbol().getSkinParameter().getStroke(skinParam, this.group.getStereotype());
        }
        return GeneralImageBuilder.getForcedStroke(this.group.getStereotype(), skinParam);
    }

    public void manageEntryExitPoint(StringBounder stringBounder) {
        ArrayList<ClusterPosition> insides = new ArrayList<ClusterPosition>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Node sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) {
                insides.add(sh.getClusterPosition());
                continue;
            }
            points.add(sh.getClusterPosition().getPointCenter());
        }
        for (Cluster in : this.children) {
            insides.add(in.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), insides, points);
        if (this.titleAndAttributeHeight > 0 && this.titleAndAttributeWidth > 0) {
            frontierCalculator.ensureMinWidth(this.titleAndAttributeWidth + 10);
        }
        ClusterPosition forced = frontierCalculator.getSuggestedPosition();
        this.xTitle += (forced.getMinX() - this.minX + (forced.getMaxX() - this.maxX)) / 2.0;
        this.minX = forced.getMinX();
        this.minY = forced.getMinY();
        this.maxX = forced.getMaxX();
        this.maxY = forced.getMaxY();
        this.yTitle = this.minY + 5.0;
        double widthTitle = this.ztitle.calculateDimension(stringBounder).getWidth();
        this.xTitle = this.minX + (this.maxX - this.minX - widthTitle) / 2.0;
    }

    private void drawSwinLinesState(UGraphic ug, HColor borderColor) {
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(UTranslate.dx(this.xTitle)));
        }
        ULine line = ULine.vline(this.maxY - this.minY);
        ug = ug.apply(borderColor);
        ug.apply(UTranslate.dx(this.minX)).draw(line);
        ug.apply(UTranslate.dx(this.maxX)).draw(line);
    }

    private HColor getColor(ISkinParam skinParam, ColorParam colorParam, Stereotype stereo) {
        return new Rose().getHtmlColor(skinParam, stereo, colorParam);
    }

    private void drawUState(UGraphic ug, HColor borderColor, ISkinParam skinParam2, UStroke stroke, UmlDiagramType umlDiagramType) {
        Stereotype stereotype;
        boolean withSymbol;
        Dimension2DDouble total = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double suppY = this.ztitle == null ? 0.0 : this.ztitle.calculateDimension(ug.getStringBounder()).getHeight() + 5.0 + 5.0;
        HColor stateBack = this.getBackColor(umlDiagramType);
        if (stateBack == null) {
            stateBack = this.getColor(skinParam2, ColorParam.stateBackground, this.group.getStereotype());
        }
        HColor background = this.getColor(skinParam2, ColorParam.background, null);
        Style style = this.getStyle(FontParam.STATE_ATTRIBUTE, skinParam2);
        TextBlock attribute = GeneralImageBuilder.stateHeader(this.group, style, skinParam2);
        double attributeHeight = attribute.calculateDimension(ug.getStringBounder()).getHeight();
        if (((Dimension2D)total).getWidth() == 0.0) {
            System.err.println("Cluster::drawUState issue");
            return;
        }
        RoundedContainer r = new RoundedContainer(total, suppY, attributeHeight + (double)(attributeHeight > 0.0 ? 5 : 0), borderColor, stateBack, background, stroke);
        r.drawU(ug.apply(new UTranslate(this.minX, this.minY)), skinParam2.shadowing(this.group.getStereotype()));
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(new UTranslate(this.xTitle, this.yTitle)));
        }
        if (attributeHeight > 0.0) {
            attribute.drawU(ug.apply(new UTranslate(this.minX + 5.0, this.minY + suppY + 2.5)));
        }
        boolean bl = withSymbol = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (withSymbol) {
            EntityImageState.drawSymbol(ug.apply(borderColor), this.maxX, this.maxY);
        }
    }

    public void setPosition(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    private Style getStyle(FontParam fontParam, ISkinParam skinParam) {
        return fontParam.getStyleDefinition(SName.stateDiagram).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    private boolean isThereALinkFromOrToGroup(Collection<Line> lines) {
        for (Line line : lines) {
            if (!line.isLinkFromOrTo(this.group)) continue;
            return true;
        }
        return false;
    }

    public void printCluster1(StringBuilder sb, Collection<Line> lines, StringBounder stringBounder) {
        for (Node node : this.getNodesOrderedTop(lines)) {
            node.appendShape(sb, stringBounder);
        }
    }

    private List<IShapePseudo> addProtection(List<? extends IShapePseudo> entries, double width) {
        ArrayList<IShapePseudo> result = new ArrayList<IShapePseudo>();
        result.add(entries.get(0));
        for (int i = 1; i < entries.size(); ++i) {
            result.add(new ShapePseudoImpl("psd" + UniqueSequence.getValue(), width, 5.0));
            result.add(entries.get(i));
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(List<? extends IShapePseudo> entries, StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (IShapePseudo iShapePseudo : entries) {
            double w = this.getMaxWidthFromLabelForEntryExit(iShapePseudo, stringBounder);
            if (!(w > result)) continue;
            result = w;
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(IShapePseudo node, StringBounder stringBounder) {
        return node.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    /*
     * WARNING - void declaration
     */
    private void printRanks(String rank, List<? extends IShapePseudo> entries, StringBuilder sb, StringBounder stringBounder) {
        if (entries.size() > 0) {
            sb.append("{rank=" + rank + ";");
            for (IShapePseudo iShapePseudo : entries) {
                sb.append(iShapePseudo.getUid() + ";");
            }
            sb.append("}");
            SvekUtils.println(sb);
            for (IShapePseudo iShapePseudo : entries) {
                iShapePseudo.appendShape(sb, stringBounder);
            }
            SvekUtils.println(sb);
            if (this.hasPort()) {
                void var6_11;
                boolean arrow = false;
                Object var6_10 = null;
                for (IShapePseudo iShapePseudo : entries) {
                    if (arrow) {
                        sb.append("->");
                    }
                    arrow = true;
                    String string = iShapePseudo.getUid();
                    sb.append(string);
                }
                sb.append(';');
                SvekUtils.println(sb);
                sb.append((String)var6_11 + "->" + this.empty() + ";");
                SvekUtils.println(sb);
            }
        }
    }

    private List<? extends IShapePseudo> withPositionProtected(StringBounder stringBounder, Set<EntityPosition> targets) {
        List<Node> result = this.withPosition(targets);
        double maxWith = this.getMaxWidthFromLabelForEntryExit(result, stringBounder);
        double naturalSpace = 70.0;
        if (maxWith > 70.0) {
            return this.addProtection(result, maxWith - 70.0);
        }
        return result;
    }

    private List<Node> withPosition(Set<EntityPosition> positions) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node sh : this.nodes) {
            if (!positions.contains((Object)sh.getEntityPosition())) continue;
            result.add(sh);
        }
        return result;
    }

    private void printClusterEntryExit(StringBuilder sb, StringBounder stringBounder) {
        this.printRanks(RANK_SOURCE, this.withPositionProtected(stringBounder, EntityPosition.getInputs()), sb, stringBounder);
        this.printRanks(RANK_SAME, this.withPositionProtected(stringBounder, EntityPosition.getSame()), sb, stringBounder);
        this.printRanks(RANK_SINK, this.withPositionProtected(stringBounder, EntityPosition.getOutputs()), sb, stringBounder);
    }

    public Node printCluster2(StringBuilder sb, Collection<Line> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        Node added = null;
        for (Node node : this.getNodesOrderedWithoutTop(lines)) {
            node.appendShape(sb, stringBounder);
            added = node;
        }
        if (this.skinParam.useRankSame() && dotMode != DotMode.NO_LEFT_RIGHT_AND_XLABEL && !graphvizVersion.ignoreHorizontalLinks()) {
            this.appendRankSame(sb, lines);
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        return added;
    }

    private void appendRankSame(StringBuilder sb, Collection<Line> lines) {
        for (String same : this.getRankSame(lines)) {
            sb.append(same);
            SvekUtils.println(sb);
        }
    }

    private Set<String> getRankSame(Collection<Line> lines) {
        HashSet<String> rankSame = new HashSet<String>();
        for (Line l : lines) {
            String same;
            if (l.hasEntryPoint()) continue;
            String startUid = l.getStartUidPrefix();
            String endUid = l.getEndUidPrefix();
            if (!this.isInCluster(startUid) || !this.isInCluster(endUid) || (same = l.rankSame()) == null) continue;
            rankSame.add(same);
        }
        return rankSame;
    }

    public void fillRankMin(Set<String> rankMin) {
        for (Node sh : this.getNodes()) {
            if (!sh.isTop()) continue;
            rankMin.add(sh.getUid());
        }
        for (Cluster child : this.getChildren()) {
            child.fillRankMin(rankMin);
        }
    }

    private boolean isInCluster(String uid) {
        for (Node node : this.nodes) {
            if (!node.getUid().equals(uid)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public static String getSpecialPointId(IEntity group) {
        return CENTER_ID + group.getUid();
    }

    private boolean protection0(UmlDiagramType type) {
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean protection1(UmlDiagramType type) {
        if (this.group.getUSymbol() == USymbol.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(type);
    }

    public String getMinPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder sb, Collection<Line> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        String label;
        Set<EntityPosition> entityPositionsExceptNormal;
        boolean thereALinkFromOrToGroup2;
        boolean thereALinkFromOrToGroup1 = thereALinkFromOrToGroup2 = this.isThereALinkFromOrToGroup(lines);
        boolean useProtectionWhenThereALinkFromOrToGroup = graphvizVersion.useProtectionWhenThereALinkFromOrToGroup();
        if (!useProtectionWhenThereALinkFromOrToGroup) {
            thereALinkFromOrToGroup1 = false;
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "a");
        }
        if ((entityPositionsExceptNormal = this.entityPositionsExceptNormal()).size() > 0) {
            for (Line line : lines) {
                if (!line.isLinkFromOrTo(this.group)) continue;
                line.setProjectionCluster(this);
            }
        }
        boolean protection0 = this.protection0(type);
        boolean protection1 = this.protection1(type);
        if (entityPositionsExceptNormal.size() > 0 || !useProtectionWhenThereALinkFromOrToGroup) {
            protection0 = false;
            protection1 = false;
        }
        if (protection0) {
            this.subgraphClusterNoLabel(sb, "p0");
        }
        sb.append("subgraph " + this.getClusterId() + " {");
        sb.append("style=solid;");
        sb.append("color=\"" + DotStringFactory.sharp000000(this.color) + "\";");
        if (this.isLabel()) {
            StringBuilder sblabel = new StringBuilder("<");
            Line.appendTable(sblabel, this.getTitleAndAttributeWidth(), this.getTitleAndAttributeHeight() - 5, this.colorTitle);
            sblabel.append(">");
            label = sblabel.toString();
            HorizontalAlignment align = this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false);
            sb.append("labeljust=\"" + align.getGraphVizValue() + "\";");
        } else {
            label = "\"\"";
        }
        if (entityPositionsExceptNormal.size() > 0) {
            this.printClusterEntryExit(sb, stringBounder);
            if (this.hasPort()) {
                this.subgraphClusterNoLabel(sb, ID_EE);
            } else {
                this.subgraphClusterWithLabel(sb, ID_EE, label);
            }
        } else {
            sb.append("label=" + label + ";");
            SvekUtils.println(sb);
        }
        if (thereALinkFromOrToGroup2) {
            sb.append(Cluster.getSpecialPointId(this.group) + " [shape=point,width=.01,label=\"\"];");
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "i");
        }
        if (protection1) {
            this.subgraphClusterNoLabel(sb, "p1");
        }
        if (this.skinParam.useSwimlanes(type)) {
            sb.append("{rank = source; ");
            sb.append(this.getSourceInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append(this.getMinPoint(type) + "->" + this.getSourceInPoint(type) + "  [weight=999];");
            sb.append("}");
            SvekUtils.println(sb);
            sb.append("{rank = sink; ");
            sb.append(this.getSinkInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append("}");
            sb.append(this.getSinkInPoint(type) + "->" + this.getMaxPoint(type) + "  [weight=999];");
            SvekUtils.println(sb);
        }
        SvekUtils.println(sb);
        this.printCluster1(sb, lines, stringBounder);
        Node added = this.printCluster2(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        if (entityPositionsExceptNormal.size() > 0) {
            if (this.hasPort()) {
                sb.append(this.empty() + " [shape=rect,width=.01,height=.01,label=");
                sb.append(label);
                sb.append("];");
            } else if (added == null) {
                sb.append(this.empty() + " [shape=point,width=.01,label=\"\"];");
            }
            SvekUtils.println(sb);
        }
        sb.append("}");
        if (protection1) {
            sb.append("}");
        }
        if (thereALinkFromOrToGroup1) {
            sb.append("}");
            sb.append("}");
        }
        if (entityPositionsExceptNormal.size() > 0) {
            sb.append("}");
        }
        if (protection0) {
            sb.append("}");
        }
        SvekUtils.println(sb);
    }

    private boolean hasPort() {
        for (EntityPosition pos : this.entityPositionsExceptNormal()) {
            if (!pos.isPort()) continue;
            return true;
        }
        return false;
    }

    private String empty() {
        return Cluster.getSpecialPointId(this.group);
    }

    public boolean isLabel() {
        return this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
    }

    private void subgraphClusterNoLabel(StringBuilder sb, String id) {
        this.subgraphClusterWithLabel(sb, id, "\"\"");
    }

    private void subgraphClusterWithLabel(StringBuilder sb, String id, String label) {
        sb.append("subgraph " + this.getClusterId() + id + " {");
        sb.append("label=" + label + ";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HColor getBackColor(UmlDiagramType umlDiagramType) {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HColor result = this.group.getColors(this.skinParam).getColor(ColorType.BACK);
        if (result != null) {
            return result;
        }
        Stereotype stereo = this.group.getStereotype();
        USymbol sym = this.group.getUSymbol() == null ? USymbol.PACKAGE : this.group.getUSymbol();
        ColorParam backparam = umlDiagramType == UmlDiagramType.ACTIVITY ? ColorParam.partitionBackground : sym.getColorParamBack();
        HColor c1 = this.skinParam.getHtmlColor(backparam, stereo, false);
        if (c1 != null) {
            return c1;
        }
        if (this.parentCluster == null) {
            return null;
        }
        return this.parentCluster.getBackColor(umlDiagramType);
    }

    public boolean isClusterOf(IEntity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        return this.group == ent;
    }

    public static HColor getBackColor(HColor backColor, ISkinParam skinParam, Stereotype stereotype, SName styleName) {
        if (UseStyle.useBetaStyle()) {
            Style style = Cluster.getDefaultStyleDefinition(styleName).getMergedStyle(skinParam.getCurrentStyleBuilder());
            if (backColor == null) {
                backColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
            }
            if (backColor == null || backColor.equals(HColorUtils.transparent())) {
                backColor = new HColorBackground(skinParam.getBackgroundColor(false));
            }
            return backColor;
        }
        if (backColor == null) {
            backColor = skinParam.getHtmlColor(ColorParam.packageBackground, stereotype, false);
        }
        if (backColor == null) {
            backColor = skinParam.getHtmlColor(ColorParam.background, stereotype, false);
        }
        if (backColor == null || backColor.equals(HColorUtils.transparent())) {
            HColor tmp = skinParam.getBackgroundColor(false);
            backColor = new HColorBackground(tmp);
        }
        return backColor;
    }

    public double checkFolderPosition(Point2D pt, StringBounder stringBounder) {
        if (this.getClusterPosition().isPointJustUpper(pt)) {
            if (this.ztitle == null) {
                return 0.0;
            }
            Dimension2D dimTitle = this.ztitle.calculateDimension(stringBounder);
            if (pt.getX() < this.getClusterPosition().getMinX() + dimTitle.getWidth()) {
                return 0.0;
            }
            return this.getClusterPosition().getMinY() - pt.getY() + dimTitle.getHeight();
        }
        return 0.0;
    }
}

