from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TColStd import *
from OCC.Core.GeomAbs import *
from OCC.Core.AdvApprox import *
from OCC.Core.Geom import *
from OCC.Core.gp import *
from OCC.Core.TColgp import *


class AdvApp2Var_SequenceOfNode:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AdvApp2Var_SequenceOfPatch:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AdvApp2Var_SequenceOfStrip:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> AdvApp2Var_Strip: ...
    def Last(self) -> AdvApp2Var_Strip: ...
    def Length(self) -> int: ...
    def Append(self, theItem: AdvApp2Var_Strip) -> AdvApp2Var_Strip: ...
    def Prepend(self, theItem: AdvApp2Var_Strip) -> AdvApp2Var_Strip: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> AdvApp2Var_Strip: ...
    def SetValue(self, theIndex: int, theValue: AdvApp2Var_Strip) -> None: ...

class AdvApp2Var_Strip:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class AdvApp2Var_CriterionRepartition(IntEnum):
	AdvApp2Var_Regular: int = ...
	AdvApp2Var_Incremental: int = ...
AdvApp2Var_Regular = AdvApp2Var_CriterionRepartition.AdvApp2Var_Regular
AdvApp2Var_Incremental = AdvApp2Var_CriterionRepartition.AdvApp2Var_Incremental

class AdvApp2Var_CriterionType(IntEnum):
	AdvApp2Var_Absolute: int = ...
	AdvApp2Var_Relative: int = ...
AdvApp2Var_Absolute = AdvApp2Var_CriterionType.AdvApp2Var_Absolute
AdvApp2Var_Relative = AdvApp2Var_CriterionType.AdvApp2Var_Relative

class AdvApp2Var_ApproxAFunc2Var:
	@overload
	def __init__(self, Num1DSS: int, Num2DSS: int, Num3DSS: int, OneDTol: TColStd_HArray1OfReal, TwoDTol: TColStd_HArray1OfReal, ThreeDTol: TColStd_HArray1OfReal, OneDTolFr: TColStd_HArray2OfReal, TwoDTolFr: TColStd_HArray2OfReal, ThreeDTolFr: TColStd_HArray2OfReal, FirstInU: float, LastInU: float, FirstInV: float, LastInV: float, FavorIso: GeomAbs_IsoType, ContInU: GeomAbs_Shape, ContInV: GeomAbs_Shape, PrecisCode: int, MaxDegInU: int, MaxDegInV: int, MaxPatch: int, Func: AdvApp2Var_EvaluatorFunc2Var, UChoice: AdvApprox_Cutting, VChoice: AdvApprox_Cutting) -> None: ...
	@overload
	def __init__(self, Num1DSS: int, Num2DSS: int, Num3DSS: int, OneDTol: TColStd_HArray1OfReal, TwoDTol: TColStd_HArray1OfReal, ThreeDTol: TColStd_HArray1OfReal, OneDTolFr: TColStd_HArray2OfReal, TwoDTolFr: TColStd_HArray2OfReal, ThreeDTolFr: TColStd_HArray2OfReal, FirstInU: float, LastInU: float, FirstInV: float, LastInV: float, FavorIso: GeomAbs_IsoType, ContInU: GeomAbs_Shape, ContInV: GeomAbs_Shape, PrecisCode: int, MaxDegInU: int, MaxDegInV: int, MaxPatch: int, Func: AdvApp2Var_EvaluatorFunc2Var, Crit: AdvApp2Var_Criterion, UChoice: AdvApprox_Cutting, VChoice: AdvApprox_Cutting) -> None: ...
	@overload
	def AverageError(self, Dimension: int) -> TColStd_HArray1OfReal: ...
	@overload
	def AverageError(self, Dimension: int, Index: int) -> float: ...
	def CritError(self, Dimension: int, Index: int) -> float: ...
	def HasResult(self) -> bool: ...
	def IsDone(self) -> bool: ...
	@overload
	def MaxError(self, Dimension: int) -> TColStd_HArray1OfReal: ...
	@overload
	def MaxError(self, Dimension: int, Index: int) -> float: ...
	def NumSubSpaces(self, Dimension: int) -> int: ...
	def Surface(self, Index: int) -> Geom_BSplineSurface: ...
	def UDegree(self) -> int: ...
	@overload
	def UFrontError(self, Dimension: int) -> TColStd_HArray1OfReal: ...
	@overload
	def UFrontError(self, Dimension: int, Index: int) -> float: ...
	def VDegree(self) -> int: ...
	@overload
	def VFrontError(self, Dimension: int) -> TColStd_HArray1OfReal: ...
	@overload
	def VFrontError(self, Dimension: int, Index: int) -> float: ...

class AdvApp2Var_ApproxF2var:
	pass

class AdvApp2Var_Context:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, ifav: int, iu: int, iv: int, nlimu: int, nlimv: int, iprecis: int, nb1Dss: int, nb2Dss: int, nb3Dss: int, tol1D: TColStd_HArray1OfReal, tol2D: TColStd_HArray1OfReal, tol3D: TColStd_HArray1OfReal, tof1D: TColStd_HArray2OfReal, tof2D: TColStd_HArray2OfReal, tof3D: TColStd_HArray2OfReal) -> None: ...
	def CToler(self) -> TColStd_HArray2OfReal: ...
	def FToler(self) -> TColStd_HArray2OfReal: ...
	def FavorIso(self) -> int: ...
	def IToler(self) -> TColStd_HArray1OfReal: ...
	def TotalDimension(self) -> int: ...
	def TotalNumberSSP(self) -> int: ...
	def UGauss(self) -> TColStd_HArray1OfReal: ...
	def UJacDeg(self) -> int: ...
	def UJacMax(self) -> TColStd_HArray1OfReal: ...
	def ULimit(self) -> int: ...
	def UOrder(self) -> int: ...
	def URoots(self) -> TColStd_HArray1OfReal: ...
	def VGauss(self) -> TColStd_HArray1OfReal: ...
	def VJacDeg(self) -> int: ...
	def VJacMax(self) -> TColStd_HArray1OfReal: ...
	def VLimit(self) -> int: ...
	def VOrder(self) -> int: ...
	def VRoots(self) -> TColStd_HArray1OfReal: ...

class AdvApp2Var_Criterion:
	def IsSatisfied(self, P: AdvApp2Var_Patch) -> bool: ...
	def MaxValue(self) -> float: ...
	def Repartition(self) -> AdvApp2Var_CriterionRepartition: ...
	def Type(self) -> AdvApp2Var_CriterionType: ...
	def Value(self, P: AdvApp2Var_Patch, C: AdvApp2Var_Context) -> None: ...

class AdvApp2Var_Data:
	@staticmethod
	def Getmaovpar() -> False: ...
	@staticmethod
	def Getmaovpch() -> False: ...
	@staticmethod
	def Getmdnombr() -> False: ...
	@staticmethod
	def Getminombr() -> False: ...
	@staticmethod
	def Getmlgdrtl() -> False: ...
	@staticmethod
	def Getmmapgs0() -> False: ...
	@staticmethod
	def Getmmapgs1() -> False: ...
	@staticmethod
	def Getmmapgs2() -> False: ...
	@staticmethod
	def Getmmapgss() -> False: ...
	@staticmethod
	def Getmmcmcnp() -> False: ...
	@staticmethod
	def Getmmjcobi() -> False: ...

class AdvApp2Var_Framework:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Frame: AdvApp2Var_SequenceOfNode, UFrontier: AdvApp2Var_SequenceOfStrip, VFrontier: AdvApp2Var_SequenceOfStrip) -> None: ...
	def ChangeIso(self, IndexIso: int, IndexStrip: int, anIso: AdvApp2Var_Iso) -> None: ...
	def FirstNode(self, Type: GeomAbs_IsoType, IndexIso: int, IndexStrip: int) -> int: ...
	def FirstNotApprox(self) -> Tuple[AdvApp2Var_Iso, int, int]: ...
	def IsoU(self, U: float, V0: float, V1: float) -> AdvApp2Var_Iso: ...
	def IsoV(self, U0: float, U1: float, V: float) -> AdvApp2Var_Iso: ...
	def LastNode(self, Type: GeomAbs_IsoType, IndexIso: int, IndexStrip: int) -> int: ...
	@overload
	def Node(self, IndexNode: int) -> AdvApp2Var_Node: ...
	@overload
	def Node(self, U: float, V: float) -> AdvApp2Var_Node: ...
	def UEquation(self, IndexIso: int, IndexStrip: int) -> TColStd_HArray1OfReal: ...
	def UpdateInU(self, CuttingValue: float) -> None: ...
	def UpdateInV(self, CuttingValue: float) -> None: ...
	def VEquation(self, IndexIso: int, IndexStrip: int) -> TColStd_HArray1OfReal: ...

class AdvApp2Var_MathBase:
	pass

class AdvApp2Var_Network:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Net: AdvApp2Var_SequenceOfPatch, TheU: TColStd_SequenceOfReal, TheV: TColStd_SequenceOfReal) -> None: ...
	def ChangePatch(self, Index: int) -> AdvApp2Var_Patch: ...
	def FirstNotApprox(self) -> Tuple[bool, int]: ...
	def NbPatch(self) -> int: ...
	def NbPatchInU(self) -> int: ...
	def NbPatchInV(self) -> int: ...
	def Patch(self, UIndex: int, VIndex: int) -> AdvApp2Var_Patch: ...
	def SameDegree(self, iu: int, iv: int) -> Tuple[int, int]: ...
	def UParameter(self, Index: int) -> float: ...
	def UpdateInU(self, CuttingValue: float) -> None: ...
	def UpdateInV(self, CuttingValue: float) -> None: ...
	def VParameter(self, Index: int) -> float: ...

class AdvApp2Var_Node(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, iu: int, iv: int) -> None: ...
	@overload
	def __init__(self, UV: gp_XY, iu: int, iv: int) -> None: ...
	def Coord(self) -> gp_XY: ...
	def Error(self, iu: int, iv: int) -> float: ...
	def Point(self, iu: int, iv: int) -> gp_Pnt: ...
	def SetCoord(self, x1: float, x2: float) -> None: ...
	def SetError(self, iu: int, iv: int, error: float) -> None: ...
	def SetPoint(self, iu: int, iv: int, Pt: gp_Pnt) -> None: ...
	def UOrder(self) -> int: ...
	def VOrder(self) -> int: ...

class AdvApp2Var_Patch(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, U0: float, U1: float, V0: float, V1: float, iu: int, iv: int) -> None: ...
	def AddConstraints(self, Conditions: AdvApp2Var_Context, Constraints: AdvApp2Var_Framework) -> None: ...
	def AddErrors(self, Constraints: AdvApp2Var_Framework) -> None: ...
	def AverageErrors(self) -> TColStd_HArray1OfReal: ...
	def ChangeDomain(self, a: float, b: float, c: float, d: float) -> None: ...
	def ChangeNbCoeff(self, NbCoeffU: int, NbCoeffV: int) -> None: ...
	def Coefficients(self, SSPIndex: int, Conditions: AdvApp2Var_Context) -> TColStd_HArray1OfReal: ...
	def CritValue(self) -> float: ...
	@overload
	def CutSense(self) -> int: ...
	@overload
	def CutSense(self, Crit: AdvApp2Var_Criterion, NumDec: int) -> int: ...
	def Discretise(self, Conditions: AdvApp2Var_Context, Constraints: AdvApp2Var_Framework, func: AdvApp2Var_EvaluatorFunc2Var) -> None: ...
	def HasResult(self) -> bool: ...
	def IsApproximated(self) -> bool: ...
	def IsDiscretised(self) -> bool: ...
	def IsoErrors(self) -> TColStd_HArray2OfReal: ...
	def MakeApprox(self, Conditions: AdvApp2Var_Context, Constraints: AdvApp2Var_Framework, NumDec: int) -> None: ...
	def MaxErrors(self) -> TColStd_HArray1OfReal: ...
	def NbCoeffInU(self) -> int: ...
	def NbCoeffInV(self) -> int: ...
	def OverwriteApprox(self) -> None: ...
	def Poles(self, SSPIndex: int, Conditions: AdvApp2Var_Context) -> TColgp_HArray2OfPnt: ...
	def ResetApprox(self) -> None: ...
	def SetCritValue(self, dist: float) -> None: ...
	def U0(self) -> float: ...
	def U1(self) -> float: ...
	def UOrder(self) -> int: ...
	def V0(self) -> float: ...
	def V1(self) -> float: ...
	def VOrder(self) -> int: ...

class AdvApp2Var_SysBase:
	def __init__(self) -> None: ...
	@staticmethod
	def do__fio() -> int: ...
	@staticmethod
	def do__lio() -> int: ...
	def mainial_(self) -> False: ...
	@staticmethod
	def mnfndeb_() -> int: ...

#classnotwrapped
class AdvApp2Var_EvaluatorFunc2Var: ...

#classnotwrapped
class AdvApp2Var_Iso: ...

# harray1 classes
# harray2 classes
# hsequence classes

AdvApp2Var_ApproxF2var_mma1her_ = AdvApp2Var_ApproxF2var.mma1her_
AdvApp2Var_ApproxF2var_mma2ac1_ = AdvApp2Var_ApproxF2var.mma2ac1_
AdvApp2Var_ApproxF2var_mma2ac2_ = AdvApp2Var_ApproxF2var.mma2ac2_
AdvApp2Var_ApproxF2var_mma2ac3_ = AdvApp2Var_ApproxF2var.mma2ac3_
AdvApp2Var_ApproxF2var_mma2can_ = AdvApp2Var_ApproxF2var.mma2can_
AdvApp2Var_ApproxF2var_mma2cdi_ = AdvApp2Var_ApproxF2var.mma2cdi_
AdvApp2Var_ApproxF2var_mma2ce1_ = AdvApp2Var_ApproxF2var.mma2ce1_
AdvApp2Var_ApproxF2var_mma2ds1_ = AdvApp2Var_ApproxF2var.mma2ds1_
AdvApp2Var_ApproxF2var_mma2fnc_ = AdvApp2Var_ApproxF2var.mma2fnc_
AdvApp2Var_ApproxF2var_mma2fx6_ = AdvApp2Var_ApproxF2var.mma2fx6_
AdvApp2Var_ApproxF2var_mma2jmx_ = AdvApp2Var_ApproxF2var.mma2jmx_
AdvApp2Var_ApproxF2var_mma2roo_ = AdvApp2Var_ApproxF2var.mma2roo_
AdvApp2Var_ApproxF2var_mmapptt_ = AdvApp2Var_ApproxF2var.mmapptt_
AdvApp2Var_Data_Getmaovpar = AdvApp2Var_Data.Getmaovpar
AdvApp2Var_Data_Getmaovpch = AdvApp2Var_Data.Getmaovpch
AdvApp2Var_Data_Getmdnombr = AdvApp2Var_Data.Getmdnombr
AdvApp2Var_Data_Getminombr = AdvApp2Var_Data.Getminombr
AdvApp2Var_Data_Getmlgdrtl = AdvApp2Var_Data.Getmlgdrtl
AdvApp2Var_Data_Getmmapgs0 = AdvApp2Var_Data.Getmmapgs0
AdvApp2Var_Data_Getmmapgs1 = AdvApp2Var_Data.Getmmapgs1
AdvApp2Var_Data_Getmmapgs2 = AdvApp2Var_Data.Getmmapgs2
AdvApp2Var_Data_Getmmapgss = AdvApp2Var_Data.Getmmapgss
AdvApp2Var_Data_Getmmcmcnp = AdvApp2Var_Data.Getmmcmcnp
AdvApp2Var_Data_Getmmjcobi = AdvApp2Var_Data.Getmmjcobi
AdvApp2Var_MathBase_mdsptpt_ = AdvApp2Var_MathBase.mdsptpt_
AdvApp2Var_MathBase_mmapcmp_ = AdvApp2Var_MathBase.mmapcmp_
AdvApp2Var_MathBase_mmaperx_ = AdvApp2Var_MathBase.mmaperx_
AdvApp2Var_MathBase_mmarcin_ = AdvApp2Var_MathBase.mmarcin_
AdvApp2Var_MathBase_mmbulld_ = AdvApp2Var_MathBase.mmbulld_
AdvApp2Var_MathBase_mmcdriv_ = AdvApp2Var_MathBase.mmcdriv_
AdvApp2Var_MathBase_mmcglc1_ = AdvApp2Var_MathBase.mmcglc1_
AdvApp2Var_MathBase_mmcvctx_ = AdvApp2Var_MathBase.mmcvctx_
AdvApp2Var_MathBase_mmcvinv_ = AdvApp2Var_MathBase.mmcvinv_
AdvApp2Var_MathBase_mmdrc11_ = AdvApp2Var_MathBase.mmdrc11_
AdvApp2Var_MathBase_mmdrvck_ = AdvApp2Var_MathBase.mmdrvck_
AdvApp2Var_MathBase_mmeps1_ = AdvApp2Var_MathBase.mmeps1_
AdvApp2Var_MathBase_mmfmca8_ = AdvApp2Var_MathBase.mmfmca8_
AdvApp2Var_MathBase_mmfmca9_ = AdvApp2Var_MathBase.mmfmca9_
AdvApp2Var_MathBase_mmfmcar_ = AdvApp2Var_MathBase.mmfmcar_
AdvApp2Var_MathBase_mmfmcb5_ = AdvApp2Var_MathBase.mmfmcb5_
AdvApp2Var_MathBase_mmfmtb1_ = AdvApp2Var_MathBase.mmfmtb1_
AdvApp2Var_MathBase_mmhjcan_ = AdvApp2Var_MathBase.mmhjcan_
AdvApp2Var_MathBase_mminltt_ = AdvApp2Var_MathBase.mminltt_
AdvApp2Var_MathBase_mmjacan_ = AdvApp2Var_MathBase.mmjacan_
AdvApp2Var_MathBase_mmjaccv_ = AdvApp2Var_MathBase.mmjaccv_
AdvApp2Var_MathBase_mmmpocur_ = AdvApp2Var_MathBase.mmmpocur_
AdvApp2Var_MathBase_mmmrslwd_ = AdvApp2Var_MathBase.mmmrslwd_
AdvApp2Var_MathBase_mmpobas_ = AdvApp2Var_MathBase.mmpobas_
AdvApp2Var_MathBase_mmpocrb_ = AdvApp2Var_MathBase.mmpocrb_
AdvApp2Var_MathBase_mmposui_ = AdvApp2Var_MathBase.mmposui_
AdvApp2Var_MathBase_mmresol_ = AdvApp2Var_MathBase.mmresol_
AdvApp2Var_MathBase_mmrtptt_ = AdvApp2Var_MathBase.mmrtptt_
AdvApp2Var_MathBase_mmsrre2_ = AdvApp2Var_MathBase.mmsrre2_
AdvApp2Var_MathBase_mmtrpjj_ = AdvApp2Var_MathBase.mmtrpjj_
AdvApp2Var_MathBase_mmunivt_ = AdvApp2Var_MathBase.mmunivt_
AdvApp2Var_MathBase_mmveps3_ = AdvApp2Var_MathBase.mmveps3_
AdvApp2Var_MathBase_mmvncol_ = AdvApp2Var_MathBase.mmvncol_
AdvApp2Var_MathBase_mmwprcs_ = AdvApp2Var_MathBase.mmwprcs_
AdvApp2Var_MathBase_msc_ = AdvApp2Var_MathBase.msc_
AdvApp2Var_MathBase_mvsheld_ = AdvApp2Var_MathBase.mvsheld_
AdvApp2Var_MathBase_mzsnorm_ = AdvApp2Var_MathBase.mzsnorm_
AdvApp2Var_MathBase_pow__di = AdvApp2Var_MathBase.pow__di
AdvApp2Var_SysBase_do__fio = AdvApp2Var_SysBase.do__fio
AdvApp2Var_SysBase_do__lio = AdvApp2Var_SysBase.do__lio
AdvApp2Var_SysBase_macinit_ = AdvApp2Var_SysBase.macinit_
AdvApp2Var_SysBase_maermsg_ = AdvApp2Var_SysBase.maermsg_
AdvApp2Var_SysBase_maitbr8_ = AdvApp2Var_SysBase.maitbr8_
AdvApp2Var_SysBase_maovsr8_ = AdvApp2Var_SysBase.maovsr8_
AdvApp2Var_SysBase_mcrfill_ = AdvApp2Var_SysBase.mcrfill_
AdvApp2Var_SysBase_mgenmsg_ = AdvApp2Var_SysBase.mgenmsg_
AdvApp2Var_SysBase_mgsomsg_ = AdvApp2Var_SysBase.mgsomsg_
AdvApp2Var_SysBase_miraz_ = AdvApp2Var_SysBase.miraz_
AdvApp2Var_SysBase_mnfndeb_ = AdvApp2Var_SysBase.mnfndeb_
AdvApp2Var_SysBase_msifill_ = AdvApp2Var_SysBase.msifill_
AdvApp2Var_SysBase_msrfill_ = AdvApp2Var_SysBase.msrfill_
AdvApp2Var_SysBase_mswrdbg_ = AdvApp2Var_SysBase.mswrdbg_
AdvApp2Var_SysBase_mvriraz_ = AdvApp2Var_SysBase.mvriraz_
