from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.IMeshData import *
from OCC.Core.gp import *
from OCC.Core.TopAbs import *
from OCC.Core.TopoDS import *


class BRepMeshData_Curve(IMeshData_Curve):
	def AddPoint(self, thePoint: gp_Pnt, theParamOnCurve: float) -> None: ...
	def Clear(self, isKeepEndPoints: bool) -> None: ...
	def GetParameter(self, theIndex: int) -> float: ...
	def GetPoint(self, theIndex: int) -> gp_Pnt: ...
	def InsertPoint(self, thePosition: int, thePoint: gp_Pnt, theParamOnPCurve: float) -> None: ...
	def ParametersNb(self) -> int: ...
	def RemovePoint(self, theIndex: int) -> None: ...

class BRepMeshData_Edge(IMeshData_Edge):
	@overload
	def GetPCurve(self, theIndex: int) -> False: ...
	def PCurvesNb(self) -> int: ...

class BRepMeshData_Face(IMeshData_Face):
	def AddWire(self, theWire: TopoDS_Wire, theEdgeNb: Optional[int] = 0) -> False: ...
	def GetWire(self, theIndex: int) -> False: ...
	def WiresNb(self) -> int: ...

class BRepMeshData_Model(IMeshData_Model):
	def __init__(self, theShape: TopoDS_Shape) -> None: ...
	def AddEdge(self, theEdge: TopoDS_Edge) -> False: ...
	def AddFace(self, theFace: TopoDS_Face) -> False: ...
	def EdgesNb(self) -> int: ...
	def FacesNb(self) -> int: ...
	def GetEdge(self, theIndex: int) -> False: ...
	def GetFace(self, theIndex: int) -> False: ...
	def GetMaxSize(self) -> float: ...
	def SetMaxSize(self, theValue: float) -> None: ...

class BRepMeshData_PCurve(IMeshData_PCurve):
	def AddPoint(self, thePoint: gp_Pnt2d, theParamOnPCurve: float) -> None: ...
	def Clear(self, isKeepEndPoints: bool) -> None: ...
	def GetIndex(self, theIndex: int) -> int: ...
	def GetParameter(self, theIndex: int) -> float: ...
	def GetPoint(self, theIndex: int) -> gp_Pnt2d: ...
	def InsertPoint(self, thePosition: int, thePoint: gp_Pnt2d, theParamOnPCurve: float) -> None: ...
	def ParametersNb(self) -> int: ...
	def RemovePoint(self, theIndex: int) -> None: ...

class BRepMeshData_Wire(IMeshData_Wire):
	def EdgesNb(self) -> int: ...
	def GetEdge(self, theIndex: int) -> False: ...
	def GetEdgeOrientation(self, theIndex: int) -> TopAbs_Orientation: ...

# harray1 classes
# harray2 classes
# hsequence classes

