/*
 * This declarations of the PIC12LF1612 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:05 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC12LF1612_H__
#define __PIC12LF1612_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define T2TMR_ADDR              0x001A
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2PR_ADDR               0x001B
#define T2CON_ADDR              0x001C
#define T2HLT_ADDR              0x001D
#define T2CLKCON_ADDR           0x001E
#define T2RST_ADDR              0x001F
#define TRISA_ADDR              0x008C
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DAC1CON0_ADDR           0x0118
#define DAC1CON1_ADDR           0x0119
#define ZCD1CON_ADDR            0x011C
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define WPUA_ADDR               0x020C
#define ODCONA_ADDR             0x028C
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCP1CAP_ADDR            0x0294
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define CCP2CAP_ADDR            0x029B
#define CCPTMRS_ADDR            0x029E
#define SLRCONA_ADDR            0x030C
#define INLVLA_ADDR             0x038C
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define T4TMR_ADDR              0x0413
#define TMR4_ADDR               0x0413
#define PR4_ADDR                0x0414
#define T4PR_ADDR               0x0414
#define T4CON_ADDR              0x0415
#define T4HLT_ADDR              0x0416
#define T4CLKCON_ADDR           0x0417
#define T4RST_ADDR              0x0418
#define T6TMR_ADDR              0x041A
#define TMR6_ADDR               0x041A
#define PR6_ADDR                0x041B
#define T6PR_ADDR               0x041B
#define T6CON_ADDR              0x041C
#define T6HLT_ADDR              0x041D
#define T6CLKCON_ADDR           0x041E
#define T6RST_ADDR              0x041F
#define CWG1DBR_ADDR            0x0691
#define CWG1DBF_ADDR            0x0692
#define CWG1AS0_ADDR            0x0693
#define CWG1AS1_ADDR            0x0694
#define CWG1OCON0_ADDR          0x0695
#define CWG1CON0_ADDR           0x0696
#define CWG1CON1_ADDR           0x0697
#define CWG1OCON1_ADDR          0x0698
#define CWG1CLKCON_ADDR         0x0699
#define CWG1ISM_ADDR            0x069A
#define WDTCON0_ADDR            0x0711
#define WDTCON1_ADDR            0x0712
#define WDTPSL_ADDR             0x0713
#define WDTPSH_ADDR             0x0714
#define WDTTMR_ADDR             0x0715
#define SCANLADR_ADDR           0x0718
#define SCANLADRL_ADDR          0x0718
#define SCANLADRH_ADDR          0x0719
#define SCANHADR_ADDR           0x071A
#define SCANHADRL_ADDR          0x071A
#define SCANHADRH_ADDR          0x071B
#define SCANCON0_ADDR           0x071C
#define SCANTRIG_ADDR           0x071D
#define CRCDAT_ADDR             0x0791
#define CRCDATL_ADDR            0x0791
#define CRCDATH_ADDR            0x0792
#define CRCACC_ADDR             0x0793
#define CRCACCL_ADDR            0x0793
#define CRCACCH_ADDR            0x0794
#define CRCSHIFT_ADDR           0x0795
#define CRCSHIFTL_ADDR          0x0795
#define CRCSHIFTH_ADDR          0x0796
#define CRCXOR_ADDR             0x0797
#define CRCXORL_ADDR            0x0797
#define CRCXORH_ADDR            0x0798
#define CRCCON0_ADDR            0x0799
#define CRCCON1_ADDR            0x079A
#define SMT1TMR_ADDR            0x0D8C
#define SMT1TMRL_ADDR           0x0D8C
#define SMT1TMRH_ADDR           0x0D8D
#define SMT1TMRU_ADDR           0x0D8E
#define SMT1CPR_ADDR            0x0D8F
#define SMT1CPRL_ADDR           0x0D8F
#define SMT1CPRH_ADDR           0x0D90
#define SMT1CPRU_ADDR           0x0D91
#define SMT1CPW_ADDR            0x0D92
#define SMT1CPWL_ADDR           0x0D92
#define SMT1CPWH_ADDR           0x0D93
#define SMT1CPWU_ADDR           0x0D94
#define SMT1PR_ADDR             0x0D95
#define SMT1PRL_ADDR            0x0D95
#define SMT1PRH_ADDR            0x0D96
#define SMT1PRU_ADDR            0x0D97
#define SMT1CON0_ADDR           0x0D98
#define SMT1CON1_ADDR           0x0D99
#define SMT1STAT_ADDR           0x0D9A
#define SMT1CLK_ADDR            0x0D9B
#define SMT1SIG_ADDR            0x0D9C
#define SMT1WIN_ADDR            0x0D9D
#define SMT2TMR_ADDR            0x0D9E
#define SMT2TMRL_ADDR           0x0D9E
#define SMT2TMRH_ADDR           0x0D9F
#define SMT2TMRU_ADDR           0x0DA0
#define SMT2CPR_ADDR            0x0DA1
#define SMT2CPRL_ADDR           0x0DA1
#define SMT2CPRH_ADDR           0x0DA2
#define SMT2CPRU_ADDR           0x0DA3
#define SMT2CPW_ADDR            0x0DA4
#define SMT2CPWL_ADDR           0x0DA4
#define SMT2CPWH_ADDR           0x0DA5
#define SMT2CPWU_ADDR           0x0DA6
#define SMT2PR_ADDR             0x0DA7
#define SMT2PRL_ADDR            0x0DA7
#define SMT2PRH_ADDR            0x0DA8
#define SMT2PRU_ADDR            0x0DA9
#define SMT2CON0_ADDR           0x0DAA
#define SMT2CON1_ADDR           0x0DAB
#define SMT2STAT_ADDR           0x0DAC
#define SMT2CLK_ADDR            0x0DAD
#define SMT2SIG_ADDR            0x0DAE
#define SMT2WIN_ADDR            0x0DAF
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR4IF                 0x02
#define _TMR6IF                 0x04
#define _C1IF                   0x20
#define _C2IF                   0x40

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIF                : 1;
  unsigned CWGIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _ZCDIF                  0x10
#define _CWGIF                  0x20

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned SMT1IF               : 1;
  unsigned SMT1PRAIF            : 1;
  unsigned SMT1PWAIF            : 1;
  unsigned SMT2IF               : 1;
  unsigned SMT2PRAIF            : 1;
  unsigned SMT2PWAIF            : 1;
  unsigned CRCIF                : 1;
  unsigned SCANIF               : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _SMT1IF                 0x01
#define _SMT1PRAIF              0x02
#define _SMT1PWAIF              0x04
#define _SMT2IF                 0x08
#define _SMT2PRAIF              0x10
#define _SMT2PWAIF              0x20
#define _CRCIF                  0x40
#define _SCANIF                 0x80

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr T2TMR;
extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;
extern __at(0x001B) __sfr T2PR;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned T2CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T2ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR2ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T2CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2OUTPS0               0x01
#define _OUTPS0                 0x01
#define _T2OUTPS1               0x02
#define _OUTPS1                 0x02
#define _T2OUTPS2               0x04
#define _OUTPS2                 0x04
#define _T2OUTPS3               0x08
#define _OUTPS3                 0x08
#define _T2CKPS0                0x10
#define _CKPS0                  0x10
#define _T2CKPS1                0x20
#define _CKPS1                  0x20
#define _T2CKPS2                0x40
#define _CKPS2                  0x40
#define _ON                     0x80
#define _T2ON                   0x80
#define _TMR2ON                 0x80

//==============================================================================


//==============================================================================
//        T2HLT Bits

extern __at(0x001D) __sfr T2HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T2MODE0            : 1;
    unsigned T2MODE1            : 1;
    unsigned T2MODE2            : 1;
    unsigned T2MODE3            : 1;
    unsigned                    : 1;
    unsigned T2CKSYNC           : 1;
    unsigned T2CKPOL            : 1;
    unsigned T2PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2MODE             : 4;
    unsigned                    : 4;
    };
  } __T2HLTbits_t;

extern __at(0x001D) volatile __T2HLTbits_t T2HLTbits;

#define _T2HLT_MODE0            0x01
#define _T2HLT_T2MODE0          0x01
#define _T2HLT_MODE1            0x02
#define _T2HLT_T2MODE1          0x02
#define _T2HLT_MODE2            0x04
#define _T2HLT_T2MODE2          0x04
#define _T2HLT_MODE3            0x08
#define _T2HLT_T2MODE3          0x08
#define _T2HLT_CKSYNC           0x20
#define _T2HLT_T2CKSYNC         0x20
#define _T2HLT_CKPOL            0x40
#define _T2HLT_T2CKPOL          0x40
#define _T2HLT_PSYNC            0x80
#define _T2HLT_T2PSYNC          0x80

//==============================================================================


//==============================================================================
//        T2CLKCON Bits

extern __at(0x001E) __sfr T2CLKCON;

typedef union
  {
  struct
    {
    unsigned T2CS0              : 1;
    unsigned T2CS1              : 1;
    unsigned T2CS2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CS               : 3;
    unsigned                    : 5;
    };
  } __T2CLKCONbits_t;

extern __at(0x001E) volatile __T2CLKCONbits_t T2CLKCONbits;

#define _T2CS0                  0x01
#define _T2CS1                  0x02
#define _T2CS2                  0x04

//==============================================================================


//==============================================================================
//        T2RST Bits

extern __at(0x001F) __sfr T2RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL0            : 1;
    unsigned T2RSEL1            : 1;
    unsigned T2RSEL2            : 1;
    unsigned T2RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };
  } __T2RSTbits_t;

extern __at(0x001F) volatile __T2RSTbits_t T2RSTbits;

#define _RSEL0                  0x01
#define _T2RSEL0                0x01
#define _RSEL1                  0x02
#define _T2RSEL1                0x02
#define _RSEL2                  0x04
#define _T2RSEL2                0x04
#define _RSEL3                  0x08
#define _T2RSEL3                0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR4IE                 0x02
#define _TMR6IE                 0x04
#define _C1IE                   0x20
#define _C2IE                   0x40

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIE                : 1;
  unsigned CWGIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _ZCDIE                  0x10
#define _CWGIE                  0x20

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned SMT1IE               : 1;
  unsigned SMT1PRAIE            : 1;
  unsigned SMT1PWAIE            : 1;
  unsigned SMT2IE               : 1;
  unsigned SMT2PRAIE            : 1;
  unsigned SMT2PWAIE            : 1;
  unsigned CRCIE                : 1;
  unsigned SCANIE               : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _SMT1IE                 0x01
#define _SMT1PRAIE              0x02
#define _SMT1PWAIE              0x04
#define _SMT2IE                 0x08
#define _SMT2PRAIE              0x10
#define _SMT2PWAIE              0x20
#define _CRCIE                  0x40
#define _SCANIE                 0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned NOT_WDTWV            : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _NOT_WDTWV              0x20
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned                      : 1;
  unsigned PLLR                 : 1;
  unsigned                      : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _PLLR                   0x40

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef union
  {
  struct
    {
    unsigned LATA0              : 1;
    unsigned LATA1              : 1;
    unsigned LATA2              : 1;
    unsigned LATA3              : 1;
    unsigned LATA4              : 1;
    unsigned LATA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATA               : 6;
    unsigned                    : 2;
    };
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned                    : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C1PCH              : 2;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x10
#define _C1PCH1                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x0118) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D1PSS0             : 1;
    unsigned D1PSS1             : 1;
    unsigned                    : 1;
    unsigned DAC1OE             : 1;
    unsigned                    : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned D1PSS              : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x0118) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _D1PSS0                 0x04
#define _D1PSS1                 0x08
#define _DAC1OE                 0x20
#define _DAC1EN                 0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x0119) __sfr DAC1CON1;

typedef struct
  {
  unsigned DAC1R0               : 1;
  unsigned DAC1R1               : 1;
  unsigned DAC1R2               : 1;
  unsigned DAC1R3               : 1;
  unsigned DAC1R4               : 1;
  unsigned DAC1R5               : 1;
  unsigned DAC1R6               : 1;
  unsigned DAC1R7               : 1;
  } __DAC1CON1bits_t;

extern __at(0x0119) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _DAC1R0                 0x01
#define _DAC1R1                 0x02
#define _DAC1R2                 0x04
#define _DAC1R3                 0x08
#define _DAC1R4                 0x10
#define _DAC1R5                 0x20
#define _DAC1R6                 0x40
#define _DAC1R7                 0x80

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x011C) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned ZCD1OE               : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x011C) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1OE                 0x40
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned CCP1SEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned CWGBSEL              : 1;
  unsigned CWGASEL              : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _CCP1SEL                0x01
#define _T1GSEL                 0x08
#define _CWGBSEL                0x20
#define _CWGASEL                0x40

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned                      : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA4                   0x10
#define _ODA5                   0x20

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned CCP1OE             : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _MODE0                  0x01
#define _CCP1MODE0              0x01
#define _MODE1                  0x02
#define _CCP1MODE1              0x02
#define _MODE2                  0x04
#define _CCP1MODE2              0x04
#define _MODE3                  0x08
#define _CCP1MODE3              0x08
#define _FMT                    0x10
#define _CCP1FMT                0x10
#define _OUT                    0x20
#define _CCP1OUT                0x20
#define _OE                     0x40
#define _CCP1OE                 0x40
#define _EN                     0x80
#define _CCP1EN                 0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x0294) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned CTS                : 2;
    unsigned                    : 6;
    };
  } __CCP1CAPbits_t;

extern __at(0x0294) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CTS0                   0x01
#define _CCP1CTS0               0x01
#define _CTS1                   0x02
#define _CCP1CTS1               0x02

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP2MODE0          : 1;
    unsigned CCP2MODE1          : 1;
    unsigned CCP2MODE2          : 1;
    unsigned CCP2MODE3          : 1;
    unsigned CCP2FMT            : 1;
    unsigned CCP2OUT            : 1;
    unsigned CCP2OE             : 1;
    unsigned CCP2EN             : 1;
    };

  struct
    {
    unsigned CCP2MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2CON_MODE0          0x01
#define _CCP2CON_CCP2MODE0      0x01
#define _CCP2CON_MODE1          0x02
#define _CCP2CON_CCP2MODE1      0x02
#define _CCP2CON_MODE2          0x04
#define _CCP2CON_CCP2MODE2      0x04
#define _CCP2CON_MODE3          0x08
#define _CCP2CON_CCP2MODE3      0x08
#define _CCP2CON_FMT            0x10
#define _CCP2CON_CCP2FMT        0x10
#define _CCP2CON_OUT            0x20
#define _CCP2CON_CCP2OUT        0x20
#define _CCP2CON_OE             0x40
#define _CCP2CON_CCP2OE         0x40
#define _CCP2CON_EN             0x80
#define _CCP2CON_CCP2EN         0x80

//==============================================================================


//==============================================================================
//        CCP2CAP Bits

extern __at(0x029B) __sfr CCP2CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS0           : 1;
    unsigned CCP2CTS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned CCP2CTS            : 2;
    unsigned                    : 6;
    };
  } __CCP2CAPbits_t;

extern __at(0x029B) volatile __CCP2CAPbits_t CCP2CAPbits;

#define _CCP2CAP_CTS0           0x01
#define _CCP2CAP_CCP2CTS0       0x01
#define _CCP2CAP_CTS1           0x02
#define _CCP2CAP_CCP2CTS1       0x02

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029E) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned CCP1TSEL0          : 1;
    unsigned CCP1TSEL1          : 1;
    unsigned CCP2TSEL0          : 1;
    unsigned CCP2TSEL1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1TSEL           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CCP2TSEL           : 2;
    unsigned                    : 4;
    };
  } __CCPTMRSbits_t;

extern __at(0x029E) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _CCP1TSEL0              0x01
#define _CCP1TSEL1              0x02
#define _CCP2TSEL0              0x04
#define _CCP2TSEL1              0x08

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================

extern __at(0x0391) __sfr IOCAP;
extern __at(0x0392) __sfr IOCAN;
extern __at(0x0393) __sfr IOCAF;
extern __at(0x0413) __sfr T4TMR;
extern __at(0x0413) __sfr TMR4;
extern __at(0x0414) __sfr PR4;
extern __at(0x0414) __sfr T4PR;

//==============================================================================
//        T4CON Bits

extern __at(0x0415) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned T4CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T4ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR4ON             : 1;
    };

  struct
    {
    unsigned T4OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T4CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0415) volatile __T4CONbits_t T4CONbits;

#define _T4CON_T4OUTPS0         0x01
#define _T4CON_OUTPS0           0x01
#define _T4CON_T4OUTPS1         0x02
#define _T4CON_OUTPS1           0x02
#define _T4CON_T4OUTPS2         0x04
#define _T4CON_OUTPS2           0x04
#define _T4CON_T4OUTPS3         0x08
#define _T4CON_OUTPS3           0x08
#define _T4CON_T4CKPS0          0x10
#define _T4CON_CKPS0            0x10
#define _T4CON_T4CKPS1          0x20
#define _T4CON_CKPS1            0x20
#define _T4CON_T4CKPS2          0x40
#define _T4CON_CKPS2            0x40
#define _T4CON_ON               0x80
#define _T4CON_T4ON             0x80
#define _T4CON_TMR4ON           0x80

//==============================================================================


//==============================================================================
//        T4HLT Bits

extern __at(0x0416) __sfr T4HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T4MODE0            : 1;
    unsigned T4MODE1            : 1;
    unsigned T4MODE2            : 1;
    unsigned T4MODE3            : 1;
    unsigned                    : 1;
    unsigned T4CKSYNC           : 1;
    unsigned T4CKPOL            : 1;
    unsigned T4PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4MODE             : 4;
    unsigned                    : 4;
    };
  } __T4HLTbits_t;

extern __at(0x0416) volatile __T4HLTbits_t T4HLTbits;

#define _T4HLT_MODE0            0x01
#define _T4HLT_T4MODE0          0x01
#define _T4HLT_MODE1            0x02
#define _T4HLT_T4MODE1          0x02
#define _T4HLT_MODE2            0x04
#define _T4HLT_T4MODE2          0x04
#define _T4HLT_MODE3            0x08
#define _T4HLT_T4MODE3          0x08
#define _T4HLT_CKSYNC           0x20
#define _T4HLT_T4CKSYNC         0x20
#define _T4HLT_CKPOL            0x40
#define _T4HLT_T4CKPOL          0x40
#define _T4HLT_PSYNC            0x80
#define _T4HLT_T4PSYNC          0x80

//==============================================================================


//==============================================================================
//        T4CLKCON Bits

extern __at(0x0417) __sfr T4CLKCON;

typedef union
  {
  struct
    {
    unsigned T4CS0              : 1;
    unsigned T4CS1              : 1;
    unsigned T4CS2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CS               : 3;
    unsigned                    : 5;
    };
  } __T4CLKCONbits_t;

extern __at(0x0417) volatile __T4CLKCONbits_t T4CLKCONbits;

#define _T4CS0                  0x01
#define _T4CS1                  0x02
#define _T4CS2                  0x04

//==============================================================================


//==============================================================================
//        T4RST Bits

extern __at(0x0418) __sfr T4RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL0            : 1;
    unsigned T4RSEL1            : 1;
    unsigned T4RSEL2            : 1;
    unsigned T4RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4RSEL             : 4;
    unsigned                    : 4;
    };
  } __T4RSTbits_t;

extern __at(0x0418) volatile __T4RSTbits_t T4RSTbits;

#define _T4RST_RSEL0            0x01
#define _T4RST_T4RSEL0          0x01
#define _T4RST_RSEL1            0x02
#define _T4RST_T4RSEL1          0x02
#define _T4RST_RSEL2            0x04
#define _T4RST_T4RSEL2          0x04
#define _T4RST_RSEL3            0x08
#define _T4RST_T4RSEL3          0x08

//==============================================================================

extern __at(0x041A) __sfr T6TMR;
extern __at(0x041A) __sfr TMR6;
extern __at(0x041B) __sfr PR6;
extern __at(0x041B) __sfr T6PR;

//==============================================================================
//        T6CON Bits

extern __at(0x041C) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned T6CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T6ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR6ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T6CKPS             : 3;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041C) volatile __T6CONbits_t T6CONbits;

#define _T6CON_T6OUTPS0         0x01
#define _T6CON_OUTPS0           0x01
#define _T6CON_T6OUTPS1         0x02
#define _T6CON_OUTPS1           0x02
#define _T6CON_T6OUTPS2         0x04
#define _T6CON_OUTPS2           0x04
#define _T6CON_T6OUTPS3         0x08
#define _T6CON_OUTPS3           0x08
#define _T6CON_T6CKPS0          0x10
#define _T6CON_CKPS0            0x10
#define _T6CON_T6CKPS1          0x20
#define _T6CON_CKPS1            0x20
#define _T6CON_T6CKPS2          0x40
#define _T6CON_CKPS2            0x40
#define _T6CON_ON               0x80
#define _T6CON_T6ON             0x80
#define _T6CON_TMR6ON           0x80

//==============================================================================


//==============================================================================
//        T6HLT Bits

extern __at(0x041D) __sfr T6HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T6MODE0            : 1;
    unsigned T6MODE1            : 1;
    unsigned T6MODE2            : 1;
    unsigned T6MODE3            : 1;
    unsigned                    : 1;
    unsigned T6CKSYNC           : 1;
    unsigned T6CKPOL            : 1;
    unsigned T6PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6MODE             : 4;
    unsigned                    : 4;
    };
  } __T6HLTbits_t;

extern __at(0x041D) volatile __T6HLTbits_t T6HLTbits;

#define _T6HLT_MODE0            0x01
#define _T6HLT_T6MODE0          0x01
#define _T6HLT_MODE1            0x02
#define _T6HLT_T6MODE1          0x02
#define _T6HLT_MODE2            0x04
#define _T6HLT_T6MODE2          0x04
#define _T6HLT_MODE3            0x08
#define _T6HLT_T6MODE3          0x08
#define _T6HLT_CKSYNC           0x20
#define _T6HLT_T6CKSYNC         0x20
#define _T6HLT_CKPOL            0x40
#define _T6HLT_T6CKPOL          0x40
#define _T6HLT_PSYNC            0x80
#define _T6HLT_T6PSYNC          0x80

//==============================================================================


//==============================================================================
//        T6CLKCON Bits

extern __at(0x041E) __sfr T6CLKCON;

typedef union
  {
  struct
    {
    unsigned T6CS0              : 1;
    unsigned T6CS1              : 1;
    unsigned T6CS2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CS               : 3;
    unsigned                    : 5;
    };
  } __T6CLKCONbits_t;

extern __at(0x041E) volatile __T6CLKCONbits_t T6CLKCONbits;

#define _T6CS0                  0x01
#define _T6CS1                  0x02
#define _T6CS2                  0x04

//==============================================================================


//==============================================================================
//        T6RST Bits

extern __at(0x041F) __sfr T6RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL0            : 1;
    unsigned T6RSEL1            : 1;
    unsigned T6RSEL2            : 1;
    unsigned T6RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };
  } __T6RSTbits_t;

extern __at(0x041F) volatile __T6RSTbits_t T6RSTbits;

#define _T6RST_RSEL0            0x01
#define _T6RST_T6RSEL0          0x01
#define _T6RST_RSEL1            0x02
#define _T6RST_T6RSEL1          0x02
#define _T6RST_RSEL2            0x04
#define _T6RST_T6RSEL2          0x04
#define _T6RST_RSEL3            0x08
#define _T6RST_T6RSEL3          0x08

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x0691) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x0691) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _DBR0                   0x01
#define _CWG1DBR0               0x01
#define _DBR1                   0x02
#define _CWG1DBR1               0x02
#define _DBR2                   0x04
#define _CWG1DBR2               0x04
#define _DBR3                   0x08
#define _CWG1DBR3               0x08
#define _DBR4                   0x10
#define _CWG1DBR4               0x10
#define _DBR5                   0x20
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x0692) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x0692) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _DBF0                   0x01
#define _CWG1DBF0               0x01
#define _DBF1                   0x02
#define _CWG1DBF1               0x02
#define _DBF2                   0x04
#define _CWG1DBF2               0x04
#define _DBF3                   0x08
#define _CWG1DBF3               0x08
#define _DBF4                   0x10
#define _CWG1DBF4               0x10
#define _DBF5                   0x20
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1AS0 Bits

extern __at(0x0693) __sfr CWG1AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LSAC0          : 1;
    unsigned CWG1LSAC1          : 1;
    unsigned CWG1LSBD0          : 1;
    unsigned CWG1LSBD1          : 1;
    unsigned CWG1REN            : 1;
    unsigned CWG1SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG1LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG1LSBD           : 2;
    unsigned                    : 2;
    };
  } __CWG1AS0bits_t;

extern __at(0x0693) volatile __CWG1AS0bits_t CWG1AS0bits;

#define _LSAC0                  0x04
#define _CWG1LSAC0              0x04
#define _LSAC1                  0x08
#define _CWG1LSAC1              0x08
#define _LSBD0                  0x10
#define _CWG1LSBD0              0x10
#define _LSBD1                  0x20
#define _CWG1LSBD1              0x20
#define _REN                    0x40
#define _CWG1REN                0x40
#define _SHUTDOWN               0x80
#define _CWG1SHUTDOWN           0x80

//==============================================================================


//==============================================================================
//        CWG1AS1 Bits

extern __at(0x0694) __sfr CWG1AS1;

typedef union
  {
  struct
    {
    unsigned INAS               : 1;
    unsigned C1AS               : 1;
    unsigned C2AS               : 1;
    unsigned                    : 1;
    unsigned TMR2AS             : 1;
    unsigned TMR4AS             : 1;
    unsigned TMR6AS             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1INAS           : 1;
    unsigned CWG1C1AS           : 1;
    unsigned CWG1C2AS           : 1;
    unsigned                    : 1;
    unsigned CWG1TMR2AS         : 1;
    unsigned CWG1TMR4AS         : 1;
    unsigned CWG1TMR6AS         : 1;
    unsigned                    : 1;
    };
  } __CWG1AS1bits_t;

extern __at(0x0694) volatile __CWG1AS1bits_t CWG1AS1bits;

#define _INAS                   0x01
#define _CWG1INAS               0x01
#define _C1AS                   0x02
#define _CWG1C1AS               0x02
#define _C2AS                   0x04
#define _CWG1C2AS               0x04
#define _TMR2AS                 0x10
#define _CWG1TMR2AS             0x10
#define _TMR4AS                 0x20
#define _CWG1TMR4AS             0x20
#define _TMR6AS                 0x40
#define _CWG1TMR6AS             0x40

//==============================================================================


//==============================================================================
//        CWG1OCON0 Bits

extern __at(0x0695) __sfr CWG1OCON0;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG1STRA           : 1;
    unsigned CWG1STRB           : 1;
    unsigned CWG1STRC           : 1;
    unsigned CWG1STRD           : 1;
    unsigned CWG1OVRA           : 1;
    unsigned CWG1OVRB           : 1;
    unsigned CWG1OVRC           : 1;
    unsigned CWG1OVRD           : 1;
    };
  } __CWG1OCON0bits_t;

extern __at(0x0695) volatile __CWG1OCON0bits_t CWG1OCON0bits;

#define _STRA                   0x01
#define _CWG1STRA               0x01
#define _STRB                   0x02
#define _CWG1STRB               0x02
#define _STRC                   0x04
#define _CWG1STRC               0x04
#define _STRD                   0x08
#define _CWG1STRD               0x08
#define _OVRA                   0x10
#define _CWG1OVRA               0x10
#define _OVRB                   0x20
#define _CWG1OVRB               0x20
#define _OVRC                   0x40
#define _CWG1OVRC               0x40
#define _OVRD                   0x80
#define _CWG1OVRD               0x80

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0696) __sfr CWG1CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG1MODE0          : 1;
    unsigned CWG1MODE1          : 1;
    unsigned CWG1MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LD             : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1EN             : 1;
    };

  struct
    {
    unsigned CWG1MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CWG1CON0bits_t;

extern __at(0x0696) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _CWG1CON0_MODE0         0x01
#define _CWG1CON0_CWG1MODE0     0x01
#define _CWG1CON0_MODE1         0x02
#define _CWG1CON0_CWG1MODE1     0x02
#define _CWG1CON0_MODE2         0x04
#define _CWG1CON0_CWG1MODE2     0x04
#define _CWG1CON0_LD            0x40
#define _CWG1CON0_CWG1LD        0x40
#define _CWG1CON0_EN            0x80
#define _CWG1CON0_G1EN          0x80
#define _CWG1CON0_CWG1EN        0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0697) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1POLA           : 1;
    unsigned CWG1POLB           : 1;
    unsigned CWG1POLC           : 1;
    unsigned CWG1POLD           : 1;
    unsigned                    : 1;
    unsigned CWG1IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CON1bits_t;

extern __at(0x0697) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _POLA                   0x01
#define _CWG1POLA               0x01
#define _POLB                   0x02
#define _CWG1POLB               0x02
#define _POLC                   0x04
#define _CWG1POLC               0x04
#define _POLD                   0x08
#define _CWG1POLD               0x08
#define _IN                     0x20
#define _CWG1IN                 0x20

//==============================================================================


//==============================================================================
//        CWG1OCON1 Bits

extern __at(0x0698) __sfr CWG1OCON1;

typedef union
  {
  struct
    {
    unsigned OEA                : 1;
    unsigned OEB                : 1;
    unsigned OEC                : 1;
    unsigned OED                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1OEA            : 1;
    unsigned CWG1OEB            : 1;
    unsigned CWG1OEC            : 1;
    unsigned CWG1OED            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1OCON1bits_t;

extern __at(0x0698) volatile __CWG1OCON1bits_t CWG1OCON1bits;

#define _OEA                    0x01
#define _CWG1OEA                0x01
#define _OEB                    0x02
#define _CWG1OEB                0x02
#define _OEC                    0x04
#define _CWG1OEC                0x04
#define _OED                    0x08
#define _CWG1OED                0x08

//==============================================================================


//==============================================================================
//        CWG1CLKCON Bits

extern __at(0x0699) __sfr CWG1CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CLKCONbits_t;

extern __at(0x0699) volatile __CWG1CLKCONbits_t CWG1CLKCONbits;

#define _CS                     0x01
#define _CWG1CS                 0x01

//==============================================================================


//==============================================================================
//        CWG1ISM Bits

extern __at(0x069A) __sfr CWG1ISM;

typedef union
  {
  struct
    {
    unsigned IS0                : 1;
    unsigned IS1                : 1;
    unsigned IS2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1IS0            : 1;
    unsigned CWG1IS1            : 1;
    unsigned CWG1IS2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IS                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CWG1IS             : 3;
    unsigned                    : 5;
    };
  } __CWG1ISMbits_t;

extern __at(0x069A) volatile __CWG1ISMbits_t CWG1ISMbits;

#define _IS0                    0x01
#define _CWG1IS0                0x01
#define _IS1                    0x02
#define _CWG1IS1                0x02
#define _IS2                    0x04
#define _CWG1IS2                0x04

//==============================================================================


//==============================================================================
//        WDTCON0 Bits

extern __at(0x0711) __sfr WDTCON0;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTSEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCON0bits_t;

extern __at(0x0711) volatile __WDTCON0bits_t WDTCON0bits;

#define _SEN                    0x01
#define _SWDTEN                 0x01
#define _WDTSEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        WDTCON1 Bits

extern __at(0x0712) __sfr WDTCON1;

typedef union
  {
  struct
    {
    unsigned WINDOW0            : 1;
    unsigned WINDOW1            : 1;
    unsigned WINDOW2            : 1;
    unsigned                    : 1;
    unsigned WDTCS0             : 1;
    unsigned WDTCS1             : 1;
    unsigned WDTCS2             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTWINDOW0         : 1;
    unsigned WDTWINDOW1         : 1;
    unsigned WDTWINDOW2         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTWINDOW          : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned WINDOW             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned WDTCS              : 3;
    unsigned                    : 1;
    };
  } __WDTCON1bits_t;

extern __at(0x0712) volatile __WDTCON1bits_t WDTCON1bits;

#define _WINDOW0                0x01
#define _WDTWINDOW0             0x01
#define _WINDOW1                0x02
#define _WDTWINDOW1             0x02
#define _WINDOW2                0x04
#define _WDTWINDOW2             0x04
#define _WDTCS0                 0x10
#define _WDTCS1                 0x20
#define _WDTCS2                 0x40

//==============================================================================


//==============================================================================
//        WDTPSL Bits

extern __at(0x0713) __sfr WDTPSL;

typedef union
  {
  struct
    {
    unsigned PSCNT0             : 1;
    unsigned PSCNT1             : 1;
    unsigned PSCNT2             : 1;
    unsigned PSCNT3             : 1;
    unsigned PSCNT4             : 1;
    unsigned PSCNT5             : 1;
    unsigned PSCNT6             : 1;
    unsigned PSCNT7             : 1;
    };

  struct
    {
    unsigned WDTPSCNT0          : 1;
    unsigned WDTPSCNT1          : 1;
    unsigned WDTPSCNT2          : 1;
    unsigned WDTPSCNT3          : 1;
    unsigned WDTPSCNT4          : 1;
    unsigned WDTPSCNT5          : 1;
    unsigned WDTPSCNT6          : 1;
    unsigned WDTPSCNT7          : 1;
    };
  } __WDTPSLbits_t;

extern __at(0x0713) volatile __WDTPSLbits_t WDTPSLbits;

#define _PSCNT0                 0x01
#define _WDTPSCNT0              0x01
#define _PSCNT1                 0x02
#define _WDTPSCNT1              0x02
#define _PSCNT2                 0x04
#define _WDTPSCNT2              0x04
#define _PSCNT3                 0x08
#define _WDTPSCNT3              0x08
#define _PSCNT4                 0x10
#define _WDTPSCNT4              0x10
#define _PSCNT5                 0x20
#define _WDTPSCNT5              0x20
#define _PSCNT6                 0x40
#define _WDTPSCNT6              0x40
#define _PSCNT7                 0x80
#define _WDTPSCNT7              0x80

//==============================================================================


//==============================================================================
//        WDTPSH Bits

extern __at(0x0714) __sfr WDTPSH;

typedef union
  {
  struct
    {
    unsigned PSCNT8             : 1;
    unsigned PSCNT9             : 1;
    unsigned PSCNT10            : 1;
    unsigned PSCNT11            : 1;
    unsigned PSCNT12            : 1;
    unsigned PSCNT13            : 1;
    unsigned PSCNT14            : 1;
    unsigned PSCNT15            : 1;
    };

  struct
    {
    unsigned WDTPSCNT8          : 1;
    unsigned WDTPSCNT9          : 1;
    unsigned WDTPSCNT10         : 1;
    unsigned WDTPSCNT11         : 1;
    unsigned WDTPSCNT12         : 1;
    unsigned WDTPSCNT13         : 1;
    unsigned WDTPSCNT14         : 1;
    unsigned WDTPSCNT15         : 1;
    };
  } __WDTPSHbits_t;

extern __at(0x0714) volatile __WDTPSHbits_t WDTPSHbits;

#define _PSCNT8                 0x01
#define _WDTPSCNT8              0x01
#define _PSCNT9                 0x02
#define _WDTPSCNT9              0x02
#define _PSCNT10                0x04
#define _WDTPSCNT10             0x04
#define _PSCNT11                0x08
#define _WDTPSCNT11             0x08
#define _PSCNT12                0x10
#define _WDTPSCNT12             0x10
#define _PSCNT13                0x20
#define _WDTPSCNT13             0x20
#define _PSCNT14                0x40
#define _WDTPSCNT14             0x40
#define _PSCNT15                0x80
#define _WDTPSCNT15             0x80

//==============================================================================


//==============================================================================
//        WDTTMR Bits

extern __at(0x0715) __sfr WDTTMR;

typedef union
  {
  struct
    {
    unsigned PSCNT16            : 1;
    unsigned PSCNT17            : 1;
    unsigned STATE              : 1;
    unsigned WDTTMR0            : 1;
    unsigned WDTTMR1            : 1;
    unsigned WDTTMR2            : 1;
    unsigned WDTTMR3            : 1;
    unsigned WDTTMR4            : 1;
    };

  struct
    {
    unsigned WDTPSCNT16         : 1;
    unsigned WDTPSCNT17         : 1;
    unsigned WDTSTATE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned WDTTMR             : 5;
    };
  } __WDTTMRbits_t;

extern __at(0x0715) volatile __WDTTMRbits_t WDTTMRbits;

#define _PSCNT16                0x01
#define _WDTPSCNT16             0x01
#define _PSCNT17                0x02
#define _WDTPSCNT17             0x02
#define _STATE                  0x04
#define _WDTSTATE               0x04
#define _WDTTMR0                0x08
#define _WDTTMR1                0x10
#define _WDTTMR2                0x20
#define _WDTTMR3                0x40
#define _WDTTMR4                0x80

//==============================================================================

extern __at(0x0718) __sfr SCANLADR;

//==============================================================================
//        SCANLADRL Bits

extern __at(0x0718) __sfr SCANLADRL;

typedef union
  {
  struct
    {
    unsigned LDAR0              : 1;
    unsigned LDAR1              : 1;
    unsigned LADR2              : 1;
    unsigned LADR3              : 1;
    unsigned LADR4              : 1;
    unsigned LADR5              : 1;
    unsigned LADR6              : 1;
    unsigned LADR7              : 1;
    };

  struct
    {
    unsigned SCANLADR0          : 1;
    unsigned SCANLADR1          : 1;
    unsigned SCANLADR2          : 1;
    unsigned SCANLADR3          : 1;
    unsigned SCANLADR4          : 1;
    unsigned SCANLADR5          : 1;
    unsigned SCANLADR6          : 1;
    unsigned SCANLADR7          : 1;
    };

  struct
    {
    unsigned LDAR               : 2;
    unsigned                    : 6;
    };
  } __SCANLADRLbits_t;

extern __at(0x0718) volatile __SCANLADRLbits_t SCANLADRLbits;

#define _LDAR0                  0x01
#define _SCANLADR0              0x01
#define _LDAR1                  0x02
#define _SCANLADR1              0x02
#define _LADR2                  0x04
#define _SCANLADR2              0x04
#define _LADR3                  0x08
#define _SCANLADR3              0x08
#define _LADR4                  0x10
#define _SCANLADR4              0x10
#define _LADR5                  0x20
#define _SCANLADR5              0x20
#define _LADR6                  0x40
#define _SCANLADR6              0x40
#define _LADR7                  0x80
#define _SCANLADR7              0x80

//==============================================================================


//==============================================================================
//        SCANLADRH Bits

extern __at(0x0719) __sfr SCANLADRH;

typedef union
  {
  struct
    {
    unsigned LADR8              : 1;
    unsigned LADR9              : 1;
    unsigned LADR10             : 1;
    unsigned LADR11             : 1;
    unsigned LADR12             : 1;
    unsigned LADR13             : 1;
    unsigned LADR14             : 1;
    unsigned LADR15             : 1;
    };

  struct
    {
    unsigned SCANLADR8          : 1;
    unsigned SCANLADR9          : 1;
    unsigned SCANLADR10         : 1;
    unsigned SCANLADR11         : 1;
    unsigned SCANLADR12         : 1;
    unsigned SCANLADR13         : 1;
    unsigned SCANLADR14         : 1;
    unsigned SCANLADR15         : 1;
    };
  } __SCANLADRHbits_t;

extern __at(0x0719) volatile __SCANLADRHbits_t SCANLADRHbits;

#define _LADR8                  0x01
#define _SCANLADR8              0x01
#define _LADR9                  0x02
#define _SCANLADR9              0x02
#define _LADR10                 0x04
#define _SCANLADR10             0x04
#define _LADR11                 0x08
#define _SCANLADR11             0x08
#define _LADR12                 0x10
#define _SCANLADR12             0x10
#define _LADR13                 0x20
#define _SCANLADR13             0x20
#define _LADR14                 0x40
#define _SCANLADR14             0x40
#define _LADR15                 0x80
#define _SCANLADR15             0x80

//==============================================================================

extern __at(0x071A) __sfr SCANHADR;

//==============================================================================
//        SCANHADRL Bits

extern __at(0x071A) __sfr SCANHADRL;

typedef union
  {
  struct
    {
    unsigned HADR0              : 1;
    unsigned HADR1              : 1;
    unsigned HARD2              : 1;
    unsigned HADR3              : 1;
    unsigned HADR4              : 1;
    unsigned HADR5              : 1;
    unsigned HADR6              : 1;
    unsigned HADR7              : 1;
    };

  struct
    {
    unsigned SCANHADR0          : 1;
    unsigned SCANHADR1          : 1;
    unsigned SCANHADR2          : 1;
    unsigned SCANHADR3          : 1;
    unsigned SCANHADR4          : 1;
    unsigned SCANHADR5          : 1;
    unsigned SCANHADR6          : 1;
    unsigned SCANHADR7          : 1;
    };
  } __SCANHADRLbits_t;

extern __at(0x071A) volatile __SCANHADRLbits_t SCANHADRLbits;

#define _HADR0                  0x01
#define _SCANHADR0              0x01
#define _HADR1                  0x02
#define _SCANHADR1              0x02
#define _HARD2                  0x04
#define _SCANHADR2              0x04
#define _HADR3                  0x08
#define _SCANHADR3              0x08
#define _HADR4                  0x10
#define _SCANHADR4              0x10
#define _HADR5                  0x20
#define _SCANHADR5              0x20
#define _HADR6                  0x40
#define _SCANHADR6              0x40
#define _HADR7                  0x80
#define _SCANHADR7              0x80

//==============================================================================


//==============================================================================
//        SCANHADRH Bits

extern __at(0x071B) __sfr SCANHADRH;

typedef union
  {
  struct
    {
    unsigned HADR8              : 1;
    unsigned HADR9              : 1;
    unsigned HADR10             : 1;
    unsigned HADR11             : 1;
    unsigned HADR12             : 1;
    unsigned HADR13             : 1;
    unsigned HADR14             : 1;
    unsigned HADR15             : 1;
    };

  struct
    {
    unsigned SCANHADR8          : 1;
    unsigned SCANHADR9          : 1;
    unsigned SCANHADR10         : 1;
    unsigned SCANHADR11         : 1;
    unsigned SCANHADR12         : 1;
    unsigned SCANHADR13         : 1;
    unsigned SCANHADR14         : 1;
    unsigned SCANHADR15         : 1;
    };
  } __SCANHADRHbits_t;

extern __at(0x071B) volatile __SCANHADRHbits_t SCANHADRHbits;

#define _HADR8                  0x01
#define _SCANHADR8              0x01
#define _HADR9                  0x02
#define _SCANHADR9              0x02
#define _HADR10                 0x04
#define _SCANHADR10             0x04
#define _HADR11                 0x08
#define _SCANHADR11             0x08
#define _HADR12                 0x10
#define _SCANHADR12             0x10
#define _HADR13                 0x20
#define _SCANHADR13             0x20
#define _HADR14                 0x40
#define _SCANHADR14             0x40
#define _HADR15                 0x80
#define _SCANHADR15             0x80

//==============================================================================


//==============================================================================
//        SCANCON0 Bits

extern __at(0x071C) __sfr SCANCON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned                    : 1;
    unsigned INTM               : 1;
    unsigned INVALID            : 1;
    unsigned BUSY               : 1;
    unsigned SCANGO             : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SCANMODE0          : 1;
    unsigned SCANMODE1          : 1;
    unsigned                    : 1;
    unsigned SCANINTM           : 1;
    unsigned SCANINVALID        : 1;
    unsigned SCANBUSY           : 1;
    unsigned                    : 1;
    unsigned SCANEN             : 1;
    };

  struct
    {
    unsigned MODE               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned SCANMODE           : 2;
    unsigned                    : 6;
    };
  } __SCANCON0bits_t;

extern __at(0x071C) volatile __SCANCON0bits_t SCANCON0bits;

#define _SCANCON0_MODE0         0x01
#define _SCANCON0_SCANMODE0     0x01
#define _SCANCON0_MODE1         0x02
#define _SCANCON0_SCANMODE1     0x02
#define _SCANCON0_INTM          0x08
#define _SCANCON0_SCANINTM      0x08
#define _SCANCON0_INVALID       0x10
#define _SCANCON0_SCANINVALID   0x10
#define _SCANCON0_BUSY          0x20
#define _SCANCON0_SCANBUSY      0x20
#define _SCANCON0_SCANGO        0x40
#define _SCANCON0_EN            0x80
#define _SCANCON0_SCANEN        0x80

//==============================================================================


//==============================================================================
//        SCANTRIG Bits

extern __at(0x071D) __sfr SCANTRIG;

typedef union
  {
  struct
    {
    unsigned TSEL0              : 1;
    unsigned TSEL1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCANTSEL0          : 1;
    unsigned SCANTSEL1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCANTSEL           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned TSEL               : 2;
    unsigned                    : 6;
    };
  } __SCANTRIGbits_t;

extern __at(0x071D) volatile __SCANTRIGbits_t SCANTRIGbits;

#define _TSEL0                  0x01
#define _SCANTSEL0              0x01
#define _TSEL1                  0x02
#define _SCANTSEL1              0x02

//==============================================================================

extern __at(0x0791) __sfr CRCDAT;

//==============================================================================
//        CRCDATL Bits

extern __at(0x0791) __sfr CRCDATL;

typedef union
  {
  struct
    {
    unsigned DAT0               : 1;
    unsigned DAT1               : 1;
    unsigned DAT2               : 1;
    unsigned DAT3               : 1;
    unsigned DAT4               : 1;
    unsigned DAT5               : 1;
    unsigned DAT6               : 1;
    unsigned DAT7               : 1;
    };

  struct
    {
    unsigned CRCDAT0            : 1;
    unsigned CRCDAT1            : 1;
    unsigned CRCDAT2            : 1;
    unsigned CRCDAT3            : 1;
    unsigned CRCDAT4            : 1;
    unsigned CRCDAT5            : 1;
    unsigned CRCDAT6            : 1;
    unsigned CRDCDAT7           : 1;
    };

  struct
    {
    unsigned CRCDAT             : 7;
    unsigned                    : 1;
    };
  } __CRCDATLbits_t;

extern __at(0x0791) volatile __CRCDATLbits_t CRCDATLbits;

#define _DAT0                   0x01
#define _CRCDAT0                0x01
#define _DAT1                   0x02
#define _CRCDAT1                0x02
#define _DAT2                   0x04
#define _CRCDAT2                0x04
#define _DAT3                   0x08
#define _CRCDAT3                0x08
#define _DAT4                   0x10
#define _CRCDAT4                0x10
#define _DAT5                   0x20
#define _CRCDAT5                0x20
#define _DAT6                   0x40
#define _CRCDAT6                0x40
#define _DAT7                   0x80
#define _CRDCDAT7               0x80

//==============================================================================


//==============================================================================
//        CRCDATH Bits

extern __at(0x0792) __sfr CRCDATH;

typedef union
  {
  struct
    {
    unsigned DAT8               : 1;
    unsigned DAT9               : 1;
    unsigned DAT10              : 1;
    unsigned DAT11              : 1;
    unsigned DAT12              : 1;
    unsigned DAT13              : 1;
    unsigned DAT14              : 1;
    unsigned DAT15              : 1;
    };

  struct
    {
    unsigned CRCDAT8            : 1;
    unsigned CRCDAT9            : 1;
    unsigned CRCDAT10           : 1;
    unsigned CRCDAT11           : 1;
    unsigned CRCDAT12           : 1;
    unsigned CRCDAT13           : 1;
    unsigned CRCDAT14           : 1;
    unsigned CRCDAT15           : 1;
    };
  } __CRCDATHbits_t;

extern __at(0x0792) volatile __CRCDATHbits_t CRCDATHbits;

#define _DAT8                   0x01
#define _CRCDAT8                0x01
#define _DAT9                   0x02
#define _CRCDAT9                0x02
#define _DAT10                  0x04
#define _CRCDAT10               0x04
#define _DAT11                  0x08
#define _CRCDAT11               0x08
#define _DAT12                  0x10
#define _CRCDAT12               0x10
#define _DAT13                  0x20
#define _CRCDAT13               0x20
#define _DAT14                  0x40
#define _CRCDAT14               0x40
#define _DAT15                  0x80
#define _CRCDAT15               0x80

//==============================================================================

extern __at(0x0793) __sfr CRCACC;

//==============================================================================
//        CRCACCL Bits

extern __at(0x0793) __sfr CRCACCL;

typedef union
  {
  struct
    {
    unsigned ACC0               : 1;
    unsigned ACC1               : 1;
    unsigned ACC2               : 1;
    unsigned ACC3               : 1;
    unsigned ACC4               : 1;
    unsigned ACC5               : 1;
    unsigned ACC6               : 1;
    unsigned ACC7               : 1;
    };

  struct
    {
    unsigned CRCACC0            : 1;
    unsigned CRCACC1            : 1;
    unsigned CRCACC2            : 1;
    unsigned CRCACC3            : 1;
    unsigned CRCACC4            : 1;
    unsigned CRCACC5            : 1;
    unsigned CRCACC6            : 1;
    unsigned CRCACC7            : 1;
    };
  } __CRCACCLbits_t;

extern __at(0x0793) volatile __CRCACCLbits_t CRCACCLbits;

#define _ACC0                   0x01
#define _CRCACC0                0x01
#define _ACC1                   0x02
#define _CRCACC1                0x02
#define _ACC2                   0x04
#define _CRCACC2                0x04
#define _ACC3                   0x08
#define _CRCACC3                0x08
#define _ACC4                   0x10
#define _CRCACC4                0x10
#define _ACC5                   0x20
#define _CRCACC5                0x20
#define _ACC6                   0x40
#define _CRCACC6                0x40
#define _ACC7                   0x80
#define _CRCACC7                0x80

//==============================================================================


//==============================================================================
//        CRCACCH Bits

extern __at(0x0794) __sfr CRCACCH;

typedef union
  {
  struct
    {
    unsigned ACC8               : 1;
    unsigned ACC9               : 1;
    unsigned ACC10              : 1;
    unsigned ACC11              : 1;
    unsigned ACC12              : 1;
    unsigned ACC13              : 1;
    unsigned ACC14              : 1;
    unsigned ACC15              : 1;
    };

  struct
    {
    unsigned CRCACC8            : 1;
    unsigned CRCACC9            : 1;
    unsigned CRCACC10           : 1;
    unsigned CRCACC11           : 1;
    unsigned CRCACC12           : 1;
    unsigned CRCACC13           : 1;
    unsigned CRCACC14           : 1;
    unsigned CRCACC15           : 1;
    };
  } __CRCACCHbits_t;

extern __at(0x0794) volatile __CRCACCHbits_t CRCACCHbits;

#define _ACC8                   0x01
#define _CRCACC8                0x01
#define _ACC9                   0x02
#define _CRCACC9                0x02
#define _ACC10                  0x04
#define _CRCACC10               0x04
#define _ACC11                  0x08
#define _CRCACC11               0x08
#define _ACC12                  0x10
#define _CRCACC12               0x10
#define _ACC13                  0x20
#define _CRCACC13               0x20
#define _ACC14                  0x40
#define _CRCACC14               0x40
#define _ACC15                  0x80
#define _CRCACC15               0x80

//==============================================================================

extern __at(0x0795) __sfr CRCSHIFT;

//==============================================================================
//        CRCSHIFTL Bits

extern __at(0x0795) __sfr CRCSHIFTL;

typedef union
  {
  struct
    {
    unsigned SHIFT0             : 1;
    unsigned SHIFT1             : 1;
    unsigned SHIFT2             : 1;
    unsigned SHIFT3             : 1;
    unsigned SHIFT4             : 1;
    unsigned SHIFT5             : 1;
    unsigned SHIFT6             : 1;
    unsigned SHIFT7             : 1;
    };

  struct
    {
    unsigned CRCSHIFT0          : 1;
    unsigned CRCSHIFT1          : 1;
    unsigned CRCSHIFT2          : 1;
    unsigned CRCSHIFT3          : 1;
    unsigned CRCSHIFT4          : 1;
    unsigned CRCSHIFT5          : 1;
    unsigned CRCSHIFT6          : 1;
    unsigned CRCSHIFT7          : 1;
    };
  } __CRCSHIFTLbits_t;

extern __at(0x0795) volatile __CRCSHIFTLbits_t CRCSHIFTLbits;

#define _SHIFT0                 0x01
#define _CRCSHIFT0              0x01
#define _SHIFT1                 0x02
#define _CRCSHIFT1              0x02
#define _SHIFT2                 0x04
#define _CRCSHIFT2              0x04
#define _SHIFT3                 0x08
#define _CRCSHIFT3              0x08
#define _SHIFT4                 0x10
#define _CRCSHIFT4              0x10
#define _SHIFT5                 0x20
#define _CRCSHIFT5              0x20
#define _SHIFT6                 0x40
#define _CRCSHIFT6              0x40
#define _SHIFT7                 0x80
#define _CRCSHIFT7              0x80

//==============================================================================


//==============================================================================
//        CRCSHIFTH Bits

extern __at(0x0796) __sfr CRCSHIFTH;

typedef union
  {
  struct
    {
    unsigned SHIFT8             : 1;
    unsigned SHIFT9             : 1;
    unsigned SHIFT10            : 1;
    unsigned SHIFT11            : 1;
    unsigned SHIFT12            : 1;
    unsigned SHIFT13            : 1;
    unsigned SHIFT14            : 1;
    unsigned SHIFT15            : 1;
    };

  struct
    {
    unsigned CRCSHIFT8          : 1;
    unsigned CRCSHIFT9          : 1;
    unsigned CRCSHIFT10         : 1;
    unsigned CRCSHIFT11         : 1;
    unsigned CRCSHIFT12         : 1;
    unsigned CRCSHIFT13         : 1;
    unsigned CRCSHIFT14         : 1;
    unsigned CRCSHIFT15         : 1;
    };
  } __CRCSHIFTHbits_t;

extern __at(0x0796) volatile __CRCSHIFTHbits_t CRCSHIFTHbits;

#define _SHIFT8                 0x01
#define _CRCSHIFT8              0x01
#define _SHIFT9                 0x02
#define _CRCSHIFT9              0x02
#define _SHIFT10                0x04
#define _CRCSHIFT10             0x04
#define _SHIFT11                0x08
#define _CRCSHIFT11             0x08
#define _SHIFT12                0x10
#define _CRCSHIFT12             0x10
#define _SHIFT13                0x20
#define _CRCSHIFT13             0x20
#define _SHIFT14                0x40
#define _CRCSHIFT14             0x40
#define _SHIFT15                0x80
#define _CRCSHIFT15             0x80

//==============================================================================

extern __at(0x0797) __sfr CRCXOR;

//==============================================================================
//        CRCXORL Bits

extern __at(0x0797) __sfr CRCXORL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned XOR1               : 1;
    unsigned XOR2               : 1;
    unsigned XOR3               : 1;
    unsigned XOR4               : 1;
    unsigned XOR5               : 1;
    unsigned XOR6               : 1;
    unsigned XOR7               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CRCXOR1            : 1;
    unsigned CRCXOR2            : 1;
    unsigned CRCXOR3            : 1;
    unsigned CRCXOR4            : 1;
    unsigned CRCXOR5            : 1;
    unsigned CRCXOR6            : 1;
    unsigned CRCXOR7            : 1;
    };
  } __CRCXORLbits_t;

extern __at(0x0797) volatile __CRCXORLbits_t CRCXORLbits;

#define _XOR1                   0x02
#define _CRCXOR1                0x02
#define _XOR2                   0x04
#define _CRCXOR2                0x04
#define _XOR3                   0x08
#define _CRCXOR3                0x08
#define _XOR4                   0x10
#define _CRCXOR4                0x10
#define _XOR5                   0x20
#define _CRCXOR5                0x20
#define _XOR6                   0x40
#define _CRCXOR6                0x40
#define _XOR7                   0x80
#define _CRCXOR7                0x80

//==============================================================================


//==============================================================================
//        CRCXORH Bits

extern __at(0x0798) __sfr CRCXORH;

typedef union
  {
  struct
    {
    unsigned XOR8               : 1;
    unsigned XOR9               : 1;
    unsigned XOR10              : 1;
    unsigned XOR11              : 1;
    unsigned XOR12              : 1;
    unsigned XOR13              : 1;
    unsigned XOR14              : 1;
    unsigned XOR15              : 1;
    };

  struct
    {
    unsigned CRCXOR8            : 1;
    unsigned CRCXOR9            : 1;
    unsigned CRCXOR10           : 1;
    unsigned CRCXOR11           : 1;
    unsigned CRCXOR12           : 1;
    unsigned CRCXOR13           : 1;
    unsigned CRCXOR14           : 1;
    unsigned CRCXOR15           : 1;
    };
  } __CRCXORHbits_t;

extern __at(0x0798) volatile __CRCXORHbits_t CRCXORHbits;

#define _XOR8                   0x01
#define _CRCXOR8                0x01
#define _XOR9                   0x02
#define _CRCXOR9                0x02
#define _XOR10                  0x04
#define _CRCXOR10               0x04
#define _XOR11                  0x08
#define _CRCXOR11               0x08
#define _XOR12                  0x10
#define _CRCXOR12               0x10
#define _XOR13                  0x20
#define _CRCXOR13               0x20
#define _XOR14                  0x40
#define _CRCXOR14               0x40
#define _XOR15                  0x80
#define _CRCXOR15               0x80

//==============================================================================


//==============================================================================
//        CRCCON0 Bits

extern __at(0x0799) __sfr CRCCON0;

typedef union
  {
  struct
    {
    unsigned FULL               : 1;
    unsigned SHIFTM             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ACCM               : 1;
    unsigned BUSY               : 1;
    unsigned CRCGO              : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CRCFULL            : 1;
    unsigned CRCSHIFTM          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CRCACCM            : 1;
    unsigned CRCBUSY            : 1;
    unsigned                    : 1;
    unsigned CRCEN              : 1;
    };
  } __CRCCON0bits_t;

extern __at(0x0799) volatile __CRCCON0bits_t CRCCON0bits;

#define _CRCCON0_FULL           0x01
#define _CRCCON0_CRCFULL        0x01
#define _CRCCON0_SHIFTM         0x02
#define _CRCCON0_CRCSHIFTM      0x02
#define _CRCCON0_ACCM           0x10
#define _CRCCON0_CRCACCM        0x10
#define _CRCCON0_BUSY           0x20
#define _CRCCON0_CRCBUSY        0x20
#define _CRCCON0_CRCGO          0x40
#define _CRCCON0_EN             0x80
#define _CRCCON0_CRCEN          0x80

//==============================================================================


//==============================================================================
//        CRCCON1 Bits

extern __at(0x079A) __sfr CRCCON1;

typedef union
  {
  struct
    {
    unsigned PLEN0              : 1;
    unsigned PLEN1              : 1;
    unsigned PLEN2              : 1;
    unsigned PLEN3              : 1;
    unsigned DLEN0              : 1;
    unsigned DLEN1              : 1;
    unsigned DLEN2              : 1;
    unsigned DLEN3              : 1;
    };

  struct
    {
    unsigned CRCPLEN0           : 1;
    unsigned CRCPLEN1           : 1;
    unsigned CRCPLEN2           : 1;
    unsigned CRCPLEN3           : 1;
    unsigned CRCDLEN0           : 1;
    unsigned CRCDLEN1           : 1;
    unsigned CRCDLEN2           : 1;
    unsigned CRCDLEN3           : 1;
    };

  struct
    {
    unsigned PLEN               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CRCPLEN            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DLEN               : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CRCDLEN            : 4;
    };
  } __CRCCON1bits_t;

extern __at(0x079A) volatile __CRCCON1bits_t CRCCON1bits;

#define _PLEN0                  0x01
#define _CRCPLEN0               0x01
#define _PLEN1                  0x02
#define _CRCPLEN1               0x02
#define _PLEN2                  0x04
#define _CRCPLEN2               0x04
#define _PLEN3                  0x08
#define _CRCPLEN3               0x08
#define _DLEN0                  0x10
#define _CRCDLEN0               0x10
#define _DLEN1                  0x20
#define _CRCDLEN1               0x20
#define _DLEN2                  0x40
#define _CRCDLEN2               0x40
#define _DLEN3                  0x80
#define _CRCDLEN3               0x80

//==============================================================================

extern __at(0x0D8C) __sfr SMT1TMR;

//==============================================================================
//        SMT1TMRL Bits

extern __at(0x0D8C) __sfr SMT1TMRL;

typedef struct
  {
  unsigned SMT1TMR0             : 1;
  unsigned SMT1TMR1             : 1;
  unsigned SMT1TMR2             : 1;
  unsigned SMT1TMR3             : 1;
  unsigned SMT1TMR4             : 1;
  unsigned SMT1TMR5             : 1;
  unsigned SMT1TMR6             : 1;
  unsigned SMT1TMR7             : 1;
  } __SMT1TMRLbits_t;

extern __at(0x0D8C) volatile __SMT1TMRLbits_t SMT1TMRLbits;

#define _SMT1TMR0               0x01
#define _SMT1TMR1               0x02
#define _SMT1TMR2               0x04
#define _SMT1TMR3               0x08
#define _SMT1TMR4               0x10
#define _SMT1TMR5               0x20
#define _SMT1TMR6               0x40
#define _SMT1TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT1TMRH Bits

extern __at(0x0D8D) __sfr SMT1TMRH;

typedef struct
  {
  unsigned SMT1TMR8             : 1;
  unsigned SMT1TMR9             : 1;
  unsigned SMT1TMR10            : 1;
  unsigned SMT1TMR11            : 1;
  unsigned SMT1TMR12            : 1;
  unsigned SMT1TMR13            : 1;
  unsigned SMT1TMR14            : 1;
  unsigned SMT1TMR15            : 1;
  } __SMT1TMRHbits_t;

extern __at(0x0D8D) volatile __SMT1TMRHbits_t SMT1TMRHbits;

#define _SMT1TMR8               0x01
#define _SMT1TMR9               0x02
#define _SMT1TMR10              0x04
#define _SMT1TMR11              0x08
#define _SMT1TMR12              0x10
#define _SMT1TMR13              0x20
#define _SMT1TMR14              0x40
#define _SMT1TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT1TMRU Bits

extern __at(0x0D8E) __sfr SMT1TMRU;

typedef struct
  {
  unsigned SMT1TMR16            : 1;
  unsigned SMT1TMR17            : 1;
  unsigned SMT1TMR18            : 1;
  unsigned SMT1TMR19            : 1;
  unsigned SMT1TMR20            : 1;
  unsigned SMT1TMR21            : 1;
  unsigned SMT1TMR22            : 1;
  unsigned SMT1TMR23            : 1;
  } __SMT1TMRUbits_t;

extern __at(0x0D8E) volatile __SMT1TMRUbits_t SMT1TMRUbits;

#define _SMT1TMR16              0x01
#define _SMT1TMR17              0x02
#define _SMT1TMR18              0x04
#define _SMT1TMR19              0x08
#define _SMT1TMR20              0x10
#define _SMT1TMR21              0x20
#define _SMT1TMR22              0x40
#define _SMT1TMR23              0x80

//==============================================================================

extern __at(0x0D8F) __sfr SMT1CPR;

//==============================================================================
//        SMT1CPRL Bits

extern __at(0x0D8F) __sfr SMT1CPRL;

typedef struct
  {
  unsigned SMT1CPR0             : 1;
  unsigned SMT1CPR1             : 1;
  unsigned SMT1CPR2             : 1;
  unsigned SMT1CPR3             : 1;
  unsigned SMT1CPR4             : 1;
  unsigned SMT1CPR5             : 1;
  unsigned SMT1CPR6             : 1;
  unsigned SMT1CPR7             : 1;
  } __SMT1CPRLbits_t;

extern __at(0x0D8F) volatile __SMT1CPRLbits_t SMT1CPRLbits;

#define _SMT1CPR0               0x01
#define _SMT1CPR1               0x02
#define _SMT1CPR2               0x04
#define _SMT1CPR3               0x08
#define _SMT1CPR4               0x10
#define _SMT1CPR5               0x20
#define _SMT1CPR6               0x40
#define _SMT1CPR7               0x80

//==============================================================================


//==============================================================================
//        SMT1CPRH Bits

extern __at(0x0D90) __sfr SMT1CPRH;

typedef struct
  {
  unsigned SMT1CPR8             : 1;
  unsigned SMT1CPR9             : 1;
  unsigned SMT1CPR10            : 1;
  unsigned SMT1CPR11            : 1;
  unsigned SMT1CPR12            : 1;
  unsigned SMT1CPR13            : 1;
  unsigned SMT1CPR14            : 1;
  unsigned SMT1CPR15            : 1;
  } __SMT1CPRHbits_t;

extern __at(0x0D90) volatile __SMT1CPRHbits_t SMT1CPRHbits;

#define _SMT1CPR8               0x01
#define _SMT1CPR9               0x02
#define _SMT1CPR10              0x04
#define _SMT1CPR11              0x08
#define _SMT1CPR12              0x10
#define _SMT1CPR13              0x20
#define _SMT1CPR14              0x40
#define _SMT1CPR15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPRU Bits

extern __at(0x0D91) __sfr SMT1CPRU;

typedef struct
  {
  unsigned SMT1CPR16            : 1;
  unsigned SMT1CPR17            : 1;
  unsigned SMT1CPR18            : 1;
  unsigned SMT1CPR19            : 1;
  unsigned SMT1CPR20            : 1;
  unsigned SMT1CPR21            : 1;
  unsigned SMT1CPR22            : 1;
  unsigned SMT1CPR23            : 1;
  } __SMT1CPRUbits_t;

extern __at(0x0D91) volatile __SMT1CPRUbits_t SMT1CPRUbits;

#define _SMT1CPR16              0x01
#define _SMT1CPR17              0x02
#define _SMT1CPR18              0x04
#define _SMT1CPR19              0x08
#define _SMT1CPR20              0x10
#define _SMT1CPR21              0x20
#define _SMT1CPR22              0x40
#define _SMT1CPR23              0x80

//==============================================================================

extern __at(0x0D92) __sfr SMT1CPW;

//==============================================================================
//        SMT1CPWL Bits

extern __at(0x0D92) __sfr SMT1CPWL;

typedef struct
  {
  unsigned SMT1CPW0             : 1;
  unsigned SMT1CPW1             : 1;
  unsigned SMT1CPW2             : 1;
  unsigned SMT1CPW3             : 1;
  unsigned SMT1CPW4             : 1;
  unsigned SMT1CPW5             : 1;
  unsigned SMT1CPW6             : 1;
  unsigned SMT1CPW7             : 1;
  } __SMT1CPWLbits_t;

extern __at(0x0D92) volatile __SMT1CPWLbits_t SMT1CPWLbits;

#define _SMT1CPW0               0x01
#define _SMT1CPW1               0x02
#define _SMT1CPW2               0x04
#define _SMT1CPW3               0x08
#define _SMT1CPW4               0x10
#define _SMT1CPW5               0x20
#define _SMT1CPW6               0x40
#define _SMT1CPW7               0x80

//==============================================================================


//==============================================================================
//        SMT1CPWH Bits

extern __at(0x0D93) __sfr SMT1CPWH;

typedef struct
  {
  unsigned SMT1CPW8             : 1;
  unsigned SMT1CPW9             : 1;
  unsigned SMT1CPW10            : 1;
  unsigned SMT1CPW11            : 1;
  unsigned SMT1CPW12            : 1;
  unsigned SMT1CPW13            : 1;
  unsigned SMT1CPW14            : 1;
  unsigned SMT1CPW15            : 1;
  } __SMT1CPWHbits_t;

extern __at(0x0D93) volatile __SMT1CPWHbits_t SMT1CPWHbits;

#define _SMT1CPW8               0x01
#define _SMT1CPW9               0x02
#define _SMT1CPW10              0x04
#define _SMT1CPW11              0x08
#define _SMT1CPW12              0x10
#define _SMT1CPW13              0x20
#define _SMT1CPW14              0x40
#define _SMT1CPW15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPWU Bits

extern __at(0x0D94) __sfr SMT1CPWU;

typedef struct
  {
  unsigned SMT1CPW16            : 1;
  unsigned SMT1CPW17            : 1;
  unsigned SMT1CPW18            : 1;
  unsigned SMT1CPW19            : 1;
  unsigned SMT1CPW20            : 1;
  unsigned SMT1CPW21            : 1;
  unsigned SMT1CPW22            : 1;
  unsigned SMT1CPW23            : 1;
  } __SMT1CPWUbits_t;

extern __at(0x0D94) volatile __SMT1CPWUbits_t SMT1CPWUbits;

#define _SMT1CPW16              0x01
#define _SMT1CPW17              0x02
#define _SMT1CPW18              0x04
#define _SMT1CPW19              0x08
#define _SMT1CPW20              0x10
#define _SMT1CPW21              0x20
#define _SMT1CPW22              0x40
#define _SMT1CPW23              0x80

//==============================================================================

extern __at(0x0D95) __sfr SMT1PR;

//==============================================================================
//        SMT1PRL Bits

extern __at(0x0D95) __sfr SMT1PRL;

typedef struct
  {
  unsigned SMT1PR0              : 1;
  unsigned SMT1PR1              : 1;
  unsigned SMT1PR2              : 1;
  unsigned SMT1PR3              : 1;
  unsigned SMT1PR4              : 1;
  unsigned SMT1PR5              : 1;
  unsigned SMT1PR6              : 1;
  unsigned SMT1PR7              : 1;
  } __SMT1PRLbits_t;

extern __at(0x0D95) volatile __SMT1PRLbits_t SMT1PRLbits;

#define _SMT1PR0                0x01
#define _SMT1PR1                0x02
#define _SMT1PR2                0x04
#define _SMT1PR3                0x08
#define _SMT1PR4                0x10
#define _SMT1PR5                0x20
#define _SMT1PR6                0x40
#define _SMT1PR7                0x80

//==============================================================================


//==============================================================================
//        SMT1PRH Bits

extern __at(0x0D96) __sfr SMT1PRH;

typedef struct
  {
  unsigned SMT1PR8              : 1;
  unsigned SMT1PR9              : 1;
  unsigned SMT1PR10             : 1;
  unsigned SMT1PR11             : 1;
  unsigned SMT1PR12             : 1;
  unsigned SMT1PR13             : 1;
  unsigned SMT1PR14             : 1;
  unsigned SMT1PR15             : 1;
  } __SMT1PRHbits_t;

extern __at(0x0D96) volatile __SMT1PRHbits_t SMT1PRHbits;

#define _SMT1PR8                0x01
#define _SMT1PR9                0x02
#define _SMT1PR10               0x04
#define _SMT1PR11               0x08
#define _SMT1PR12               0x10
#define _SMT1PR13               0x20
#define _SMT1PR14               0x40
#define _SMT1PR15               0x80

//==============================================================================


//==============================================================================
//        SMT1PRU Bits

extern __at(0x0D97) __sfr SMT1PRU;

typedef struct
  {
  unsigned SMT1PR16             : 1;
  unsigned SMT1PR17             : 1;
  unsigned SMT1PR18             : 1;
  unsigned SMT1PR19             : 1;
  unsigned SMT1PR20             : 1;
  unsigned SMT1PR21             : 1;
  unsigned SMT1PR22             : 1;
  unsigned SMT1PR23             : 1;
  } __SMT1PRUbits_t;

extern __at(0x0D97) volatile __SMT1PRUbits_t SMT1PRUbits;

#define _SMT1PR16               0x01
#define _SMT1PR17               0x02
#define _SMT1PR18               0x04
#define _SMT1PR19               0x08
#define _SMT1PR20               0x10
#define _SMT1PR21               0x20
#define _SMT1PR22               0x40
#define _SMT1PR23               0x80

//==============================================================================


//==============================================================================
//        SMT1CON0 Bits

extern __at(0x0D98) __sfr SMT1CON0;

typedef union
  {
  struct
    {
    unsigned SMT1PS0            : 1;
    unsigned SMT1PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SMT1PS             : 2;
    unsigned                    : 6;
    };
  } __SMT1CON0bits_t;

extern __at(0x0D98) volatile __SMT1CON0bits_t SMT1CON0bits;

#define _SMT1CON0_SMT1PS0       0x01
#define _SMT1CON0_SMT1PS1       0x02
#define _SMT1CON0_CPOL          0x04
#define _SMT1CON0_SPOL          0x08
#define _SMT1CON0_WPOL          0x10
#define _SMT1CON0_STP           0x20
#define _SMT1CON0_EN            0x80

//==============================================================================


//==============================================================================
//        SMT1CON1 Bits

extern __at(0x0D99) __sfr SMT1CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT1GO             : 1;
    };

  struct
    {
    unsigned SMT1MODE0          : 1;
    unsigned SMT1MODE1          : 1;
    unsigned SMT1MODE2          : 1;
    unsigned SMT1MODE3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1REPEAT         : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __SMT1CON1bits_t;

extern __at(0x0D99) volatile __SMT1CON1bits_t SMT1CON1bits;

#define _SMT1CON1_MODE0         0x01
#define _SMT1CON1_SMT1MODE0     0x01
#define _SMT1CON1_MODE1         0x02
#define _SMT1CON1_SMT1MODE1     0x02
#define _SMT1CON1_MODE2         0x04
#define _SMT1CON1_SMT1MODE2     0x04
#define _SMT1CON1_MODE3         0x08
#define _SMT1CON1_SMT1MODE3     0x08
#define _SMT1CON1_REPEAT        0x40
#define _SMT1CON1_SMT1REPEAT    0x40
#define _SMT1CON1_SMT1GO        0x80

//==============================================================================


//==============================================================================
//        SMT1STAT Bits

extern __at(0x0D9A) __sfr SMT1STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT1AS             : 1;
    unsigned SMT1WS             : 1;
    unsigned SMT1TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1RESET          : 1;
    unsigned SMT1CPWUP          : 1;
    unsigned SMT1CPRUP          : 1;
    };
  } __SMT1STATbits_t;

extern __at(0x0D9A) volatile __SMT1STATbits_t SMT1STATbits;

#define _AS                     0x01
#define _SMT1AS                 0x01
#define _WS                     0x02
#define _SMT1WS                 0x02
#define _TS                     0x04
#define _SMT1TS                 0x04
#define _RST                    0x20
#define _SMT1RESET              0x20
#define _CPWUP                  0x40
#define _SMT1CPWUP              0x40
#define _CPRUP                  0x80
#define _SMT1CPRUP              0x80

//==============================================================================


//==============================================================================
//        SMT1CLK Bits

extern __at(0x0D9B) __sfr SMT1CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1CSEL0          : 1;
    unsigned SMT1CSEL1          : 1;
    unsigned SMT1CSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CSEL               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SMT1CSEL           : 3;
    unsigned                    : 5;
    };
  } __SMT1CLKbits_t;

extern __at(0x0D9B) volatile __SMT1CLKbits_t SMT1CLKbits;

#define _CSEL0                  0x01
#define _SMT1CSEL0              0x01
#define _CSEL1                  0x02
#define _SMT1CSEL1              0x02
#define _CSEL2                  0x04
#define _SMT1CSEL2              0x04

//==============================================================================


//==============================================================================
//        SMT1SIG Bits

extern __at(0x0D9C) __sfr SMT1SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL0          : 1;
    unsigned SMT1SSEL1          : 1;
    unsigned SMT1SSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SSEL               : 3;
    unsigned                    : 5;
    };
  } __SMT1SIGbits_t;

extern __at(0x0D9C) volatile __SMT1SIGbits_t SMT1SIGbits;

#define _SSEL0                  0x01
#define _SMT1SSEL0              0x01
#define _SSEL1                  0x02
#define _SMT1SSEL1              0x02
#define _SSEL2                  0x04
#define _SMT1SSEL2              0x04

//==============================================================================


//==============================================================================
//        SMT1WIN Bits

extern __at(0x0D9D) __sfr SMT1WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1WSEL0          : 1;
    unsigned SMT1WSEL1          : 1;
    unsigned SMT1WSEL2          : 1;
    unsigned SMT1WSEL3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1WSEL           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned WSEL               : 4;
    unsigned                    : 4;
    };
  } __SMT1WINbits_t;

extern __at(0x0D9D) volatile __SMT1WINbits_t SMT1WINbits;

#define _WSEL0                  0x01
#define _SMT1WSEL0              0x01
#define _WSEL1                  0x02
#define _SMT1WSEL1              0x02
#define _WSEL2                  0x04
#define _SMT1WSEL2              0x04
#define _WSEL3                  0x08
#define _SMT1WSEL3              0x08

//==============================================================================

extern __at(0x0D9E) __sfr SMT2TMR;

//==============================================================================
//        SMT2TMRL Bits

extern __at(0x0D9E) __sfr SMT2TMRL;

typedef struct
  {
  unsigned SMT2TMR0             : 1;
  unsigned SMT2TMR1             : 1;
  unsigned SMT2TMR2             : 1;
  unsigned SMT2TMR3             : 1;
  unsigned SMT2TMR4             : 1;
  unsigned SMT2TMR5             : 1;
  unsigned SMT2TMR6             : 1;
  unsigned SMT2TMR7             : 1;
  } __SMT2TMRLbits_t;

extern __at(0x0D9E) volatile __SMT2TMRLbits_t SMT2TMRLbits;

#define _SMT2TMR0               0x01
#define _SMT2TMR1               0x02
#define _SMT2TMR2               0x04
#define _SMT2TMR3               0x08
#define _SMT2TMR4               0x10
#define _SMT2TMR5               0x20
#define _SMT2TMR6               0x40
#define _SMT2TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT2TMRH Bits

extern __at(0x0D9F) __sfr SMT2TMRH;

typedef struct
  {
  unsigned SMT2TMR8             : 1;
  unsigned SMT2TMR9             : 1;
  unsigned SMT2TMR10            : 1;
  unsigned SMT2TMR11            : 1;
  unsigned SMT2TMR12            : 1;
  unsigned SMT2TMR13            : 1;
  unsigned SMT2TMR14            : 1;
  unsigned SMT2TMR15            : 1;
  } __SMT2TMRHbits_t;

extern __at(0x0D9F) volatile __SMT2TMRHbits_t SMT2TMRHbits;

#define _SMT2TMR8               0x01
#define _SMT2TMR9               0x02
#define _SMT2TMR10              0x04
#define _SMT2TMR11              0x08
#define _SMT2TMR12              0x10
#define _SMT2TMR13              0x20
#define _SMT2TMR14              0x40
#define _SMT2TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT2TMRU Bits

extern __at(0x0DA0) __sfr SMT2TMRU;

typedef struct
  {
  unsigned SMT2TMR16            : 1;
  unsigned SMT2TMR17            : 1;
  unsigned SMT2TMR18            : 1;
  unsigned SMT2TMR19            : 1;
  unsigned SMT2TMR20            : 1;
  unsigned SMT2TMR21            : 1;
  unsigned SMT2TMR22            : 1;
  unsigned SMT2TMR23            : 1;
  } __SMT2TMRUbits_t;

extern __at(0x0DA0) volatile __SMT2TMRUbits_t SMT2TMRUbits;

#define _SMT2TMR16              0x01
#define _SMT2TMR17              0x02
#define _SMT2TMR18              0x04
#define _SMT2TMR19              0x08
#define _SMT2TMR20              0x10
#define _SMT2TMR21              0x20
#define _SMT2TMR22              0x40
#define _SMT2TMR23              0x80

//==============================================================================

extern __at(0x0DA1) __sfr SMT2CPR;

//==============================================================================
//        SMT2CPRL Bits

extern __at(0x0DA1) __sfr SMT2CPRL;

typedef struct
  {
  unsigned SMT2CPR0             : 1;
  unsigned SMT2CPR1             : 1;
  unsigned SMT2CPR2             : 1;
  unsigned SMT2CPR3             : 1;
  unsigned SMT2CPR4             : 1;
  unsigned SMT2CPR5             : 1;
  unsigned SMT2CPR6             : 1;
  unsigned SMT2CPR7             : 1;
  } __SMT2CPRLbits_t;

extern __at(0x0DA1) volatile __SMT2CPRLbits_t SMT2CPRLbits;

#define _SMT2CPR0               0x01
#define _SMT2CPR1               0x02
#define _SMT2CPR2               0x04
#define _SMT2CPR3               0x08
#define _SMT2CPR4               0x10
#define _SMT2CPR5               0x20
#define _SMT2CPR6               0x40
#define _SMT2CPR7               0x80

//==============================================================================


//==============================================================================
//        SMT2CPRH Bits

extern __at(0x0DA2) __sfr SMT2CPRH;

typedef struct
  {
  unsigned SMT2CPR8             : 1;
  unsigned SMT2CPR9             : 1;
  unsigned SMT2CPR10            : 1;
  unsigned SMT2CPR11            : 1;
  unsigned SMT2CPR12            : 1;
  unsigned SMT2CPR13            : 1;
  unsigned SMT2CPR14            : 1;
  unsigned SMT2CPR15            : 1;
  } __SMT2CPRHbits_t;

extern __at(0x0DA2) volatile __SMT2CPRHbits_t SMT2CPRHbits;

#define _SMT2CPR8               0x01
#define _SMT2CPR9               0x02
#define _SMT2CPR10              0x04
#define _SMT2CPR11              0x08
#define _SMT2CPR12              0x10
#define _SMT2CPR13              0x20
#define _SMT2CPR14              0x40
#define _SMT2CPR15              0x80

//==============================================================================


//==============================================================================
//        SMT2CPRU Bits

extern __at(0x0DA3) __sfr SMT2CPRU;

typedef struct
  {
  unsigned SMT2CPR16            : 1;
  unsigned SMT2CPR17            : 1;
  unsigned SMT2CPR18            : 1;
  unsigned SMT2CPR19            : 1;
  unsigned SMT2CPR20            : 1;
  unsigned SMT2CPR21            : 1;
  unsigned SMT2CPR22            : 1;
  unsigned SMT2CPR23            : 1;
  } __SMT2CPRUbits_t;

extern __at(0x0DA3) volatile __SMT2CPRUbits_t SMT2CPRUbits;

#define _SMT2CPR16              0x01
#define _SMT2CPR17              0x02
#define _SMT2CPR18              0x04
#define _SMT2CPR19              0x08
#define _SMT2CPR20              0x10
#define _SMT2CPR21              0x20
#define _SMT2CPR22              0x40
#define _SMT2CPR23              0x80

//==============================================================================

extern __at(0x0DA4) __sfr SMT2CPW;

//==============================================================================
//        SMT2CPWL Bits

extern __at(0x0DA4) __sfr SMT2CPWL;

typedef struct
  {
  unsigned SMT2CPW0             : 1;
  unsigned SMT2CPW1             : 1;
  unsigned SMT2CPW2             : 1;
  unsigned SMT2CPW3             : 1;
  unsigned SMT2CPW4             : 1;
  unsigned SMT2CPW5             : 1;
  unsigned SMT2CPW6             : 1;
  unsigned SMT2CPW7             : 1;
  } __SMT2CPWLbits_t;

extern __at(0x0DA4) volatile __SMT2CPWLbits_t SMT2CPWLbits;

#define _SMT2CPW0               0x01
#define _SMT2CPW1               0x02
#define _SMT2CPW2               0x04
#define _SMT2CPW3               0x08
#define _SMT2CPW4               0x10
#define _SMT2CPW5               0x20
#define _SMT2CPW6               0x40
#define _SMT2CPW7               0x80

//==============================================================================


//==============================================================================
//        SMT2CPWH Bits

extern __at(0x0DA5) __sfr SMT2CPWH;

typedef struct
  {
  unsigned SMT2CPW8             : 1;
  unsigned SMT2CPW9             : 1;
  unsigned SMT2CPW10            : 1;
  unsigned SMT2CPW11            : 1;
  unsigned SMT2CPW12            : 1;
  unsigned SMT2CPW13            : 1;
  unsigned SMT2CPW14            : 1;
  unsigned SMT2CPW15            : 1;
  } __SMT2CPWHbits_t;

extern __at(0x0DA5) volatile __SMT2CPWHbits_t SMT2CPWHbits;

#define _SMT2CPW8               0x01
#define _SMT2CPW9               0x02
#define _SMT2CPW10              0x04
#define _SMT2CPW11              0x08
#define _SMT2CPW12              0x10
#define _SMT2CPW13              0x20
#define _SMT2CPW14              0x40
#define _SMT2CPW15              0x80

//==============================================================================


//==============================================================================
//        SMT2CPWU Bits

extern __at(0x0DA6) __sfr SMT2CPWU;

typedef struct
  {
  unsigned SMT2CPW16            : 1;
  unsigned SMT2CPW17            : 1;
  unsigned SMT2CPW18            : 1;
  unsigned SMT2CPW19            : 1;
  unsigned SMT2CPW20            : 1;
  unsigned SMT2CPW21            : 1;
  unsigned SMT2CPW22            : 1;
  unsigned SMT2CPW23            : 1;
  } __SMT2CPWUbits_t;

extern __at(0x0DA6) volatile __SMT2CPWUbits_t SMT2CPWUbits;

#define _SMT2CPW16              0x01
#define _SMT2CPW17              0x02
#define _SMT2CPW18              0x04
#define _SMT2CPW19              0x08
#define _SMT2CPW20              0x10
#define _SMT2CPW21              0x20
#define _SMT2CPW22              0x40
#define _SMT2CPW23              0x80

//==============================================================================

extern __at(0x0DA7) __sfr SMT2PR;

//==============================================================================
//        SMT2PRL Bits

extern __at(0x0DA7) __sfr SMT2PRL;

typedef struct
  {
  unsigned SMT2PR0              : 1;
  unsigned SMT2PR1              : 1;
  unsigned SMT2PR2              : 1;
  unsigned SMT2PR3              : 1;
  unsigned SMT2PR4              : 1;
  unsigned SMT2PR5              : 1;
  unsigned SMT2PR6              : 1;
  unsigned SMT2PR7              : 1;
  } __SMT2PRLbits_t;

extern __at(0x0DA7) volatile __SMT2PRLbits_t SMT2PRLbits;

#define _SMT2PR0                0x01
#define _SMT2PR1                0x02
#define _SMT2PR2                0x04
#define _SMT2PR3                0x08
#define _SMT2PR4                0x10
#define _SMT2PR5                0x20
#define _SMT2PR6                0x40
#define _SMT2PR7                0x80

//==============================================================================


//==============================================================================
//        SMT2PRH Bits

extern __at(0x0DA8) __sfr SMT2PRH;

typedef struct
  {
  unsigned SMT2PR8              : 1;
  unsigned SMT2PR9              : 1;
  unsigned SMT2PR10             : 1;
  unsigned SMT2PR11             : 1;
  unsigned SMT2PR12             : 1;
  unsigned SMT2PR13             : 1;
  unsigned SMT2PR14             : 1;
  unsigned SMT2PR15             : 1;
  } __SMT2PRHbits_t;

extern __at(0x0DA8) volatile __SMT2PRHbits_t SMT2PRHbits;

#define _SMT2PR8                0x01
#define _SMT2PR9                0x02
#define _SMT2PR10               0x04
#define _SMT2PR11               0x08
#define _SMT2PR12               0x10
#define _SMT2PR13               0x20
#define _SMT2PR14               0x40
#define _SMT2PR15               0x80

//==============================================================================


//==============================================================================
//        SMT2PRU Bits

extern __at(0x0DA9) __sfr SMT2PRU;

typedef struct
  {
  unsigned SMT2PR16             : 1;
  unsigned SMT2PR17             : 1;
  unsigned SMT2PR18             : 1;
  unsigned SMT2PR19             : 1;
  unsigned SMT2PR20             : 1;
  unsigned SMT2PR21             : 1;
  unsigned SMT2PR22             : 1;
  unsigned SMT2PR23             : 1;
  } __SMT2PRUbits_t;

extern __at(0x0DA9) volatile __SMT2PRUbits_t SMT2PRUbits;

#define _SMT2PR16               0x01
#define _SMT2PR17               0x02
#define _SMT2PR18               0x04
#define _SMT2PR19               0x08
#define _SMT2PR20               0x10
#define _SMT2PR21               0x20
#define _SMT2PR22               0x40
#define _SMT2PR23               0x80

//==============================================================================


//==============================================================================
//        SMT2CON0 Bits

extern __at(0x0DAA) __sfr SMT2CON0;

typedef union
  {
  struct
    {
    unsigned SMT2PS0            : 1;
    unsigned SMT2PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SMT2PS             : 2;
    unsigned                    : 6;
    };
  } __SMT2CON0bits_t;

extern __at(0x0DAA) volatile __SMT2CON0bits_t SMT2CON0bits;

#define _SMT2CON0_SMT2PS0       0x01
#define _SMT2CON0_SMT2PS1       0x02
#define _SMT2CON0_CPOL          0x04
#define _SMT2CON0_SPOL          0x08
#define _SMT2CON0_WPOL          0x10
#define _SMT2CON0_STP           0x20
#define _SMT2CON0_EN            0x80

//==============================================================================


//==============================================================================
//        SMT2CON1 Bits

extern __at(0x0DAB) __sfr SMT2CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT2GO             : 1;
    };

  struct
    {
    unsigned SMT2MODE0          : 1;
    unsigned SMT2MODE1          : 1;
    unsigned SMT2MODE2          : 1;
    unsigned SMT2MODE3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2REPEAT         : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned SMT2MODE           : 4;
    unsigned                    : 4;
    };
  } __SMT2CON1bits_t;

extern __at(0x0DAB) volatile __SMT2CON1bits_t SMT2CON1bits;

#define _SMT2CON1_MODE0         0x01
#define _SMT2CON1_SMT2MODE0     0x01
#define _SMT2CON1_MODE1         0x02
#define _SMT2CON1_SMT2MODE1     0x02
#define _SMT2CON1_MODE2         0x04
#define _SMT2CON1_SMT2MODE2     0x04
#define _SMT2CON1_MODE3         0x08
#define _SMT2CON1_SMT2MODE3     0x08
#define _SMT2CON1_REPEAT        0x40
#define _SMT2CON1_SMT2REPEAT    0x40
#define _SMT2CON1_SMT2GO        0x80

//==============================================================================


//==============================================================================
//        SMT2STAT Bits

extern __at(0x0DAC) __sfr SMT2STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT2AS             : 1;
    unsigned SMT2WS             : 1;
    unsigned SMT2TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2RESET          : 1;
    unsigned SMT2CPWUP          : 1;
    unsigned SMT2CPRUP          : 1;
    };
  } __SMT2STATbits_t;

extern __at(0x0DAC) volatile __SMT2STATbits_t SMT2STATbits;

#define _SMT2STAT_AS            0x01
#define _SMT2STAT_SMT2AS        0x01
#define _SMT2STAT_WS            0x02
#define _SMT2STAT_SMT2WS        0x02
#define _SMT2STAT_TS            0x04
#define _SMT2STAT_SMT2TS        0x04
#define _SMT2STAT_RST           0x20
#define _SMT2STAT_SMT2RESET     0x20
#define _SMT2STAT_CPWUP         0x40
#define _SMT2STAT_SMT2CPWUP     0x40
#define _SMT2STAT_CPRUP         0x80
#define _SMT2STAT_SMT2CPRUP     0x80

//==============================================================================


//==============================================================================
//        SMT2CLK Bits

extern __at(0x0DAD) __sfr SMT2CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned CSEL3              : 1;
    unsigned CSEL4              : 1;
    unsigned CSEL5              : 1;
    unsigned CSEL6              : 1;
    unsigned CSEL7              : 1;
    };

  struct
    {
    unsigned SMT2CSEL0          : 1;
    unsigned SMT2CSEL1          : 1;
    unsigned SMT2CSEL2          : 1;
    unsigned SMT2CSEL3          : 1;
    unsigned SMT2CSEL4          : 1;
    unsigned SMT2CSEL5          : 1;
    unsigned SMT2CSEL6          : 1;
    unsigned SMT2CSEL7          : 1;
    };
  } __SMT2CLKbits_t;

extern __at(0x0DAD) volatile __SMT2CLKbits_t SMT2CLKbits;

#define _SMT2CLK_CSEL0          0x01
#define _SMT2CLK_SMT2CSEL0      0x01
#define _SMT2CLK_CSEL1          0x02
#define _SMT2CLK_SMT2CSEL1      0x02
#define _SMT2CLK_CSEL2          0x04
#define _SMT2CLK_SMT2CSEL2      0x04
#define _SMT2CLK_CSEL3          0x08
#define _SMT2CLK_SMT2CSEL3      0x08
#define _SMT2CLK_CSEL4          0x10
#define _SMT2CLK_SMT2CSEL4      0x10
#define _SMT2CLK_CSEL5          0x20
#define _SMT2CLK_SMT2CSEL5      0x20
#define _SMT2CLK_CSEL6          0x40
#define _SMT2CLK_SMT2CSEL6      0x40
#define _SMT2CLK_CSEL7          0x80
#define _SMT2CLK_SMT2CSEL7      0x80

//==============================================================================


//==============================================================================
//        SMT2SIG Bits

extern __at(0x0DAE) __sfr SMT2SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned SSEL3              : 1;
    unsigned SSEL4              : 1;
    unsigned SSEL5              : 1;
    unsigned SSEL6              : 1;
    unsigned SSEL7              : 1;
    };

  struct
    {
    unsigned SMT2SSEL0          : 1;
    unsigned SMT2SSEL1          : 1;
    unsigned SMT2SSEL2          : 1;
    unsigned SMT2SSEL3          : 1;
    unsigned SMT2SSEL4          : 1;
    unsigned SMT2SSEL5          : 1;
    unsigned SMT2SSEL6          : 1;
    unsigned SMT2SSEL7          : 1;
    };
  } __SMT2SIGbits_t;

extern __at(0x0DAE) volatile __SMT2SIGbits_t SMT2SIGbits;

#define _SMT2SIG_SSEL0          0x01
#define _SMT2SIG_SMT2SSEL0      0x01
#define _SMT2SIG_SSEL1          0x02
#define _SMT2SIG_SMT2SSEL1      0x02
#define _SMT2SIG_SSEL2          0x04
#define _SMT2SIG_SMT2SSEL2      0x04
#define _SMT2SIG_SSEL3          0x08
#define _SMT2SIG_SMT2SSEL3      0x08
#define _SMT2SIG_SSEL4          0x10
#define _SMT2SIG_SMT2SSEL4      0x10
#define _SMT2SIG_SSEL5          0x20
#define _SMT2SIG_SMT2SSEL5      0x20
#define _SMT2SIG_SSEL6          0x40
#define _SMT2SIG_SMT2SSEL6      0x40
#define _SMT2SIG_SSEL7          0x80
#define _SMT2SIG_SMT2SSEL7      0x80

//==============================================================================


//==============================================================================
//        SMT2WIN Bits

extern __at(0x0DAF) __sfr SMT2WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned WSEL4              : 1;
    unsigned WSEL5              : 1;
    unsigned WSEL6              : 1;
    unsigned WSEL7              : 1;
    };

  struct
    {
    unsigned SMT2WSEL0          : 1;
    unsigned SMT2WSEL1          : 1;
    unsigned SMT2WSEL2          : 1;
    unsigned SMT2WSEL3          : 1;
    unsigned SMT2WSEL4          : 1;
    unsigned SMT2WSEL5          : 1;
    unsigned SMT2WSEL6          : 1;
    unsigned SMT2WSEL7          : 1;
    };
  } __SMT2WINbits_t;

extern __at(0x0DAF) volatile __SMT2WINbits_t SMT2WINbits;

#define _SMT2WIN_WSEL0          0x01
#define _SMT2WIN_SMT2WSEL0      0x01
#define _SMT2WIN_WSEL1          0x02
#define _SMT2WIN_SMT2WSEL1      0x02
#define _SMT2WIN_WSEL2          0x04
#define _SMT2WIN_SMT2WSEL2      0x04
#define _SMT2WIN_WSEL3          0x08
#define _SMT2WIN_SMT2WSEL3      0x08
#define _SMT2WIN_WSEL4          0x10
#define _SMT2WIN_SMT2WSEL4      0x10
#define _SMT2WIN_WSEL5          0x20
#define _SMT2WIN_SMT2WSEL5      0x20
#define _SMT2WIN_WSEL6          0x40
#define _SMT2WIN_SMT2WSEL6      0x40
#define _SMT2WIN_WSEL7          0x80
#define _SMT2WIN_SMT2WSEL7      0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008
#define _CONFIG3                0x8009

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _ZCD_ON                 0x3F7F  // ZCD always enabled.
#define _ZCD_OFF                0x3FFF  // ZCD disable.  ZCD can be enabled by setting the ZCDSEN bit of ZCDCON.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//----------------------------- CONFIG3 Options -------------------------------

#define _WDTCPS_WDTCPS0         0x3FE0  // 1:32 (1 ms period).
#define _WDTCPS_WDTCPS1         0x3FE1  // 1:64 (2 ms period).
#define _WDTCPS_WDTCPS2         0x3FE2  // 1:128 (4 ms period).
#define _WDTCPS_WDTCPS3         0x3FE3  // 1:256 (8 ms period).
#define _WDTCPS_WDTCPS4         0x3FE4  // 1:512 (16 ms period).
#define _WDTCPS_WDTCPS5         0x3FE5  // 1:1024 (32 ms period).
#define _WDTCPS_WDTCPS6         0x3FE6  // 1:2048 (64 ms period).
#define _WDTCPS_WDTCPS7         0x3FE7  // 1:4096 (128 ms period).
#define _WDTCPS_WDTCPS8         0x3FE8  // 1:8192 (256 ms period).
#define _WDTCPS_WDTCPS9         0x3FE9  // 1:16384 (512 ms period).
#define _WDTCPS_WDTCPSA         0x3FEA  // 1:32768 (1 s period).
#define _WDTCPS_WDTCPSB         0x3FEB  // 1:65536 (2 s period).
#define _WDTCPS_WDTCPSC         0x3FEC  // 1:131072 (4 s period).
#define _WDTCPS_WDTCPSD         0x3FED  // 1:262144 (8 s period).
#define _WDTCPS_WDTCPSE         0x3FEE  // 1:524299 (16 s period).
#define _WDTCPS_WDTCPSF         0x3FEF  // 1:1048576 (32 s period).
#define _WDTCPS_WDTCPS10        0x3FF0  // 1:2097152 (64 s period).
#define _WDTCPS_WDTCPS11        0x3FF1  // 1:4194304 (128 s period).
#define _WDTCPS_WDTCPS12        0x3FF2  // 1:8388608 (256 s period).
#define _WDTCPS_WDTCPS1F        0x3FFF  // Software Control (WDTPS).
#define _WDTE_OFF               0x3F9F  // WDT disabled.
#define _WDTE_SWDTEN            0x3FBF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FDF  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDTCWS_WDTCWS125       0x38FF  // 12.5 percent window open time.
#define _WDTCWS_WDTCWS25        0x39FF  // 25 percent window open time.
#define _WDTCWS_WDTCWS375       0x3AFF  // 37.5 percent window open time.
#define _WDTCWS_WDTCWS50        0x3BFF  // 50 percent window open time.
#define _WDTCWS_WDTCWS625       0x3CFF  // 62.5 percent window open time.
#define _WDTCWS_WDTCWS75        0x3DFF  // 75 percent window open time.
#define _WDTCWS_WDTCWS100       0x3EFF  // 100 percent window open time (Legacy WDT).
#define _WDTCWS_WDTCWSSW        0x3FFF  // Software WDT window size control (WDTWS bits).
#define _WDTCCS_LFINTOSC        0x07FF  // 31.0 kHz LFINTOSC.
#define _WDTCCS_MFINTOSC        0x0FFF  // 31.0 kHz LFINTOSC.
#define _WDTCCS_SWC             0x3FFF  // Software control, controlled by WDTCS bits.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define CCP1SEL                 APFCONbits.CCP1SEL              // bit 0
#define T1GSEL                  APFCONbits.T1GSEL               // bit 3
#define CWGBSEL                 APFCONbits.CWGBSEL              // bit 5
#define CWGASEL                 APFCONbits.CWGASEL              // bit 6

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CTS0                    CCP1CAPbits.CTS0                // bit 0, shadows bit in CCP1CAPbits
#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0, shadows bit in CCP1CAPbits
#define CTS1                    CCP1CAPbits.CTS1                // bit 1, shadows bit in CCP1CAPbits
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1, shadows bit in CCP1CAPbits

#define MODE0                   CCP1CONbits.MODE0               // bit 0, shadows bit in CCP1CONbits
#define CCP1MODE0               CCP1CONbits.CCP1MODE0           // bit 0, shadows bit in CCP1CONbits
#define MODE1                   CCP1CONbits.MODE1               // bit 1, shadows bit in CCP1CONbits
#define CCP1MODE1               CCP1CONbits.CCP1MODE1           // bit 1, shadows bit in CCP1CONbits
#define MODE2                   CCP1CONbits.MODE2               // bit 2, shadows bit in CCP1CONbits
#define CCP1MODE2               CCP1CONbits.CCP1MODE2           // bit 2, shadows bit in CCP1CONbits
#define MODE3                   CCP1CONbits.MODE3               // bit 3, shadows bit in CCP1CONbits
#define CCP1MODE3               CCP1CONbits.CCP1MODE3           // bit 3, shadows bit in CCP1CONbits
#define FMT                     CCP1CONbits.FMT                 // bit 4, shadows bit in CCP1CONbits
#define CCP1FMT                 CCP1CONbits.CCP1FMT             // bit 4, shadows bit in CCP1CONbits
#define OUT                     CCP1CONbits.OUT                 // bit 5, shadows bit in CCP1CONbits
#define CCP1OUT                 CCP1CONbits.CCP1OUT             // bit 5, shadows bit in CCP1CONbits
#define OE                      CCP1CONbits.OE                  // bit 6, shadows bit in CCP1CONbits
#define CCP1OE                  CCP1CONbits.CCP1OE              // bit 6, shadows bit in CCP1CONbits
#define EN                      CCP1CONbits.EN                  // bit 7, shadows bit in CCP1CONbits
#define CCP1EN                  CCP1CONbits.CCP1EN              // bit 7, shadows bit in CCP1CONbits

#define CCP1TSEL0               CCPTMRSbits.CCP1TSEL0           // bit 0
#define CCP1TSEL1               CCPTMRSbits.CCP1TSEL1           // bit 1
#define CCP2TSEL0               CCPTMRSbits.CCP2TSEL0           // bit 2
#define CCP2TSEL1               CCPTMRSbits.CCP2TSEL1           // bit 3

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 4
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0

#define ACC8                    CRCACCHbits.ACC8                // bit 0, shadows bit in CRCACCHbits
#define CRCACC8                 CRCACCHbits.CRCACC8             // bit 0, shadows bit in CRCACCHbits
#define ACC9                    CRCACCHbits.ACC9                // bit 1, shadows bit in CRCACCHbits
#define CRCACC9                 CRCACCHbits.CRCACC9             // bit 1, shadows bit in CRCACCHbits
#define ACC10                   CRCACCHbits.ACC10               // bit 2, shadows bit in CRCACCHbits
#define CRCACC10                CRCACCHbits.CRCACC10            // bit 2, shadows bit in CRCACCHbits
#define ACC11                   CRCACCHbits.ACC11               // bit 3, shadows bit in CRCACCHbits
#define CRCACC11                CRCACCHbits.CRCACC11            // bit 3, shadows bit in CRCACCHbits
#define ACC12                   CRCACCHbits.ACC12               // bit 4, shadows bit in CRCACCHbits
#define CRCACC12                CRCACCHbits.CRCACC12            // bit 4, shadows bit in CRCACCHbits
#define ACC13                   CRCACCHbits.ACC13               // bit 5, shadows bit in CRCACCHbits
#define CRCACC13                CRCACCHbits.CRCACC13            // bit 5, shadows bit in CRCACCHbits
#define ACC14                   CRCACCHbits.ACC14               // bit 6, shadows bit in CRCACCHbits
#define CRCACC14                CRCACCHbits.CRCACC14            // bit 6, shadows bit in CRCACCHbits
#define ACC15                   CRCACCHbits.ACC15               // bit 7, shadows bit in CRCACCHbits
#define CRCACC15                CRCACCHbits.CRCACC15            // bit 7, shadows bit in CRCACCHbits

#define ACC0                    CRCACCLbits.ACC0                // bit 0, shadows bit in CRCACCLbits
#define CRCACC0                 CRCACCLbits.CRCACC0             // bit 0, shadows bit in CRCACCLbits
#define ACC1                    CRCACCLbits.ACC1                // bit 1, shadows bit in CRCACCLbits
#define CRCACC1                 CRCACCLbits.CRCACC1             // bit 1, shadows bit in CRCACCLbits
#define ACC2                    CRCACCLbits.ACC2                // bit 2, shadows bit in CRCACCLbits
#define CRCACC2                 CRCACCLbits.CRCACC2             // bit 2, shadows bit in CRCACCLbits
#define ACC3                    CRCACCLbits.ACC3                // bit 3, shadows bit in CRCACCLbits
#define CRCACC3                 CRCACCLbits.CRCACC3             // bit 3, shadows bit in CRCACCLbits
#define ACC4                    CRCACCLbits.ACC4                // bit 4, shadows bit in CRCACCLbits
#define CRCACC4                 CRCACCLbits.CRCACC4             // bit 4, shadows bit in CRCACCLbits
#define ACC5                    CRCACCLbits.ACC5                // bit 5, shadows bit in CRCACCLbits
#define CRCACC5                 CRCACCLbits.CRCACC5             // bit 5, shadows bit in CRCACCLbits
#define ACC6                    CRCACCLbits.ACC6                // bit 6, shadows bit in CRCACCLbits
#define CRCACC6                 CRCACCLbits.CRCACC6             // bit 6, shadows bit in CRCACCLbits
#define ACC7                    CRCACCLbits.ACC7                // bit 7, shadows bit in CRCACCLbits
#define CRCACC7                 CRCACCLbits.CRCACC7             // bit 7, shadows bit in CRCACCLbits

#define PLEN0                   CRCCON1bits.PLEN0               // bit 0, shadows bit in CRCCON1bits
#define CRCPLEN0                CRCCON1bits.CRCPLEN0            // bit 0, shadows bit in CRCCON1bits
#define PLEN1                   CRCCON1bits.PLEN1               // bit 1, shadows bit in CRCCON1bits
#define CRCPLEN1                CRCCON1bits.CRCPLEN1            // bit 1, shadows bit in CRCCON1bits
#define PLEN2                   CRCCON1bits.PLEN2               // bit 2, shadows bit in CRCCON1bits
#define CRCPLEN2                CRCCON1bits.CRCPLEN2            // bit 2, shadows bit in CRCCON1bits
#define PLEN3                   CRCCON1bits.PLEN3               // bit 3, shadows bit in CRCCON1bits
#define CRCPLEN3                CRCCON1bits.CRCPLEN3            // bit 3, shadows bit in CRCCON1bits
#define DLEN0                   CRCCON1bits.DLEN0               // bit 4, shadows bit in CRCCON1bits
#define CRCDLEN0                CRCCON1bits.CRCDLEN0            // bit 4, shadows bit in CRCCON1bits
#define DLEN1                   CRCCON1bits.DLEN1               // bit 5, shadows bit in CRCCON1bits
#define CRCDLEN1                CRCCON1bits.CRCDLEN1            // bit 5, shadows bit in CRCCON1bits
#define DLEN2                   CRCCON1bits.DLEN2               // bit 6, shadows bit in CRCCON1bits
#define CRCDLEN2                CRCCON1bits.CRCDLEN2            // bit 6, shadows bit in CRCCON1bits
#define DLEN3                   CRCCON1bits.DLEN3               // bit 7, shadows bit in CRCCON1bits
#define CRCDLEN3                CRCCON1bits.CRCDLEN3            // bit 7, shadows bit in CRCCON1bits

#define DAT8                    CRCDATHbits.DAT8                // bit 0, shadows bit in CRCDATHbits
#define CRCDAT8                 CRCDATHbits.CRCDAT8             // bit 0, shadows bit in CRCDATHbits
#define DAT9                    CRCDATHbits.DAT9                // bit 1, shadows bit in CRCDATHbits
#define CRCDAT9                 CRCDATHbits.CRCDAT9             // bit 1, shadows bit in CRCDATHbits
#define DAT10                   CRCDATHbits.DAT10               // bit 2, shadows bit in CRCDATHbits
#define CRCDAT10                CRCDATHbits.CRCDAT10            // bit 2, shadows bit in CRCDATHbits
#define DAT11                   CRCDATHbits.DAT11               // bit 3, shadows bit in CRCDATHbits
#define CRCDAT11                CRCDATHbits.CRCDAT11            // bit 3, shadows bit in CRCDATHbits
#define DAT12                   CRCDATHbits.DAT12               // bit 4, shadows bit in CRCDATHbits
#define CRCDAT12                CRCDATHbits.CRCDAT12            // bit 4, shadows bit in CRCDATHbits
#define DAT13                   CRCDATHbits.DAT13               // bit 5, shadows bit in CRCDATHbits
#define CRCDAT13                CRCDATHbits.CRCDAT13            // bit 5, shadows bit in CRCDATHbits
#define DAT14                   CRCDATHbits.DAT14               // bit 6, shadows bit in CRCDATHbits
#define CRCDAT14                CRCDATHbits.CRCDAT14            // bit 6, shadows bit in CRCDATHbits
#define DAT15                   CRCDATHbits.DAT15               // bit 7, shadows bit in CRCDATHbits
#define CRCDAT15                CRCDATHbits.CRCDAT15            // bit 7, shadows bit in CRCDATHbits

#define DAT0                    CRCDATLbits.DAT0                // bit 0, shadows bit in CRCDATLbits
#define CRCDAT0                 CRCDATLbits.CRCDAT0             // bit 0, shadows bit in CRCDATLbits
#define DAT1                    CRCDATLbits.DAT1                // bit 1, shadows bit in CRCDATLbits
#define CRCDAT1                 CRCDATLbits.CRCDAT1             // bit 1, shadows bit in CRCDATLbits
#define DAT2                    CRCDATLbits.DAT2                // bit 2, shadows bit in CRCDATLbits
#define CRCDAT2                 CRCDATLbits.CRCDAT2             // bit 2, shadows bit in CRCDATLbits
#define DAT3                    CRCDATLbits.DAT3                // bit 3, shadows bit in CRCDATLbits
#define CRCDAT3                 CRCDATLbits.CRCDAT3             // bit 3, shadows bit in CRCDATLbits
#define DAT4                    CRCDATLbits.DAT4                // bit 4, shadows bit in CRCDATLbits
#define CRCDAT4                 CRCDATLbits.CRCDAT4             // bit 4, shadows bit in CRCDATLbits
#define DAT5                    CRCDATLbits.DAT5                // bit 5, shadows bit in CRCDATLbits
#define CRCDAT5                 CRCDATLbits.CRCDAT5             // bit 5, shadows bit in CRCDATLbits
#define DAT6                    CRCDATLbits.DAT6                // bit 6, shadows bit in CRCDATLbits
#define CRCDAT6                 CRCDATLbits.CRCDAT6             // bit 6, shadows bit in CRCDATLbits
#define DAT7                    CRCDATLbits.DAT7                // bit 7, shadows bit in CRCDATLbits
#define CRDCDAT7                CRCDATLbits.CRDCDAT7            // bit 7, shadows bit in CRCDATLbits

#define SHIFT8                  CRCSHIFTHbits.SHIFT8            // bit 0, shadows bit in CRCSHIFTHbits
#define CRCSHIFT8               CRCSHIFTHbits.CRCSHIFT8         // bit 0, shadows bit in CRCSHIFTHbits
#define SHIFT9                  CRCSHIFTHbits.SHIFT9            // bit 1, shadows bit in CRCSHIFTHbits
#define CRCSHIFT9               CRCSHIFTHbits.CRCSHIFT9         // bit 1, shadows bit in CRCSHIFTHbits
#define SHIFT10                 CRCSHIFTHbits.SHIFT10           // bit 2, shadows bit in CRCSHIFTHbits
#define CRCSHIFT10              CRCSHIFTHbits.CRCSHIFT10        // bit 2, shadows bit in CRCSHIFTHbits
#define SHIFT11                 CRCSHIFTHbits.SHIFT11           // bit 3, shadows bit in CRCSHIFTHbits
#define CRCSHIFT11              CRCSHIFTHbits.CRCSHIFT11        // bit 3, shadows bit in CRCSHIFTHbits
#define SHIFT12                 CRCSHIFTHbits.SHIFT12           // bit 4, shadows bit in CRCSHIFTHbits
#define CRCSHIFT12              CRCSHIFTHbits.CRCSHIFT12        // bit 4, shadows bit in CRCSHIFTHbits
#define SHIFT13                 CRCSHIFTHbits.SHIFT13           // bit 5, shadows bit in CRCSHIFTHbits
#define CRCSHIFT13              CRCSHIFTHbits.CRCSHIFT13        // bit 5, shadows bit in CRCSHIFTHbits
#define SHIFT14                 CRCSHIFTHbits.SHIFT14           // bit 6, shadows bit in CRCSHIFTHbits
#define CRCSHIFT14              CRCSHIFTHbits.CRCSHIFT14        // bit 6, shadows bit in CRCSHIFTHbits
#define SHIFT15                 CRCSHIFTHbits.SHIFT15           // bit 7, shadows bit in CRCSHIFTHbits
#define CRCSHIFT15              CRCSHIFTHbits.CRCSHIFT15        // bit 7, shadows bit in CRCSHIFTHbits

#define SHIFT0                  CRCSHIFTLbits.SHIFT0            // bit 0, shadows bit in CRCSHIFTLbits
#define CRCSHIFT0               CRCSHIFTLbits.CRCSHIFT0         // bit 0, shadows bit in CRCSHIFTLbits
#define SHIFT1                  CRCSHIFTLbits.SHIFT1            // bit 1, shadows bit in CRCSHIFTLbits
#define CRCSHIFT1               CRCSHIFTLbits.CRCSHIFT1         // bit 1, shadows bit in CRCSHIFTLbits
#define SHIFT2                  CRCSHIFTLbits.SHIFT2            // bit 2, shadows bit in CRCSHIFTLbits
#define CRCSHIFT2               CRCSHIFTLbits.CRCSHIFT2         // bit 2, shadows bit in CRCSHIFTLbits
#define SHIFT3                  CRCSHIFTLbits.SHIFT3            // bit 3, shadows bit in CRCSHIFTLbits
#define CRCSHIFT3               CRCSHIFTLbits.CRCSHIFT3         // bit 3, shadows bit in CRCSHIFTLbits
#define SHIFT4                  CRCSHIFTLbits.SHIFT4            // bit 4, shadows bit in CRCSHIFTLbits
#define CRCSHIFT4               CRCSHIFTLbits.CRCSHIFT4         // bit 4, shadows bit in CRCSHIFTLbits
#define SHIFT5                  CRCSHIFTLbits.SHIFT5            // bit 5, shadows bit in CRCSHIFTLbits
#define CRCSHIFT5               CRCSHIFTLbits.CRCSHIFT5         // bit 5, shadows bit in CRCSHIFTLbits
#define SHIFT6                  CRCSHIFTLbits.SHIFT6            // bit 6, shadows bit in CRCSHIFTLbits
#define CRCSHIFT6               CRCSHIFTLbits.CRCSHIFT6         // bit 6, shadows bit in CRCSHIFTLbits
#define SHIFT7                  CRCSHIFTLbits.SHIFT7            // bit 7, shadows bit in CRCSHIFTLbits
#define CRCSHIFT7               CRCSHIFTLbits.CRCSHIFT7         // bit 7, shadows bit in CRCSHIFTLbits

#define XOR8                    CRCXORHbits.XOR8                // bit 0, shadows bit in CRCXORHbits
#define CRCXOR8                 CRCXORHbits.CRCXOR8             // bit 0, shadows bit in CRCXORHbits
#define XOR9                    CRCXORHbits.XOR9                // bit 1, shadows bit in CRCXORHbits
#define CRCXOR9                 CRCXORHbits.CRCXOR9             // bit 1, shadows bit in CRCXORHbits
#define XOR10                   CRCXORHbits.XOR10               // bit 2, shadows bit in CRCXORHbits
#define CRCXOR10                CRCXORHbits.CRCXOR10            // bit 2, shadows bit in CRCXORHbits
#define XOR11                   CRCXORHbits.XOR11               // bit 3, shadows bit in CRCXORHbits
#define CRCXOR11                CRCXORHbits.CRCXOR11            // bit 3, shadows bit in CRCXORHbits
#define XOR12                   CRCXORHbits.XOR12               // bit 4, shadows bit in CRCXORHbits
#define CRCXOR12                CRCXORHbits.CRCXOR12            // bit 4, shadows bit in CRCXORHbits
#define XOR13                   CRCXORHbits.XOR13               // bit 5, shadows bit in CRCXORHbits
#define CRCXOR13                CRCXORHbits.CRCXOR13            // bit 5, shadows bit in CRCXORHbits
#define XOR14                   CRCXORHbits.XOR14               // bit 6, shadows bit in CRCXORHbits
#define CRCXOR14                CRCXORHbits.CRCXOR14            // bit 6, shadows bit in CRCXORHbits
#define XOR15                   CRCXORHbits.XOR15               // bit 7, shadows bit in CRCXORHbits
#define CRCXOR15                CRCXORHbits.CRCXOR15            // bit 7, shadows bit in CRCXORHbits

#define XOR1                    CRCXORLbits.XOR1                // bit 1, shadows bit in CRCXORLbits
#define CRCXOR1                 CRCXORLbits.CRCXOR1             // bit 1, shadows bit in CRCXORLbits
#define XOR2                    CRCXORLbits.XOR2                // bit 2, shadows bit in CRCXORLbits
#define CRCXOR2                 CRCXORLbits.CRCXOR2             // bit 2, shadows bit in CRCXORLbits
#define XOR3                    CRCXORLbits.XOR3                // bit 3, shadows bit in CRCXORLbits
#define CRCXOR3                 CRCXORLbits.CRCXOR3             // bit 3, shadows bit in CRCXORLbits
#define XOR4                    CRCXORLbits.XOR4                // bit 4, shadows bit in CRCXORLbits
#define CRCXOR4                 CRCXORLbits.CRCXOR4             // bit 4, shadows bit in CRCXORLbits
#define XOR5                    CRCXORLbits.XOR5                // bit 5, shadows bit in CRCXORLbits
#define CRCXOR5                 CRCXORLbits.CRCXOR5             // bit 5, shadows bit in CRCXORLbits
#define XOR6                    CRCXORLbits.XOR6                // bit 6, shadows bit in CRCXORLbits
#define CRCXOR6                 CRCXORLbits.CRCXOR6             // bit 6, shadows bit in CRCXORLbits
#define XOR7                    CRCXORLbits.XOR7                // bit 7, shadows bit in CRCXORLbits
#define CRCXOR7                 CRCXORLbits.CRCXOR7             // bit 7, shadows bit in CRCXORLbits

#define LSAC0                   CWG1AS0bits.LSAC0               // bit 2, shadows bit in CWG1AS0bits
#define CWG1LSAC0               CWG1AS0bits.CWG1LSAC0           // bit 2, shadows bit in CWG1AS0bits
#define LSAC1                   CWG1AS0bits.LSAC1               // bit 3, shadows bit in CWG1AS0bits
#define CWG1LSAC1               CWG1AS0bits.CWG1LSAC1           // bit 3, shadows bit in CWG1AS0bits
#define LSBD0                   CWG1AS0bits.LSBD0               // bit 4, shadows bit in CWG1AS0bits
#define CWG1LSBD0               CWG1AS0bits.CWG1LSBD0           // bit 4, shadows bit in CWG1AS0bits
#define LSBD1                   CWG1AS0bits.LSBD1               // bit 5, shadows bit in CWG1AS0bits
#define CWG1LSBD1               CWG1AS0bits.CWG1LSBD1           // bit 5, shadows bit in CWG1AS0bits
#define REN                     CWG1AS0bits.REN                 // bit 6, shadows bit in CWG1AS0bits
#define CWG1REN                 CWG1AS0bits.CWG1REN             // bit 6, shadows bit in CWG1AS0bits
#define SHUTDOWN                CWG1AS0bits.SHUTDOWN            // bit 7, shadows bit in CWG1AS0bits
#define CWG1SHUTDOWN            CWG1AS0bits.CWG1SHUTDOWN        // bit 7, shadows bit in CWG1AS0bits

#define INAS                    CWG1AS1bits.INAS                // bit 0, shadows bit in CWG1AS1bits
#define CWG1INAS                CWG1AS1bits.CWG1INAS            // bit 0, shadows bit in CWG1AS1bits
#define C1AS                    CWG1AS1bits.C1AS                // bit 1, shadows bit in CWG1AS1bits
#define CWG1C1AS                CWG1AS1bits.CWG1C1AS            // bit 1, shadows bit in CWG1AS1bits
#define C2AS                    CWG1AS1bits.C2AS                // bit 2, shadows bit in CWG1AS1bits
#define CWG1C2AS                CWG1AS1bits.CWG1C2AS            // bit 2, shadows bit in CWG1AS1bits
#define TMR2AS                  CWG1AS1bits.TMR2AS              // bit 4, shadows bit in CWG1AS1bits
#define CWG1TMR2AS              CWG1AS1bits.CWG1TMR2AS          // bit 4, shadows bit in CWG1AS1bits
#define TMR4AS                  CWG1AS1bits.TMR4AS              // bit 5, shadows bit in CWG1AS1bits
#define CWG1TMR4AS              CWG1AS1bits.CWG1TMR4AS          // bit 5, shadows bit in CWG1AS1bits
#define TMR6AS                  CWG1AS1bits.TMR6AS              // bit 6, shadows bit in CWG1AS1bits
#define CWG1TMR6AS              CWG1AS1bits.CWG1TMR6AS          // bit 6, shadows bit in CWG1AS1bits

#define CS                      CWG1CLKCONbits.CS               // bit 0, shadows bit in CWG1CLKCONbits
#define CWG1CS                  CWG1CLKCONbits.CWG1CS           // bit 0, shadows bit in CWG1CLKCONbits

#define POLA                    CWG1CON1bits.POLA               // bit 0, shadows bit in CWG1CON1bits
#define CWG1POLA                CWG1CON1bits.CWG1POLA           // bit 0, shadows bit in CWG1CON1bits
#define POLB                    CWG1CON1bits.POLB               // bit 1, shadows bit in CWG1CON1bits
#define CWG1POLB                CWG1CON1bits.CWG1POLB           // bit 1, shadows bit in CWG1CON1bits
#define POLC                    CWG1CON1bits.POLC               // bit 2, shadows bit in CWG1CON1bits
#define CWG1POLC                CWG1CON1bits.CWG1POLC           // bit 2, shadows bit in CWG1CON1bits
#define POLD                    CWG1CON1bits.POLD               // bit 3, shadows bit in CWG1CON1bits
#define CWG1POLD                CWG1CON1bits.CWG1POLD           // bit 3, shadows bit in CWG1CON1bits
#define IN                      CWG1CON1bits.IN                 // bit 5, shadows bit in CWG1CON1bits
#define CWG1IN                  CWG1CON1bits.CWG1IN             // bit 5, shadows bit in CWG1CON1bits

#define DBF0                    CWG1DBFbits.DBF0                // bit 0, shadows bit in CWG1DBFbits
#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0, shadows bit in CWG1DBFbits
#define DBF1                    CWG1DBFbits.DBF1                // bit 1, shadows bit in CWG1DBFbits
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1, shadows bit in CWG1DBFbits
#define DBF2                    CWG1DBFbits.DBF2                // bit 2, shadows bit in CWG1DBFbits
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2, shadows bit in CWG1DBFbits
#define DBF3                    CWG1DBFbits.DBF3                // bit 3, shadows bit in CWG1DBFbits
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3, shadows bit in CWG1DBFbits
#define DBF4                    CWG1DBFbits.DBF4                // bit 4, shadows bit in CWG1DBFbits
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4, shadows bit in CWG1DBFbits
#define DBF5                    CWG1DBFbits.DBF5                // bit 5, shadows bit in CWG1DBFbits
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5, shadows bit in CWG1DBFbits

#define DBR0                    CWG1DBRbits.DBR0                // bit 0, shadows bit in CWG1DBRbits
#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0, shadows bit in CWG1DBRbits
#define DBR1                    CWG1DBRbits.DBR1                // bit 1, shadows bit in CWG1DBRbits
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1, shadows bit in CWG1DBRbits
#define DBR2                    CWG1DBRbits.DBR2                // bit 2, shadows bit in CWG1DBRbits
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2, shadows bit in CWG1DBRbits
#define DBR3                    CWG1DBRbits.DBR3                // bit 3, shadows bit in CWG1DBRbits
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3, shadows bit in CWG1DBRbits
#define DBR4                    CWG1DBRbits.DBR4                // bit 4, shadows bit in CWG1DBRbits
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4, shadows bit in CWG1DBRbits
#define DBR5                    CWG1DBRbits.DBR5                // bit 5, shadows bit in CWG1DBRbits
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5, shadows bit in CWG1DBRbits

#define IS0                     CWG1ISMbits.IS0                 // bit 0, shadows bit in CWG1ISMbits
#define CWG1IS0                 CWG1ISMbits.CWG1IS0             // bit 0, shadows bit in CWG1ISMbits
#define IS1                     CWG1ISMbits.IS1                 // bit 1, shadows bit in CWG1ISMbits
#define CWG1IS1                 CWG1ISMbits.CWG1IS1             // bit 1, shadows bit in CWG1ISMbits
#define IS2                     CWG1ISMbits.IS2                 // bit 2, shadows bit in CWG1ISMbits
#define CWG1IS2                 CWG1ISMbits.CWG1IS2             // bit 2, shadows bit in CWG1ISMbits

#define STRA                    CWG1OCON0bits.STRA              // bit 0, shadows bit in CWG1OCON0bits
#define CWG1STRA                CWG1OCON0bits.CWG1STRA          // bit 0, shadows bit in CWG1OCON0bits
#define STRB                    CWG1OCON0bits.STRB              // bit 1, shadows bit in CWG1OCON0bits
#define CWG1STRB                CWG1OCON0bits.CWG1STRB          // bit 1, shadows bit in CWG1OCON0bits
#define STRC                    CWG1OCON0bits.STRC              // bit 2, shadows bit in CWG1OCON0bits
#define CWG1STRC                CWG1OCON0bits.CWG1STRC          // bit 2, shadows bit in CWG1OCON0bits
#define STRD                    CWG1OCON0bits.STRD              // bit 3, shadows bit in CWG1OCON0bits
#define CWG1STRD                CWG1OCON0bits.CWG1STRD          // bit 3, shadows bit in CWG1OCON0bits
#define OVRA                    CWG1OCON0bits.OVRA              // bit 4, shadows bit in CWG1OCON0bits
#define CWG1OVRA                CWG1OCON0bits.CWG1OVRA          // bit 4, shadows bit in CWG1OCON0bits
#define OVRB                    CWG1OCON0bits.OVRB              // bit 5, shadows bit in CWG1OCON0bits
#define CWG1OVRB                CWG1OCON0bits.CWG1OVRB          // bit 5, shadows bit in CWG1OCON0bits
#define OVRC                    CWG1OCON0bits.OVRC              // bit 6, shadows bit in CWG1OCON0bits
#define CWG1OVRC                CWG1OCON0bits.CWG1OVRC          // bit 6, shadows bit in CWG1OCON0bits
#define OVRD                    CWG1OCON0bits.OVRD              // bit 7, shadows bit in CWG1OCON0bits
#define CWG1OVRD                CWG1OCON0bits.CWG1OVRD          // bit 7, shadows bit in CWG1OCON0bits

#define OEA                     CWG1OCON1bits.OEA               // bit 0, shadows bit in CWG1OCON1bits
#define CWG1OEA                 CWG1OCON1bits.CWG1OEA           // bit 0, shadows bit in CWG1OCON1bits
#define OEB                     CWG1OCON1bits.OEB               // bit 1, shadows bit in CWG1OCON1bits
#define CWG1OEB                 CWG1OCON1bits.CWG1OEB           // bit 1, shadows bit in CWG1OCON1bits
#define OEC                     CWG1OCON1bits.OEC               // bit 2, shadows bit in CWG1OCON1bits
#define CWG1OEC                 CWG1OCON1bits.CWG1OEC           // bit 2, shadows bit in CWG1OCON1bits
#define OED                     CWG1OCON1bits.OED               // bit 3, shadows bit in CWG1OCON1bits
#define CWG1OED                 CWG1OCON1bits.CWG1OED           // bit 3, shadows bit in CWG1OCON1bits

#define D1PSS0                  DAC1CON0bits.D1PSS0             // bit 2
#define D1PSS1                  DAC1CON0bits.D1PSS1             // bit 3
#define DAC1OE                  DAC1CON0bits.DAC1OE             // bit 5
#define DAC1EN                  DAC1CON0bits.DAC1EN             // bit 7

#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4
#define DAC1R5                  DAC1CON1bits.DAC1R5             // bit 5
#define DAC1R6                  DAC1CON1bits.DAC1R6             // bit 6
#define DAC1R7                  DAC1CON1bits.DAC1R7             // bit 7

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define PLLR                    OSCSTATbits.PLLR                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define NOT_WDTWV               PCONbits.NOT_WDTWV              // bit 5
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define TMR4IE                  PIE2bits.TMR4IE                 // bit 1
#define TMR6IE                  PIE2bits.TMR6IE                 // bit 2
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6

#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4
#define CWGIE                   PIE3bits.CWGIE                  // bit 5

#define SMT1IE                  PIE4bits.SMT1IE                 // bit 0
#define SMT1PRAIE               PIE4bits.SMT1PRAIE              // bit 1
#define SMT1PWAIE               PIE4bits.SMT1PWAIE              // bit 2
#define SMT2IE                  PIE4bits.SMT2IE                 // bit 3
#define SMT2PRAIE               PIE4bits.SMT2PRAIE              // bit 4
#define SMT2PWAIE               PIE4bits.SMT2PWAIE              // bit 5
#define CRCIE                   PIE4bits.CRCIE                  // bit 6
#define SCANIE                  PIE4bits.SCANIE                 // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define TMR4IF                  PIR2bits.TMR4IF                 // bit 1
#define TMR6IF                  PIR2bits.TMR6IF                 // bit 2
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6

#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4
#define CWGIF                   PIR3bits.CWGIF                  // bit 5

#define SMT1IF                  PIR4bits.SMT1IF                 // bit 0
#define SMT1PRAIF               PIR4bits.SMT1PRAIF              // bit 1
#define SMT1PWAIF               PIR4bits.SMT1PWAIF              // bit 2
#define SMT2IF                  PIR4bits.SMT2IF                 // bit 3
#define SMT2PRAIF               PIR4bits.SMT2PRAIF              // bit 4
#define SMT2PWAIF               PIR4bits.SMT2PWAIF              // bit 5
#define CRCIF                   PIR4bits.CRCIF                  // bit 6
#define SCANIF                  PIR4bits.SCANIF                 // bit 7

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define HADR8                   SCANHADRHbits.HADR8             // bit 0, shadows bit in SCANHADRHbits
#define SCANHADR8               SCANHADRHbits.SCANHADR8         // bit 0, shadows bit in SCANHADRHbits
#define HADR9                   SCANHADRHbits.HADR9             // bit 1, shadows bit in SCANHADRHbits
#define SCANHADR9               SCANHADRHbits.SCANHADR9         // bit 1, shadows bit in SCANHADRHbits
#define HADR10                  SCANHADRHbits.HADR10            // bit 2, shadows bit in SCANHADRHbits
#define SCANHADR10              SCANHADRHbits.SCANHADR10        // bit 2, shadows bit in SCANHADRHbits
#define HADR11                  SCANHADRHbits.HADR11            // bit 3, shadows bit in SCANHADRHbits
#define SCANHADR11              SCANHADRHbits.SCANHADR11        // bit 3, shadows bit in SCANHADRHbits
#define HADR12                  SCANHADRHbits.HADR12            // bit 4, shadows bit in SCANHADRHbits
#define SCANHADR12              SCANHADRHbits.SCANHADR12        // bit 4, shadows bit in SCANHADRHbits
#define HADR13                  SCANHADRHbits.HADR13            // bit 5, shadows bit in SCANHADRHbits
#define SCANHADR13              SCANHADRHbits.SCANHADR13        // bit 5, shadows bit in SCANHADRHbits
#define HADR14                  SCANHADRHbits.HADR14            // bit 6, shadows bit in SCANHADRHbits
#define SCANHADR14              SCANHADRHbits.SCANHADR14        // bit 6, shadows bit in SCANHADRHbits
#define HADR15                  SCANHADRHbits.HADR15            // bit 7, shadows bit in SCANHADRHbits
#define SCANHADR15              SCANHADRHbits.SCANHADR15        // bit 7, shadows bit in SCANHADRHbits

#define HADR0                   SCANHADRLbits.HADR0             // bit 0, shadows bit in SCANHADRLbits
#define SCANHADR0               SCANHADRLbits.SCANHADR0         // bit 0, shadows bit in SCANHADRLbits
#define HADR1                   SCANHADRLbits.HADR1             // bit 1, shadows bit in SCANHADRLbits
#define SCANHADR1               SCANHADRLbits.SCANHADR1         // bit 1, shadows bit in SCANHADRLbits
#define HARD2                   SCANHADRLbits.HARD2             // bit 2, shadows bit in SCANHADRLbits
#define SCANHADR2               SCANHADRLbits.SCANHADR2         // bit 2, shadows bit in SCANHADRLbits
#define HADR3                   SCANHADRLbits.HADR3             // bit 3, shadows bit in SCANHADRLbits
#define SCANHADR3               SCANHADRLbits.SCANHADR3         // bit 3, shadows bit in SCANHADRLbits
#define HADR4                   SCANHADRLbits.HADR4             // bit 4, shadows bit in SCANHADRLbits
#define SCANHADR4               SCANHADRLbits.SCANHADR4         // bit 4, shadows bit in SCANHADRLbits
#define HADR5                   SCANHADRLbits.HADR5             // bit 5, shadows bit in SCANHADRLbits
#define SCANHADR5               SCANHADRLbits.SCANHADR5         // bit 5, shadows bit in SCANHADRLbits
#define HADR6                   SCANHADRLbits.HADR6             // bit 6, shadows bit in SCANHADRLbits
#define SCANHADR6               SCANHADRLbits.SCANHADR6         // bit 6, shadows bit in SCANHADRLbits
#define HADR7                   SCANHADRLbits.HADR7             // bit 7, shadows bit in SCANHADRLbits
#define SCANHADR7               SCANHADRLbits.SCANHADR7         // bit 7, shadows bit in SCANHADRLbits

#define LADR8                   SCANLADRHbits.LADR8             // bit 0, shadows bit in SCANLADRHbits
#define SCANLADR8               SCANLADRHbits.SCANLADR8         // bit 0, shadows bit in SCANLADRHbits
#define LADR9                   SCANLADRHbits.LADR9             // bit 1, shadows bit in SCANLADRHbits
#define SCANLADR9               SCANLADRHbits.SCANLADR9         // bit 1, shadows bit in SCANLADRHbits
#define LADR10                  SCANLADRHbits.LADR10            // bit 2, shadows bit in SCANLADRHbits
#define SCANLADR10              SCANLADRHbits.SCANLADR10        // bit 2, shadows bit in SCANLADRHbits
#define LADR11                  SCANLADRHbits.LADR11            // bit 3, shadows bit in SCANLADRHbits
#define SCANLADR11              SCANLADRHbits.SCANLADR11        // bit 3, shadows bit in SCANLADRHbits
#define LADR12                  SCANLADRHbits.LADR12            // bit 4, shadows bit in SCANLADRHbits
#define SCANLADR12              SCANLADRHbits.SCANLADR12        // bit 4, shadows bit in SCANLADRHbits
#define LADR13                  SCANLADRHbits.LADR13            // bit 5, shadows bit in SCANLADRHbits
#define SCANLADR13              SCANLADRHbits.SCANLADR13        // bit 5, shadows bit in SCANLADRHbits
#define LADR14                  SCANLADRHbits.LADR14            // bit 6, shadows bit in SCANLADRHbits
#define SCANLADR14              SCANLADRHbits.SCANLADR14        // bit 6, shadows bit in SCANLADRHbits
#define LADR15                  SCANLADRHbits.LADR15            // bit 7, shadows bit in SCANLADRHbits
#define SCANLADR15              SCANLADRHbits.SCANLADR15        // bit 7, shadows bit in SCANLADRHbits

#define LDAR0                   SCANLADRLbits.LDAR0             // bit 0, shadows bit in SCANLADRLbits
#define SCANLADR0               SCANLADRLbits.SCANLADR0         // bit 0, shadows bit in SCANLADRLbits
#define LDAR1                   SCANLADRLbits.LDAR1             // bit 1, shadows bit in SCANLADRLbits
#define SCANLADR1               SCANLADRLbits.SCANLADR1         // bit 1, shadows bit in SCANLADRLbits
#define LADR2                   SCANLADRLbits.LADR2             // bit 2, shadows bit in SCANLADRLbits
#define SCANLADR2               SCANLADRLbits.SCANLADR2         // bit 2, shadows bit in SCANLADRLbits
#define LADR3                   SCANLADRLbits.LADR3             // bit 3, shadows bit in SCANLADRLbits
#define SCANLADR3               SCANLADRLbits.SCANLADR3         // bit 3, shadows bit in SCANLADRLbits
#define LADR4                   SCANLADRLbits.LADR4             // bit 4, shadows bit in SCANLADRLbits
#define SCANLADR4               SCANLADRLbits.SCANLADR4         // bit 4, shadows bit in SCANLADRLbits
#define LADR5                   SCANLADRLbits.LADR5             // bit 5, shadows bit in SCANLADRLbits
#define SCANLADR5               SCANLADRLbits.SCANLADR5         // bit 5, shadows bit in SCANLADRLbits
#define LADR6                   SCANLADRLbits.LADR6             // bit 6, shadows bit in SCANLADRLbits
#define SCANLADR6               SCANLADRLbits.SCANLADR6         // bit 6, shadows bit in SCANLADRLbits
#define LADR7                   SCANLADRLbits.LADR7             // bit 7, shadows bit in SCANLADRLbits
#define SCANLADR7               SCANLADRLbits.SCANLADR7         // bit 7, shadows bit in SCANLADRLbits

#define TSEL0                   SCANTRIGbits.TSEL0              // bit 0, shadows bit in SCANTRIGbits
#define SCANTSEL0               SCANTRIGbits.SCANTSEL0          // bit 0, shadows bit in SCANTRIGbits
#define TSEL1                   SCANTRIGbits.TSEL1              // bit 1, shadows bit in SCANTRIGbits
#define SCANTSEL1               SCANTRIGbits.SCANTSEL1          // bit 1, shadows bit in SCANTRIGbits

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define CSEL0                   SMT1CLKbits.CSEL0               // bit 0, shadows bit in SMT1CLKbits
#define SMT1CSEL0               SMT1CLKbits.SMT1CSEL0           // bit 0, shadows bit in SMT1CLKbits
#define CSEL1                   SMT1CLKbits.CSEL1               // bit 1, shadows bit in SMT1CLKbits
#define SMT1CSEL1               SMT1CLKbits.SMT1CSEL1           // bit 1, shadows bit in SMT1CLKbits
#define CSEL2                   SMT1CLKbits.CSEL2               // bit 2, shadows bit in SMT1CLKbits
#define SMT1CSEL2               SMT1CLKbits.SMT1CSEL2           // bit 2, shadows bit in SMT1CLKbits

#define SMT1CPR8                SMT1CPRHbits.SMT1CPR8           // bit 0
#define SMT1CPR9                SMT1CPRHbits.SMT1CPR9           // bit 1
#define SMT1CPR10               SMT1CPRHbits.SMT1CPR10          // bit 2
#define SMT1CPR11               SMT1CPRHbits.SMT1CPR11          // bit 3
#define SMT1CPR12               SMT1CPRHbits.SMT1CPR12          // bit 4
#define SMT1CPR13               SMT1CPRHbits.SMT1CPR13          // bit 5
#define SMT1CPR14               SMT1CPRHbits.SMT1CPR14          // bit 6
#define SMT1CPR15               SMT1CPRHbits.SMT1CPR15          // bit 7

#define SMT1CPR0                SMT1CPRLbits.SMT1CPR0           // bit 0
#define SMT1CPR1                SMT1CPRLbits.SMT1CPR1           // bit 1
#define SMT1CPR2                SMT1CPRLbits.SMT1CPR2           // bit 2
#define SMT1CPR3                SMT1CPRLbits.SMT1CPR3           // bit 3
#define SMT1CPR4                SMT1CPRLbits.SMT1CPR4           // bit 4
#define SMT1CPR5                SMT1CPRLbits.SMT1CPR5           // bit 5
#define SMT1CPR6                SMT1CPRLbits.SMT1CPR6           // bit 6
#define SMT1CPR7                SMT1CPRLbits.SMT1CPR7           // bit 7

#define SMT1CPR16               SMT1CPRUbits.SMT1CPR16          // bit 0
#define SMT1CPR17               SMT1CPRUbits.SMT1CPR17          // bit 1
#define SMT1CPR18               SMT1CPRUbits.SMT1CPR18          // bit 2
#define SMT1CPR19               SMT1CPRUbits.SMT1CPR19          // bit 3
#define SMT1CPR20               SMT1CPRUbits.SMT1CPR20          // bit 4
#define SMT1CPR21               SMT1CPRUbits.SMT1CPR21          // bit 5
#define SMT1CPR22               SMT1CPRUbits.SMT1CPR22          // bit 6
#define SMT1CPR23               SMT1CPRUbits.SMT1CPR23          // bit 7

#define SMT1CPW8                SMT1CPWHbits.SMT1CPW8           // bit 0
#define SMT1CPW9                SMT1CPWHbits.SMT1CPW9           // bit 1
#define SMT1CPW10               SMT1CPWHbits.SMT1CPW10          // bit 2
#define SMT1CPW11               SMT1CPWHbits.SMT1CPW11          // bit 3
#define SMT1CPW12               SMT1CPWHbits.SMT1CPW12          // bit 4
#define SMT1CPW13               SMT1CPWHbits.SMT1CPW13          // bit 5
#define SMT1CPW14               SMT1CPWHbits.SMT1CPW14          // bit 6
#define SMT1CPW15               SMT1CPWHbits.SMT1CPW15          // bit 7

#define SMT1CPW0                SMT1CPWLbits.SMT1CPW0           // bit 0
#define SMT1CPW1                SMT1CPWLbits.SMT1CPW1           // bit 1
#define SMT1CPW2                SMT1CPWLbits.SMT1CPW2           // bit 2
#define SMT1CPW3                SMT1CPWLbits.SMT1CPW3           // bit 3
#define SMT1CPW4                SMT1CPWLbits.SMT1CPW4           // bit 4
#define SMT1CPW5                SMT1CPWLbits.SMT1CPW5           // bit 5
#define SMT1CPW6                SMT1CPWLbits.SMT1CPW6           // bit 6
#define SMT1CPW7                SMT1CPWLbits.SMT1CPW7           // bit 7

#define SMT1CPW16               SMT1CPWUbits.SMT1CPW16          // bit 0
#define SMT1CPW17               SMT1CPWUbits.SMT1CPW17          // bit 1
#define SMT1CPW18               SMT1CPWUbits.SMT1CPW18          // bit 2
#define SMT1CPW19               SMT1CPWUbits.SMT1CPW19          // bit 3
#define SMT1CPW20               SMT1CPWUbits.SMT1CPW20          // bit 4
#define SMT1CPW21               SMT1CPWUbits.SMT1CPW21          // bit 5
#define SMT1CPW22               SMT1CPWUbits.SMT1CPW22          // bit 6
#define SMT1CPW23               SMT1CPWUbits.SMT1CPW23          // bit 7

#define SMT1PR8                 SMT1PRHbits.SMT1PR8             // bit 0
#define SMT1PR9                 SMT1PRHbits.SMT1PR9             // bit 1
#define SMT1PR10                SMT1PRHbits.SMT1PR10            // bit 2
#define SMT1PR11                SMT1PRHbits.SMT1PR11            // bit 3
#define SMT1PR12                SMT1PRHbits.SMT1PR12            // bit 4
#define SMT1PR13                SMT1PRHbits.SMT1PR13            // bit 5
#define SMT1PR14                SMT1PRHbits.SMT1PR14            // bit 6
#define SMT1PR15                SMT1PRHbits.SMT1PR15            // bit 7

#define SMT1PR0                 SMT1PRLbits.SMT1PR0             // bit 0
#define SMT1PR1                 SMT1PRLbits.SMT1PR1             // bit 1
#define SMT1PR2                 SMT1PRLbits.SMT1PR2             // bit 2
#define SMT1PR3                 SMT1PRLbits.SMT1PR3             // bit 3
#define SMT1PR4                 SMT1PRLbits.SMT1PR4             // bit 4
#define SMT1PR5                 SMT1PRLbits.SMT1PR5             // bit 5
#define SMT1PR6                 SMT1PRLbits.SMT1PR6             // bit 6
#define SMT1PR7                 SMT1PRLbits.SMT1PR7             // bit 7

#define SMT1PR16                SMT1PRUbits.SMT1PR16            // bit 0
#define SMT1PR17                SMT1PRUbits.SMT1PR17            // bit 1
#define SMT1PR18                SMT1PRUbits.SMT1PR18            // bit 2
#define SMT1PR19                SMT1PRUbits.SMT1PR19            // bit 3
#define SMT1PR20                SMT1PRUbits.SMT1PR20            // bit 4
#define SMT1PR21                SMT1PRUbits.SMT1PR21            // bit 5
#define SMT1PR22                SMT1PRUbits.SMT1PR22            // bit 6
#define SMT1PR23                SMT1PRUbits.SMT1PR23            // bit 7

#define SSEL0                   SMT1SIGbits.SSEL0               // bit 0, shadows bit in SMT1SIGbits
#define SMT1SSEL0               SMT1SIGbits.SMT1SSEL0           // bit 0, shadows bit in SMT1SIGbits
#define SSEL1                   SMT1SIGbits.SSEL1               // bit 1, shadows bit in SMT1SIGbits
#define SMT1SSEL1               SMT1SIGbits.SMT1SSEL1           // bit 1, shadows bit in SMT1SIGbits
#define SSEL2                   SMT1SIGbits.SSEL2               // bit 2, shadows bit in SMT1SIGbits
#define SMT1SSEL2               SMT1SIGbits.SMT1SSEL2           // bit 2, shadows bit in SMT1SIGbits

#define AS                      SMT1STATbits.AS                 // bit 0, shadows bit in SMT1STATbits
#define SMT1AS                  SMT1STATbits.SMT1AS             // bit 0, shadows bit in SMT1STATbits
#define WS                      SMT1STATbits.WS                 // bit 1, shadows bit in SMT1STATbits
#define SMT1WS                  SMT1STATbits.SMT1WS             // bit 1, shadows bit in SMT1STATbits
#define TS                      SMT1STATbits.TS                 // bit 2, shadows bit in SMT1STATbits
#define SMT1TS                  SMT1STATbits.SMT1TS             // bit 2, shadows bit in SMT1STATbits
#define RST                     SMT1STATbits.RST                // bit 5, shadows bit in SMT1STATbits
#define SMT1RESET               SMT1STATbits.SMT1RESET          // bit 5, shadows bit in SMT1STATbits
#define CPWUP                   SMT1STATbits.CPWUP              // bit 6, shadows bit in SMT1STATbits
#define SMT1CPWUP               SMT1STATbits.SMT1CPWUP          // bit 6, shadows bit in SMT1STATbits
#define CPRUP                   SMT1STATbits.CPRUP              // bit 7, shadows bit in SMT1STATbits
#define SMT1CPRUP               SMT1STATbits.SMT1CPRUP          // bit 7, shadows bit in SMT1STATbits

#define SMT1TMR8                SMT1TMRHbits.SMT1TMR8           // bit 0
#define SMT1TMR9                SMT1TMRHbits.SMT1TMR9           // bit 1
#define SMT1TMR10               SMT1TMRHbits.SMT1TMR10          // bit 2
#define SMT1TMR11               SMT1TMRHbits.SMT1TMR11          // bit 3
#define SMT1TMR12               SMT1TMRHbits.SMT1TMR12          // bit 4
#define SMT1TMR13               SMT1TMRHbits.SMT1TMR13          // bit 5
#define SMT1TMR14               SMT1TMRHbits.SMT1TMR14          // bit 6
#define SMT1TMR15               SMT1TMRHbits.SMT1TMR15          // bit 7

#define SMT1TMR0                SMT1TMRLbits.SMT1TMR0           // bit 0
#define SMT1TMR1                SMT1TMRLbits.SMT1TMR1           // bit 1
#define SMT1TMR2                SMT1TMRLbits.SMT1TMR2           // bit 2
#define SMT1TMR3                SMT1TMRLbits.SMT1TMR3           // bit 3
#define SMT1TMR4                SMT1TMRLbits.SMT1TMR4           // bit 4
#define SMT1TMR5                SMT1TMRLbits.SMT1TMR5           // bit 5
#define SMT1TMR6                SMT1TMRLbits.SMT1TMR6           // bit 6
#define SMT1TMR7                SMT1TMRLbits.SMT1TMR7           // bit 7

#define SMT1TMR16               SMT1TMRUbits.SMT1TMR16          // bit 0
#define SMT1TMR17               SMT1TMRUbits.SMT1TMR17          // bit 1
#define SMT1TMR18               SMT1TMRUbits.SMT1TMR18          // bit 2
#define SMT1TMR19               SMT1TMRUbits.SMT1TMR19          // bit 3
#define SMT1TMR20               SMT1TMRUbits.SMT1TMR20          // bit 4
#define SMT1TMR21               SMT1TMRUbits.SMT1TMR21          // bit 5
#define SMT1TMR22               SMT1TMRUbits.SMT1TMR22          // bit 6
#define SMT1TMR23               SMT1TMRUbits.SMT1TMR23          // bit 7

#define WSEL0                   SMT1WINbits.WSEL0               // bit 0, shadows bit in SMT1WINbits
#define SMT1WSEL0               SMT1WINbits.SMT1WSEL0           // bit 0, shadows bit in SMT1WINbits
#define WSEL1                   SMT1WINbits.WSEL1               // bit 1, shadows bit in SMT1WINbits
#define SMT1WSEL1               SMT1WINbits.SMT1WSEL1           // bit 1, shadows bit in SMT1WINbits
#define WSEL2                   SMT1WINbits.WSEL2               // bit 2, shadows bit in SMT1WINbits
#define SMT1WSEL2               SMT1WINbits.SMT1WSEL2           // bit 2, shadows bit in SMT1WINbits
#define WSEL3                   SMT1WINbits.WSEL3               // bit 3, shadows bit in SMT1WINbits
#define SMT1WSEL3               SMT1WINbits.SMT1WSEL3           // bit 3, shadows bit in SMT1WINbits

#define SMT2CPR8                SMT2CPRHbits.SMT2CPR8           // bit 0
#define SMT2CPR9                SMT2CPRHbits.SMT2CPR9           // bit 1
#define SMT2CPR10               SMT2CPRHbits.SMT2CPR10          // bit 2
#define SMT2CPR11               SMT2CPRHbits.SMT2CPR11          // bit 3
#define SMT2CPR12               SMT2CPRHbits.SMT2CPR12          // bit 4
#define SMT2CPR13               SMT2CPRHbits.SMT2CPR13          // bit 5
#define SMT2CPR14               SMT2CPRHbits.SMT2CPR14          // bit 6
#define SMT2CPR15               SMT2CPRHbits.SMT2CPR15          // bit 7

#define SMT2CPR0                SMT2CPRLbits.SMT2CPR0           // bit 0
#define SMT2CPR1                SMT2CPRLbits.SMT2CPR1           // bit 1
#define SMT2CPR2                SMT2CPRLbits.SMT2CPR2           // bit 2
#define SMT2CPR3                SMT2CPRLbits.SMT2CPR3           // bit 3
#define SMT2CPR4                SMT2CPRLbits.SMT2CPR4           // bit 4
#define SMT2CPR5                SMT2CPRLbits.SMT2CPR5           // bit 5
#define SMT2CPR6                SMT2CPRLbits.SMT2CPR6           // bit 6
#define SMT2CPR7                SMT2CPRLbits.SMT2CPR7           // bit 7

#define SMT2CPR16               SMT2CPRUbits.SMT2CPR16          // bit 0
#define SMT2CPR17               SMT2CPRUbits.SMT2CPR17          // bit 1
#define SMT2CPR18               SMT2CPRUbits.SMT2CPR18          // bit 2
#define SMT2CPR19               SMT2CPRUbits.SMT2CPR19          // bit 3
#define SMT2CPR20               SMT2CPRUbits.SMT2CPR20          // bit 4
#define SMT2CPR21               SMT2CPRUbits.SMT2CPR21          // bit 5
#define SMT2CPR22               SMT2CPRUbits.SMT2CPR22          // bit 6
#define SMT2CPR23               SMT2CPRUbits.SMT2CPR23          // bit 7

#define SMT2CPW8                SMT2CPWHbits.SMT2CPW8           // bit 0
#define SMT2CPW9                SMT2CPWHbits.SMT2CPW9           // bit 1
#define SMT2CPW10               SMT2CPWHbits.SMT2CPW10          // bit 2
#define SMT2CPW11               SMT2CPWHbits.SMT2CPW11          // bit 3
#define SMT2CPW12               SMT2CPWHbits.SMT2CPW12          // bit 4
#define SMT2CPW13               SMT2CPWHbits.SMT2CPW13          // bit 5
#define SMT2CPW14               SMT2CPWHbits.SMT2CPW14          // bit 6
#define SMT2CPW15               SMT2CPWHbits.SMT2CPW15          // bit 7

#define SMT2CPW0                SMT2CPWLbits.SMT2CPW0           // bit 0
#define SMT2CPW1                SMT2CPWLbits.SMT2CPW1           // bit 1
#define SMT2CPW2                SMT2CPWLbits.SMT2CPW2           // bit 2
#define SMT2CPW3                SMT2CPWLbits.SMT2CPW3           // bit 3
#define SMT2CPW4                SMT2CPWLbits.SMT2CPW4           // bit 4
#define SMT2CPW5                SMT2CPWLbits.SMT2CPW5           // bit 5
#define SMT2CPW6                SMT2CPWLbits.SMT2CPW6           // bit 6
#define SMT2CPW7                SMT2CPWLbits.SMT2CPW7           // bit 7

#define SMT2CPW16               SMT2CPWUbits.SMT2CPW16          // bit 0
#define SMT2CPW17               SMT2CPWUbits.SMT2CPW17          // bit 1
#define SMT2CPW18               SMT2CPWUbits.SMT2CPW18          // bit 2
#define SMT2CPW19               SMT2CPWUbits.SMT2CPW19          // bit 3
#define SMT2CPW20               SMT2CPWUbits.SMT2CPW20          // bit 4
#define SMT2CPW21               SMT2CPWUbits.SMT2CPW21          // bit 5
#define SMT2CPW22               SMT2CPWUbits.SMT2CPW22          // bit 6
#define SMT2CPW23               SMT2CPWUbits.SMT2CPW23          // bit 7

#define SMT2PR8                 SMT2PRHbits.SMT2PR8             // bit 0
#define SMT2PR9                 SMT2PRHbits.SMT2PR9             // bit 1
#define SMT2PR10                SMT2PRHbits.SMT2PR10            // bit 2
#define SMT2PR11                SMT2PRHbits.SMT2PR11            // bit 3
#define SMT2PR12                SMT2PRHbits.SMT2PR12            // bit 4
#define SMT2PR13                SMT2PRHbits.SMT2PR13            // bit 5
#define SMT2PR14                SMT2PRHbits.SMT2PR14            // bit 6
#define SMT2PR15                SMT2PRHbits.SMT2PR15            // bit 7

#define SMT2PR0                 SMT2PRLbits.SMT2PR0             // bit 0
#define SMT2PR1                 SMT2PRLbits.SMT2PR1             // bit 1
#define SMT2PR2                 SMT2PRLbits.SMT2PR2             // bit 2
#define SMT2PR3                 SMT2PRLbits.SMT2PR3             // bit 3
#define SMT2PR4                 SMT2PRLbits.SMT2PR4             // bit 4
#define SMT2PR5                 SMT2PRLbits.SMT2PR5             // bit 5
#define SMT2PR6                 SMT2PRLbits.SMT2PR6             // bit 6
#define SMT2PR7                 SMT2PRLbits.SMT2PR7             // bit 7

#define SMT2PR16                SMT2PRUbits.SMT2PR16            // bit 0
#define SMT2PR17                SMT2PRUbits.SMT2PR17            // bit 1
#define SMT2PR18                SMT2PRUbits.SMT2PR18            // bit 2
#define SMT2PR19                SMT2PRUbits.SMT2PR19            // bit 3
#define SMT2PR20                SMT2PRUbits.SMT2PR20            // bit 4
#define SMT2PR21                SMT2PRUbits.SMT2PR21            // bit 5
#define SMT2PR22                SMT2PRUbits.SMT2PR22            // bit 6
#define SMT2PR23                SMT2PRUbits.SMT2PR23            // bit 7

#define SMT2TMR8                SMT2TMRHbits.SMT2TMR8           // bit 0
#define SMT2TMR9                SMT2TMRHbits.SMT2TMR9           // bit 1
#define SMT2TMR10               SMT2TMRHbits.SMT2TMR10          // bit 2
#define SMT2TMR11               SMT2TMRHbits.SMT2TMR11          // bit 3
#define SMT2TMR12               SMT2TMRHbits.SMT2TMR12          // bit 4
#define SMT2TMR13               SMT2TMRHbits.SMT2TMR13          // bit 5
#define SMT2TMR14               SMT2TMRHbits.SMT2TMR14          // bit 6
#define SMT2TMR15               SMT2TMRHbits.SMT2TMR15          // bit 7

#define SMT2TMR0                SMT2TMRLbits.SMT2TMR0           // bit 0
#define SMT2TMR1                SMT2TMRLbits.SMT2TMR1           // bit 1
#define SMT2TMR2                SMT2TMRLbits.SMT2TMR2           // bit 2
#define SMT2TMR3                SMT2TMRLbits.SMT2TMR3           // bit 3
#define SMT2TMR4                SMT2TMRLbits.SMT2TMR4           // bit 4
#define SMT2TMR5                SMT2TMRLbits.SMT2TMR5           // bit 5
#define SMT2TMR6                SMT2TMRLbits.SMT2TMR6           // bit 6
#define SMT2TMR7                SMT2TMRLbits.SMT2TMR7           // bit 7

#define SMT2TMR16               SMT2TMRUbits.SMT2TMR16          // bit 0
#define SMT2TMR17               SMT2TMRUbits.SMT2TMR17          // bit 1
#define SMT2TMR18               SMT2TMRUbits.SMT2TMR18          // bit 2
#define SMT2TMR19               SMT2TMRUbits.SMT2TMR19          // bit 3
#define SMT2TMR20               SMT2TMRUbits.SMT2TMR20          // bit 4
#define SMT2TMR21               SMT2TMRUbits.SMT2TMR21          // bit 5
#define SMT2TMR22               SMT2TMRUbits.SMT2TMR22          // bit 6
#define SMT2TMR23               SMT2TMRUbits.SMT2TMR23          // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CS0                   T2CLKCONbits.T2CS0              // bit 0
#define T2CS1                   T2CLKCONbits.T2CS1              // bit 1
#define T2CS2                   T2CLKCONbits.T2CS2              // bit 2

#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 0, shadows bit in T2CONbits
#define OUTPS0                  T2CONbits.OUTPS0                // bit 0, shadows bit in T2CONbits
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 1, shadows bit in T2CONbits
#define OUTPS1                  T2CONbits.OUTPS1                // bit 1, shadows bit in T2CONbits
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 2, shadows bit in T2CONbits
#define OUTPS2                  T2CONbits.OUTPS2                // bit 2, shadows bit in T2CONbits
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 3, shadows bit in T2CONbits
#define OUTPS3                  T2CONbits.OUTPS3                // bit 3, shadows bit in T2CONbits
#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 4, shadows bit in T2CONbits
#define CKPS0                   T2CONbits.CKPS0                 // bit 4, shadows bit in T2CONbits
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 5, shadows bit in T2CONbits
#define CKPS1                   T2CONbits.CKPS1                 // bit 5, shadows bit in T2CONbits
#define T2CKPS2                 T2CONbits.T2CKPS2               // bit 6, shadows bit in T2CONbits
#define CKPS2                   T2CONbits.CKPS2                 // bit 6, shadows bit in T2CONbits
#define ON                      T2CONbits.ON                    // bit 7, shadows bit in T2CONbits
#define T2ON                    T2CONbits.T2ON                  // bit 7, shadows bit in T2CONbits
#define TMR2ON                  T2CONbits.TMR2ON                // bit 7, shadows bit in T2CONbits

#define RSEL0                   T2RSTbits.RSEL0                 // bit 0, shadows bit in T2RSTbits
#define T2RSEL0                 T2RSTbits.T2RSEL0               // bit 0, shadows bit in T2RSTbits
#define RSEL1                   T2RSTbits.RSEL1                 // bit 1, shadows bit in T2RSTbits
#define T2RSEL1                 T2RSTbits.T2RSEL1               // bit 1, shadows bit in T2RSTbits
#define RSEL2                   T2RSTbits.RSEL2                 // bit 2, shadows bit in T2RSTbits
#define T2RSEL2                 T2RSTbits.T2RSEL2               // bit 2, shadows bit in T2RSTbits
#define RSEL3                   T2RSTbits.RSEL3                 // bit 3, shadows bit in T2RSTbits
#define T2RSEL3                 T2RSTbits.T2RSEL3               // bit 3, shadows bit in T2RSTbits

#define T4CS0                   T4CLKCONbits.T4CS0              // bit 0
#define T4CS1                   T4CLKCONbits.T4CS1              // bit 1
#define T4CS2                   T4CLKCONbits.T4CS2              // bit 2

#define T6CS0                   T6CLKCONbits.T6CS0              // bit 0
#define T6CS1                   T6CLKCONbits.T6CS1              // bit 1
#define T6CS2                   T6CLKCONbits.T6CS2              // bit 2

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define SEN                     WDTCON0bits.SEN                 // bit 0, shadows bit in WDTCON0bits
#define SWDTEN                  WDTCON0bits.SWDTEN              // bit 0, shadows bit in WDTCON0bits
#define WDTSEN                  WDTCON0bits.WDTSEN              // bit 0, shadows bit in WDTCON0bits
#define WDTPS0                  WDTCON0bits.WDTPS0              // bit 1
#define WDTPS1                  WDTCON0bits.WDTPS1              // bit 2
#define WDTPS2                  WDTCON0bits.WDTPS2              // bit 3
#define WDTPS3                  WDTCON0bits.WDTPS3              // bit 4
#define WDTPS4                  WDTCON0bits.WDTPS4              // bit 5

#define WINDOW0                 WDTCON1bits.WINDOW0             // bit 0, shadows bit in WDTCON1bits
#define WDTWINDOW0              WDTCON1bits.WDTWINDOW0          // bit 0, shadows bit in WDTCON1bits
#define WINDOW1                 WDTCON1bits.WINDOW1             // bit 1, shadows bit in WDTCON1bits
#define WDTWINDOW1              WDTCON1bits.WDTWINDOW1          // bit 1, shadows bit in WDTCON1bits
#define WINDOW2                 WDTCON1bits.WINDOW2             // bit 2, shadows bit in WDTCON1bits
#define WDTWINDOW2              WDTCON1bits.WDTWINDOW2          // bit 2, shadows bit in WDTCON1bits
#define WDTCS0                  WDTCON1bits.WDTCS0              // bit 4
#define WDTCS1                  WDTCON1bits.WDTCS1              // bit 5
#define WDTCS2                  WDTCON1bits.WDTCS2              // bit 6

#define PSCNT8                  WDTPSHbits.PSCNT8               // bit 0, shadows bit in WDTPSHbits
#define WDTPSCNT8               WDTPSHbits.WDTPSCNT8            // bit 0, shadows bit in WDTPSHbits
#define PSCNT9                  WDTPSHbits.PSCNT9               // bit 1, shadows bit in WDTPSHbits
#define WDTPSCNT9               WDTPSHbits.WDTPSCNT9            // bit 1, shadows bit in WDTPSHbits
#define PSCNT10                 WDTPSHbits.PSCNT10              // bit 2, shadows bit in WDTPSHbits
#define WDTPSCNT10              WDTPSHbits.WDTPSCNT10           // bit 2, shadows bit in WDTPSHbits
#define PSCNT11                 WDTPSHbits.PSCNT11              // bit 3, shadows bit in WDTPSHbits
#define WDTPSCNT11              WDTPSHbits.WDTPSCNT11           // bit 3, shadows bit in WDTPSHbits
#define PSCNT12                 WDTPSHbits.PSCNT12              // bit 4, shadows bit in WDTPSHbits
#define WDTPSCNT12              WDTPSHbits.WDTPSCNT12           // bit 4, shadows bit in WDTPSHbits
#define PSCNT13                 WDTPSHbits.PSCNT13              // bit 5, shadows bit in WDTPSHbits
#define WDTPSCNT13              WDTPSHbits.WDTPSCNT13           // bit 5, shadows bit in WDTPSHbits
#define PSCNT14                 WDTPSHbits.PSCNT14              // bit 6, shadows bit in WDTPSHbits
#define WDTPSCNT14              WDTPSHbits.WDTPSCNT14           // bit 6, shadows bit in WDTPSHbits
#define PSCNT15                 WDTPSHbits.PSCNT15              // bit 7, shadows bit in WDTPSHbits
#define WDTPSCNT15              WDTPSHbits.WDTPSCNT15           // bit 7, shadows bit in WDTPSHbits

#define PSCNT0                  WDTPSLbits.PSCNT0               // bit 0, shadows bit in WDTPSLbits
#define WDTPSCNT0               WDTPSLbits.WDTPSCNT0            // bit 0, shadows bit in WDTPSLbits
#define PSCNT1                  WDTPSLbits.PSCNT1               // bit 1, shadows bit in WDTPSLbits
#define WDTPSCNT1               WDTPSLbits.WDTPSCNT1            // bit 1, shadows bit in WDTPSLbits
#define PSCNT2                  WDTPSLbits.PSCNT2               // bit 2, shadows bit in WDTPSLbits
#define WDTPSCNT2               WDTPSLbits.WDTPSCNT2            // bit 2, shadows bit in WDTPSLbits
#define PSCNT3                  WDTPSLbits.PSCNT3               // bit 3, shadows bit in WDTPSLbits
#define WDTPSCNT3               WDTPSLbits.WDTPSCNT3            // bit 3, shadows bit in WDTPSLbits
#define PSCNT4                  WDTPSLbits.PSCNT4               // bit 4, shadows bit in WDTPSLbits
#define WDTPSCNT4               WDTPSLbits.WDTPSCNT4            // bit 4, shadows bit in WDTPSLbits
#define PSCNT5                  WDTPSLbits.PSCNT5               // bit 5, shadows bit in WDTPSLbits
#define WDTPSCNT5               WDTPSLbits.WDTPSCNT5            // bit 5, shadows bit in WDTPSLbits
#define PSCNT6                  WDTPSLbits.PSCNT6               // bit 6, shadows bit in WDTPSLbits
#define WDTPSCNT6               WDTPSLbits.WDTPSCNT6            // bit 6, shadows bit in WDTPSLbits
#define PSCNT7                  WDTPSLbits.PSCNT7               // bit 7, shadows bit in WDTPSLbits
#define WDTPSCNT7               WDTPSLbits.WDTPSCNT7            // bit 7, shadows bit in WDTPSLbits

#define PSCNT16                 WDTTMRbits.PSCNT16              // bit 0, shadows bit in WDTTMRbits
#define WDTPSCNT16              WDTTMRbits.WDTPSCNT16           // bit 0, shadows bit in WDTTMRbits
#define PSCNT17                 WDTTMRbits.PSCNT17              // bit 1, shadows bit in WDTTMRbits
#define WDTPSCNT17              WDTTMRbits.WDTPSCNT17           // bit 1, shadows bit in WDTTMRbits
#define STATE                   WDTTMRbits.STATE                // bit 2, shadows bit in WDTTMRbits
#define WDTSTATE                WDTTMRbits.WDTSTATE             // bit 2, shadows bit in WDTTMRbits
#define WDTTMR0                 WDTTMRbits.WDTTMR0              // bit 3
#define WDTTMR1                 WDTTMRbits.WDTTMR1              // bit 4
#define WDTTMR2                 WDTTMRbits.WDTTMR2              // bit 5
#define WDTTMR3                 WDTTMRbits.WDTTMR3              // bit 6
#define WDTTMR4                 WDTTMRbits.WDTTMR4              // bit 7

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1OE                  ZCD1CONbits.ZCD1OE              // bit 6
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC12LF1612_H__
