/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.sdedit.util.Utilities;

public class ProcessRunner
implements Runnable {
    private ProcessBuilder builder;
    private List<String> commands = new ArrayList<String>();
    private Redirect outRedir;
    private Redirect errRedir;
    private Redirect inRedir;
    private OutputStream out;
    private OutputStream err;
    private InputStream in;
    private Map<String, String> env = new LinkedHashMap<String, String>();
    private IOException exception;
    private Process process;
    private boolean redirect = false;
    private File workingDirectory;
    private Integer exitValue;

    public ProcessRunner command(String ... commands) {
        for (String cmd : commands) {
            this.commands.add(cmd);
        }
        return this;
    }

    public ProcessRunner out(OutputStream out) {
        this.out = out;
        return this;
    }

    public ProcessRunner err(OutputStream err) {
        this.err = err;
        return this;
    }

    public ProcessRunner in(InputStream in) {
        this.in = in;
        return this;
    }

    public ProcessRunner in(String in, String encoding) {
        if (in != null) {
            byte[] bytes = Utilities.getBytes(in, encoding);
            this.in = new ByteArrayInputStream(bytes);
        }
        return this;
    }

    public ProcessRunner in(String in) {
        return this.in(in, Charset.defaultCharset().name());
    }

    public ProcessRunner outToString() {
        this.out = new ByteArrayOutputStream();
        return this;
    }

    public ProcessRunner errToString() {
        this.err = new ByteArrayOutputStream();
        return this;
    }

    public ProcessRunner setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
        return this;
    }

    public ProcessRunner redirectErrorStream() {
        this.redirect = true;
        return this;
    }

    public ProcessRunner set(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public void start(long maxDurationMillis) {
        if (this.commands.size() == 0) {
            throw new IllegalStateException("There is no command.");
        }
        this.builder = new ProcessBuilder(this.commands);
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            this.builder.environment().put(entry.getKey(), entry.getValue());
        }
        if (this.workingDirectory != null) {
            this.builder.directory(this.workingDirectory);
        }
        if (this.redirect) {
            this.builder.redirectErrorStream(true);
        }
        Thread thread = new Thread(this);
        thread.start();
        try {
            thread.join(maxDurationMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.isTerminated()) {
            try {
                this.process.destroy();
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void run() {
        try {
            this.process = this.builder.start();
            if (this.in != null) {
                this.inRedir = new Redirect(this.in, this.process.getOutputStream());
                this.inRedir.start();
            }
            if (this.out != null) {
                this.outRedir = new Redirect(this.process.getInputStream(), this.out);
                this.outRedir.start();
            }
            if (this.err != null) {
                this.errRedir = new Redirect(this.process.getErrorStream(), this.err);
                this.errRedir.start();
            }
            try {
                this.process.waitFor();
                if (this.inRedir != null) {
                    this.inRedir.join();
                }
                if (this.outRedir != null) {
                    this.outRedir.join();
                }
                if (this.errRedir != null) {
                    this.errRedir.join();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public String getOut(String charset) {
        if (!(this.out instanceof ByteArrayOutputStream)) {
            return null;
        }
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.out;
        return Utilities.toString(bout.toByteArray(), charset);
    }

    public String getOut() {
        return this.getOut(Charset.defaultCharset().name());
    }

    public String getErr(String charset) {
        if (!(this.err instanceof ByteArrayOutputStream)) {
            return null;
        }
        ByteArrayOutputStream berr = (ByteArrayOutputStream)this.err;
        return Utilities.toString(berr.toByteArray(), charset);
    }

    public String getErr() {
        return this.getErr(Charset.defaultCharset().name());
    }

    public IOException getException() {
        return this.exception;
    }

    public boolean isTerminated() {
        while (this.process == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.exitValue = this.process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public IOException getOutputException() {
        if (this.outRedir == null) {
            return null;
        }
        return this.outRedir.getException();
    }

    public IOException getErrorException() {
        if (this.errRedir == null) {
            return null;
        }
        return this.errRedir.getException();
    }

    private class Redirect
    implements Runnable {
        private InputStream in;
        private OutputStream out;
        private IOException e;
        private Thread thread;

        Redirect(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream bis = new BufferedInputStream(this.in);
                BufferedOutputStream bos = new BufferedOutputStream(this.out);
                int n = 0;
                int EOF2 = -1;
                byte[] buffer = new byte[1024];
                while (-1 != (n = bis.read(buffer))) {
                    bos.write(buffer, 0, n);
                }
                bos.flush();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.e = e;
            }
        }

        IOException getException() {
            return this.e;
        }

        void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        void join() {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

