/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

class HashKey {
    char[] value;
    int count = 0;

    HashKey() {
        this(16);
    }

    HashKey(int n) {
        this.value = new char[n];
    }

    HashKey(HashKey hashKey) {
        this.set(hashKey);
    }

    HashKey(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    void set(HashKey hashKey) {
        if (this.count < hashKey.count) {
            this.value = new char[hashKey.count];
        }
        for (int i = 0; i < hashKey.count; ++i) {
            this.value[i] = hashKey.value[i];
        }
        this.count = hashKey.count;
    }

    void reset() {
        this.count = 0;
    }

    void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    HashKey append(String string) {
        int n = 0;
        if (string == null) {
            return this;
        }
        n = string.length();
        this.ensureCapacity(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        char[] cArray = this.value;
        int n3 = this.count;
        if (n3 < 16) {
            for (int i = n3; i > 0; --i) {
                n = n * 37 + cArray[n2++];
            }
        } else {
            int n4 = n3 / 8;
            int n5 = n3;
            while (n5 > 0) {
                n = n * 39 + cArray[n2];
                n5 -= n4;
                n2 += n4;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof HashKey) {
            HashKey hashKey = (HashKey)object;
            int n = this.count;
            if (n == hashKey.count) {
                char[] cArray = this.value;
                char[] cArray2 = hashKey.value;
                int n2 = 0;
                int n3 = 0;
                while (n-- != 0) {
                    if (cArray[n2++] == cArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private int equals(HashKey hashKey) {
        for (int i = 0; i < this.count && i < hashKey.count; ++i) {
            if (this.value[i] < hashKey.value[i]) {
                return -1;
            }
            if (this.value[i] <= hashKey.value[i]) continue;
            return 1;
        }
        if (this.count == hashKey.count) {
            return 0;
        }
        if (this.count < hashKey.count) {
            return -1;
        }
        return 1;
    }

    int equals(HashKey[] hashKeyArray, int n, int n2) {
        int n3 = n + (n2 - n) / 2;
        if (hashKeyArray[n3] != null) {
            int n4 = this.equals(hashKeyArray[n3]);
            if (n4 < 0 && n != n3) {
                return this.equals(hashKeyArray, n, n3);
            }
            if (n4 > 0 && n != n3) {
                return this.equals(hashKeyArray, n3, n2);
            }
            if (n4 == 0) {
                return n3;
            }
            return -1;
        }
        return -2;
    }

    boolean equals(HashKey[] hashKeyArray, int[] nArray, int n, int n2) {
        int n3 = n + (n2 - n) / 2;
        if (hashKeyArray[n3] != null) {
            int n4 = this.equals(hashKeyArray[n3]);
            if (n != n3) {
                if (n4 < 0) {
                    return this.equals(hashKeyArray, nArray, n, n3);
                }
                if (n4 > 0) {
                    return this.equals(hashKeyArray, nArray, n3, n2);
                }
            } else {
                if (n4 < 0) {
                    nArray[0] = n3;
                    return false;
                }
                if (n4 > 0) {
                    nArray[0] = n3 + 1;
                    return false;
                }
            }
            nArray[0] = n3;
            return true;
        }
        nArray[0] = n3;
        return false;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    String getLastNodeId() {
        int n;
        for (n = this.count - 1; n > 0 && this.value[n] != '+'; --n) {
        }
        if (n > 0) {
            this.value[n++] = '\u0000';
            int n2 = this.count - n;
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3] = this.value[n];
                this.value[n] = '\u0000';
                ++n3;
                ++n;
            }
            this.count -= n2 + 1;
            return new String(cArray);
        }
        return new String(this.value, 0, this.count);
    }
}

