/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.util.GenericGUIUtilities;

public class BrowserCommandsMenu
extends JPopupMenu {
    private final VFSBrowser browser;
    private HashMap<String, JRadioButtonMenuItem> encodingMenuItems;
    private JCheckBoxMenuItem autoDetect;
    private JRadioButtonMenuItem otherEncoding;

    public BrowserCommandsMenu(VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
        Object object;
        this.browser = vFSBrowser;
        if (vFSFileArray != null) {
            object = VFSManager.getVFSForPath(vFSFileArray[0].getDeletePath());
            int n = vFSFileArray[0].getType();
            Component[] componentArray = jEdit.getBufferManager();
            int n2 = componentArray.getBuffer(vFSFileArray[0].getPath()).isPresent();
            int n3 = componentArray.getBuffer(vFSFileArray[0].getDeletePath()).isPresent();
            boolean bl = n3 == 0 && (((VFS)object).getCapabilities() & 8) != 0;
            boolean bl2 = n2 == 0 && (((VFS)object).getCapabilities() & 0x10) != 0;
            for (int i = 1; i < vFSFileArray.length; ++i) {
                VFSFile vFSFile = vFSFileArray[i];
                VFS vFS = VFSManager.getVFSForPath(vFSFile.getDeletePath());
                bl &= object == vFS && (vFS.getCapabilities() & 8) != 0;
                if (n != vFSFile.getType()) {
                    n = -1;
                }
                bl2 = false;
                if (!componentArray.getBuffer(vFSFile.getPath()).isPresent()) continue;
                n2 = 1;
            }
            if (n == 1 || n == 2) {
                if (vFSFileArray.length == 1) {
                    this.add(BrowserCommandsMenu.createMenuItem("browse"));
                }
                if (vFSBrowser.getMode() == 2) {
                    this.add(BrowserCommandsMenu.createMenuItem("browse-window"));
                }
            } else if (n == 0 && (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4)) {
                this.add(BrowserCommandsMenu.createMenuItem("open", "22x22/actions/document-open.png"));
                this.add(GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "vfs.browser.open-in"));
                if (vFSBrowser.getSelectedFiles().length == 1) {
                    this.add(BrowserCommandsMenu.createMenuItem("open-desktop", "22x22/actions/document-open.png"));
                    this.add(BrowserCommandsMenu.createMenuItem("insert"));
                }
                if (n2 != 0) {
                    this.add(BrowserCommandsMenu.createMenuItem("close"));
                }
            } else if (n != -1) {
                this.add(BrowserCommandsMenu.createMenuItem("open", "22x22/actions/document-open.png"));
            }
            if (bl2) {
                this.add(BrowserCommandsMenu.createMenuItem("rename"));
            }
            if (bl) {
                this.add(BrowserCommandsMenu.createMenuItem("delete", "22x22/actions/edit-delete.png"));
            }
            this.add(BrowserCommandsMenu.createMenuItem("copy-path", "22x22/actions/edit-copy.png"));
            this.add(BrowserCommandsMenu.createMenuItem("paste", "22x22/actions/edit-paste.png"));
            if (vFSFileArray.length == 1 || vFSBrowser.getSelectedFiles().length != 0) {
                this.add(BrowserCommandsMenu.createMenuItem("properties", "22x22/actions/document-properties.png"));
            }
            this.addSeparator();
        }
        this.add(BrowserCommandsMenu.createMenuItem("up", "22x22/actions/go-parent.png"));
        this.add(BrowserCommandsMenu.createMenuItem("previous", "22x22/actions/go-previous.png"));
        this.add(BrowserCommandsMenu.createMenuItem("next", "22x22/actions/go-next.png"));
        this.add(BrowserCommandsMenu.createMenuItem("reload", "22x22/actions/document-reload.png"));
        this.add(BrowserCommandsMenu.createMenuItem("roots"));
        this.add(BrowserCommandsMenu.createMenuItem("home", "22x22/actions/go-home.png"));
        this.add(BrowserCommandsMenu.createMenuItem("synchronize"));
        this.addSeparator();
        if (vFSBrowser.getMode() == 2) {
            this.add(BrowserCommandsMenu.createMenuItem("new-file", "22x22/actions/document-new.png"));
        }
        this.add(BrowserCommandsMenu.createMenuItem("new-directory", "22x22/actions/folder-new.png"));
        if (vFSBrowser.getMode() == 2) {
            this.addSeparator();
            this.add(BrowserCommandsMenu.createMenuItem("search-directory", "22x22/actions/system-search.png"));
        }
        this.addSeparator();
        this.add(BrowserCommandsMenu.createMenuItem("show-hidden-files"));
        if (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4) {
            this.addSeparator();
            this.add(this.createEncodingMenu());
        }
        if ((object = BrowserCommandsMenu.createCustomMenu()) != null) {
            Component[] componentArray;
            this.addSeparator();
            for (Component component : componentArray = ((JMenu)object).getMenuComponents()) {
                this.add((JMenuItem)component);
            }
        }
        this.addSeparator();
        this.add(BrowserCommandsMenu.createPluginMenu(vFSBrowser));
        this.update();
    }

    public void update() {
        if (this.encodingMenuItems != null && this.browser.currentEncoding != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.encodingMenuItems.get(this.browser.currentEncoding);
            if (jRadioButtonMenuItem != null) {
                jRadioButtonMenuItem.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding.label"));
            } else {
                this.otherEncoding.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding-2.label", new String[]{this.browser.currentEncoding}));
            }
        }
    }

    private static JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), "vfs.browser." + string, false);
        jMenuItem.setIcon(GUIUtilities.loadIcon(string2));
        return jMenuItem;
    }

    private static JMenuItem createMenuItem(String string) {
        return BrowserCommandsMenu.createMenuItem(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private JMenu createEncodingMenu() {
        void var9_13;
        String[] stringArray;
        JMenu jMenu;
        ActionHandler actionHandler = new ActionHandler();
        this.encodingMenuItems = new HashMap();
        JMenu object = jMenu = new JMenu(jEdit.getProperty("vfs.browser.commands.encoding.label"));
        this.autoDetect = new JCheckBoxMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        this.autoDetect.setSelected(this.browser.autoDetectEncoding);
        this.autoDetect.setActionCommand("auto-detect");
        this.autoDetect.addActionListener(actionHandler);
        object.add(this.autoDetect);
        object.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        String[] object3 = stringArray = MiscUtilities.getEncodings(true);
        int jRadioButtonMenuItem = object3.length;
        boolean jRadioButtonMenuItem2 = false;
        while (var9_13 < jRadioButtonMenuItem) {
            String string = object3[var9_13];
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem3.setActionCommand("encoding@" + string);
            jRadioButtonMenuItem3.addActionListener(actionHandler);
            buttonGroup.add(jRadioButtonMenuItem3);
            this.encodingMenuItems.put(string, jRadioButtonMenuItem3);
            arrayList.add(jRadioButtonMenuItem3);
            ++var9_13;
        }
        String string = System.getProperty("file.encoding");
        if (this.encodingMenuItems.get(string) == null) {
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem4.setActionCommand("encoding@" + string);
            jRadioButtonMenuItem4.addActionListener(actionHandler);
            buttonGroup.add(jRadioButtonMenuItem4);
            this.encodingMenuItems.put(string, jRadioButtonMenuItem4);
            arrayList.add(jRadioButtonMenuItem4);
        }
        arrayList.sort(new MenuItemTextComparator());
        for (JRadioButtonMenuItem jRadioButtonMenuItem5 : arrayList) {
            if (object.getMenuComponentCount() > 20) {
                JMenu jMenu2 = new JMenu(jEdit.getProperty("common.more"));
                object.add(jMenu2);
                object = jMenu2;
            }
            object.add(jRadioButtonMenuItem5);
        }
        object.addSeparator();
        this.otherEncoding = new JRadioButtonMenuItem();
        this.otherEncoding.setActionCommand("other-encoding");
        this.otherEncoding.addActionListener(actionHandler);
        buttonGroup.add(this.otherEncoding);
        object.add(this.otherEncoding);
        return jMenu;
    }

    private static JMenu createCustomMenu() {
        if (!jEdit.getProperty("browser.custom.context", "").isEmpty()) {
            JMenu jMenu = GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "browser.custom.context");
            return jMenu;
        }
        return null;
    }

    private static JMenu createPluginMenu(VFSBrowser vFSBrowser) {
        JMenu jMenu = new JMenu(jEdit.getProperty("vfs.browser.plugins.label"));
        GenericGUIUtilities.setAutoMnemonic(jMenu);
        return (JMenu)vFSBrowser.createPluginsMenu(jMenu, false);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("auto-detect")) {
                BrowserCommandsMenu.this.browser.autoDetectEncoding = BrowserCommandsMenu.this.autoDetect.isSelected();
            } else if (string.equals("other-encoding")) {
                String string2 = GUIUtilities.input(BrowserCommandsMenu.this.browser, "encoding-prompt", null, jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
                if (string2 == null) {
                    return;
                }
                BrowserCommandsMenu.this.browser.currentEncoding = string2;
            } else if (string.startsWith("encoding@")) {
                BrowserCommandsMenu.this.browser.currentEncoding = string.substring(9);
            }
        }
    }
}

