/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DisplayTokenHandler
extends DefaultTokenHandler {
    public static int MAX_CHUNK_LEN = 1;
    private SyntaxStyle[] styles;
    private FontRenderContext fontRenderContext;
    private TabExpander expander;
    private List<Chunk> out;
    private float wrapMargin;
    private int physicalLineOffset;

    public void init(SyntaxStyle[] syntaxStyleArray, FontRenderContext fontRenderContext, TabExpander tabExpander, List<Chunk> list, float f, int n) {
        super.init();
        this.styles = syntaxStyleArray;
        this.fontRenderContext = fontRenderContext;
        this.expander = tabExpander;
        this.out = list;
        this.wrapMargin = f;
        this.physicalLineOffset = n;
    }

    public List<Chunk> getChunkList() {
        return this.out;
    }

    @Override
    public void handleToken(Segment segment, byte by, int n, int n2, TokenMarker.LineContext lineContext) {
        int n3;
        if (by == 127) {
            this.makeScreenLine(segment);
            return;
        }
        if (n2 <= MAX_CHUNK_LEN) {
            Chunk chunk = this.createChunk(by, n, n2, lineContext);
            this.addToken(chunk, lineContext);
            return;
        }
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(segment);
        int n4 = segment.offset + n;
        int n5 = n4 + n2;
        int n6 = 0;
        do {
            int n7 = n4 + n6;
            int n8 = breakIterator.preceding(n7 + MAX_CHUNK_LEN + 1);
            assert (n8 != -1);
            if (n8 <= n7) {
                n8 = breakIterator.following(n7 + MAX_CHUNK_LEN);
                assert (n8 != -1);
                if (n8 >= n5) break;
            }
            n3 = n8 - n7;
            Chunk chunk = this.createChunk(by, n + n6, n3, lineContext);
            this.addToken(chunk, lineContext);
        } while ((n6 += n3) + MAX_CHUNK_LEN < n2);
        Chunk chunk = this.createChunk(by, n + n6, n2 - n6, lineContext);
        this.addToken(chunk, lineContext);
    }

    private Chunk createChunk(byte by, int n, int n2, TokenMarker.LineContext lineContext) {
        return new Chunk(by, n, n2, this.getParserRuleSet(lineContext), this.styles, lineContext.rules.getDefault());
    }

    private void initChunk(Chunk chunk, float f, Segment segment) {
        chunk.init(segment, this.expander, f, this.fontRenderContext, this.physicalLineOffset);
    }

    private float initChunks(Chunk chunk, Segment segment) {
        float f = 0.0f;
        Chunk chunk2 = chunk;
        while (chunk2 != null) {
            this.initChunk(chunk2, f, segment);
            f += chunk2.width;
            chunk2 = (Chunk)chunk2.next;
        }
        return f;
    }

    private static void mergeAdjucentChunks(Chunk chunk, Segment segment) {
        Chunk chunk2 = chunk;
        while (chunk2.next != null) {
            Chunk chunk3 = (Chunk)chunk2.next;
            if (DisplayTokenHandler.canMerge(chunk2, chunk3, segment)) {
                chunk2.length += chunk3.length;
                chunk2.next = chunk3.next;
                continue;
            }
            chunk2 = chunk3;
        }
    }

    private static boolean canMerge(Chunk chunk, Chunk chunk2, Segment segment) {
        return chunk.style == chunk2.style && chunk.isAccessible() && !chunk.isTab(segment) && chunk2.isAccessible() && !chunk2.isTab(segment) && chunk.length + chunk2.length <= MAX_CHUNK_LEN;
    }

    private Chunk makeWrappedLine(Chunk chunk, float f, Segment segment) {
        if (f > 0.0f) {
            Chunk chunk2 = new Chunk(f, chunk.offset, chunk.rules);
            this.initChunk(chunk2, 0.0f, segment);
            chunk2.next = chunk;
            return chunk2;
        }
        return chunk;
    }

    private boolean recalculateTabWidthInWrapMargin(Chunk chunk, Segment segment) {
        float f = 0.0f;
        Chunk chunk2 = chunk;
        while (chunk2 != null) {
            if (chunk2.isTab(segment)) {
                this.initChunk(chunk2, f, segment);
            }
            if ((f += chunk2.width) > this.wrapMargin) {
                return false;
            }
            chunk2 = (Chunk)chunk2.next;
        }
        return true;
    }

    private static int endOffsetOfWhitespaces(Segment segment, int n) {
        int n2;
        for (n2 = n; n2 < segment.count && Character.isWhitespace(segment.array[segment.offset + n2]); ++n2) {
        }
        return n2;
    }

    private void makeScreenLineInWrapMargin(Chunk token, Segment segment) {
        int n = DisplayTokenHandler.endOffsetOfWhitespaces(segment, 0);
        float f = Chunk.offsetToX(token, n);
        LineBreaker lineBreaker = new LineBreaker(segment, n);
        if (lineBreaker.currentBreak() == -1) {
            this.out.add((Chunk)token);
            return;
        }
        do {
            Token token2;
            int n2 = Chunk.xToOffset(token, this.wrapMargin, false);
            assert (n2 != -1);
            lineBreaker.skipToNearest(DisplayTokenHandler.endOffsetOfWhitespaces(segment, n2));
            int n3 = lineBreaker.currentBreak();
            if (n3 == -1) {
                this.out.add((Chunk)token);
                return;
            }
            lineBreaker.advance();
            Chunk chunk = null;
            Chunk chunk2 = token;
            float f2 = 0.0f;
            while (chunk2.offset + chunk2.length < n3) {
                f2 += chunk2.width;
                chunk = chunk2;
                chunk2 = (Chunk)chunk2.next;
            }
            if (chunk2.offset + chunk2.length == n3) {
                token2 = chunk2.next;
                chunk2.next = null;
                this.out.add((Chunk)token);
                if (token2 == null) {
                    return;
                }
                token = (Chunk)token2;
                continue;
            }
            token2 = chunk2.snippetBeforeLineOffset(n3);
            this.initChunk((Chunk)token2, f2, segment);
            if (chunk != null) {
                chunk.next = token2;
            } else {
                token = token2;
            }
            this.out.add((Chunk)token);
            Chunk chunk3 = chunk2.snippetAfter(((Chunk)token2).length);
            float f3 = this.wrapMargin - f;
            float f4 = ((Chunk)token2).width;
            while (chunk2.width - f4 > f3 && lineBreaker.currentBreak() != -1 && lineBreaker.currentBreak() < chunk3.offset + chunk3.length) {
                int n4 = chunk2.xToOffset(f4 + f3, false);
                assert (n4 != -1);
                lineBreaker.skipToNearest(DisplayTokenHandler.endOffsetOfWhitespaces(segment, n4));
                int n5 = lineBreaker.currentBreak();
                assert (n5 != -1);
                if (n5 >= chunk3.offset + chunk3.length) break;
                lineBreaker.advance();
                Chunk chunk4 = chunk3.snippetBeforeLineOffset(n5);
                this.initChunk(chunk4, f, segment);
                this.out.add(this.makeWrappedLine(chunk4, f, segment));
                chunk3 = chunk3.snippetAfter(chunk4.length);
                f4 += chunk4.width;
            }
            this.initChunk(chunk3, f, segment);
            chunk3.next = chunk2.next;
            token = chunk3;
        } while (!this.recalculateTabWidthInWrapMargin((Chunk)(token = this.makeWrappedLine((Chunk)token, f, segment)), segment));
        this.out.add((Chunk)token);
    }

    private void makeScreenLine(Segment segment) {
        if (this.firstToken == null) {
            assert (this.out.isEmpty());
        } else {
            Chunk chunk = (Chunk)this.firstToken;
            DisplayTokenHandler.mergeAdjucentChunks(chunk, segment);
            float f = this.initChunks(chunk, segment);
            if (this.wrapMargin > 0.0f && f > this.wrapMargin) {
                this.makeScreenLineInWrapMargin(chunk, segment);
            } else {
                this.out.add(chunk);
            }
        }
    }

    private static class LineBreakIterator
    extends BreakIterator {
        private final BreakIterator base;

        LineBreakIterator() {
            this.base = BreakIterator.getLineInstance();
        }

        private LineBreakIterator(LineBreakIterator lineBreakIterator) {
            this.base = (BreakIterator)lineBreakIterator.base.clone();
        }

        @Override
        public Object clone() {
            return new LineBreakIterator(this);
        }

        @Override
        public int current() {
            int n = this.base.current();
            if (this.isAcceptableBreak(n)) {
                return n;
            }
            return this.base.next() == -1 ? this.last() : this.first();
        }

        @Override
        public int first() {
            return this.baseOrNext(this.base.first());
        }

        @Override
        public int following(int n) {
            return this.baseOrNext(this.base.following(n));
        }

        @Override
        public CharacterIterator getText() {
            return this.base.getText();
        }

        @Override
        public int last() {
            return this.baseOrPrevious(this.base.last());
        }

        @Override
        public int next() {
            return this.baseOrNext(this.base.next());
        }

        @Override
        public int next(int n) {
            while (n > 1) {
                if (this.next() == -1) {
                    return -1;
                }
                --n;
            }
            return this.next();
        }

        @Override
        public int previous() {
            return this.baseOrPrevious(this.base.previous());
        }

        @Override
        public void setText(CharacterIterator characterIterator) {
            this.base.setText(characterIterator);
            this.baseOrNext(this.base.first());
        }

        private int baseOrNext(int n) {
            while (!this.isAcceptableBreak(n)) {
                n = this.base.next();
            }
            return n;
        }

        private int baseOrPrevious(int n) {
            while (!this.isAcceptableBreak(n)) {
                n = this.base.previous();
            }
            return n;
        }

        private boolean isAcceptableBreak(int n) {
            if (n == -1) {
                return true;
            }
            CharacterIterator characterIterator = this.getText();
            if (n <= characterIterator.getBeginIndex() || n > characterIterator.getEndIndex()) {
                return true;
            }
            int n2 = characterIterator.getIndex();
            char c = characterIterator.setIndex(n);
            char c2 = characterIterator.previous();
            characterIterator.setIndex(n2);
            return !Character.isWhitespace(c) && (Character.isWhitespace(c2) || c2 > '\u007f' || c > '\u007f') && (c2 != '\u2019' || !Character.isLowerCase(c) && !Character.isUpperCase(c)) && !LineBreakIterator.isUnacceptableBreakInsideQuote(n, characterIterator, c2, c);
        }

        private static char charAt(CharacterIterator characterIterator, int n) {
            int n2 = characterIterator.getIndex();
            char c = characterIterator.setIndex(n);
            characterIterator.setIndex(n2);
            return c;
        }

        private static boolean isUnacceptableBreakInsideQuote(int n, CharacterIterator characterIterator, char c, char c2) {
            if ("\u201d\u2019\u00bb\u203a".indexOf(c) >= 0 && !Character.isWhitespace(c2)) {
                int n2 = characterIterator.getBeginIndex();
                for (int i = n - 2; i >= n2; --i) {
                    char c3 = LineBreakIterator.charAt(characterIterator, i);
                    if (Character.isWhitespace(c3)) {
                        return true;
                    }
                    if (!Character.isLetterOrDigit(c3)) continue;
                    return false;
                }
                return true;
            }
            if (!Character.isWhitespace(c) && "\u201c\u201e\u2018\u201a\u00ab\u2039".indexOf(c2) >= 0) {
                int n3 = characterIterator.getEndIndex();
                for (int i = n + 1; i < n3; ++i) {
                    char c4 = LineBreakIterator.charAt(characterIterator, i);
                    if (Character.isWhitespace(c4)) {
                        return true;
                    }
                    if (!Character.isLetterOrDigit(c4)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class LineBreaker {
        public static final int DONE = -1;
        private final BreakIterator iterator = new LineBreakIterator();
        private final int offsetOrigin;
        private int current;
        private int next;

        LineBreaker(Segment segment, int n) {
            this.iterator.setText(segment);
            this.offsetOrigin = segment.offset;
            this.current = n < segment.count ? this.iterator.following(this.offsetOrigin + n) : -1;
            this.next = this.current != -1 ? this.iterator.next() : -1;
        }

        public int currentBreak() {
            return this.outerOffset(this.current);
        }

        public void advance() {
            this.current = this.next;
            this.next = this.iterator.next();
        }

        public void skipToNearest(int n) {
            while (this.next != -1 && this.next - this.offsetOrigin <= n) {
                this.advance();
            }
        }

        private int outerOffset(int n) {
            return n != -1 ? n - this.offsetOrigin : -1;
        }
    }
}

