/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.OsmPrimitiveImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class Tag2Link {
    static final MultiMap<String, String> wikidataRules = new MultiMap();
    static final Map<String, UnaryOperator<String>> valueFormatter = Collections.singletonMap("ref:bag", v -> String.format("%16s", v).replace(' ', '0'));
    static final String languagePattern = LanguageInfo.getLanguageCodes(null).stream().map(Pattern::quote).collect(Collectors.joining("|"));
    static final ListProperty PREF_SOURCE = new ListProperty("tag2link.source", Collections.singletonList("resource://META-INF/resources/webjars/tag2link/2020.10.18/index.json"));
    static final CachingProperty<List<String>> PREF_SEARCH_ENGINES = new ListProperty("tag2link.search", Arrays.asList("https://duckduckgo.com/?q=$1", "https://www.google.com/search?q=$1")).cached();

    private Tag2Link() {
    }

    public static void initialize() {
        try {
            wikidataRules.clear();
            Iterator iterator = PREF_SOURCE.get().iterator();
            while (iterator.hasNext()) {
                String source = (String)iterator.next();
                Tag2Link.initializeFromResources(new CachedFile(source));
            }
        }
        catch (Exception e) {
            Logging.error("Failed to initialize tag2link rules");
            Logging.error(e);
        }
    }

    private static void initializeFromResources(CachedFile resource) throws IOException {
        JsonArray rules;
        try (InputStream inputStream = resource.getInputStream();
             JsonReader jsonReader = Json.createReader(inputStream);){
            rules = jsonReader.readArray();
        }
        for (JsonValue rule : rules) {
            String key2 = rule.asJsonObject().getString("key");
            String url = rule.asJsonObject().getString("url");
            if (!key2.startsWith("Key:")) continue;
            wikidataRules.put(key2.substring("Key:".length()), url);
        }
        wikidataRules.keySet().removeIf(key -> key.matches("^(.+[:_])?website([:_].+)?$") || key.matches("^(.+[:_])?url([:_].+)?$") || key.matches("wikimedia_commons|image") || key.matches("wikipedia(:(?<lang>\\p{Lower}{2,}))?") || key.matches("(.*:)?wikidata"));
        int size = wikidataRules.size();
        Logging.info(I18n.trn("Obtained {0} Tag2Link rule from {1}", "Obtained {0} Tag2Link rules from {1}", size, size, resource));
    }

    public static void getLinksForTag(String key, String value, LinkConsumer linkConsumer) {
        String validURL;
        if (value == null || value.isEmpty()) {
            return;
        }
        HashMap memoize = new HashMap();
        Supplier<ImageResource> imageResource = () -> memoize.computeIfAbsent(OsmPrimitiveType.NODE, type -> OsmPrimitiveImageProvider.getResource(key, value, type)).orElse(null);
        if (key.matches("^(.+[:_])?name([:_]" + languagePattern + ")?$")) {
            ImageResource search = new ImageProvider("dialogs/search").getResource();
            PREF_SEARCH_ENGINES.get().forEach(url -> linkConsumer.acceptLink(I18n.tr("Search on {0}", Tag2Link.getHost(url, url)), url.replace("$1", Utils.encodeUrl(value)), search));
        }
        String string = value.startsWith("http:") || value.startsWith("https:") ? value : (validURL = value.startsWith("www.") ? "http://" + value : null);
        if (key.matches("^(.+[:_])?website([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL, imageResource.get());
        }
        if (key.matches("^(.+[:_])?source([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL, imageResource.get());
        }
        if (key.matches("^(.+[:_])?url([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL, imageResource.get());
        }
        if (key.matches("image") && validURL != null) {
            linkConsumer.acceptLink(I18n.tr("View image", new Object[0]), validURL, imageResource.get());
        }
        Matcher keyMatcher = Pattern.compile("wikipedia(:(?<lang>\\p{Lower}{2,}))?").matcher(key);
        Matcher valueMatcher = Pattern.compile("((?<lang>\\p{Lower}{2,}):)?(?<article>.*)").matcher(value);
        if (keyMatcher.matches() && valueMatcher.matches()) {
            String lang = Utils.firstNotEmptyString("en", keyMatcher.group("lang"), valueMatcher.group("lang"));
            String url2 = "https://" + lang + ".wikipedia.org/wiki/" + valueMatcher.group("article").replace(' ', '_');
            linkConsumer.acceptLink(I18n.tr("View Wikipedia article", new Object[0]), url2, imageResource.get());
        }
        if (key.matches("(.*:)?wikidata")) {
            OsmUtils.splitMultipleValues(value).forEach(q -> linkConsumer.acceptLink(I18n.tr("View Wikidata item", new Object[0]), "https://www.wikidata.org/wiki/" + q, (ImageResource)imageResource.get()));
        }
        if (key.matches("(.*:)?species")) {
            String url3 = "https://species.wikimedia.org/wiki/" + value;
            linkConsumer.acceptLink(Tag2Link.getLinkName(url3, key), url3, imageResource.get());
        }
        if (key.matches("wikimedia_commons|image") && value.matches("(?i:File):.*")) {
            OsmUtils.splitMultipleValues(value).forEach(i -> linkConsumer.acceptLink(I18n.tr("View image on Wikimedia Commons", new Object[0]), "https://commons.wikimedia.org/wiki/" + i, (ImageResource)imageResource.get()));
        }
        if (key.matches("wikimedia_commons|image") && value.matches("(?i:Category):.*")) {
            OsmUtils.splitMultipleValues(value).forEach(i -> linkConsumer.acceptLink(I18n.tr("View category on Wikimedia Commons", new Object[0]), "https://commons.wikimedia.org/wiki/" + i, (ImageResource)imageResource.get()));
        }
        wikidataRules.getValues(key).forEach(urlFormatter -> {
            String formattedValue = (String)valueFormatter.getOrDefault(key, x -> x).apply(value);
            String url = urlFormatter.replace("$1", formattedValue);
            linkConsumer.acceptLink(Tag2Link.getLinkName(url, key), url, (ImageResource)imageResource.get());
        });
    }

    private static String getLinkName(String url, String fallback) {
        return I18n.tr("Open {0}", Tag2Link.getHost(url, fallback));
    }

    private static String getHost(String url, String fallback) {
        try {
            return new URL(url).getHost().replaceFirst("^www\\.", "");
        }
        catch (MalformedURLException e) {
            return fallback;
        }
    }

    @FunctionalInterface
    public static interface LinkConsumer {
        public void acceptLink(String var1, String var2, ImageResource var3);
    }
}

