/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class TextBlockCommand
extends ControlSequence {
    private Declaration declaration;

    public TextBlockCommand(String string, Declaration declaration) {
        super(string);
        this.declaration = declaration;
    }

    @Override
    public Object clone() {
        return new TextBlockCommand(this.getName(), (Declaration)this.declaration.clone());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Group group = teXParser.getListener().createGroup();
        group.add(this.declaration);
        String string = this.declaration.getArgTypes();
        if (string != null) {
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case 'm': {
                        group.add(teXParser.popStack());
                        continue block4;
                    }
                    case 'o': {
                        TeXObject teXObject = teXParser.popNextArg(91, 93);
                        if (teXObject == null) continue block4;
                        group.add(teXParser.getListener().getOther(91));
                        group.add(teXObject);
                        group.add(teXParser.getListener().getOther(93));
                        continue block4;
                    }
                    default: {
                        throw new LaTeXSyntaxException(teXParser, "latex.illegal.argtype", Character.valueOf(c));
                    }
                }
            }
        }
        TeXObject teXObject = teXParser.popNextArg();
        group.add(teXObject);
        group.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Group group = teXParser.getListener().createGroup();
        group.add(this.declaration);
        String string = this.declaration.getArgTypes();
        if (string != null) {
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case 'm': {
                        group.add(teXObjectList.popStack(teXParser));
                        continue block4;
                    }
                    case 'o': {
                        TeXObject teXObject = teXObjectList.popArg(teXParser, 91, 93);
                        if (teXObject == null) continue block4;
                        group.add(teXParser.getListener().getOther(91));
                        group.add(teXObject);
                        group.add(teXParser.getListener().getOther(93));
                        continue block4;
                    }
                    default: {
                        throw new LaTeXSyntaxException(teXParser, "latex.illegal.argtype", Character.valueOf(c));
                    }
                }
            }
        }
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        group.add(teXObject);
        group.process(teXParser, teXObjectList);
    }
}

