/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;

class JspReader {
    private final Log log = LogFactory.getLog(JspReader.class);
    private Mark current;
    private final JspCompilationContext context;
    private final ErrorDispatcher err;

    public JspReader(JspCompilationContext jspCompilationContext, String string, String string2, Jar jar, ErrorDispatcher errorDispatcher) throws JasperException, FileNotFoundException, IOException {
        this(jspCompilationContext, string, JspUtil.getReader(string, string2, jar, jspCompilationContext, errorDispatcher), errorDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspReader(JspCompilationContext jspCompilationContext, String string, InputStreamReader inputStreamReader, ErrorDispatcher errorDispatcher) throws JasperException {
        this.context = jspCompilationContext;
        this.err = errorDispatcher;
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = inputStreamReader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            charArrayWriter.close();
            this.current = new Mark(this, charArrayWriter.toCharArray(), string);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.log.error((Object)"Exception parsing file ", throwable);
            errorDispatcher.jspError("jsp.error.file.cannot.read", string);
        }
        finally {
            block14: {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!this.log.isDebugEnabled()) break block14;
                        this.log.debug((Object)"Exception closing reader: ", (Throwable)exception);
                    }
                }
            }
        }
    }

    JspCompilationContext getJspCompilationContext() {
        return this.context;
    }

    boolean hasMoreInput() {
        return this.current.cursor < this.current.stream.length;
    }

    int nextChar() {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (c == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    private int nextChar(Mark mark) {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        mark.init(this.current, true);
        ++this.current.cursor;
        if (c == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    private Boolean indexOf(char c, Mark mark) {
        int n;
        if (!this.hasMoreInput()) {
            return null;
        }
        int n2 = this.current.stream.length;
        int n3 = this.current.line;
        int n4 = this.current.col;
        for (n = this.current.cursor; n < n2; ++n) {
            char c2 = this.current.stream[n];
            if (c2 == c) {
                mark.update(n, n3, n4);
            }
            if (c2 == '\n') {
                ++n3;
                n4 = 0;
            } else {
                ++n4;
            }
            if (c2 != c) continue;
            this.current.update(n + 1, n3, n4);
            return Boolean.TRUE;
        }
        this.current.update(n, n3, n4);
        return Boolean.FALSE;
    }

    void pushChar() {
        --this.current.cursor;
        --this.current.col;
    }

    String getText(Mark mark, Mark mark2) {
        Mark mark3 = this.mark();
        this.reset(mark);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while (!this.markEquals(mark2)) {
            charArrayWriter.write(this.nextChar());
        }
        charArrayWriter.close();
        this.setCurrent(mark3);
        return charArrayWriter.toString();
    }

    int peekChar() {
        return this.peekChar(0);
    }

    int peekChar(int n) {
        int n2 = this.current.cursor + n;
        if (n2 < this.current.stream.length) {
            return this.current.stream[n2];
        }
        return -1;
    }

    Mark mark() {
        return new Mark(this.current);
    }

    private boolean markEquals(Mark mark) {
        return mark.equals(this.current);
    }

    void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    private void setCurrent(Mark mark) {
        this.current = mark;
    }

    boolean matches(String string) {
        int n;
        int n2 = this.current.cursor;
        int n3 = string.length();
        if (n2 + n3 < (n = this.current.stream.length)) {
            int n4;
            int n5 = this.current.line;
            int n6 = this.current.col;
            for (n4 = 0; n4 < n3; ++n4) {
                char c = this.current.stream[n4 + n2];
                if (string.charAt(n4) != c) {
                    return false;
                }
                if (c == '\n') {
                    ++n5;
                    n6 = 0;
                    continue;
                }
                ++n6;
            }
            this.current.update(n4 + n2, n5, n6);
        } else {
            Mark mark = this.mark();
            int n7 = 0;
            int n8 = 0;
            do {
                if ((char)(n7 = this.nextChar()) == string.charAt(n8++)) continue;
                this.setCurrent(mark);
                return false;
            } while (n8 < n3);
        }
        return true;
    }

    boolean matchesETag(String string) {
        Mark mark = this.mark();
        if (!this.matches("</" + string)) {
            return false;
        }
        this.skipSpaces();
        if (this.nextChar() == 62) {
            return true;
        }
        this.setCurrent(mark);
        return false;
    }

    boolean matchesETagWithoutLessThan(String string) {
        Mark mark = this.mark();
        if (!this.matches("/" + string)) {
            return false;
        }
        this.skipSpaces();
        if (this.nextChar() == 62) {
            return true;
        }
        this.setCurrent(mark);
        return false;
    }

    boolean matchesOptionalSpacesFollowedBy(String string) {
        Mark mark = this.mark();
        this.skipSpaces();
        boolean bl = this.matches(string);
        if (!bl) {
            this.setCurrent(mark);
        }
        return bl;
    }

    int skipSpaces() {
        int n = 0;
        while (this.hasMoreInput() && this.isSpace()) {
            ++n;
            this.nextChar();
        }
        return n;
    }

    Mark skipUntil(String string) {
        Mark mark = this.mark();
        int n = string.length();
        char c = string.charAt(0);
        Boolean bl = null;
        Mark mark2 = null;
        block0: while ((bl = this.indexOf(c, mark)) != null) {
            if (!bl.booleanValue()) continue;
            if (mark2 != null) {
                mark2.init(this.current, true);
            } else {
                mark2 = this.mark();
            }
            for (int i = 1; i < n; ++i) {
                if (this.peekChar() != string.charAt(i)) {
                    this.current.init(mark2, true);
                    continue block0;
                }
                this.nextChar();
            }
            return mark;
        }
        return null;
    }

    Mark skipUntilIgnoreEsc(String string, boolean bl) {
        Mark mark = this.mark();
        int n = string.length();
        int n2 = 120;
        int n3 = string.charAt(0);
        int n4 = this.nextChar(mark);
        while (n4 != -1) {
            block9: {
                if (n4 == 92 && n2 == 92) {
                    n4 = 0;
                } else if (n2 != 92) {
                    if (!(bl || n4 != 36 && n4 != 35 || this.peekChar() != 123)) {
                        this.nextChar();
                        this.skipELExpression();
                    } else if (n4 == n3) {
                        for (int i = 1; i < n; ++i) {
                            if (this.peekChar() == string.charAt(i)) {
                                this.nextChar();
                                continue;
                            }
                            break block9;
                        }
                        return mark;
                    }
                }
            }
            n2 = n4;
            n4 = this.nextChar(mark);
        }
        return null;
    }

    Mark skipUntilETag(String string) {
        Mark mark = this.skipUntil("</" + string);
        if (mark != null) {
            this.skipSpaces();
            if (this.nextChar() != 62) {
                mark = null;
            }
        }
        return mark;
    }

    Mark skipELExpression() {
        int n;
        Mark mark = this.mark();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        do {
            n = this.nextChar(mark);
            while (n == 92 && (bl || bl2)) {
                this.nextChar();
                n = this.nextChar();
            }
            if (n == -1) {
                return null;
            }
            if (n == 34 && !bl) {
                bl2 = !bl2;
                continue;
            }
            if (n == 39 && !bl2) {
                bl = !bl;
                continue;
            }
            if (n == 123 && !bl2 && !bl) {
                ++n2;
                continue;
            }
            if (n != 125 || bl2 || bl) continue;
            --n2;
        } while (n != 125 || bl || bl2 || n2 > -1);
        return mark;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    String parseToken(boolean bl) throws JasperException {
        StringBuilder stringBuilder = new StringBuilder();
        this.skipSpaces();
        stringBuilder.setLength(0);
        if (!this.hasMoreInput()) {
            return "";
        }
        int n = this.peekChar();
        if (bl) {
            if (n == 34 || n == 39) {
                int n2 = n == 34 ? 34 : 39;
                n = this.nextChar();
                n = this.nextChar();
                while (n != -1 && n != n2) {
                    if (n == 92) {
                        n = this.nextChar();
                    }
                    stringBuilder.append((char)n);
                    n = this.nextChar();
                }
                if (n == -1) {
                    this.err.jspError(this.mark(), "jsp.error.quotes.unterminated", new String[0]);
                }
            } else {
                this.err.jspError(this.mark(), "jsp.error.attr.quoted", new String[0]);
            }
        } else if (!this.isDelimiter()) {
            do {
                if ((n = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                    n = this.nextChar();
                }
                stringBuilder.append((char)n);
            } while (!this.isDelimiter());
        }
        return stringBuilder.toString();
    }

    private boolean isDelimiter() {
        if (!this.isSpace()) {
            int n = this.peekChar();
            if (n == 61 || n == 62 || n == 34 || n == 39 || n == 47) {
                return true;
            }
            if (n == 45) {
                Mark mark = this.mark();
                n = this.nextChar();
                if (n == 62 || n == 45 && this.nextChar() == 62) {
                    this.setCurrent(mark);
                    return true;
                }
                this.setCurrent(mark);
                return false;
            }
            return false;
        }
        return true;
    }
}

