/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.catalina.tribes.util.StringManager;

public final class ReplicationStream
extends ObjectInputStream {
    static final StringManager sm = StringManager.getManager(ReplicationStream.class);
    private ClassLoader[] classLoaders = null;

    public ReplicationStream(InputStream inputStream, ClassLoader[] classLoaderArray) throws IOException {
        super(inputStream);
        this.classLoaders = classLoaderArray;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        String string = objectStreamClass.getName();
        try {
            return this.resolveClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    public Class<?> resolveClass(String string) throws ClassNotFoundException {
        boolean bl = string.startsWith("org.apache.catalina.tribes");
        try {
            if (bl) {
                return this.findReplicationClass(string);
            }
            return this.findExternalClass(string);
        }
        catch (Exception exception) {
            if (bl) {
                return this.findExternalClass(string);
            }
            return this.findReplicationClass(string);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.classLoaders != null && this.classLoaders.length > 0 ? this.classLoaders[0] : null;
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = this.resolveClass(stringArray[i]);
            if (classLoader == null) {
                classLoader = clazz.getClassLoader();
            }
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError(sm.getString("replicationStream.conflict"));
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            Class<?> clazz = Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
            return clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    public Class<?> findReplicationClass(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string, false, this.getClass().getClassLoader());
        return clazz;
    }

    public Class<?> findExternalClass(String string) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> clazz = Class.forName(string, false, classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    public void close() throws IOException {
        this.classLoaders = null;
        super.close();
    }
}

