/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;

public final class CompilerOptionsPreprocessor {
    static void preprocess(CompilerOptions options) {
        if (options.getInlineFunctionsLevel() == CompilerOptions.Reach.NONE && options.maxFunctionSizeAfterInlining != -1) {
            throw new InvalidOptionsException("max_function_size_after_inlining has no effect if inlining is disabled.", new Object[0]);
        }
        if (options.dartPass) {
            if (!options.getOutputFeatureSet().contains(FeatureSet.ES5)) {
                throw new InvalidOptionsException("Dart requires --language_out=ES5 or higher.", new Object[0]);
            }
            options.setAmbiguateProperties(false);
            options.setDisambiguateProperties(false);
        }
        if (CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED.equals((Object)options.getLanguageIn())) {
            throw new InvalidOptionsException("Cannot set input language to ECMASCRIPT6_TYPED.", new Object[0]);
        }
    }

    private CompilerOptionsPreprocessor() {
    }

    public static class InvalidOptionsException
    extends RuntimeException {
        private InvalidOptionsException(String message, Object ... args) {
            super(SimpleFormat.format(message, args));
        }
    }
}

