/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ijs.ClassUtil;
import com.google.javascript.jscomp.ijs.JsdocUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import javax.annotation.Nullable;

abstract class PotentialDeclaration {
    private final String fullyQualifiedName;
    private final Node lhs;
    @Nullable
    private final Node rhs;

    private PotentialDeclaration(String fullyQualifiedName, Node lhs, @Nullable Node rhs) {
        this.fullyQualifiedName = Preconditions.checkNotNull(fullyQualifiedName);
        this.lhs = Preconditions.checkNotNull(lhs);
        this.rhs = rhs;
    }

    static PotentialDeclaration fromName(Node nameNode) {
        Preconditions.checkArgument(nameNode.isQualifiedName(), nameNode);
        Node rhs = NodeUtil.getRValueOfLValue(nameNode);
        if (ClassUtil.isThisProp(nameNode)) {
            String name = ClassUtil.getPrototypeNameOfThisProp(nameNode);
            return new ThisPropDeclaration(name, nameNode, rhs);
        }
        return new NameDeclaration(nameNode.getQualifiedName(), nameNode, rhs);
    }

    static PotentialDeclaration fromMethod(Node functionNode) {
        Preconditions.checkArgument(ClassUtil.isClassMethod(functionNode));
        String name = ClassUtil.getFullyQualifiedNameOfMethod(functionNode);
        return new MethodDeclaration(name, functionNode);
    }

    static PotentialDeclaration fromStringKey(Node stringKeyNode) {
        JSDocInfo objLitJsDoc;
        Preconditions.checkArgument(stringKeyNode.isStringKey());
        Preconditions.checkArgument(stringKeyNode.getParent().isObjectLit());
        String name = "this." + stringKeyNode.getString();
        if (stringKeyNode.getString().equals("properties") && (objLitJsDoc = NodeUtil.getBestJSDocInfo(stringKeyNode.getParent())) != null && objLitJsDoc.isPolymerBehavior()) {
            return new PolymerBehaviorPropertiesDeclaration(name, stringKeyNode);
        }
        return new StringKeyDeclaration(name, stringKeyNode);
    }

    static PotentialDeclaration fromDefine(Node callNode) {
        Preconditions.checkArgument(NodeUtil.isCallTo(callNode, "goog.define"));
        return DefineDeclaration.from(callNode);
    }

    static PotentialDeclaration fromAlias(Node nameNode) {
        Preconditions.checkArgument(nameNode.isQualifiedName(), nameNode);
        return new AliasDeclaration(nameNode.getQualifiedName(), nameNode);
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    Node getLhs() {
        return this.lhs;
    }

    @Nullable
    Node getRhs() {
        return this.rhs;
    }

    @Nullable
    JSDocInfo getJsDoc() {
        return NodeUtil.getBestJSDocInfo(this.lhs);
    }

    boolean isDetached() {
        for (Node current = this.lhs; current != null; current = current.getParent()) {
            if (!current.isScript()) continue;
            return false;
        }
        return true;
    }

    Node getRemovableNode() {
        return NodeUtil.getEnclosingStatement(this.lhs);
    }

    final void remove(AbstractCompiler compiler) {
        if (this.isDetached()) {
            return;
        }
        Node statement = this.getRemovableNode();
        NodeUtil.deleteNode(statement, compiler);
        statement.removeChildren();
    }

    abstract void simplify(AbstractCompiler var1);

    private void simplifyEnumValues(AbstractCompiler compiler) {
        if (this.getRhs().isObjectLit() && this.getRhs().hasChildren()) {
            for (Node key : this.getRhs().children()) {
                PotentialDeclaration.removeStringKeyValue(key);
            }
            compiler.reportChangeToEnclosingScope(this.getRhs());
        }
    }

    boolean isDefiniteDeclaration() {
        Node parent = this.getLhs().getParent();
        switch (parent.getToken()) {
            case VAR: 
            case LET: 
            case CONST: 
            case CLASS: 
            case FUNCTION: {
                return true;
            }
        }
        return PotentialDeclaration.isExportLhs(this.getLhs()) || this.getJsDoc() != null && this.getJsDoc().containsDeclaration() || this.getRhs() != null && PotentialDeclaration.isTypedRhs(this.getRhs());
    }

    boolean shouldPreserve() {
        return this.getRhs() != null && PotentialDeclaration.isTypedRhs(this.getRhs());
    }

    boolean isConstToBeInferred() {
        return PotentialDeclaration.isConstToBeInferred(this.getLhs());
    }

    static boolean isConstToBeInferred(Node nameNode) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(nameNode);
        boolean isConst = nameNode.getParent().isConst() || PotentialDeclaration.isExportLhs(nameNode) || jsdoc != null && jsdoc.isConstant();
        return isConst && !JsdocUtil.hasAnnotatedType(jsdoc) && !NodeUtil.isNamespaceDecl(nameNode);
    }

    private static boolean isTypedRhs(Node rhs) {
        return rhs.isFunction() || rhs.isClass() || NodeUtil.isCallTo(rhs, "goog.defineClass") || rhs.isQualifiedName() && rhs.matchesQualifiedName("goog.abstractMethod") || rhs.isQualifiedName() && rhs.matchesQualifiedName("goog.nullFunction");
    }

    private static boolean isExportLhs(Node lhs) {
        return lhs.isName() && lhs.matchesName("exports") || lhs.isGetProp() && lhs.getFirstChild().matchesName("exports") || lhs.matchesQualifiedName("module.exports");
    }

    static boolean isImportRhs(@Nullable Node rhs) {
        if (rhs == null || !rhs.isCall()) {
            return false;
        }
        Node callee = rhs.getFirstChild();
        return callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.requireType") || callee.matchesQualifiedName("goog.forwardDeclare") || callee.matchesName("require");
    }

    static boolean isAliasDeclaration(Node lhs, @Nullable Node rhs) {
        return !ClassUtil.isThisProp(lhs) && PotentialDeclaration.isConstToBeInferred(lhs) && rhs != null && rhs.isQualifiedName();
    }

    private static void removeStringKeyValue(Node stringKey) {
        Node value = stringKey.getOnlyChild();
        Node replacementValue = IR.number(0.0).srcrefTree(value);
        stringKey.replaceChild(value, replacementValue);
    }

    private static class AliasDeclaration
    extends PotentialDeclaration {
        AliasDeclaration(String name, Node lhs) {
            super(name, lhs, null);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
        }

        @Override
        Node getRemovableNode() {
            Node lhs = this.getLhs();
            if (lhs.getParent().isArrayPattern() && lhs.getParent().hasMoreThanOneChild()) {
                return lhs;
            }
            if (lhs.getGrandparent().isObjectPattern() && lhs.getGrandparent().hasMoreThanOneChild()) {
                return lhs.getParent();
            }
            return NodeUtil.getEnclosingStatement(lhs);
        }

        @Override
        boolean isDefiniteDeclaration() {
            return true;
        }

        @Override
        boolean shouldPreserve() {
            return true;
        }
    }

    private static class PolymerBehaviorPropertiesDeclaration
    extends PotentialDeclaration {
        PolymerBehaviorPropertiesDeclaration(String name, Node stringKeyNode) {
            super(name, stringKeyNode, stringKeyNode.getLastChild());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.isDetached()) {
                return;
            }
            Node propertiesObject = this.getRhs();
            if (!propertiesObject.isObjectLit() || !propertiesObject.hasChildren()) {
                return;
            }
            for (Node propKey : propertiesObject.children()) {
                Node propDef = propKey.getOnlyChild();
                if (!propDef.isObjectLit()) continue;
                for (Node subProp : propDef.children()) {
                    if (subProp.getString().equals("type")) continue;
                    NodeUtil.deleteNode(subProp, compiler);
                }
            }
        }

        @Override
        boolean shouldPreserve() {
            return true;
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class StringKeyDeclaration
    extends PotentialDeclaration {
        StringKeyDeclaration(String name, Node stringKeyNode) {
            super(name, stringKeyNode, stringKeyNode.getLastChild());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.shouldPreserve()) {
                return;
            }
            JSDocInfo jsdoc = this.getJsDoc();
            if (jsdoc != null && jsdoc.hasEnumParameterType()) {
                ((PotentialDeclaration)this).simplifyEnumValues(compiler);
                return;
            }
            Node key = this.getLhs();
            PotentialDeclaration.removeStringKeyValue(key);
            compiler.reportChangeToEnclosingScope(key);
            if (jsdoc == null || !jsdoc.containsDeclaration() || this.isConstToBeInferred()) {
                key.setJSDocInfo(JsdocUtil.getUnusableTypeJSDoc(jsdoc));
            }
        }

        @Override
        boolean shouldPreserve() {
            return super.isDetached() || super.shouldPreserve() || !this.isInNamespace();
        }

        private boolean isInNamespace() {
            Node stringKey = this.getLhs();
            Node objLit = stringKey.getParent();
            Node lvalue = NodeUtil.getBestLValue(objLit);
            if (lvalue == null) {
                return false;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lvalue);
            return !PotentialDeclaration.isExportLhs(lvalue) && !JsdocUtil.hasAnnotatedType(jsdoc) && NodeUtil.isNamespaceDecl(lvalue);
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class MethodDeclaration
    extends PotentialDeclaration {
        MethodDeclaration(String name, Node functionNode) {
            super(name, functionNode.getParent(), functionNode);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class DefineDeclaration
    extends PotentialDeclaration {
        DefineDeclaration(String qualifiedName, Node lhs, Node rhs) {
            super(qualifiedName, lhs, rhs);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            Node newRhs;
            JSDocInfo info = this.getJsDoc();
            if (info != null && info.getType() != null && (newRhs = DefineDeclaration.makeEmptyValueNode(info.getType())) != null) {
                this.getRhs().replaceWith(newRhs);
                compiler.reportChangeToEnclosingScope(newRhs);
                return;
            }
            NodeUtil.deleteNode(this.getRemovableNode(), compiler);
        }

        static DefineDeclaration from(Node callNode) {
            switch (callNode.getParent().getToken()) {
                case EXPR_RESULT: {
                    return new DefineDeclaration(callNode.getSecondChild().getString(), callNode, callNode.getLastChild());
                }
                case ASSIGN: {
                    Node previous = callNode.getPrevious();
                    return new DefineDeclaration(previous.getQualifiedName(), previous, callNode.getLastChild());
                }
                case NAME: {
                    Node parent = callNode.getParent();
                    return new DefineDeclaration(parent.getString(), parent, callNode.getLastChild());
                }
            }
            throw new IllegalStateException("Unexpected parent: " + (Object)((Object)callNode.getParent().getToken()));
        }

        static Node makeEmptyValueNode(JSTypeExpression type) {
            Node n;
            for (n = type.getRoot(); n != null && !n.isString() && !n.isName(); n = n.getFirstChild()) {
            }
            switch (n != null ? n.getString() : "") {
                case "boolean": {
                    return new Node(Token.FALSE);
                }
                case "number": {
                    return Node.newNumber(0.0);
                }
                case "string": {
                    return Node.newString("");
                }
            }
            return null;
        }
    }

    private static class ThisPropDeclaration
    extends PotentialDeclaration {
        private final Node insertionPoint;

        ThisPropDeclaration(String fullyQualifiedName, Node lhs, Node rhs) {
            super(fullyQualifiedName, lhs, rhs);
            Node thisPropDefinition = NodeUtil.getEnclosingStatement(lhs);
            this.insertionPoint = NodeUtil.getEnclosingStatement(thisPropDefinition.getParent());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.shouldPreserve()) {
                return;
            }
            Node newStatement = NodeUtil.newQNameDeclaration(compiler, this.getFullyQualifiedName(), null, this.getJsDoc());
            newStatement.useSourceInfoIfMissingFromForTree(this.getLhs());
            NodeUtil.deleteNode(this.getRemovableNode(), compiler);
            if (this.insertionPoint.getParent() != null) {
                this.insertionPoint.getParent().addChildAfter(newStatement, this.insertionPoint);
                compiler.reportChangeToEnclosingScope(newStatement);
            }
        }
    }

    private static class NameDeclaration
    extends PotentialDeclaration {
        NameDeclaration(String fullyQualifiedName, Node lhs, Node rhs) {
            super(fullyQualifiedName, lhs, rhs);
        }

        private void simplifyNamespace(AbstractCompiler compiler) {
            if (this.getRhs().isOr()) {
                Node objLit = this.getRhs().getLastChild().detach();
                this.getRhs().replaceWith(objLit);
                compiler.reportChangeToEnclosingScope(this.getLhs());
            }
        }

        private void simplifySymbol(AbstractCompiler compiler) {
            Preconditions.checkArgument(NodeUtil.isCallTo(this.getRhs(), "Symbol"));
            Node callNode = this.getRhs();
            while (callNode.hasMoreThanOneChild()) {
                NodeUtil.deleteNode(callNode.getLastChild(), compiler);
            }
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.getRhs() == null || this.shouldPreserve()) {
                return;
            }
            Node nameNode = this.getLhs();
            JSDocInfo jsdoc = this.getJsDoc();
            if (jsdoc != null && jsdoc.hasEnumParameterType()) {
                ((PotentialDeclaration)this).simplifyEnumValues(compiler);
                return;
            }
            if (NodeUtil.isNamespaceDecl(nameNode)) {
                this.simplifyNamespace(compiler);
                return;
            }
            if (nameNode.matchesName("exports")) {
                NameDeclaration.replaceRhsWithUnknown(this.getRhs());
                compiler.reportChangeToEnclosingScope(nameNode);
                return;
            }
            if (NodeUtil.isCallTo(this.getRhs(), "Symbol")) {
                this.simplifySymbol(compiler);
                return;
            }
            if (this.getLhs().getParent().isConst()) {
                jsdoc = JsdocUtil.markConstant(jsdoc);
            }
            Node newStatement = NodeUtil.newQNameDeclaration(compiler, nameNode.getQualifiedName(), null, jsdoc);
            newStatement.useSourceInfoIfMissingFromForTree(nameNode);
            Node oldStatement = this.getRemovableNode();
            NodeUtil.deleteChildren(oldStatement, compiler);
            if (oldStatement.isExport()) {
                oldStatement.addChildToBack(newStatement);
            } else {
                oldStatement.replaceWith(newStatement);
            }
            compiler.reportChangeToEnclosingScope(newStatement);
        }

        private static void replaceRhsWithUnknown(Node rhs) {
            rhs.replaceWith(IR.cast(IR.number(0.0), JsdocUtil.getQmarkTypeJSDoc()).srcrefTree(rhs));
        }

        @Override
        boolean shouldPreserve() {
            Node rhs = this.getRhs();
            Node nameNode = this.getLhs();
            JSDocInfo jsdoc = this.getJsDoc();
            boolean isExport = PotentialDeclaration.isExportLhs(nameNode);
            return super.shouldPreserve() || NameDeclaration.isImportRhs(rhs) || isExport && rhs != null && (rhs.isQualifiedName() || rhs.isObjectLit()) || jsdoc != null && jsdoc.isConstructor() && rhs != null && rhs.isQualifiedName() || rhs != null && rhs.isObjectLit() && !rhs.hasChildren() && (jsdoc == null || !JsdocUtil.hasAnnotatedType(jsdoc)) || rhs != null && NodeUtil.isCallTo(rhs, "Polymer") || this.isPolymerBehaviorAliasOrArray();
        }

        boolean isPolymerBehaviorAliasOrArray() {
            JSDocInfo jsdoc = this.getJsDoc();
            Node rhs = this.getRhs();
            return jsdoc != null && jsdoc.isPolymerBehavior() && rhs != null && (rhs.isName() || rhs.isArrayLit());
        }
    }
}

