/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Keyring;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.Tuple;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.GatewayMessage;
import esmska.gui.GatewayMessageFrame;
import esmska.gui.JHtmlLabel;
import esmska.gui.ThemeManager;
import esmska.transfer.GatewayExecutor;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.openide.awt.Mnemonics;

public class GatewayErrorMessage
extends GatewayMessage {
    private static final Config config = Config.getInstance();
    private static final Gateways gateways = Gateways.getInstance();
    private JHtmlLabel descriptionLabel;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel helpLabel;
    private JLabel helpTextLabel;
    private JButton okButton;
    private JButton retryButton;
    private JTextArea smsTextArea;
    private JLabel smsTextLabel;
    private JScrollPane smsTextScrollPane;
    private JScrollPane thirdPartyScrollPane;
    private JTextPane thirdPartyTextPane;

    public String getDescription(SMS sms) {
        Validate.notNull(sms.getProblem());
        GatewayExecutor.Problem problem = sms.getProblem().get1();
        String param = sms.getProblem().get2();
        Gateway gw = gateways.get(sms.getGateway());
        String website = gw != null ? gw.getWebsite() : null;
        Tuple<String, String> key = Keyring.getInstance().getKey(sms.getGateway());
        String login = key != null ? key.get1() : "";
        String password = key != null ? key.get2() : "";
        switch (problem) {
            case CUSTOM_MESSAGE: {
                return l10n.getString("GatewayProblem.CUSTOM_MESSAGE");
            }
            case FIX_IN_PROGRESS: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.FIX_IN_PROGRESS"), website);
            }
            case GATEWAY_MESSAGE: {
                return l10n.getString("GatewayProblem.GATEWAY_MESSAGE");
            }
            case INTERNAL_MESSAGE: {
                return param;
            }
            case LIMIT_REACHED: {
                return l10n.getString("GatewayProblem.LIMIT_REACHED");
            }
            case LONG_TEXT: {
                return l10n.getString("GatewayProblem.LONG_TEXT");
            }
            case NO_CREDIT: {
                return l10n.getString("GatewayProblem.NO_CREDIT");
            }
            case NO_REASON: {
                return l10n.getString("GatewayProblem.NO_REASON");
            }
            case SIGNATURE_NEEDED: {
                return MessageFormat.format(l10n.getString("GatewayProblem.SIGNATURE_NEEDED"), "esmska://config-gateways");
            }
            case UNKNOWN: {
                return l10n.getString("GatewayProblem.UNKNOWN");
            }
            case UNUSABLE: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.UNUSABLE"), website);
            }
            case WRONG_AUTH: {
                assert (login != null);
                assert (password != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_AUTH"), login, password.replaceAll(".", "*"));
            }
            case WRONG_CODE: {
                return l10n.getString("GatewayProblem.WRONG_CODE");
            }
            case WRONG_NUMBER: {
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_NUMBER"), sms.getNumber());
            }
            case WRONG_SIGNATURE: {
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_SIGNATURE"), sms.getSenderNumber(), sms.getSenderName());
            }
        }
        throw new IllegalStateException("Uknown problem type: " + (Object)((Object)problem));
    }

    public String getThirdPartyDescription(SMS sms) {
        Validate.notNull(sms.getProblem());
        GatewayExecutor.Problem problem = sms.getProblem().get1();
        String param = sms.getProblem().get2();
        switch (problem) {
            case CUSTOM_MESSAGE: 
            case GATEWAY_MESSAGE: {
                return param;
            }
        }
        return null;
    }

    public String getHelp(SMS sms) {
        Validate.notNull(sms.getProblem());
        GatewayExecutor.Problem problem = sms.getProblem().get1();
        String param = sms.getProblem().get2();
        Gateway gw = gateways.get(sms.getGateway());
        String website = gw != null ? gw.getWebsite() : null;
        switch (problem) {
            case CUSTOM_MESSAGE: {
                return l10n.getString("GatewayProblem.CUSTOM_MESSAGE.help");
            }
            case FIX_IN_PROGRESS: 
            case UNUSABLE: {
                assert (param != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.FIX_IN_PROGRESS.help"), param);
            }
            case GATEWAY_MESSAGE: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.GATEWAY_MESSAGE.help"), website);
            }
            case INTERNAL_MESSAGE: {
                return param;
            }
            case LIMIT_REACHED: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.LIMIT_REACHED.help"), website);
            }
            case LONG_TEXT: {
                return l10n.getString("GatewayProblem.LONG_TEXT.help");
            }
            case NO_CREDIT: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.NO_CREDIT.help"), website);
            }
            case NO_REASON: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.NO_REASON.help"), website);
            }
            case SIGNATURE_NEEDED: {
                return null;
            }
            case UNKNOWN: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.UNKNOWN.help"), website, "http://code.google.com/p/esmska/wiki/Issues");
            }
            case WRONG_AUTH: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_AUTH.help"), website, "esmska://config-gateways");
            }
            case WRONG_CODE: {
                return null;
            }
            case WRONG_NUMBER: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_NUMBER.help"), website);
            }
            case WRONG_SIGNATURE: {
                assert (website != null);
                return MessageFormat.format(l10n.getString("GatewayProblem.WRONG_SIGNATURE.help"), "esmska://config-gateways", website);
            }
        }
        throw new IllegalStateException("Uknown problem type: " + (Object)((Object)problem));
    }

    private boolean showRetryButton(SMS sms) {
        Validate.notNull(sms.getProblem());
        GatewayExecutor.Problem problem = sms.getProblem().get1();
        switch (problem) {
            case CUSTOM_MESSAGE: 
            case GATEWAY_MESSAGE: 
            case INTERNAL_MESSAGE: 
            case LIMIT_REACHED: 
            case NO_REASON: 
            case UNKNOWN: 
            case WRONG_CODE: {
                return true;
            }
        }
        return false;
    }

    public GatewayErrorMessage() {
        this.initComponents();
        if (!config.getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.smsTextArea);
            ClipboardPopupMenu.register(this.thirdPartyTextPane);
        }
    }

    public GatewayMessageFrame.TaskPane showErrorMsg(SMS sms) {
        Validate.notNull(sms);
        String description = this.getDescription(sms);
        String thirdPartyDescription = this.getThirdPartyDescription(sms);
        String help = this.getHelp(sms);
        String recipient = this.extractRecipient(sms);
        String title = MessageFormat.format(l10n.getString("GatewayErrorMessage.smsFailed"), recipient);
        ImageIcon icon = Icons.STATUS_WARNING;
        this.descriptionLabel.setText("<html>" + description + "</html>");
        if (StringUtils.isEmpty(thirdPartyDescription)) {
            this.thirdPartyScrollPane.setVisible(false);
        } else {
            this.thirdPartyScrollPane.setVisible(true);
            this.thirdPartyTextPane.setText("<html>" + thirdPartyDescription + "</html>");
        }
        this.helpTextLabel.setText("<html>" + help + "</html>");
        this.helpLabel.setVisible(StringUtils.isNotEmpty(help));
        this.smsTextArea.setText(sms.getText());
        this.retryButton.setVisible(this.showRetryButton(sms));
        return this.wrapAsTaskPane(this, title, icon);
    }

    @Override
    public void setBestFocus() {
        this.okButton.requestFocusInWindow();
    }

    @Override
    public void cancel() {
        this.okButton.doClick(0);
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.smsTextScrollPane = new JScrollPane();
        this.smsTextArea = new JTextArea();
        this.smsTextLabel = new JLabel();
        this.descriptionLabel = new JHtmlLabel();
        this.thirdPartyScrollPane = new JScrollPane();
        this.thirdPartyTextPane = new JTextPane();
        this.helpTextLabel = new JHtmlLabel();
        this.helpLabel = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 1), new Dimension(0, 1), new Dimension(0, 1));
        this.filler2 = new Box.Filler(new Dimension(0, 1), new Dimension(0, 1), new Dimension(0, 1));
        this.retryButton = new JButton();
        Mnemonics.setLocalizedText(this.okButton, l10n.getString("OK_"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GatewayErrorMessage.this.okButtonActionPerformed(evt);
            }
        });
        this.smsTextScrollPane.setVisible(false);
        this.smsTextArea.setColumns(20);
        this.smsTextArea.setLineWrap(true);
        this.smsTextArea.setRows(5);
        this.smsTextArea.setWrapStyleWord(true);
        this.smsTextScrollPane.setViewportView(this.smsTextArea);
        this.smsTextLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/expand-off-12.png")));
        Mnemonics.setLocalizedText(this.smsTextLabel, l10n.getString("GatewayErrorMessage.smsTextLabel.text"));
        this.smsTextLabel.setCursor(new Cursor(12));
        this.smsTextLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GatewayErrorMessage.this.smsTextLabelMouseClicked(evt);
            }
        });
        Mnemonics.setLocalizedText(this.descriptionLabel, "<<Failure description>>\t");
        this.descriptionLabel.setVerticalAlignment(1);
        this.thirdPartyTextPane.setContentType("text/html; charset=UTF-8");
        this.thirdPartyTextPane.setEditable(false);
        this.thirdPartyTextPane.setFocusable(false);
        this.thirdPartyScrollPane.setViewportView(this.thirdPartyTextPane);
        Mnemonics.setLocalizedText(this.helpTextLabel, "<<Help>>");
        this.helpTextLabel.setVisible(false);
        this.helpLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/expand-off-12.png")));
        Mnemonics.setLocalizedText(this.helpLabel, l10n.getString("GatewayErrorMessage.helpLabel.text"));
        this.helpLabel.setCursor(new Cursor(12));
        this.helpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GatewayErrorMessage.this.helpLabelMouseClicked(evt);
            }
        });
        Mnemonics.setLocalizedText(this.retryButton, l10n.getString("GatewayErrorMessage.retryButton.text"));
        this.retryButton.setToolTipText(l10n.getString("GatewayErrorMessage.retryButton.toolTipText"));
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GatewayErrorMessage.this.retryButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 238, Short.MAX_VALUE).addComponent(this.filler1, -1, 238, Short.MAX_VALUE).addComponent(this.smsTextScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.retryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addComponent(this.smsTextLabel, GroupLayout.Alignment.LEADING).addComponent(this.helpTextLabel, GroupLayout.Alignment.LEADING, -1, 238, Short.MAX_VALUE).addComponent(this.helpLabel, GroupLayout.Alignment.LEADING).addComponent(this.filler2, GroupLayout.Alignment.LEADING, -1, 238, Short.MAX_VALUE).addComponent(this.thirdPartyScrollPane, -1, 238, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.thirdPartyScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpTextLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smsTextLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smsTextScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.retryButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.actionSupport.fireActionPerformed(0, null);
    }

    private void smsTextLabelMouseClicked(MouseEvent evt) {
        this.smsTextScrollPane.setVisible(!this.smsTextScrollPane.isVisible());
        if (this.smsTextScrollPane.isVisible()) {
            this.smsTextLabel.setIcon(Icons.get("expand-on-12.png"));
        } else {
            this.smsTextLabel.setIcon(Icons.get("expand-off-12.png"));
        }
        this.revalidate();
    }

    private void helpLabelMouseClicked(MouseEvent evt) {
        this.helpTextLabel.setVisible(!this.helpTextLabel.isVisible());
        if (this.helpTextLabel.isVisible()) {
            this.helpLabel.setIcon(Icons.get("expand-on-12.png"));
        } else {
            this.helpLabel.setIcon(Icons.get("expand-off-12.png"));
        }
        this.revalidate();
    }

    private void retryButtonActionPerformed(ActionEvent evt) {
        Queue.getInstance().setPaused(false);
        this.actionSupport.fireActionPerformed(0, null);
    }
}

