/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import org.netbeans.api.io.Fold;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.Position;
import org.netbeans.spi.io.InputOutputProvider;

public abstract class OutputWriter
extends PrintWriter {
    private OutputWriter() {
        super(new DummyWriter());
    }

    public abstract Position getCurrentPosition();

    public abstract Fold startFold(boolean var1);

    public abstract void endFold(Fold var1);

    public abstract void print(String var1, Hyperlink var2, OutputColor var3);

    public abstract void print(String var1, Hyperlink var2);

    public abstract void print(String var1, OutputColor var2);

    public abstract void println(String var1, Hyperlink var2, OutputColor var3);

    public abstract void println(String var1, Hyperlink var2);

    public abstract void println(String var1, OutputColor var2);

    static <IO, OW extends PrintWriter, P, F> OutputWriter create(InputOutputProvider<IO, OW, P, F> provider, IO io, OW writer) {
        return new Impl<IO, OW, P, F>(provider, io, writer);
    }

    private static class DummyWriter
    extends Writer {
        private DummyWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends OutputWriter {
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO io;
        private final OW writer;

        public Impl(InputOutputProvider<IO, OW, P, F> provider, IO io, OW writer) {
            this.provider = provider;
            this.io = io;
            this.writer = writer;
        }

        @Override
        public Position getCurrentPosition() {
            return Position.create(this.provider, this.io, this.writer, this.provider.getCurrentPosition(this.io, this.writer));
        }

        @Override
        public void print(String s, Hyperlink link, OutputColor color) {
            this.provider.print(this.io, this.writer, s, link, color, false);
        }

        @Override
        public void print(String s, Hyperlink link) {
            this.provider.print(this.io, this.writer, s, link, null, false);
        }

        @Override
        public void print(String s, OutputColor color) {
            this.provider.print(this.io, this.writer, s, null, color, false);
        }

        @Override
        public void println(String s, Hyperlink link, OutputColor color) {
            this.provider.print(this.io, this.writer, s, link, color, true);
        }

        @Override
        public void println(String s, Hyperlink link) {
            this.provider.print(this.io, this.writer, s, link, null, true);
        }

        @Override
        public void println(String s, OutputColor color) {
            this.provider.print(this.io, this.writer, s, null, color, true);
        }

        @Override
        public void flush() {
            ((PrintWriter)this.writer).flush();
        }

        @Override
        public void close() {
            ((PrintWriter)this.writer).close();
        }

        @Override
        public boolean checkError() {
            return ((PrintWriter)this.writer).checkError();
        }

        @Override
        public void write(int c) {
            ((PrintWriter)this.writer).write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            ((PrintWriter)this.writer).write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            ((PrintWriter)this.writer).write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            ((PrintWriter)this.writer).write(s, off, len);
        }

        @Override
        public void write(String s) {
            ((PrintWriter)this.writer).write(s);
        }

        @Override
        public void print(boolean b) {
            ((PrintWriter)this.writer).print(b);
        }

        @Override
        public void print(char c) {
            ((PrintWriter)this.writer).print(c);
        }

        @Override
        public void print(int i) {
            ((PrintWriter)this.writer).print(i);
        }

        @Override
        public void print(long l) {
            ((PrintWriter)this.writer).print(l);
        }

        @Override
        public void print(float f) {
            ((PrintWriter)this.writer).print(f);
        }

        @Override
        public void print(double d) {
            ((PrintWriter)this.writer).print(d);
        }

        @Override
        public void print(char[] s) {
            ((PrintWriter)this.writer).print(s);
        }

        @Override
        public void print(String s) {
            ((PrintWriter)this.writer).print(s);
        }

        @Override
        public void print(Object obj) {
            ((PrintWriter)this.writer).print(obj);
        }

        @Override
        public void println() {
            ((PrintWriter)this.writer).println();
        }

        @Override
        public void println(boolean x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(char x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(int x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(long x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(float x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(double x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(char[] x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(String x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public void println(Object x) {
            ((PrintWriter)this.writer).println(x);
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            return ((PrintWriter)this.writer).printf(format, args);
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            return ((PrintWriter)this.writer).printf(l, format, args);
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            return ((PrintWriter)this.writer).format(format, args);
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            return ((PrintWriter)this.writer).format(l, format, args);
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            return ((PrintWriter)this.writer).append(csq);
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            return ((PrintWriter)this.writer).append(csq, start, end);
        }

        @Override
        public PrintWriter append(char c) {
            return ((PrintWriter)this.writer).append(c);
        }

        @Override
        public Fold startFold(boolean expanded) {
            F fold = this.provider.startFold(this.io, this.writer, expanded);
            return Fold.create(this.provider, this.io, this.writer, fold);
        }

        @Override
        public void endFold(Fold fold) {
            if (fold != Fold.UNSUPPORTED) {
                fold.endFold();
            }
        }
    }
}

