/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.google.protobuf.GeneratedMessage;
import com.mysql.cj.api.result.RowList;
import com.mysql.cj.api.x.core.ResultCtor;
import com.mysql.cj.api.x.io.ColToFieldTransformer;
import com.mysql.cj.api.x.io.MessageListener;
import com.mysql.cj.api.xdevapi.SqlResult;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.x.io.ResultCreatingResultListener;
import com.mysql.cj.x.io.ResultMessageListener;
import com.mysql.cj.x.io.StatementExecuteOkMessageListener;
import com.mysql.cj.x.protobuf.Mysqlx;
import com.mysql.cj.x.protobuf.MysqlxResultset;
import com.mysql.cj.xdevapi.SqlDataResult;
import com.mysql.cj.xdevapi.SqlUpdateResult;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class SqlResultMessageListener
implements MessageListener {
    private ResultType resultType;
    private CompletableFuture<SqlResult> resultF;
    private StatementExecuteOkMessageListener okListener;
    private ResultMessageListener resultListener;
    private ResultCreatingResultListener<SqlResult> resultCreator;

    public SqlResultMessageListener(CompletableFuture<SqlResult> resultF, ColToFieldTransformer colToField, TimeZone defaultTimeZone) {
        this.resultF = resultF;
        ResultCtor resultCtor = metadata -> (rows, task) -> new SqlDataResult((ArrayList<Field>)metadata, defaultTimeZone, (RowList)rows, (Supplier<StatementExecuteOk>)task);
        this.resultCreator = new ResultCreatingResultListener<SqlResult>(resultCtor, resultF);
        this.resultListener = new ResultMessageListener(colToField, this.resultCreator);
        CompletableFuture<StatementExecuteOk> okF = new CompletableFuture<StatementExecuteOk>();
        okF.whenComplete((ok, ex) -> {
            if (ex != null) {
                this.resultF.completeExceptionally((Throwable)ex);
            } else {
                this.resultF.complete(new SqlUpdateResult((StatementExecuteOk)ok));
            }
        });
        this.okListener = new StatementExecuteOkMessageListener(okF);
    }

    @Override
    public Boolean apply(Class<? extends GeneratedMessage> msgClass, GeneratedMessage msg) {
        if (this.resultType == null) {
            if (MysqlxResultset.ColumnMetaData.class.equals(msgClass)) {
                this.resultType = ResultType.DATA;
            } else if (!Mysqlx.Error.class.equals(msgClass)) {
                this.resultType = ResultType.UPDATE;
            }
        }
        if (this.resultType == ResultType.DATA) {
            return this.resultListener.apply(msgClass, msg);
        }
        return this.okListener.apply(msgClass, msg);
    }

    @Override
    public void closed() {
        this.resultF.completeExceptionally(new CJCommunicationsException("Sock was closed"));
    }

    @Override
    public void error(Throwable ex) {
        this.resultF.completeExceptionally(ex);
    }

    private static enum ResultType {
        UPDATE,
        DATA;

    }
}

