/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.DefaultMessageContext;
import io.micronaut.context.exceptions.NoSuchMessageException;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@Indexed(value=MessageSource.class)
public interface MessageSource {
    public static final MessageSource EMPTY = new MessageSource(){

        @Override
        @Nonnull
        public Optional<String> getMessage(@Nonnull String code, @Nonnull MessageContext context) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public String interpolate(@Nonnull String template, @Nonnull MessageContext context) {
            return template;
        }
    };

    @Nonnull
    public Optional<String> getMessage(@Nonnull String var1, @Nonnull MessageContext var2);

    @Nonnull
    default public String getMessage(@Nonnull String code, @Nonnull MessageContext context, @Nonnull String defaultMessage) {
        ArgumentUtils.requireNonNull((String)"defaultMessage", (Object)defaultMessage);
        return this.getMessage(code, context).orElse(defaultMessage);
    }

    @Nonnull
    public String interpolate(@Nonnull String var1, @Nonnull MessageContext var2);

    @Nonnull
    default public String getRequiredMessage(@Nonnull String code, @Nonnull MessageContext context) {
        return this.getMessage(code, context).orElseThrow(() -> new NoSuchMessageException(code));
    }

    public static interface MessageContext {
        public static final MessageContext DEFAULT = new MessageContext(){};

        @Nonnull
        default public Locale getLocale() {
            return Locale.getDefault();
        }

        @Nonnull
        default public Map<String, Object> getVariables() {
            return Collections.emptyMap();
        }

        @Nonnull
        public static MessageContext of(@Nullable Locale locale) {
            return new DefaultMessageContext(locale, null);
        }

        @Nonnull
        public static MessageContext of(@Nullable Map<String, Object> variables) {
            return new DefaultMessageContext(null, variables);
        }

        @Nonnull
        public static MessageContext of(@Nullable Locale locale, @Nullable Map<String, Object> variables) {
            return new DefaultMessageContext(locale, variables);
        }
    }
}

