/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.InputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SegmentBuffer;

public class BufferInsertRequest
extends BufferIORequest {
    public BufferInsertRequest(View view, Buffer buffer, Object object, VFS vFS, String string) {
        super(view, buffer, object, vFS, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _run() {
        Object object;
        InputStream inputStream = null;
        try {
            Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
            this.setStatus(jEdit.getProperty("vfs.status.load", objectArray));
            this.setCancellable(true);
            this.path = this.vfs._canonPath(this.session, this.path, this.view);
            object = this.vfs._getFile(this.session, this.path, this.view);
            long l = object != null ? ((VFSFile)object).getLength() : 0L;
            inputStream = this.vfs._createInputStream(this.session, this.path, false, this.view);
            if (inputStream == null) {
                IOUtilities.closeQuietly(inputStream);
                this.endSessionQuietly();
                return;
            }
            final SegmentBuffer segmentBuffer = this.read(this.autodetect(inputStream), l, true);
            AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

                @Override
                public void run() {
                    BufferInsertRequest.this.view.getTextArea().setSelectedText(segmentBuffer.toString());
                }
            });
            IOUtilities.closeQuietly(inputStream);
        }
        catch (InterruptedException interruptedException) {
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            Thread.currentThread().interrupt();
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                object = new String[]{exception.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", (Object[])object);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
        }
        finally {
            IOUtilities.closeQuietly(inputStream);
            this.endSessionQuietly();
        }
        this.endSessionQuietly();
        return;
    }
}

