/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;

public class JEditSwingTrayIcon
extends JEditTrayIcon {
    private boolean restore;
    private String userDir;
    private String[] args;

    public JEditSwingTrayIcon() {
        super(GUIUtilities.getEditorIcon(), "jEdit");
        this.setImageAutoSize(true);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("tray.newView.label"));
        JMenuItem jMenuItem2 = new JMenuItem(jEdit.getProperty("tray.newPlainView.label"));
        JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("tray.exit.label"));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        jMenuItem.addActionListener(actionEvent -> jEdit.newView(null));
        jMenuItem2.addActionListener(actionEvent -> jEdit.newView(null, null, true));
        jMenuItem3.addActionListener(actionEvent -> jEdit.exit(null, true));
        this.setMenu(jPopupMenu);
        this.addMouseListener(new MyMouseAdapter());
    }

    @EditBus.EBHandler
    public void handleMessage(EditPaneUpdate editPaneUpdate) {
        if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            ArrayList arrayList = new ArrayList();
            jEdit.getViewManager().forEach(view -> arrayList.add(view.getTitle()));
            this.setToolTip(String.join((CharSequence)" | ", arrayList));
        }
    }

    @Override
    void setTrayIconArgs(boolean bl, String string, String[] stringArray) {
        this.restore = bl;
        this.userDir = string;
        this.args = stringArray;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final Map<Window, Boolean> windowState = new HashMap<Window, Boolean>();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (jEdit.getViewCount() == 0) {
                EditServer.handleClient(JEditSwingTrayIcon.this.restore, true, false, JEditSwingTrayIcon.this.userDir, JEditSwingTrayIcon.this.args);
            } else {
                boolean bl;
                boolean bl2 = bl = !jEdit.getActiveView().isVisible();
                if (bl) {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        Boolean bl3 = this.windowState.get(window);
                        if (bl3 == null) {
                            window.setVisible(true);
                            continue;
                        }
                        if (!bl3.booleanValue()) continue;
                        window.setVisible(bl3);
                    }
                    this.windowState.clear();
                    if (jEdit.getActiveView().getState() == 1) {
                        jEdit.getActiveView().setState(0);
                    }
                    jEdit.getActiveView().toFront();
                } else {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        this.windowState.put(window, window.isVisible());
                        window.setVisible(false);
                    }
                }
            }
        }

        private boolean skipWindow(Window window) {
            return window.getClass().getName().contains("Tray");
        }
    }
}

