/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.statusbar.HoverSetStatusMouseHandler;
import org.gjt.sp.jedit.jEdit;
import org.jedit.keymap.Keymap;

public class EnhancedMenuItem
extends JMenuItem {
    static Font acceleratorFont = GUIUtilities.menuAcceleratorFont();
    static Color acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
    static Color acceleratorSelectionForeground;
    @Nullable
    private String shortcut;

    public EnhancedMenuItem(String string, String string2, ActionContext actionContext) {
        this.shortcut = GUIUtilities.getShortcutLabel(string2, true);
        String string3 = jEdit.getProperty(string2 + ".tooltip");
        if (string3 != null) {
            this.setToolTipText(string3);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(string + " ( " + this.shortcut + " )");
            } else {
                this.setText(string);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String string4 = keymap.getShortcut(string2 + ".shortcut");
                KeyStroke keyStroke = KeyEventTranslator.parseKeyStroke(string4);
                if (keyStroke != null) {
                    this.setAccelerator(keyStroke);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(string);
        }
        if (string2 != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(actionContext, string2));
            this.addMouseListener(new HoverSetStatusMouseHandler(string2));
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.shortcut != null) {
            FontMetrics fontMetrics = this.getFontMetrics(acceleratorFont);
            dimension.width += fontMetrics.stringWidth(this.shortcut) + fontMetrics.stringWidth("AAAA");
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.shortcut != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setFont(acceleratorFont);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets();
            graphics.drawString(this.shortcut, this.getWidth() - (fontMetrics.stringWidth(this.shortcut) + insets.right + insets.left + 5), fontMetrics.getAscent() + insets.top);
        }
    }

    static {
        if (acceleratorForeground == null) {
            acceleratorForeground = Color.black;
        }
        if ((acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground")) == null) {
            acceleratorSelectionForeground = Color.black;
        }
    }
}

