/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    @NotNull
    public static Disposable newDisposable() {
        return Disposer.newDisposable(null);
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
    }

    public static void register(@NotNull Disposable parent2, @NotNull Disposable child) {
        if (parent2 == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(1);
        }
        ourTree.register(parent2, child);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(8);
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(10);
        }
        ourTree.executeAll(disposable, processUnregistered, false);
    }

    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(11);
        }
        return objectTree;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo(disposable), Throwable.class);
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

