/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.JavaPsiRecordUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordAugmentProvider
extends PsiAugmentProvider
implements DumbAware {
    @Override
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            RecordAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiExtensibleClass) {
            PsiExtensibleClass aClass2 = (PsiExtensibleClass)element;
            if (!aClass2.isRecord()) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    RecordAugmentProvider.$$$reportNull$$$0(2);
                }
                return list2;
            }
            if (type2 == PsiMethod.class) {
                return RecordAugmentProvider.getAccessorsAugments(element, aClass2);
            }
            if (type2 == PsiField.class) {
                return RecordAugmentProvider.getFieldAugments(element, aClass2);
            }
        }
        List list3 = Collections.emptyList();
        if (list3 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getAccessorsAugments(@NotNull PsiElement element, PsiExtensibleClass aClass2) {
        PsiRecordHeader header;
        if (element == null) {
            RecordAugmentProvider.$$$reportNull$$$0(4);
        }
        if ((header = aClass2.getRecordHeader()) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                RecordAugmentProvider.$$$reportNull$$$0(5);
            }
            return list2;
        }
        PsiRecordComponent[] components = aClass2.getRecordComponents();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
        ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>(components.length);
        List<PsiMethod> ownMethods2 = aClass2.getOwnMethods();
        for (PsiRecordComponent component : components) {
            PsiMethod recordMethod;
            if (!RecordAugmentProvider.shouldGenerateMethod(component, ownMethods2) || (recordMethod = RecordAugmentProvider.createRecordMethod(component, factory2)) == null) continue;
            LightRecordMethod method = new LightRecordMethod(element.getManager(), recordMethod, (PsiClass)aClass2, component);
            methods2.add(method);
        }
        PsiMethod constructor2 = RecordAugmentProvider.getCanonicalConstructor(aClass2, ownMethods2, header);
        if (constructor2 != null) {
            methods2.add(constructor2);
        }
        ArrayList<PsiMethod> arrayList = methods2;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static PsiMethod getCanonicalConstructor(PsiExtensibleClass aClass2, List<PsiMethod> ownMethods2, @NotNull PsiRecordHeader recordHeader) {
        String className2;
        if (recordHeader == null) {
            RecordAugmentProvider.$$$reportNull$$$0(7);
        }
        if ((className2 = aClass2.getName()) == null) {
            return null;
        }
        for (PsiMethod method : ownMethods2) {
            if (!JavaPsiRecordUtil.isCompactConstructor(method) && !JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) continue;
            return null;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(recordHeader.getProject());
        String sb = "public " + className2 + recordHeader.getText() + "{}";
        PsiMethod nonPhysical = factory2.createMethodFromText(sb, recordHeader.getContainingClass());
        return new LightRecordCanonicalConstructor(nonPhysical, aClass2);
    }

    private static boolean shouldGenerateMethod(PsiRecordComponent component, List<PsiMethod> ownMethods2) {
        String componentName = component.getName();
        if (componentName == null) {
            return false;
        }
        for (PsiMethod method : ownMethods2) {
            if (!componentName.equals(method.getName()) || !method.getParameterList().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getFieldAugments(@NotNull PsiElement element, PsiClass aClass2) {
        if (element == null) {
            RecordAugmentProvider.$$$reportNull$$$0(8);
        }
        PsiRecordComponent[] components = aClass2.getRecordComponents();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
        ArrayList<LightRecordField> fields2 = new ArrayList<LightRecordField>(components.length);
        for (PsiRecordComponent component : components) {
            PsiField recordField = RecordAugmentProvider.createRecordField(component, factory2);
            if (recordField == null) continue;
            LightRecordField field = new LightRecordField(element.getManager(), recordField, aClass2, component);
            fields2.add(field);
        }
        ArrayList<LightRecordField> arrayList = fields2;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static PsiField createRecordField(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory2) {
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(10);
        }
        if (factory2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(11);
        }
        String name = component.getName();
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        return factory2.createFieldFromText("private final " + typeText + " " + name + ";", component.getContainingClass());
    }

    @Nullable
    private static PsiMethod createRecordMethod(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory2) {
        String name;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(12);
        }
        if (factory2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(13);
        }
        if ((name = component.getName()) == null) {
            return null;
        }
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        return factory2.createMethodFromText("public " + typeText + " " + name + "(){ return " + name + "; }", component.getContainingClass());
    }

    private static boolean hasForbiddenType(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(14);
        }
        return (typeElement = component.getTypeElement()) == null || typeElement.getText().equals("record");
    }

    @Nullable
    private static String getTypeText(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(15);
        }
        if ((typeElement = component.getTypeElement()) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (PsiElement child : typeElement.getChildren()) {
            if (child.getNode().getElementType() != JavaTokenType.ELLIPSIS) {
                sb.append(child.getText());
                continue;
            }
            sb.append("[]");
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHeader";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorsAugments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldAugments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorsAugments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAugments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRecordField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRecordMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasForbiddenType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

