/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceParameterListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    @NonNls
    private static final Pattern EXTENDS_PREFIX = Pattern.compile("^(\\?\\s*extends\\s*)(.*)");
    @NonNls
    private static final Pattern SUPER_PREFIX = Pattern.compile("^(\\?\\s*super\\s*)(.*)");
    private final PsiElement myParent;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes;

    public ClsReferenceParameterListImpl(PsiElement parent2, String[] classParameters) {
        this.myParent = parent2;
        int length = classParameters.length;
        this.myTypeParameters = new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParameters[length - i - 1];
            char variance = '\u0000';
            Matcher extendsMatcher = EXTENDS_PREFIX.matcher(s);
            if (extendsMatcher.find()) {
                variance = '+';
                s = extendsMatcher.group(2);
            } else {
                Matcher superMatcher = SUPER_PREFIX.matcher(s);
                if (superMatcher.find()) {
                    variance = '-';
                    s = superMatcher.group(2);
                } else if (StringUtil.startsWithChar(s, '?')) {
                    variance = '*';
                    s = s.substring(1);
                }
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(1);
        }
    }

    @Override
    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        if (this.myTypeParameters == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(2);
        }
        return this.myTypeParameters;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = PsiType.createArray(this.myTypeParameters.length);
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(3);
        }
        return cachedTypes;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        if (this.myTypeParameters == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(4);
        }
        return this.myTypeParameters;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

