/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmOptimizationLowering;
import org.jetbrains.kotlin.codegen.intrinsics.Not;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "backend.jvm"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    private final JvmBackendContext context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        if (!Intrinsics.areEqual($this$isObjectEquals.getName().asString(), "equals")) return false;
        Collection collection = $this$isObjectEquals.getValueParameters();
        boolean bl = false;
        if (collection.size() != 1) return false;
        if (!IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType())) return false;
        if ($this$isObjectEquals.getExtensionReceiverParameter() != null) return false;
        if ($this$isObjectEquals.getDispatchReceiverParameter() == null) return false;
        return true;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair<IrExpression, IrExpression> pair;
        if (Intrinsics.areEqual(call2.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            Intrinsics.checkNotNull(irExpression2);
            IrExpression right = irExpression2;
            pair = TuplesKt.to(left, right);
        } else if (this.isObjectEquals((IrFunction)call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression3);
            IrExpression right = irExpression3;
            pair = TuplesKt.to(left, right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformer<IrClass> transformer2 = new IrElementTransformer<IrClass>(this){
            final /* synthetic */ JvmOptimizationLowering this$0;

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                declaration2.transformChildren(this, declaration2);
                return declaration2;
            }

            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                boolean codeMightBeGeneratedInDifferentClass = AdditionalIrUtilsKt.isSuspend(declaration2) || declaration2.isInline() || Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE);
                IrClass irClass2 = data;
                boolean bl = false;
                boolean bl2 = false;
                IrClass irClass3 = irClass2;
                IrElementTransformer irElementTransformer = this;
                IrFunction irFunction2 = declaration2;
                boolean bl3 = false;
                boolean bl4 = codeMightBeGeneratedInDifferentClass;
                irFunction2.transformChildren(irElementTransformer, !bl4 ? irClass2 : null);
                return declaration2;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                expression2.transformChildren(this, data);
                this.removeIntTypeSafeCastsForEquality(expression2);
                if (Intrinsics.areEqual(((IrSimpleFunction)expression2.getSymbol().getOwner()).getOrigin(), IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) {
                    if (data == null) {
                        return expression2;
                    }
                    B b = expression2.getSymbol().getOwner();
                    if (!(b instanceof IrSimpleFunction)) {
                        b = null;
                    }
                    IrSimpleFunction irSimpleFunction = (IrSimpleFunction)b;
                    if (irSimpleFunction == null) {
                        return expression2;
                    }
                    IrSimpleFunction simpleFunction = irSimpleFunction;
                    Object object = simpleFunction.getCorrespondingPropertySymbol();
                    if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                        return expression2;
                    }
                    Object property2 = object;
                    if (((IrProperty)property2).isLateinit()) {
                        return expression2;
                    }
                    return this.optimizePropertyAccess(expression2, simpleFunction, (IrProperty)property2, data);
                }
                if (JvmOptimizationLowering.Companion.isNegation(expression2, this.this$0.getContext())) {
                    IrExpression irExpression = expression2.getDispatchReceiver();
                    Intrinsics.checkNotNull(irExpression);
                    if (JvmOptimizationLowering.Companion.isNegation(irExpression, this.this$0.getContext())) {
                        IrExpression irExpression2 = expression2.getDispatchReceiver();
                        if (irExpression2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                        }
                        IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                        Intrinsics.checkNotNull(irExpression3);
                        return irExpression3;
                    }
                }
                Pair pair = JvmOptimizationLowering.access$getOperandsIfCallToEQEQOrEquals(this.this$0, expression2);
                if (pair != null) {
                    void left;
                    Pair pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair $dstr$left$right = pair2;
                    boolean bl3 = false;
                    IrExpression irExpression = (IrExpression)$dstr$left$right.component1();
                    IrExpression right = (IrExpression)$dstr$left$right.component2();
                    return IrUtilsKt.isNullConst((IrExpression)left) && IrUtilsKt.isNullConst(right) ? (IrExpression)IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType()) : (IrUtilsKt.isNullConst((IrExpression)left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst ? (IrExpression)IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType()) : (IrExpression)expression2);
                }
                return expression2;
            }

            private final boolean isByteOrShort(IrType $this$isByteOrShort) {
                return IrTypePredicatesKt.isByte($this$isByteOrShort) || IrTypePredicatesKt.isShort($this$isByteOrShort);
            }

            /*
             * WARNING - void declaration
             */
            private final void removeIntTypeSafeCastsForEquality(IrCall expression2) {
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.EQEQ.INSTANCE) || Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.EXCLEQ.INSTANCE)) {
                    int n = 0;
                    int n2 = expression2.getValueArgumentsCount();
                    while (n < n2) {
                        void i;
                        IrExpression irExpression = expression2.getValueArgument((int)i);
                        Intrinsics.checkNotNull(irExpression);
                        if (IrTypePredicatesKt.isInt(IrTypesKt.makeNotNull(irExpression.getType()))) {
                            IrBranch secondBranch;
                            IrStatement whenExpression;
                            IrStatement variable2;
                            IrExpression argument;
                            Intrinsics.checkNotNull(expression2.getValueArgument((int)i));
                            if (argument instanceof IrBlock && Intrinsics.areEqual(((IrBlock)argument).getOrigin(), IrStatementOrigin.SAFE_CALL.INSTANCE) && ((IrBlock)argument).getStatements().size() == 2 && (variable2 = ((IrBlock)argument).getStatements().get(0)) instanceof IrVariable && this.isByteOrShort(IrTypesKt.makeNotNull(((IrVariable)variable2).getType())) && (whenExpression = ((IrBlock)argument).getStatements().get(1)) instanceof IrWhen && ((IrWhen)whenExpression).getBranches().size() == 2 && (secondBranch = ((IrWhen)whenExpression).getBranches().get(1)) instanceof IrElseBranch && secondBranch.getResult() instanceof IrCall) {
                                IrExpression irExpression2 = secondBranch.getResult();
                                if (irExpression2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                                }
                                IrCall conversion = (IrCall)irExpression2;
                                if (Intrinsics.areEqual(((IrSimpleFunction)conversion.getSymbol().getOwner()).getName().asString(), "toInt") && conversion.getDispatchReceiver() instanceof IrGetValue) {
                                    IrExpression irExpression3 = conversion.getDispatchReceiver();
                                    if (irExpression3 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
                                    }
                                    if (Intrinsics.areEqual(((IrGetValue)irExpression3).getSymbol().getOwner(), variable2)) {
                                        expression2.putValueArgument((int)i, ((IrVariable)variable2).getInitializer());
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final IrExpression optimizePropertyAccess(IrCall expression2, IrSimpleFunction accessor, IrProperty property2, IrClass currentClass) {
                if (Intrinsics.areEqual(IrUtilsKt.getParentAsClass(accessor), currentClass)) {
                    IrField irField = property2.getBackingField();
                    if (Intrinsics.areEqual(irField != null ? IrUtilsKt.getParentAsClass(irField) : null, currentClass) && accessor.getModality() == Modality.FINAL && !accessor.isExternal()) {
                        void startOffset$iv$iv;
                        void $this$irBlock$iv$iv;
                        IrField irField2 = property2.getBackingField();
                        Intrinsics.checkNotNull(irField2);
                        IrField backingField2 = irField2;
                        IrExpression receiver = expression2.getDispatchReceiver();
                        IrGeneratorWithScope $this$irBlock$iv = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = ((IrExpression)expression2).getType();
                        boolean $i$f$irBlock = false;
                        IrGeneratorWithScope irGeneratorWithScope = $this$irBlock$iv;
                        int n = ((IrExpression)expression2).getStartOffset();
                        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
                        boolean $i$f$irBlock2 = false;
                        IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
                        boolean bl = false;
                        if (backingField2.isStatic() && receiver != null) {
                            $this$irBlock.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$irBlock.getContext().getIrBuiltIns()));
                        }
                        if (accessor.getValueParameters().size() > 0) {
                            IrExpression irExpression = receiver;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            IrExpression irExpression2 = irExpression;
                            IrBuilderWithScope irBuilderWithScope = $this$irBlock;
                            IrBlockBuilder irBlockBuilder = $this$irBlock;
                            boolean bl4 = false;
                            boolean bl5 = backingField2.isStatic();
                            IrExpression irExpression3 = !bl5 ? irExpression : null;
                            IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
                            Intrinsics.checkNotNull(irExpression4);
                            irBlockBuilder.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression3, backingField2, irExpression4));
                        } else {
                            IrExpression irExpression = receiver;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            IrExpression it = irExpression;
                            IrBuilderWithScope irBuilderWithScope = $this$irBlock;
                            IrBlockBuilder irBlockBuilder = $this$irBlock;
                            boolean bl8 = false;
                            boolean bl9 = backingField2.isStatic();
                            irBlockBuilder.unaryPlus(ExpressionHelpersKt.irGetField(irBuilderWithScope, !bl9 ? irExpression : null, backingField2));
                        }
                        return this_$iv$iv$iv.doBuild();
                    }
                }
                return expression2;
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrClass data) {
                IrElementBase irElementBase;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                boolean isCompilerGenerated = expression2.getOrigin() == null;
                expression2.transformChildren(this, data);
                expression2.getBranches().removeIf(new Predicate<IrBranch>(isCompilerGenerated){
                    final /* synthetic */ boolean $isCompilerGenerated;

                    public final boolean test(@NotNull IrBranch it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return IrUtilsKt.isFalseConst(it.getCondition()) && this.$isCompilerGenerated;
                    }
                    {
                        this.$isCompilerGenerated = bl;
                    }
                });
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.ANDAND.INSTANCE)) {
                    boolean bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-JvmOptimizationLowering$lower$transformer$1$visitWhen$32 = false;
                        String $i$a$-assert-JvmOptimizationLowering$lower$transformer$1$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. " + "Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$lower$transformer$1$visitWhen$32));
                    }
                    IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), this.this$0.getContext().getIrBuiltIns().getAndandSymbol(), null, null, 48, null);
                    bl2 = false;
                    boolean $i$a$-assert-JvmOptimizationLowering$lower$transformer$1$visitWhen$32 = false;
                    IrCallImpl $this$apply = irCallImpl;
                    boolean bl3 = false;
                    $this$apply.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                    $this$apply.putValueArgument(1, expression2.getBranches().get(0).getResult());
                    return irCallImpl;
                }
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.OROR.INSTANCE)) {
                    boolean bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                    boolean bl4 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl5 = false;
                        String string2 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. " + "Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), this.this$0.getContext().getIrBuiltIns().getOrorSymbol(), null, null, 48, null);
                    bl4 = false;
                    boolean bl6 = false;
                    IrCallImpl $this$apply = irCallImpl;
                    boolean bl7 = false;
                    $this$apply.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                    $this$apply.putValueArgument(1, expression2.getBranches().get(1).getResult());
                    return irCallImpl;
                }
                if (expression2.getBranches().size() == 0) {
                    irElementBase = new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
                } else {
                    IrBranch irBranch = CollectionsKt.first(expression2.getBranches());
                    boolean bl = false;
                    boolean bl8 = false;
                    IrBranch it = irBranch;
                    boolean bl9 = false;
                    irElementBase = IrUtilsKt.isTrueConst(it.getCondition()) && isCompilerGenerated ? irBranch : null;
                    if (irElementBase == null || (irElementBase = ((IrBranch)irElementBase).getResult()) == null) {
                        irElementBase = expression2;
                    }
                }
                return irElementBase;
            }

            private final boolean isImmutableTemporaryVariableWithConstantValue(IrStatement statement2) {
                return statement2 instanceof IrVariable && Intrinsics.areEqual(((IrVariable)statement2).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && !((IrVariable)statement2).isVar() && ((IrVariable)statement2).getInitializer() instanceof IrConst;
            }

            private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements2) {
                block2: {
                    statements2.removeIf(new Predicate<IrStatement>(this){
                        final /* synthetic */ lower.transformer.1 this$0;

                        public final boolean test(@NotNull IrStatement it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return lower.transformer.1.access$isImmutableTemporaryVariableWithConstantValue(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    if (statements2.size() != 2) break block2;
                    IrStatement first = statements2.get(0);
                    IrStatement second = statements2.get(1);
                    if (first instanceof IrVariable && Intrinsics.areEqual(((IrVariable)first).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && second instanceof IrGetValue && Intrinsics.areEqual((IrVariableSymbol)((IrVariable)first).getSymbol(), ((IrGetValue)second).getSymbol())) {
                        statements2.clear();
                        IrExpression irExpression = ((IrVariable)first).getInitializer();
                        if (irExpression != null) {
                            IrExpression irExpression2 = irExpression;
                            boolean bl = false;
                            boolean bl2 = false;
                            IrExpression it = irExpression2;
                            boolean bl3 = false;
                            statements2.add(it);
                        }
                    }
                }
            }

            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(body2, "body");
                body2.transformChildren(this, data);
                this.removeUnnecessaryTemporaryVariables(body2.getStatements());
                return body2;
            }

            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                expression2.transformChildren(this, data);
                this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
                return expression2;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrClass data) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
                if (this.isImmutableTemporaryVariableWithConstantValue(variable2)) {
                    IrValueDeclaration irValueDeclaration = variable2;
                    if (irValueDeclaration == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    }
                    IrExpression irExpression2 = ((IrVariable)irValueDeclaration).getInitializer();
                    Intrinsics.checkNotNull(irExpression2);
                    if (irExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                    }
                    irExpression = ((IrConst)irExpression2).copy();
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }
            {
                this.this$0 = this$0;
            }

            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
            }

            @NotNull
            public IrBody visitBody(@NotNull IrBody body2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(body2, "body");
                return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
            }

            @NotNull
            public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(branch, "branch");
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
            }

            @NotNull
            public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(jump, "jump");
                return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
            }

            @NotNull
            public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(jump, "jump");
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            @NotNull
            public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            @NotNull
            public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(aCatch, "aCatch");
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
            }

            @NotNull
            public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
            }

            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            @NotNull
            public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(jump, "jump");
                return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            @NotNull
            public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(loop2, "loop");
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            @NotNull
            public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            @NotNull
            public IrElement visitElement(@NotNull IrElement element, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(element, "element");
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
            }

            @NotNull
            public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(branch, "branch");
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
            }

            @NotNull
            public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            @NotNull
            public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
            }

            @NotNull
            public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(body2, "body");
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            @NotNull
            public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            @NotNull
            public IrStatement visitField(@NotNull IrField declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            @NotNull
            public IrFile visitFile(@NotNull IrFile declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
            }

            @NotNull
            public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            @NotNull
            public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            @NotNull
            public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            @NotNull
            public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(loop2, "loop");
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
            }

            @NotNull
            public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            @NotNull
            public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            @NotNull
            public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
            }

            @NotNull
            public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
            }

            @NotNull
            public IrStatement visitScript(@NotNull IrScript declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
            }

            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            @NotNull
            public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(spread, "spread");
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(body2, "body");
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            @NotNull
            public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
            }

            @NotNull
            public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(aTry, "aTry");
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
            }

            @NotNull
            public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            @NotNull
            public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            @NotNull
            public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
            }

            @NotNull
            public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrClass data) {
                Intrinsics.checkNotNullParameter(loop2, "loop");
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
            }

            public static final /* synthetic */ boolean access$isImmutableTemporaryVariableWithConstantValue(lower.transformer.1 $this, IrStatement statement2) {
                return $this.isImmutableTemporaryVariableWithConstantValue(statement2);
            }
        };
        irFile.transformChildren((IrElementTransformer)transformer2, null);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    public static final /* synthetic */ Pair access$getOperandsIfCallToEQEQOrEquals(JvmOptimizationLowering $this, IrCall call2) {
        return $this.getOperandsIfCallToEQEQOrEquals(call2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm"})
    public static final class Companion {
        public final boolean isNegation(@NotNull IrExpression expression2, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            return expression2 instanceof IrCall && context2.getState().getIntrinsics().getIntrinsic((CallableMemberDescriptor)((IrCall)expression2).getSymbol().getDescriptor()) instanceof Not;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

