/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "()V", "compare", "", "a", "b", "TypeAndNameComparator", "tree"})
public final class FirMemberDeclarationComparator
implements Comparator<FirMemberDeclaration> {
    @NotNull
    public static final FirMemberDeclarationComparator INSTANCE;

    @Override
    public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (a instanceof FirCallableMemberDeclaration && b instanceof FirCallableMemberDeclaration) {
            return FirCallableMemberDeclarationComparator.INSTANCE.compare((FirCallableMemberDeclaration)a, (FirCallableMemberDeclaration)b);
        }
        int typeAndNameDiff = TypeAndNameComparator.INSTANCE.compare(a, b);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        FirMemberDeclaration firMemberDeclaration = a;
        if (firMemberDeclaration instanceof FirClass) {
            boolean bl = b instanceof FirClass;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            String string3 = FirDeclarationUtilKt.getClassId((FirClass)((Object)a)).getPackageFqName().asString();
            String string4 = FirDeclarationUtilKt.getClassId((FirClass)((Object)b)).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "b.classId.packageFqName.asString()");
            return string3.compareTo(string4);
        }
        if (firMemberDeclaration instanceof FirTypeAlias) {
            boolean bl = b instanceof FirTypeAlias;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string5 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            return FirTypeRefComparator.INSTANCE.compare(((FirTypeAlias)a).getExpandedTypeRef(), ((FirTypeAlias)b).getExpandedTypeRef());
        }
        String string6 = "Unsupported member declaration comparison: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string6.toString());
    }

    private FirMemberDeclarationComparator() {
    }

    static {
        FirMemberDeclarationComparator firMemberDeclarationComparator;
        INSTANCE = firMemberDeclarationComparator = new FirMemberDeclarationComparator();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclarationComparator$TypeAndNameComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "()V", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Lorg/jetbrains/kotlin/name/Name;", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)I", "compare", "a", "b", "tree"})
    public static final class TypeAndNameComparator
    implements Comparator<FirMemberDeclaration> {
        @NotNull
        public static final TypeAndNameComparator INSTANCE;

        private final int getPriority(FirMemberDeclaration $this$priority) {
            FirMemberDeclaration firMemberDeclaration = $this$priority;
            return firMemberDeclaration instanceof FirEnumEntry ? 7 : (firMemberDeclaration instanceof FirConstructor ? 6 : (firMemberDeclaration instanceof FirProperty ? 5 : (firMemberDeclaration instanceof FirField ? 4 : (firMemberDeclaration instanceof FirFunction ? 3 : (firMemberDeclaration instanceof FirClass ? 2 : (firMemberDeclaration instanceof FirTypeAlias ? 1 : 0))))));
        }

        private final Name getName(FirMemberDeclaration $this$name) {
            Name name;
            FirMemberDeclaration firMemberDeclaration = $this$name;
            if (firMemberDeclaration instanceof FirCallableMemberDeclaration) {
                name = ((FirCallableMemberDeclaration)$this$name).getSymbol().getCallableId().getCallableName();
            } else if (firMemberDeclaration instanceof FirClass) {
                Name name2 = FirDeclarationUtilKt.getClassId((FirClass)((Object)$this$name)).getShortClassName();
                name = name2;
                Intrinsics.checkNotNullExpressionValue(name2, "this.classId.shortClassName");
            } else if (firMemberDeclaration instanceof FirTypeAlias) {
                name = ((FirTypeAlias)$this$name).getName();
            } else {
                String string2 = "Unsupported name retrieval for " + FirRendererKt.render$default($this$name, null, 1, null);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return name;
        }

        @Override
        public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            int priorityDiff = this.getPriority(a) - this.getPriority(b);
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            if (a instanceof FirEnumEntry) {
                boolean bl = b instanceof FirEnumEntry;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string2 = "priority is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                return 0;
            }
            return this.getName(a).compareTo(this.getName(b));
        }

        private TypeAndNameComparator() {
        }

        static {
            TypeAndNameComparator typeAndNameComparator;
            INSTANCE = typeAndNameComparator = new TypeAndNameComparator();
        }
    }
}

