/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Streams;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerGrpc;
import org.languagetool.rules.ml.MLServerProto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GRPCRule
extends RemoteRule {
    private static final Logger logger = LoggerFactory.getLogger(GRPCRule.class);
    private static final LoadingCache<RemoteRuleConfig, Connection> servers = CacheBuilder.newBuilder().build(CacheLoader.from(serviceConfiguration -> {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("No configuration for connection given");
        }
        try {
            return new Connection((RemoteRuleConfig)serviceConfiguration);
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }));
    private final Connection conn;

    public static String cleanID(String id) {
        return id.replaceAll("[^a-zA-Z_]", "_").toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GRPCRule(ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging) {
        super(messages, config, inputLogging);
        LoadingCache<RemoteRuleConfig, Connection> loadingCache = servers;
        synchronized (loadingCache) {
            Connection conn = null;
            try {
                conn = (Connection)servers.get((Object)this.serviceConfiguration);
            }
            catch (Exception e) {
                logger.error("Could not connect to remote service at " + this.serviceConfiguration, (Throwable)e);
            }
            this.conn = conn;
        }
    }

    @Override
    protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences, AnnotatedText annotatedText) {
        List<String> text = sentences.stream().map(AnalyzedSentence::getText).collect(Collectors.toList());
        MLServerProto.MatchRequest req = MLServerProto.MatchRequest.newBuilder().addAllSentences(text).setInputLogging(this.inputLogging).build();
        return new MLRuleRequest(req, sentences);
    }

    @Override
    protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest request) {
        return () -> {
            MLRuleRequest req = (MLRuleRequest)request;
            MLServerProto.MatchResponse response = this.conn.stub.match(req.request);
            List<RuleMatch> matches = Streams.zip(response.getSentenceMatchesList().stream(), req.sentences.stream(), (matchList, sentence) -> matchList.getMatchesList().stream().map(match -> {
                GRPCSubRule subRule = new GRPCSubRule(match.getSubId(), match.getRuleDescription());
                String message = match.getMatchDescription();
                String shortMessage = match.getMatchShortDescription();
                if (message == null || message.isEmpty()) {
                    message = this.getMessage((MLServerProto.Match)match, (AnalyzedSentence)sentence);
                }
                if (message == null || message.isEmpty()) {
                    throw new RuntimeException("Missing message for match with ID " + subRule.getId());
                }
                int start = match.getOffset();
                int end = start + match.getLength();
                RuleMatch m = new RuleMatch(subRule, (AnalyzedSentence)sentence, start, end, message, shortMessage);
                m.setSuggestedReplacements((List<String>)match.getSuggestionsList());
                return m;
            })).flatMap(Function.identity()).collect(Collectors.toList());
            RemoteRuleResult result = new RemoteRuleResult(true, true, matches);
            return result;
        };
    }

    protected abstract String getMessage(MLServerProto.Match var1, AnalyzedSentence var2);

    @Override
    protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
        return new RemoteRuleResult(false, false, Collections.emptyList());
    }

    public static GRPCRule create(ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging, String id, final String descriptionKey, final Map<String, String> messagesByID) {
        return new GRPCRule(messages, config, inputLogging){

            @Override
            protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
                return this.messages.getString((String)messagesByID.get(match.getSubId()));
            }

            @Override
            public String getDescription() {
                return this.messages.getString(descriptionKey);
            }
        };
    }

    public static GRPCRule create(RemoteRuleConfig config, boolean inputLogging, String id, final String description, final Map<String, String> messagesByID) {
        return new GRPCRule(JLanguageTool.getMessageBundle(), config, inputLogging){

            @Override
            protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
                return (String)messagesByID.get(match.getSubId());
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static List<GRPCRule> createAll(List<RemoteRuleConfig> configs, boolean inputLogging, String defaultDescription) {
        return configs.stream().filter(cfg -> cfg.getRuleId().startsWith("AI_")).map(cfg -> GRPCRule.create(cfg, inputLogging, cfg.getRuleId(), defaultDescription, Collections.emptyMap())).collect(Collectors.toList());
    }

    static {
        shutdownRoutines.add(() -> servers.asMap().values().forEach(rec$ -> ((Connection)rec$).shutdown()));
    }

    protected class MLRuleRequest
    extends RemoteRule.RemoteRequest {
        final MLServerProto.MatchRequest request;
        final List<AnalyzedSentence> sentences;

        public MLRuleRequest(MLServerProto.MatchRequest request, List<AnalyzedSentence> sentences) {
            this.request = request;
            this.sentences = sentences;
        }
    }

    static class Connection {
        final ManagedChannel channel;
        final MLServerGrpc.MLServerBlockingStub stub;

        private ManagedChannel getChannel(String host, int port, boolean useSSL, @Nullable String clientPrivateKey, @Nullable String clientCertificate, @Nullable String rootCertificate) throws SSLException {
            NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
            if (useSSL) {
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (rootCertificate != null) {
                    sslContextBuilder.trustManager(new File(rootCertificate));
                }
                if (clientCertificate != null && clientPrivateKey != null) {
                    sslContextBuilder.keyManager(new File(clientCertificate), new File(clientPrivateKey));
                }
                channelBuilder = channelBuilder.negotiationType(NegotiationType.TLS).sslContext(sslContextBuilder.build());
            } else {
                channelBuilder = channelBuilder.usePlaintext();
            }
            return channelBuilder.build();
        }

        Connection(RemoteRuleConfig serviceConfiguration) throws SSLException {
            String host = serviceConfiguration.getUrl();
            int port = serviceConfiguration.getPort();
            boolean ssl = Boolean.parseBoolean(serviceConfiguration.getOptions().getOrDefault("secure", "false"));
            String key = serviceConfiguration.getOptions().get("clientKey");
            String cert = serviceConfiguration.getOptions().get("clientCertificate");
            String ca = serviceConfiguration.getOptions().get("rootCertificate");
            this.channel = this.getChannel(host, port, ssl, key, cert, ca);
            this.stub = MLServerGrpc.newBlockingStub((Channel)this.channel);
        }

        private void shutdown() {
            if (this.channel != null) {
                this.channel.shutdownNow();
            }
        }
    }

    protected class GRPCSubRule
    extends Rule {
        private final String subId;
        private final String matchId;
        private final String description;

        GRPCSubRule(@Nullable String subId, String description) {
            this.subId = subId;
            this.matchId = GRPCRule.this.getId() + "_" + GRPCRule.cleanID(subId);
            if (description == null || description.isEmpty()) {
                this.description = GRPCRule.this.getDescription();
                if (this.description == null || this.description.isEmpty()) {
                    throw new RuntimeException("Missing description for rule with ID " + this.matchId);
                }
            } else {
                this.description = description;
            }
        }

        @Override
        public String getId() {
            return this.matchId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

