/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.util.Accountable;

public class UndeadNormsProducer
extends NormsProducer {
    public static final String LEGACY_UNDEAD_NORMS_KEY = UndeadNormsProducer.class.getSimpleName() + ".undeadnorms";
    public static final NormsProducer INSTANCE = new UndeadNormsProducer();

    private UndeadNormsProducer() {
    }

    public static boolean isUndeadArmy(FieldInfos fieldInfos) {
        boolean everythingIsUndead = true;
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.hasNorms()) continue;
            String isUndead = fieldInfo.getAttribute(LEGACY_UNDEAD_NORMS_KEY);
            if (isUndead != null) {
                assert ("true".equals(isUndead));
                continue;
            }
            everythingIsUndead = false;
        }
        return everythingIsUndead;
    }

    public static boolean isUndead(FieldInfo fieldInfo) {
        String isUndead = fieldInfo.getAttribute(LEGACY_UNDEAD_NORMS_KEY);
        if (isUndead != null) {
            assert ("true".equals(isUndead));
            return true;
        }
        return false;
    }

    public static void setUndead(Map<String, String> attributes) {
        attributes.put(LEGACY_UNDEAD_NORMS_KEY, "true");
    }

    public NumericDocValues getNorms(FieldInfo field) throws IOException {
        return DocValues.emptyNumeric();
    }

    public void close() {
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public void checkIntegrity() throws IOException {
    }

    public NormsProducer getMergeInstance() throws IOException {
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

