/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class PartialGradientLineBorder
extends AbstractBorder
implements PartialSide {
    private int _sides = 15;
    private Color[] _colors;
    protected int _thickness;

    public PartialGradientLineBorder(Color[] colorArray) {
        this(colorArray, 1);
    }

    public PartialGradientLineBorder(Color[] colorArray, int n) {
        this(colorArray, n, 15);
    }

    public PartialGradientLineBorder(Color[] colorArray, int n, int n2) {
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("Array \"colors\" should have at least 2 elements.");
        }
        this._colors = colorArray;
        this._thickness = n;
        this._sides = n2;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int n) {
        this._sides = n;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = 0;
        if ((this._sides & 1) != 0) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(n, n2, n3, this._thickness), this._colors[n5++], this._colors[n5++], false);
        }
        if ((this._sides & 2) != 0) {
            if (n5 >= this._colors.length) {
                n5 -= 2;
            }
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(n, n2 + n4 - this._thickness, n3, this._thickness), this._colors[n5++], this._colors[n5++], false);
        }
        if ((this._sides & 8) != 0) {
            if (n5 >= this._colors.length) {
                n5 -= 2;
            }
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(n, n2, this._thickness, n4), this._colors[n5++], this._colors[n5++], true);
        }
        if ((this._sides & 4) != 0) {
            if (n5 >= this._colors.length) {
                n5 -= 2;
            }
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(n + n3 - this._thickness, n2, this._thickness, n4), this._colors[n5++], this._colors[n5], true);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = super.getBorderInsets(component);
        if ((this._sides & 1) == 0) {
            insets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets.right = 0;
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = super.getBorderInsets(component, insets);
        if ((this._sides & 1) == 0) {
            insets2.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets2.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets2.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets2.right = 0;
        }
        return insets2;
    }
}

