/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.FieldColumnInfo;
import com.zaxxer.sansorm.internal.Introspected;
import com.zaxxer.sansorm.internal.Introspector;
import com.zaxxer.sansorm.internal.OrmBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrmReader
extends OrmBase {
    private static final int CACHE_SIZE = Integer.getInteger("com.zaxxer.sansorm.statementCacheSize", 500);
    private static final Map<String, String> fromClauseStmtCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(CACHE_SIZE){
        private static final long serialVersionUID = 6259942586093454872L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > CACHE_SIZE;
        }
    });

    public static <T> List<T> statementToList(PreparedStatement stmt, Class<T> clazz, Object ... args2) throws SQLException {
        try (PreparedStatement closeStmt = stmt;){
            List<T> list = OrmReader.resultSetToList(OrmReader.statementToResultSet(stmt, args2), clazz);
            return list;
        }
    }

    public static ResultSet statementToResultSet(PreparedStatement stmt, Object ... args2) throws SQLException {
        OrmReader.populateStatementParameters(stmt, args2);
        return stmt.executeQuery();
    }

    public static <T> List<T> resultSetToList(ResultSet resultSet, Class<T> targetClass) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        if (!resultSet.next()) {
            resultSet.close();
            return list;
        }
        Introspected introspected = Introspector.getIntrospected(targetClass);
        boolean hasJoinColumns = introspected.hasSelfJoinColumn();
        HashMap<T, Object> deferredSelfJoinFkMap = hasJoinColumns ? new HashMap<T, Object>() : null;
        HashMap<Object, T> idToTargetMap = hasJoinColumns ? new HashMap<Object, T>() : null;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int column = columnCount; column > 0; --column) {
            columnNames[column - 1] = metaData.getColumnName(column).toLowerCase();
        }
        try {
            ResultSet closeRS = resultSet;
            Object object = null;
            try {
                do {
                    T t = targetClass.newInstance();
                    list.add(t);
                    for (int column = columnCount; column > 0; --column) {
                        Object columnValue = resultSet.getObject(column);
                        if (columnValue == null) continue;
                        String columnName = columnNames[column - 1];
                        FieldColumnInfo fcInfo = introspected.getFieldColumnInfo(columnName);
                        if (fcInfo.isSelfJoinField()) {
                            deferredSelfJoinFkMap.put(t, columnValue);
                            continue;
                        }
                        introspected.set(t, fcInfo, columnValue);
                    }
                    if (!hasJoinColumns) continue;
                    idToTargetMap.put(introspected.getActualIds(t)[0], t);
                } while (resultSet.next());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeRS != null) {
                    if (object != null) {
                        try {
                            closeRS.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        closeRS.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            if (hasJoinColumns) {
                FieldColumnInfo idColumn = introspected.getSelfJoinColumnInfo();
                for (Map.Entry entry : deferredSelfJoinFkMap.entrySet()) {
                    Object value = idToTargetMap.get(entry.getValue());
                    if (value == null) continue;
                    introspected.set(entry.getKey(), idColumn, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    private static <T> T statementToObject(PreparedStatement stmt, T target, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T statementToObject(PreparedStatement stmt, Class<T> clazz, Object ... args2) throws SQLException {
        T target;
        try {
            target = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return OrmReader.statementToObject(stmt, target, args2);
    }

    public static <T> T resultSetToObject(ResultSet resultSet, T target) throws SQLException {
        Set<String> ignoreNone = Collections.emptySet();
        return OrmReader.resultSetToObject(resultSet, target, ignoreNone);
    }

    public static <T> T resultSetToObject(ResultSet resultSet, T target, Set<String> ignoredColumns) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Introspected introspected = Introspector.getIntrospected(target.getClass());
        for (int column = metaData.getColumnCount(); column > 0; --column) {
            Object columnValue;
            String columnName = metaData.getColumnName(column);
            if (OrmReader.isIgnoredColumn(ignoredColumns, columnName) || (columnValue = resultSet.getObject(column)) == null) continue;
            introspected.set(target, introspected.getFieldColumnInfo(columnName), columnValue);
        }
        return target;
    }

    public static <T> T objectById(Connection connection, Class<T> clazz, Object ... args2) throws SQLException {
        String where = OrmReader.getWhereIdClause(Introspector.getIntrospected(clazz));
        return OrmReader.objectFromClause(connection, clazz, where, args2);
    }

    public static <T> T refresh(Connection connection, T target) throws SQLException {
        Introspected introspected = Introspector.getIntrospected(target.getClass());
        String where = OrmReader.getWhereIdClause(introspected);
        String sql = OrmReader.generateSelectFromClause(target.getClass(), where);
        PreparedStatement stmt = connection.prepareStatement(sql);
        return OrmReader.statementToObject(stmt, target, introspected.getActualIds(target));
    }

    private static String getWhereIdClause(Introspected introspected) {
        String[] idColumnNames;
        StringBuilder where = new StringBuilder();
        for (String column : idColumnNames = introspected.getIdColumnNames()) {
            where.append(column).append("=? AND ");
        }
        if (where.length() > 0) {
            where.setLength(where.length() - 5);
        }
        return where.toString();
    }

    public static <T> List<T> listFromClause(Connection connection, Class<T> clazz, String clause, Object ... args2) throws SQLException {
        String sql = OrmReader.generateSelectFromClause(clazz, clause);
        PreparedStatement stmt = connection.prepareStatement(sql);
        return OrmReader.statementToList(stmt, clazz, args2);
    }

    public static <T> T objectFromClause(Connection connection, Class<T> clazz, String clause, Object ... args2) throws SQLException {
        String sql = OrmReader.generateSelectFromClause(clazz, clause);
        PreparedStatement stmt = connection.prepareStatement(sql);
        return OrmReader.statementToObject(stmt, clazz, args2);
    }

    public static <T> int countObjectsFromClause(Connection connection, Class<T> clazz, String clause, Object ... args2) throws SQLException {
        Introspected introspected = Introspector.getIntrospected(clazz);
        String tableName = introspected.getTableName();
        String[] idColumnNames = introspected.getIdColumnNames();
        StringBuilder sql = new StringBuilder().append("SELECT COUNT(").append(tableName).append('.').append(idColumnNames.length > 0 ? idColumnNames[0] : introspected.getColumnNames()[0]).append(")").append(" FROM ").append(tableName).append(' ').append(tableName);
        if (clause != null && !clause.isEmpty()) {
            String upper = clause.toUpperCase();
            if (!(upper.contains("WHERE") || upper.contains("JOIN") || upper.startsWith("ORDER"))) {
                sql.append(" WHERE ");
            }
            sql.append(' ').append(clause);
        }
        return OrmReader.numberFromSql(connection, sql.toString(), args2).intValue();
    }

    /*
     * Exception decompiling
     */
    public static Number numberFromSql(Connection connection, String sql, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> String generateSelectFromClause(Class<T> clazz, String clause) {
        String cacheKey = clazz.getName() + clause;
        return fromClauseStmtCache.computeIfAbsent(cacheKey, key -> {
            Introspected introspected = Introspector.getIntrospected(clazz);
            String tableName = introspected.getTableName();
            StringBuilder sqlSB = new StringBuilder().append("SELECT ").append(OrmReader.getColumnsCsv(clazz, tableName)).append(" FROM ").append(tableName).append(' ').append(tableName);
            if (clause != null && !clause.isEmpty()) {
                String upper = clause.toUpperCase();
                if (!upper.contains("WHERE") && !upper.contains("JOIN")) {
                    sqlSB.append(" WHERE ");
                }
                sqlSB.append(' ').append(clause);
            }
            return sqlSB.toString();
        });
    }
}

