/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import mediathek.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log {
    public static final String LINE = "################################################################################";
    public static final Instant startZeit = Instant.now();
    private static final String FEHLER = "Fehler(MediathekView): ";
    private static final ArrayList<String> logList = new ArrayList();
    private static final Logger logger = LogManager.getLogger();
    private static boolean progress;

    public static void printRuntimeStatistics() {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        ZoneId systemZone = ZoneId.systemDefault();
        Instant endZeit = Instant.now();
        long runtimeDuration = Duration.between(startZeit, endZeit).toSeconds();
        LocalTime str = LocalTime.MIN.plusSeconds(runtimeDuration);
        logger.info(LINE);
        logger.info("   --> Start: {}", (Object)formatter.format(LocalDateTime.ofInstant(startZeit, systemZone)));
        logger.info("   --> Ende: {}", (Object)formatter.format(LocalDateTime.ofInstant(endZeit, systemZone)));
        logger.info("   --> Laufzeit: {}h {}m {}s", (Object)str.getHour(), (Object)str.getMinute(), (Object)str.getSecond());
        logger.info(LINE);
    }

    @Deprecated
    public static synchronized void errorLog(int fehlerNummer, Exception ex) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[0]);
    }

    @Deprecated
    public static synchronized void errorLog(int fehlerNummer, Exception ex, String text) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[]{text});
    }

    @Deprecated
    public static synchronized void errorLog(int fehlerNummer, Exception ex, String[] text) {
        Log.fehlermeldung_(fehlerNummer, ex, text);
    }

    @Deprecated
    public static synchronized void errorLog(int fehlerNummer, String text) {
        Log.fehlermeldung_(fehlerNummer, null, new String[]{text});
    }

    @Deprecated
    public static synchronized void errorLog(int fehlerNummer, String[] text) {
        Log.fehlermeldung_(fehlerNummer, null, text);
    }

    public static synchronized void sysLog(String text) {
        Log.systemmeldung_(new String[]{text});
    }

    public static synchronized void progress(String texte) {
        progress = true;
        if (!texte.isEmpty()) {
            System.out.print(texte + "\r");
        }
    }

    private static void resetProgress() {
        if (progress) {
            System.out.print("                                                                                                             \r");
            progress = false;
        }
    }

    private static void fehlermeldung_(int fehlerNummer, Exception ex, String[] texte) {
        Object kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (((String)kl).contains(".") && !Character.isUpperCase(((String)kl).charAt(0))) {
                kl = ((String)kl).substring(((String)kl).indexOf(46) + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        if (ex != null || Config.isDebugModeEnabled()) {
            Log.resetProgress();
            String x = ex != null ? "!" : "=";
            String z = "*";
            logList.add(x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x);
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                if (ex != null) {
                    ex.printStackTrace(pw);
                }
                pw.flush();
                sw.flush();
                logList.add(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logList.add(z + " Fehlernr: " + fehlerNummer);
            if (ex != null) {
                logList.add(z + " Exception: " + ex.getMessage());
            }
            logList.add(z + " Fehler(MediathekView): " + (String)kl);
            for (String aTexte : texte) {
                logList.add(z + "           " + aTexte);
            }
            logList.add("");
            Log.printLog();
        }
    }

    private static void systemmeldung_(String[] texte) {
        Log.resetProgress();
        String z = ". ";
        if (texte.length <= 1) {
            logList.add(".  " + texte[0]);
        } else {
            String zeile = "---------------------------------------";
            logList.add(". " + zeile);
            for (String aTexte : texte) {
                String txt = "| " + aTexte;
                logList.add(". " + txt);
            }
            logList.add(". " + zeile);
        }
        Log.printLog();
    }

    private static void printLog() {
        logList.forEach(System.out::println);
        logList.clear();
    }
}

