/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.Frame;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import mediathek.config.Konstanten;
import mediathek.gui.dialog.StandardCloseDialog;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Version;
import mediathek.update.UpdateNotificationPanel;

public class UpdateNotificationDialog
extends StandardCloseDialog {
    private final Version version;
    private final UpdateNotificationPanel panel = new UpdateNotificationPanel();
    private WebView browser;
    private WebEngine webEngine;

    public UpdateNotificationDialog(Frame owner, String title, Version version) {
        super(owner, title, true);
        this.version = version;
        this.setupDialogInformation();
        this.setupFxWebView();
        this.pack();
        GuiFunktionen.centerOnScreen(this, false);
    }

    private void setupFxWebView() {
        Platform.runLater(() -> {
            this.browser = new WebView();
            Scene scene = new Scene(this.browser);
            this.webEngine = this.browser.getEngine();
            this.webEngine.load(Objects.requireNonNull(Konstanten.WEBSITE_BASE_URL.resolve("changelogs")).toString());
            this.panel.getFxPanel().setScene(scene);
        });
    }

    private void setupDialogInformation() {
        String label = "MediathekView " + this.version + " ist verf\u00fcgbar - Sie haben Version " + Konstanten.MVVERSION;
        this.panel.getReleaseInfoLabel().setText(label);
    }

    @Override
    public JComponent createContentPanel() {
        return this.panel;
    }
}

