/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.security.SFile;

public class SvekUtils {
    public static void traceString(SFile f, String text) throws IOException {
        try (PrintWriter pw = null;){
            Log.info("Creating intermediate file " + f.getPrintablePath());
            pw = f.createPrintWriter();
            pw.print(text);
        }
    }

    public static double getValue(String svg, int starting, String varName) {
        String varNameString = varName + "=\"";
        int p1 = svg.indexOf(varNameString, starting);
        if (p1 == -1) {
            throw new IllegalStateException();
        }
        int p2 = svg.indexOf(34, p1 += varNameString.length());
        return Double.parseDouble(svg.substring(p1, p2));
    }

    public static double getMaxX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x > result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    public static double getMinX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x < result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    public static Point2D.Double getMinXY(List<Point2D.Double> points) {
        return new Point2D.Double(SvekUtils.getMinX(points), SvekUtils.getMinY(points));
    }

    public static double getMaxY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y > result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    public static double getMinY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y < result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    public static void println(StringBuilder sb) {
        sb.append('\n');
    }

    public static String pixelToInches(double pixel) {
        double v = pixel / 72.0;
        return String.format(Locale.US, "%6.6f", v);
    }
}

