/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import net.sf.json.JSON;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.utils.JsonUtil;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiResponseElement
extends ApiResponse {
    public static final ApiResponseElement OK = new ApiResponseElement("Result", "OK");
    public static final ApiResponseElement FAIL = new ApiResponseElement("Result", "FAIL");
    private String value = null;
    private ApiResponse apiResponse;

    public ApiResponseElement(String name) {
        super(name);
    }

    public ApiResponseElement(String name, String value) {
        super(name);
        this.value = value;
    }

    public ApiResponseElement(ApiResponse value) {
        super(value.getName());
        this.apiResponse = value;
    }

    public ApiResponseElement(Node node, ApiResponse template) {
        super(node.getNodeName());
        this.value = node.getTextContent();
    }

    public ApiResponseElement(Node node) {
        super(node.getNodeName());
        this.value = node.getTextContent();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JSON toJSON() {
        JSONObject jo = new JSONObject();
        if (this.apiResponse == null) {
            jo.put((Object)this.getName(), this.value == null ? JSONNull.getInstance() : JsonUtil.getJsonFriendlyString(this.value));
        } else {
            jo.put((Object)this.getName(), (Object)this.apiResponse.toJSON().toString());
        }
        return jo;
    }

    @Override
    public void toXML(Document doc, Element parent) {
        if (this.apiResponse == null) {
            parent.appendChild(doc.createTextNode(this.getValue() != null ? XMLStringUtil.escapeControlChrs(this.getValue()) : ""));
        } else {
            this.apiResponse.toXML(doc, parent);
        }
    }

    @Override
    public void toHTML(StringBuilder sb) {
        if (this.apiResponse == null) {
            sb.append("<table border=\"1\">\n");
            sb.append("<tr><td>\n");
            sb.append(StringEscapeUtils.escapeHtml((String)this.getName()));
            sb.append("</td><td>\n");
            sb.append(StringEscapeUtils.escapeHtml((String)this.getValue()));
            sb.append("</td></tr>\n");
            sb.append("</table>\n");
        } else {
            this.apiResponse.toHTML(sb);
        }
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseElement ");
        sb.append(this.getName());
        sb.append(" = ");
        if (this.apiResponse == null) {
            sb.append(this.getValue());
        } else {
            sb.append(this.apiResponse.toString(indent + 1));
        }
        sb.append("\n");
        return sb.toString();
    }
}

