/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.Icons;
import esmska.gui.CountryPrefixPanel;
import esmska.utils.L10N;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.openide.awt.Mnemonics;

public class InitWizardDialog
extends JDialog {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Config config = Config.getInstance();
    private CountryPrefixPanel countryPrefixPanel;
    private JButton finishButton;
    private JLabel jLabel1;

    public InitWizardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setResizable(true);
        this.initComponents();
        this.finishButton.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.finishButton);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("esmska-16.png").getImage());
        images.add(Icons.get("esmska-32.png").getImage());
        images.add(Icons.get("esmska-64.png").getImage());
        images.add(Icons.get("esmska.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InitWizardDialog.this.finishButtonActionPerformed(e);
            }
        });
        this.setLocationRelativeTo(parent);
    }

    private void processCountryPrefix() {
        String prefix = this.countryPrefixPanel.getCountryPrefix();
        if (CountryPrefix.isValidCountryPrefix(prefix)) {
            config.setCountryPrefix(prefix);
        }
    }

    private void initComponents() {
        this.countryPrefixPanel = new CountryPrefixPanel();
        this.jLabel1 = new JLabel();
        this.finishButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setIconImage(null);
        Mnemonics.setLocalizedText(this.jLabel1, l10n.getString("InitWizardDialog.jLabel1.text"));
        this.finishButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/next-22.png")));
        Mnemonics.setLocalizedText(this.finishButton, l10n.getString("Finish_"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InitWizardDialog.this.finishButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.finishButton, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.countryPrefixPanel, -1, 403, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.countryPrefixPanel, -2, -1, -2).addGap(18, 46, Short.MAX_VALUE).addComponent(this.finishButton).addContainerGap()));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.processCountryPrefix();
        this.dispose();
    }
}

