/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.CloseTransactionMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DisbandUnitMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipForRoleMessage;
import net.sf.freecol.common.networking.GetNationSummaryMessage;
import net.sf.freecol.common.networking.GetTransactionMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LoadGoodsMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.RearrangeColonyMessage;
import net.sf.freecol.common.networking.ScoutSpeakToChiefMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.UnloadGoodsMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AIMessage {
    private static final Logger logger = Logger.getLogger(AIMessage.class.getName());

    private static Element ask(Connection conn, Element request) {
        Element reply;
        try {
            reply = conn.ask(request);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send \"" + request.getTagName() + "\"-message.", e);
            reply = null;
        }
        return reply;
    }

    private static boolean checkError(Element element, String tag) {
        if (element != null && "error".equals(element.getTagName())) {
            String messageId = element.getAttribute("messageID");
            String messageText = element.getAttribute("message");
            logger.warning("AIMessage." + tag + " error," + " messageId: " + messageId + " message: " + messageText);
            return true;
        }
        return false;
    }

    private static boolean askHandling(Connection conn, Element request) {
        Element reply;
        while (request != null && (reply = AIMessage.ask(conn, request)) != null) {
            if (AIMessage.checkError(reply, request.getTagName())) {
                return false;
            }
            try {
                request = conn.handle(reply);
            }
            catch (FreeColException fce) {
                logger.log(Level.WARNING, "AI handler failed: " + reply, fce);
                return false;
            }
        }
        return true;
    }

    private static Element askExpecting(Connection conn, Element request, String expect) {
        Element reply = AIMessage.ask(conn, request);
        if (AIMessage.checkError(reply, request.getTagName()) || reply == null) {
            return null;
        }
        String tag = reply.getTagName();
        if ("multiple".equals(tag)) {
            ArrayList<Element> replies = new ArrayList<Element>();
            NodeList nodes = reply.getChildNodes();
            Element result = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i) instanceof Element && ((Element)nodes.item(i)).getTagName().equals(expect)) {
                    result = (Element)nodes.item(i);
                    continue;
                }
                try {
                    Element e = conn.handle((Element)nodes.item(i));
                    if (e == null) continue;
                    replies.add(e);
                    continue;
                }
                catch (FreeColException fce) {
                    logger.log(Level.WARNING, "AI handler failed: " + reply, fce);
                }
            }
            if (!AIMessage.askHandling(conn, DOMMessage.collapseElements(replies)) || result == null) {
                return null;
            }
            reply = result;
        }
        if (expect.equals(reply.getTagName())) {
            return reply;
        }
        logger.log(Level.WARNING, "AI handler expected " + expect + ", recieved " + tag);
        return null;
    }

    private static boolean sendMessage(Connection connection, Element request) {
        return AIMessage.askHandling(connection, request);
    }

    private static boolean sendMessage(Connection connection, DOMMessage message) {
        return connection != null && message != null ? AIMessage.sendMessage(connection, message.toXMLElement()) : false;
    }

    public static boolean sendTrivial(Connection connection, String tag, String ... attributes) {
        return AIMessage.sendMessage(connection, AIMessage.makeTrivial(tag, attributes));
    }

    public static Element makeTrivial(String tag, String ... attributes) {
        if ((attributes.length & 1) == 1) {
            throw new IllegalArgumentException("Attributes list must have even length");
        }
        return DOMMessage.createMessage(tag, attributes);
    }

    public static boolean askAttack(AIUnit aiUnit, Direction direction) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new AttackMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askBuildColony(AIUnit aiUnit, String name) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new BuildColonyMessage(name, aiUnit.getUnit()));
    }

    public static boolean askCashInTreasureTrain(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new CashInTreasureTrainMessage(aiUnit.getUnit()));
    }

    public static boolean askChangeState(AIUnit aiUnit, Unit.UnitState state) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new ChangeStateMessage(aiUnit.getUnit(), state));
    }

    public static boolean askChangeWorkType(AIUnit aiUnit, GoodsType type) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new ChangeWorkTypeMessage(aiUnit.getUnit(), type));
    }

    public static boolean askChangeWorkImprovementType(AIUnit aiUnit, TileImprovementType type) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new ChangeWorkImprovementTypeMessage(aiUnit.getUnit(), type));
    }

    public static boolean askClaimLand(Tile tile, AIObject claimant, int price) {
        Player owner;
        GoodsLocation fcgo;
        if (claimant instanceof AIUnit) {
            fcgo = ((AIUnit)claimant).getUnit();
            owner = fcgo.getOwner();
        } else if (claimant instanceof AIColony) {
            fcgo = ((AIColony)claimant).getColony();
            owner = ((Colony)fcgo).getOwner();
        } else {
            throw new IllegalArgumentException("Claimant must be an AIUnit or AIColony: " + claimant.getId());
        }
        return AIMessage.sendMessage(claimant.getAIMain().getAIPlayer(owner).getConnection(), new ClaimLandMessage(tile, fcgo, price));
    }

    public static boolean askClearSpeciality(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new ClearSpecialityMessage(aiUnit.getUnit()));
    }

    public static boolean askCloseTransaction(AIUnit aiUnit, Settlement settlement) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new CloseTransactionMessage(aiUnit.getUnit(), settlement));
    }

    public static boolean askDeliverGift(AIUnit aiUnit, Settlement settlement, Goods goods) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new DeliverGiftMessage(aiUnit.getUnit(), settlement, goods));
    }

    public static boolean askDisband(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new DisbandUnitMessage(aiUnit.getUnit()));
    }

    public static boolean askDisembark(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new DisembarkMessage(aiUnit.getUnit()));
    }

    public static boolean askEmbark(AIUnit aiUnit, Unit unit, Direction direction) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new EmbarkMessage(unit, aiUnit.getUnit(), direction));
    }

    public static boolean askEmigrate(AIPlayer aiPlayer, int slot) {
        return AIMessage.sendMessage(aiPlayer.getConnection(), new EmigrateUnitMessage(slot));
    }

    public static boolean askEndTurn(AIPlayer aiPlayer) {
        return AIMessage.sendTrivial(aiPlayer.getConnection(), "endTurn", new String[0]);
    }

    public static boolean askEquipForRole(AIUnit aiUnit, Role role, int roleCount) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new EquipForRoleMessage(aiUnit.getUnit(), role, roleCount));
    }

    public static boolean askEstablishMission(AIUnit aiUnit, Direction direction, boolean denounce) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new MissionaryMessage(aiUnit.getUnit(), direction, denounce));
    }

    public static NationSummary askGetNationSummary(AIPlayer owner, Player player) {
        Element reply = AIMessage.askExpecting(owner.getConnection(), new GetNationSummaryMessage(player).toXMLElement(), GetNationSummaryMessage.getXMLElementTagName());
        return new GetNationSummaryMessage(reply).getNationSummary();
    }

    public static boolean askGetTransaction(AIUnit aiUnit, Settlement settlement) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new GetTransactionMessage(aiUnit.getUnit(), settlement));
    }

    public static boolean askIndianDemand(AIUnit aiUnit, Colony colony, GoodsType type, int amount) {
        Element reply = AIMessage.askExpecting(aiUnit.getAIOwner().getConnection(), new IndianDemandMessage(aiUnit.getUnit(), colony, type, amount).toXMLElement(), IndianDemandMessage.getXMLElementTagName());
        return new IndianDemandMessage(colony.getGame(), reply).getResult();
    }

    public static boolean askLoadGoods(Location loc, GoodsType type, int amount, AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new LoadGoodsMessage(loc, type, amount, aiUnit.getUnit()));
    }

    public static boolean askLoot(AIUnit aiUnit, String defenderId, List<Goods> goods) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new LootCargoMessage(aiUnit.getUnit(), defenderId, goods));
    }

    public static boolean askMove(AIUnit aiUnit, Direction direction) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new MoveMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askMoveTo(AIUnit aiUnit, Location destination) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new MoveToMessage(aiUnit.getUnit(), destination));
    }

    public static boolean askPutOutsideColony(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new PutOutsideColonyMessage(aiUnit.getUnit()));
    }

    public static boolean askRearrangeColony(AIColony aiColony, List<Unit> workers, Colony scratch) {
        Colony colony = aiColony.getColony();
        RearrangeColonyMessage message = new RearrangeColonyMessage(colony);
        for (Unit u : workers) {
            Unit su = scratch.getCorresponding(u);
            if (u.getLocation().getId().equals(su.getLocation().getId()) && u.getWorkType() == su.getWorkType() && u.getRole() == su.getRole() && u.getRoleCount() == su.getRoleCount()) continue;
            message.addChange(u, (Location)((Object)colony.getCorresponding((FreeColObject)((Object)su.getLocation()))), su.getWorkType(), su.getRole(), su.getRoleCount());
        }
        return message.isEmpty() ? false : AIMessage.sendMessage(aiColony.getAIOwner().getConnection(), message);
    }

    public static boolean askScoutSpeakToChief(AIUnit aiUnit, Direction direction) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new ScoutSpeakToChiefMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askSetBuildQueue(AIColony aiColony, List<BuildableType> queue) {
        return AIMessage.sendMessage(aiColony.getAIOwner().getConnection(), new SetBuildQueueMessage(aiColony.getColony(), queue));
    }

    public static boolean askTrainUnitInEurope(AIPlayer aiPlayer, UnitType type) {
        return AIMessage.sendMessage(aiPlayer.getConnection(), new TrainUnitInEuropeMessage(type));
    }

    public static boolean askUnloadGoods(GoodsType type, int amount, AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new UnloadGoodsMessage(type, amount, aiUnit.getUnit()));
    }

    public static boolean askWork(AIUnit aiUnit, WorkLocation workLocation) {
        return AIMessage.sendMessage(aiUnit.getAIOwner().getConnection(), new WorkMessage(aiUnit.getUnit(), workLocation));
    }
}

