/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001aH\u0014J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0002J\u001c\u0010%\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010$\u001a\u00020\u0019H\u0002J \u0010'\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030&2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030&H\u0004J(\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\t2\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0*H\u0014R'\u0010\u0007\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/AbstractFirOverrideScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "overrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;)V", "overrideByBase", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getOverrideByBase", "()Ljava/util/Map;", "getOverrideChecker", "()Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "createFunctionCopy", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirSimpleFunctionBuilder;", "firSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "newSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "createPropertyCopy", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "firProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "createValueParameterCopy", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilder;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "newDefaultValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isOverriddenFunction", "", "overrideCandidate", "baseDeclaration", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "similarFunctionsOrBothProperties", "getOverridden", "overrideCandidates", "", "resolve"})
public abstract class AbstractFirOverrideScope
extends FirTypeScope {
    private final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> overrideByBase;
    private final FirSession session;
    private final FirOverrideChecker overrideChecker;

    @NotNull
    public final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> getOverrideByBase() {
        return this.overrideByBase;
    }

    private final boolean isOverriddenFunction(FirSimpleFunction overrideCandidate, FirSimpleFunction baseDeclaration) {
        return this.overrideChecker.isOverriddenFunction(overrideCandidate, baseDeclaration);
    }

    private final boolean isOverriddenProperty(FirCallableMemberDeclaration<?> overrideCandidate, FirProperty baseDeclaration) {
        return this.overrideChecker.isOverriddenProperty(overrideCandidate, baseDeclaration);
    }

    protected final boolean similarFunctionsOrBothProperties(@NotNull FirCallableMemberDeclaration<?> overrideCandidate, @NotNull FirCallableMemberDeclaration<?> baseDeclaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(overrideCandidate, "overrideCandidate");
        Intrinsics.checkNotNullParameter(baseDeclaration, "baseDeclaration");
        FirCallableMemberDeclaration<?> firCallableMemberDeclaration = overrideCandidate;
        if (firCallableMemberDeclaration instanceof FirSimpleFunction) {
            FirCallableMemberDeclaration<?> firCallableMemberDeclaration2 = baseDeclaration;
            bl = firCallableMemberDeclaration2 instanceof FirSimpleFunction ? this.isOverriddenFunction((FirSimpleFunction)overrideCandidate, (FirSimpleFunction)baseDeclaration) : (firCallableMemberDeclaration2 instanceof FirProperty ? this.isOverriddenProperty(overrideCandidate, (FirProperty)baseDeclaration) : false);
        } else if (firCallableMemberDeclaration instanceof FirConstructor) {
            bl = false;
        } else if (firCallableMemberDeclaration instanceof FirProperty) {
            bl = baseDeclaration instanceof FirProperty && this.isOverriddenProperty(overrideCandidate, (FirProperty)baseDeclaration);
        } else if (firCallableMemberDeclaration instanceof FirField) {
            bl = baseDeclaration instanceof FirField;
        } else {
            String string2 = "Unknown fir callable type: " + overrideCandidate + ", " + baseDeclaration;
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return bl;
    }

    @Nullable
    protected FirCallableSymbol<?> getOverridden(@NotNull FirCallableSymbol<?> $this$getOverridden, @NotNull Set<? extends FirCallableSymbol<?>> overrideCandidates) {
        Object v4;
        block5: {
            Intrinsics.checkNotNullParameter($this$getOverridden, "$this$getOverridden");
            Intrinsics.checkNotNullParameter(overrideCandidates, "overrideCandidates");
            if (this.overrideByBase.containsKey($this$getOverridden)) {
                return this.overrideByBase.get($this$getOverridden);
            }
            Object e = ((AbstractFirBasedSymbol)$this$getOverridden).getFir();
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration<*>");
            }
            FirCallableMemberDeclaration baseDeclaration = (FirCallableMemberDeclaration)e;
            Iterable $this$firstOrNull$iv = overrideCandidates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                boolean bl = false;
                FirCallableSymbol firCallableSymbol = it;
                if (firCallableSymbol == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol<*>");
                }
                Object e2 = ((AbstractFirBasedSymbol)firCallableSymbol).getFir();
                if (e2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration<*>");
                }
                FirCallableMemberDeclaration overrideCandidate = (FirCallableMemberDeclaration)e2;
                FirMemberDeclaration $this$modality$iv = baseDeclaration;
                boolean $i$f$getModality = false;
                boolean bl2 = $this$modality$iv.getStatus().getModality() != Modality.FINAL && this.similarFunctionsOrBothProperties(overrideCandidate, baseDeclaration);
                if (!bl2) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        FirCallableSymbol override = v4;
        this.overrideByBase.put($this$getOverridden, override);
        return override;
    }

    @NotNull
    protected FirSimpleFunctionBuilder createFunctionCopy(@NotNull FirSimpleFunction firSimpleFunction, @NotNull FirNamedFunctionSymbol newSymbol) {
        Intrinsics.checkNotNullParameter(firSimpleFunction, "firSimpleFunction");
        Intrinsics.checkNotNullParameter(newSymbol, "newSymbol");
        FirSimpleFunctionBuilder firSimpleFunctionBuilder = new FirSimpleFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        FirSimpleFunctionBuilder $this$apply = firSimpleFunctionBuilder;
        boolean bl3 = false;
        $this$apply.setSource(firSimpleFunction.getSource());
        $this$apply.setSession(firSimpleFunction.getSession());
        $this$apply.setResolvePhase(firSimpleFunction.getResolvePhase());
        $this$apply.setOrigin(FirDeclarationOrigin.FakeOverride.INSTANCE);
        $this$apply.setReturnTypeRef(firSimpleFunction.getReturnTypeRef());
        $this$apply.setReceiverTypeRef(firSimpleFunction.getReceiverTypeRef());
        $this$apply.setName(firSimpleFunction.getName());
        $this$apply.setStatus(firSimpleFunction.getStatus());
        $this$apply.setSymbol(newSymbol);
        return firSimpleFunctionBuilder;
    }

    @NotNull
    protected FirValueParameterBuilder createValueParameterCopy(@NotNull FirValueParameter parameter, @Nullable FirExpression newDefaultValue) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
        boolean bl = false;
        boolean bl2 = false;
        FirValueParameterBuilder $this$apply = firValueParameterBuilder;
        boolean bl3 = false;
        $this$apply.setSource(parameter.getSource());
        $this$apply.setSession(parameter.getSession());
        $this$apply.setResolvePhase(parameter.getResolvePhase());
        $this$apply.setOrigin(FirDeclarationOrigin.FakeOverride.INSTANCE);
        $this$apply.setReturnTypeRef(parameter.getReturnTypeRef());
        $this$apply.setName(parameter.getName());
        $this$apply.setSymbol(new FirVariableSymbol<FirValueParameter>(parameter.getSymbol().getCallableId()));
        $this$apply.setDefaultValue(newDefaultValue);
        $this$apply.setCrossinline(parameter.isCrossinline());
        $this$apply.setNoinline(parameter.isNoinline());
        $this$apply.setVararg(parameter.isVararg());
        return firValueParameterBuilder;
    }

    @NotNull
    protected FirPropertyBuilder createPropertyCopy(@NotNull FirProperty firProperty, @NotNull FirPropertySymbol newSymbol) {
        Intrinsics.checkNotNullParameter(firProperty, "firProperty");
        Intrinsics.checkNotNullParameter(newSymbol, "newSymbol");
        FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
        boolean bl = false;
        boolean bl2 = false;
        FirPropertyBuilder $this$apply = firPropertyBuilder;
        boolean bl3 = false;
        $this$apply.setSource(firProperty.getSource());
        $this$apply.setSession(firProperty.getSession());
        $this$apply.setResolvePhase(firProperty.getResolvePhase());
        $this$apply.setOrigin(FirDeclarationOrigin.FakeOverride.INSTANCE);
        $this$apply.setReturnTypeRef(firProperty.getReturnTypeRef());
        $this$apply.setReceiverTypeRef(firProperty.getReceiverTypeRef());
        $this$apply.setVar(firProperty.isVar());
        $this$apply.setLocal(firProperty.isLocal());
        $this$apply.setGetter(firProperty.getGetter());
        $this$apply.setSetter(firProperty.getSetter());
        $this$apply.setName(firProperty.getName());
        $this$apply.setStatus(firProperty.getStatus());
        $this$apply.setSymbol(newSymbol);
        return firPropertyBuilder;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final FirOverrideChecker getOverrideChecker() {
        return this.overrideChecker;
    }

    public AbstractFirOverrideScope(@NotNull FirSession session2, @NotNull FirOverrideChecker overrideChecker) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(overrideChecker, "overrideChecker");
        this.session = session2;
        this.overrideChecker = overrideChecker;
        boolean bl = false;
        this.overrideByBase = new LinkedHashMap();
    }
}

