/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.weather;

import eu.hansolo.tilesfx.weather.DataPoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class DarkSky {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final String apiKey;
    private final String darkSkyUrl;
    private DataPoint today;
    private List<DataPoint> forecast;
    private Unit unit;
    private Language language;
    private double latitude;
    private double longitude;
    private String city;
    private TimeZone timeZone;

    public DarkSky(String API_KEY) {
        this(API_KEY, Unit.CA, Language.ENGLISH, 0.0, 0.0);
    }

    public DarkSky(String API_KEY, double LATITUDE, double LONGITUDE) {
        this(API_KEY, Unit.CA, Language.ENGLISH, LATITUDE, LONGITUDE);
    }

    public DarkSky(String API_KEY, Unit UNIT, Language LANGUAGE, double LATITUDE, double LONGITUDE) {
        if (null == API_KEY || API_KEY.isEmpty()) {
            throw new IllegalArgumentException("Please provide a valid DarkSky API key");
        }
        this.apiKey = API_KEY;
        this.darkSkyUrl = String.join((CharSequence)"", "https://api.darksky.net/forecast/", this.apiKey, "/");
        this.today = new DataPoint();
        this.forecast = new LinkedList<DataPoint>();
        this.unit = UNIT;
        this.language = LANGUAGE;
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
        this.timeZone = TimeZone.getDefault();
        this.city = "";
    }

    public DataPoint getToday() {
        return this.today;
    }

    public void setToday(DataPoint TODAY) {
        this.today = TODAY;
    }

    public List<DataPoint> getForecast() {
        return this.forecast;
    }

    public void setForecast(List<DataPoint> FORECAST) {
        this.forecast = FORECAST;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit UNIT) {
        this.unit = UNIT;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language LANGUAGE) {
        this.language = LANGUAGE;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double LATITUDE) {
        this.latitude = LATITUDE;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double LONGITUDE) {
        this.longitude = LONGITUDE;
    }

    public void setLatLon(double LATITUDE, double LONGITUDE) {
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone TIME_ZONE) {
        this.timeZone = TIME_ZONE;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String CITY) {
        this.city = CITY;
    }

    public boolean update() {
        return this.update(this.latitude, this.longitude, this.unit, this.language);
    }

    public boolean update(double LATITUDE, double LONGITUDE) {
        return this.update(LATITUDE, LONGITUDE, Unit.CA, Language.ENGLISH);
    }

    public boolean update(double LATITUDE, double LONGITUDE, Unit UNIT, Language LANGUAGE) {
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            this.forecast.clear();
            String URL_STRING = this.createUrl(LATITUDE, LONGITUDE, UNIT, LANGUAGE, Exclude.HOURLY, Exclude.MINUTELY, Exclude.FLAGS);
            HttpsURLConnection CONNECTION = (HttpsURLConnection)new URL(URL_STRING).openConnection();
            BufferedReader IN = new BufferedReader(new InputStreamReader(CONNECTION.getInputStream()));
            while ((inputLine = IN.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            IN.close();
            this.parseDarkSkyJsonData(response.toString());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void updateWithDarkSkyJsonData(String JSON_DATA) {
        this.parseDarkSkyJsonData(JSON_DATA);
    }

    private void parseDarkSkyJsonData(String JSON_DATA) {
        Object obj = JSONValue.parse(JSON_DATA);
        JSONObject jsonObj = (JSONObject)obj;
        this.timeZone = TimeZone.getTimeZone(jsonObj.getOrDefault("timezone", "").toString());
        JSONObject currently = (JSONObject)jsonObj.get("currently");
        this.setDataPoint(this.today, currently, this.timeZone);
        JSONObject daily = (JSONObject)jsonObj.get("daily");
        JSONArray days = (JSONArray)daily.get("data");
        JSONObject day0 = (JSONObject)days.get(0);
        this.today.setSunriseTime(this.epochStringToLocalDateTime(((Object)day0.getOrDefault("sunriseTime", 0)).toString(), this.timeZone));
        this.today.setSunsetTime(this.epochStringToLocalDateTime(((Object)day0.getOrDefault("sunsetTime", 0)).toString(), this.timeZone));
        this.today.setPrecipProbability(Double.parseDouble(((Object)day0.getOrDefault("precipProbability", 0)).toString()));
        this.today.setPrecipType(PrecipType.valueOf(day0.getOrDefault("precipType", "none").toString().toUpperCase().replace("-", "_")));
        for (int i = 1; i < days.size(); ++i) {
            JSONObject day = (JSONObject)days.get(i);
            DataPoint dataPoint = new DataPoint();
            this.setDataPoint(dataPoint, day, this.timeZone);
            this.forecast.add(dataPoint);
        }
    }

    private void setDataPoint(DataPoint DATA_POINT, JSONObject JSON_OBJ, TimeZone TIME_ZONE) {
        DATA_POINT.setTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("time", 0)).toString(), TIME_ZONE));
        DATA_POINT.setSummary(JSON_OBJ.getOrDefault("summary", "").toString());
        DATA_POINT.setCondition(ConditionAndIcon.valueOf(JSON_OBJ.getOrDefault("icon", "none").toString().toUpperCase().replace("-", "_")));
        DATA_POINT.setSunriseTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("sunriseTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setSunsetTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("sunsetTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setMoonPhase(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("moonPhase", 0)).toString()));
        DATA_POINT.setPrecipIntensity(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("precipIntensity", 0)).toString()));
        DATA_POINT.setPrecipIntensityMax(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("precipIntensityMax", 0)).toString()));
        DATA_POINT.setPrecipIntensityMaxTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("precipIntensityMaxTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setPrecipProbability(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("precipProbability", 0)).toString()));
        DATA_POINT.setPrecipType(PrecipType.valueOf(JSON_OBJ.getOrDefault("precipType", "none").toString().toUpperCase().replace("-", "_")));
        DATA_POINT.setTemperature(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("temperature", 0)).toString()));
        DATA_POINT.setTemperatureMin(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("temperatureMin", 0)).toString()));
        DATA_POINT.setTemperatureMinTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("temperatureMinTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setTemperatureMax(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("temperatureMax", 0)).toString()));
        DATA_POINT.setTemperatureMaxTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("temperatureMaxTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setApparentTemperatureMin(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("apparentTemperatureMin", 0)).toString()));
        DATA_POINT.setApparentTemperatureMinTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("apparentTemperatureMinTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setApparentTemperatureMax(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("apparentTemperatureMax", 0)).toString()));
        DATA_POINT.setApparentTemperatureMaxTime(this.epochStringToLocalDateTime(((Object)JSON_OBJ.getOrDefault("apparentTemperatureMaxTime", 0)).toString(), TIME_ZONE));
        DATA_POINT.setDewPoint(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("dewPoint", 0)).toString()));
        DATA_POINT.setHumidity(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("humidity", 0)).toString()));
        DATA_POINT.setWindSpeed(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("windSpeed", 0)).toString()));
        DATA_POINT.setWindBearing(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("windBearing", 0)).toString()));
        DATA_POINT.setCloudCover(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("cloudCover", 0)).toString()));
        DATA_POINT.setPressure(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("pressure", 0)).toString()));
        DATA_POINT.setOzone(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("ozone", 0)).toString()));
        DATA_POINT.setNearestStormBearing(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("nearestStormBearing", 0)).toString()));
        DATA_POINT.setNearestStormDistance(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("nearestStormDistance", 0)).toString()));
        DATA_POINT.setPrecipAccumlation(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("precipAccumlation", 0)).toString()));
        DATA_POINT.setVisibility(Double.parseDouble(((Object)JSON_OBJ.getOrDefault("visibility", 0)).toString()));
    }

    private LocalDateTime epochToLocalDateTime(long TIMESTAMP, TimeZone TIME_ZONE) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(TIMESTAMP), ZoneId.of(TIME_ZONE.getID()));
    }

    private LocalDateTime epochStringToLocalDateTime(String TIME_STRING, TimeZone TIME_ZONE) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(TIME_STRING)), ZoneId.of(TIME_ZONE.getID()));
    }

    private String createUrl(double LATITUDE, double LONGITUDE, Unit UNIT, Language LANGUAGE, Exclude ... EXCLUDES) {
        StringBuilder PARAMETERS = new StringBuilder().append(Double.toString(LATITUDE)).append(",").append(Double.toString(LONGITUDE)).append("?").append("units=").append(UNIT.value).append("&").append("lang=").append(LANGUAGE.value);
        if (EXCLUDES.length > 0) {
            PARAMETERS.append("&").append("exclude=");
            for (Exclude exclude : EXCLUDES) {
                PARAMETERS.append(exclude.value).append(",");
            }
            PARAMETERS.deleteCharAt(PARAMETERS.length() - 1);
        }
        return String.join((CharSequence)"", this.darkSkyUrl, PARAMETERS.toString());
    }

    public JSONObject toJsonObject() {
        JSONObject locationJson = new JSONObject();
        locationJson.put("latitude", this.latitude);
        locationJson.put("longitude", this.longitude);
        locationJson.put("unit", this.unit.value);
        locationJson.put("language", this.language.value);
        locationJson.put("date", DTF.format(ZonedDateTime.now()));
        locationJson.put("timezone", this.timeZone.getID());
        JSONObject todayJson = this.today.toJson();
        JSONArray forecastJson = new JSONArray();
        for (DataPoint dataPoint : this.forecast) {
            JSONObject forecastDayJson = dataPoint.toJson();
            forecastJson.add(forecastDayJson);
        }
        JSONObject json = new JSONObject();
        json.put("location", locationJson);
        json.put("today", todayJson);
        json.put("forecast", forecastJson);
        return json;
    }

    public String toJsonString() {
        return this.toJsonObject().toJSONString().replace("\\", "");
    }

    public static enum Exclude {
        CURRENTLY("currently"),
        MINUTELY("minutely"),
        HOURLY("hourly"),
        DAILY("daily"),
        ALERTS("alerts"),
        FLAGS("flags");

        public String value;

        private Exclude(String VALUE) {
            this.value = VALUE;
        }
    }

    public static enum PrecipType {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow"),
        SLEET("sleet");

        public String value;

        private PrecipType(String VALUE) {
            this.value = VALUE;
        }
    }

    public static enum ConditionAndIcon {
        NONE("none", "unknown", 0.305085, 0.576271),
        CLEAR_DAY("clear-day", "sun", 0.881356, 0.881356),
        CLEAR_NIGHT("clear-night", "sun", 0.881356, 0.881356),
        RAIN("rain", "rain", 0.89831, 0.79661),
        SNOW("snow", "snow", 0.898305, 0.728814),
        SLEET("sleet", "sleet", 0.898305, 0.677966),
        WIND("wind", "wind", 0.813559, 0.474576),
        FOG("fog", "fog", 0.949153, 0.661017),
        CLOUDY("cloudy", "cloud", 0.898305, 0.559322),
        PARTLY_CLOUDY_DAY("partly-cloudy-day", "sun-and-cloud", 0.983051, 0.745763),
        PARTLY_CLOUDY_NIGHT("partly-cloudy-night", "sun-and-cloud", 0.983051, 0.745763),
        HAIL("hail", "sleet", 0.898305, 0.677966),
        THUNDERSTORM("thunderstorm", "thunderstorm", 0.898305, 0.728814),
        INSIDE_TEMP("inside-temp", "inside-temp", 0.67307692, 0.92307692),
        OUTSIDE_TEMP("outside-temp", "outside-temp", 0.38461538, 0.92307692),
        PRESSURE("pressure", "pressure", 0.610169, 0.610169),
        HUMIDITY("humidity", "humidity", 0.644068, 0.728814),
        WIND_SPEED("windSpeed", "wind", 0.813559, 0.474576),
        SUNRISE("sunrise", "sun-rise", 1.0, 0.69230769),
        SUNSET("sunset", "sun-set", 1.0, 0.73076923);

        public String value;
        public String styleClass;
        public double widthFactor;
        public double heightFactor;

        private ConditionAndIcon(String VALUE, String STYLE_CLASS, double WIDTH_FACTOR, double HEIGHT_FACTOR) {
            this.value = VALUE;
            this.styleClass = STYLE_CLASS;
            this.widthFactor = WIDTH_FACTOR;
            this.heightFactor = HEIGHT_FACTOR;
        }
    }

    public static enum Unit {
        US("us", "\u00b0F", "mb", "%", "mph"),
        SI("si", "\u00b0C", "mb", "%", "m/s"),
        CA("ca", "\u00b0C", "mb", "%", "kph"),
        UK("uk", "\u00b0C", "mb", "%", "mph"),
        UK2("uk2", "\u00b0C", "mb", "%", "mph"),
        AUTO("auto", "\u00b0C", "mb", "%", "mph");

        public final String value;
        public final String temperatureUnitString;
        public final String pressureUnitString;
        public final String humidityUnitString;
        public final String speedUnitString;

        private Unit(String VALUE, String TEMPERATURE_UNIT_STRING, String PRESSURE_UNIT_STRING, String HUMIDITY_UNIT_STRING, String SPEED_UNIT_STRING) {
            this.value = VALUE;
            this.temperatureUnitString = TEMPERATURE_UNIT_STRING;
            this.pressureUnitString = PRESSURE_UNIT_STRING;
            this.humidityUnitString = HUMIDITY_UNIT_STRING;
            this.speedUnitString = SPEED_UNIT_STRING;
        }
    }

    public static enum Language {
        ARABIC("ar"),
        AZERBAIJANI("az"),
        BELRUSIAN("be"),
        BOSNIAN("bs"),
        CZECH("cs"),
        GERMAN("de"),
        GREEK("el"),
        ENGLISH("en"),
        SPANISH("es"),
        FRENCH("fr"),
        CROATIAN("hr"),
        HUNGARIAN("hu"),
        ITALIAN("it"),
        ICELANDIC("is"),
        CORNISH("kw"),
        NORWEGIAN("nb"),
        DUTCH("nl"),
        POLISH("pl"),
        PORTUGUESE("pt"),
        RUSSIAN("ru"),
        SLOVAK("sk"),
        SERBIAN("sr"),
        SWEDISH("sv"),
        TETUM("tet"),
        TURKISH("tr"),
        UKRAINIAN("uk"),
        IKPAY_ATINLAY("x-pig-latin"),
        SIMPLIFIED_CHINESE("zh"),
        TRADITIONAL_CHINESE("zw-tw");

        public String value;

        private Language(String VALUE) {
            this.value = VALUE;
        }
    }
}

