/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.threads;

import java.util.List;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;

public class IndicatorThread
extends Thread {
    protected final Daten daten;

    public IndicatorThread() {
        this.setName("IndicatorThread");
        this.daten = Daten.getInstance();
    }

    protected double calculateOverallPercentage() {
        int numOfDownloadsActive = 0;
        double accumPercentage = 0.0;
        List<DatenDownload> activeDownloadList = this.daten.getListeDownloads().getListOfStartsNotFinished(-1);
        for (DatenDownload download : activeDownloadList) {
            if (download.start.status != 2) continue;
            ++numOfDownloadsActive;
            accumPercentage += (double)download.start.percent / 10.0;
        }
        activeDownloadList.clear();
        return accumPercentage / (double)numOfDownloadsActive;
    }
}

