/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.script.ScriptException;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.anim.AnimationDecoder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.version.Version;

public abstract class UmlDiagram
extends TitledDiagram
implements Diagram,
Annotated,
WithSprite {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private Animation animation;
    private Dimension2D lastInfo;

    public UmlDiagram() {
    }

    public UmlDiagram(ISkinSimple orig) {
        super(orig);
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int minwidth) {
        this.minwidth = minwidth;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public final DisplaySection getFooterOrHeaderTeoz(FontParam param) {
        if (param == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (param == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    public final void setAnimation(Iterable<CharSequence> animationData) {
        try {
            AnimationDecoder animationDecoder = new AnimationDecoder(animationData);
            this.animation = Animation.create(animationDecoder.decode());
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean hideUnlinkedData) {
        this.hideUnlinkedData = hideUnlinkedData;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        HColor hover = this.getSkinParam().hoverPathColor();
        if (fileFormatOption.getSvgLinkTarget() == null || fileFormatOption.getSvgLinkTarget().equals("_top")) {
            fileFormatOption = fileFormatOption.withSvgLinkTarget(this.getSkinParam().getSvgLinkTarget());
        }
        fileFormatOption = fileFormatOption.withPreserveAspectRatio(this.getSkinParam().getPreserveAspectRatio());
        fileFormatOption = fileFormatOption.withTikzFontDistortion(this.getSkinParam().getTikzFontDistortion());
        if (hover != null) {
            fileFormatOption = fileFormatOption.withHoverColor(this.getSkinParam().getColorMapper().toRGB(hover));
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(os, index);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(os, index, fileFormatOption);
            this.lastInfo = new Dimension2DDouble(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (NoStyleAvailableException e) {
            this.exportDiagramError(os, e, fileFormatOption, seed, null);
        }
        catch (UnparsableGraphvizException e) {
            e.printStackTrace();
            this.exportDiagramError(os, e.getCause(), fileFormatOption, seed, e.getGraphvizVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exportDiagramError(os, e, fileFormatOption, seed, null);
        }
        catch (Error e) {
            e.printStackTrace();
            this.exportDiagramError(os, e, fileFormatOption, seed, null);
        }
        return ImageDataSimple.error();
    }

    private void exportDiagramError(OutputStream os, Throwable exception, FileFormatOption fileFormat, long seed, String graphvizVersion) throws IOException {
        UmlDiagram.exportDiagramError(os, exception, fileFormat, seed, this.getMetadata(), this.getFlashData(), UmlDiagram.getFailureText1(exception, graphvizVersion, this.getFlashData()));
    }

    public static void exportDiagramError(OutputStream os, Throwable exception, FileFormatOption fileFormat, long seed, String metadata, String flash, List<String> strings) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UmlDiagram.exportDiagramErrorText(os, exception, strings);
            return;
        }
        strings.addAll(CommandExecutionResult.getStackTrace(exception));
        HColor backcolor = HColorUtils.WHITE;
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, metadata, null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        BufferedImage im2 = null;
        if (flash != null) {
            FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
            try {
                im2 = utils.exportFlashcode(flash, Color.BLACK, Color.WHITE);
            }
            catch (Throwable e) {
                Log.error("Issue in flashcode generation " + e);
            }
            if (im2 != null) {
                GraphvizCrash.addDecodeHint(strings);
            }
        }
        final BufferedImage im = im2;
        final TextBlockBackcolored graphicStrings = GraphicStrings.createBlackOnWhite(strings, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        if (im == null) {
            imageBuilder.setUDrawable(graphicStrings);
        } else {
            imageBuilder.setUDrawable(new UDrawable(){

                @Override
                public void drawU(UGraphic ug) {
                    graphicStrings.drawU(ug);
                    double height = graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
                    ug = ug.apply(UTranslate.dy(height));
                    ug.draw(new UImage(new PixelImage(im, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0));
                }
            });
        }
        imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private static void exportDiagramErrorText(OutputStream os, Throwable exception, List<String> strings) {
        PrintWriter pw = SecurityUtils.createPrintWriter(os);
        exception.printStackTrace(pw);
        pw.println();
        pw.println();
        for (String s : strings) {
            s = s.replaceAll("\\</?\\w+?\\>", "");
            pw.println(s);
        }
        pw.flush();
    }

    public String getFlashData() {
        UmlSource source = this.getSource();
        if (source == null) {
            return "";
        }
        return source.getPlainString();
    }

    private static List<String> getFailureText1(Throwable exception, String graphvizVersion, String textDiagram) {
        List<String> strings = GraphvizCrash.anErrorHasOccured(exception, textDiagram);
        strings.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (exception instanceof EmptySvgException) {
            strings.add("Because dot/GraphViz returns an empty string.");
        }
        GraphvizCrash.checkOldVersionWarning(strings);
        if (graphvizVersion != null) {
            strings.add(" ");
            strings.add("GraphViz version used : " + graphvizVersion);
        }
        GraphvizCrash.pleaseGoTo(strings);
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        GraphvizCrash.thisMayBeCaused(strings);
        strings.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(strings);
        strings.add(" ");
        return strings;
    }

    public static List<String> getFailureText2(Throwable exception, String textDiagram) {
        List<String> strings = GraphvizCrash.anErrorHasOccured(exception, textDiagram);
        strings.add("PlantUML (" + Version.versionString() + ") has crashed.");
        GraphvizCrash.checkOldVersionWarning(strings);
        strings.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(strings);
        strings.add(" ");
        return strings;
    }

    private void exportDiagramInternalMjpeg(OutputStream os) throws IOException {
        SFile f = new SFile("c:/test.avi");
        int nb = 150;
        double framerate = 30.0;
        MJPEGGenerator m = new MJPEGGenerator(f, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform at = new AffineTransform();
            double coef = (double)(149 - i) * 1.0 / 150.0;
            at.setToShear(coef, coef);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.close();
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            m.addImage(im);
        }
        m.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream os, int index) throws IOException {
        File svg = FileUtils.createTempFileLegacy("pdf", ".svf");
        File pdfFile = FileUtils.createTempFileLegacy("pdf", ".pdf");
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(svg));
        ImageData result = this.exportDiagram(fos, index, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)fos).close();
        PdfConverter.convert(svg, pdfFile);
        FileUtils.copyToStream(pdfFile, os);
        return result;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(SuggestedFile suggestedFile, int index, ImageData cmapdata) throws FileNotFoundException {
        String name = UmlDiagram.changeName(suggestedFile.getFile(index).getAbsolutePath());
        SFile cmapFile = new SFile(name);
        try (PrintWriter pw = null;){
            if (!PSystemUtils.canFileBeWritten(cmapFile)) {
                return;
            }
            pw = cmapFile.createPrintWriter();
            pw.print(cmapdata.getCMapData(cmapFile.getName().substring(0, cmapFile.getName().length() - 6)));
            pw.close();
        }
    }

    static String changeName(String name) {
        return name.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double actualWidth = this.lastInfo.getWidth();
        if (actualWidth == 0.0) {
            return null;
        }
        String value = this.getSkinParam().getValue("widthwarning");
        if (value == null) {
            return null;
        }
        if (!value.matches("\\d+")) {
            return null;
        }
        int widthwarning = Integer.parseInt(value);
        if (actualWidth > (double)widthwarning) {
            return "The image is " + (int)actualWidth + " pixel width. (Warning limit is " + widthwarning + ")";
        }
        return null;
    }

    public void setHideEmptyDescription(boolean hideEmptyDescription) {
    }
}

