/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.gitlog.GNode;
import net.sourceforge.plantuml.gitlog.GNodeBuilder;
import net.sourceforge.plantuml.gitlog.GitTextArea;
import net.sourceforge.plantuml.gitlog.SmetanaForGit;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GitDiagram
extends UmlDiagram {
    private final Collection<GNode> gnodes;

    public GitDiagram(GitTextArea textArea) {
        this.gnodes = new GNodeBuilder(textArea.getAllCommits()).getAllNodes();
        new GNodeBuilder(textArea.getAllCommits());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Git)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.GIT;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        int margin2;
        int margin1;
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        if (UseStyle.useBetaStyle()) {
            margin1 = SkinParam.zeroMargin(10);
            margin2 = SkinParam.zeroMargin(10);
        } else {
            margin1 = 10;
            margin2 = 10;
        }
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, dpiFactor, "", "", ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder(this.getSkinParam())).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, 0L, os);
    }

    private void drawInternal(UGraphic ug) {
        new SmetanaForGit(ug, this.getSkinParam()).drawMe(this.gnodes);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                GitDiagram.this.drawInternal(ug);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return null;
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return null;
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }
}

