/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.text.CharacterIterator;
import sun.text.normalizer.CharacterIteratorWrapper;
import sun.text.normalizer.ReplaceableUCharacterIterator;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;

public abstract class UCharacterIterator
implements Cloneable {
    public static final int DONE = -1;

    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(String source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(StringBuffer source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(CharacterIterator source) {
        return new CharacterIteratorWrapper(source);
    }

    public abstract int current();

    public abstract int getLength();

    public abstract int getIndex();

    public abstract int next();

    public int nextCodePoint() {
        int ch1 = this.next();
        if (UTF16.isLeadSurrogate((char)ch1)) {
            int ch2 = this.next();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return UCharacterProperty.getRawSupplementary((char)ch1, (char)ch2);
            }
            if (ch2 != -1) {
                this.previous();
            }
        }
        return ch1;
    }

    public abstract int previous();

    public abstract void setIndex(int var1);

    public abstract int getText(char[] var1, int var2);

    public final int getText(char[] fillIn) {
        return this.getText(fillIn, 0);
    }

    public String getText() {
        char[] text = new char[this.getLength()];
        this.getText(text);
        return new String(text);
    }

    public int moveIndex(int delta) {
        int x = Math.max(0, Math.min(this.getIndex() + delta, this.getLength()));
        this.setIndex(x);
        return x;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

