/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingResultSet;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;

public class DelegatingDatabaseMetaData
implements DatabaseMetaData {
    private final DatabaseMetaData databaseMetaData;
    private final DelegatingConnection<?> connection;

    public DelegatingDatabaseMetaData(DelegatingConnection<?> delegatingConnection, DatabaseMetaData databaseMetaData) {
        this.connection = delegatingConnection;
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.databaseMetaData.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.databaseMetaData.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.databaseMetaData.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.databaseMetaData.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.databaseMetaData.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        try {
            return this.databaseMetaData.deletesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.databaseMetaData.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.connection.checkOpen();
        try {
            return Jdbc41Bridge.generatedKeyAlwaysReturned(this.databaseMetaData);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getAttributes(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getBestRowIdentifier(string, string2, string3, n, bl));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getCatalogs());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.databaseMetaData.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.databaseMetaData.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getClientInfoProperties());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getColumnPrivileges(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getCrossReference(string, string2, string3, string4, string5, string6));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.databaseMetaData.getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return this.databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.databaseMetaData.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public DatabaseMetaData getDelegate() {
        return this.databaseMetaData;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.databaseMetaData.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.databaseMetaData.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return this.databaseMetaData.getDriverName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return this.databaseMetaData.getDriverVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getExportedKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.databaseMetaData.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getFunctionColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getFunctions(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this.databaseMetaData.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getImportedKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getIndexInfo(string, string2, string3, bl, bl2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    public DatabaseMetaData getInnermostDelegate() {
        DatabaseMetaData databaseMetaData = this.databaseMetaData;
        while (databaseMetaData != null && databaseMetaData instanceof DelegatingDatabaseMetaData) {
            if (this != (databaseMetaData = ((DelegatingDatabaseMetaData)databaseMetaData).getDelegate())) continue;
            return null;
        }
        return databaseMetaData;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.databaseMetaData.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.databaseMetaData.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.databaseMetaData.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.databaseMetaData.getMaxConnections();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.databaseMetaData.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.databaseMetaData.getMaxStatements();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.databaseMetaData.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.databaseMetaData.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.databaseMetaData.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getPrimaryKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getProcedureColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getProcedures(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.databaseMetaData.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, Jdbc41Bridge.getPseudoColumns(this.databaseMetaData, string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.databaseMetaData.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return this.databaseMetaData.getRowIdLifetime();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getSchemas());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getSchemas(string, string2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this.databaseMetaData.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.databaseMetaData.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.databaseMetaData.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.databaseMetaData.getSQLStateType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.databaseMetaData.getStringFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getSuperTables(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getSuperTypes(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.databaseMetaData.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getTablePrivileges(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getTables(string, string2, string3, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getTableTypes());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.databaseMetaData.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getTypeInfo());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getUDTs(string, string2, string3, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this.databaseMetaData.getURL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.connection.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this.connection, this.databaseMetaData.getVersionColumns(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this.connection == null) {
            throw sQLException;
        }
        this.connection.handleException(sQLException);
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        try {
            return this.databaseMetaData.insertsAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.databaseMetaData.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.databaseMetaData.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (clazz.isAssignableFrom(this.databaseMetaData.getClass())) {
            return true;
        }
        return this.databaseMetaData.isWrapperFor(clazz);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.databaseMetaData.locatorsUpdateCopy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.databaseMetaData.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.databaseMetaData.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.databaseMetaData.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.databaseMetaData.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.databaseMetaData.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.othersDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.othersInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.othersUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.ownDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.ownInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        try {
            return this.databaseMetaData.ownUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.databaseMetaData.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.databaseMetaData.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.databaseMetaData.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.databaseMetaData.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.databaseMetaData.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.databaseMetaData.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.databaseMetaData.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.databaseMetaData.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.databaseMetaData.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.databaseMetaData.supportsConvert();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        try {
            return this.databaseMetaData.supportsConvert(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.databaseMetaData.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.databaseMetaData.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.databaseMetaData.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.databaseMetaData.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.databaseMetaData.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.databaseMetaData.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.databaseMetaData.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.databaseMetaData.supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.databaseMetaData.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.databaseMetaData.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.databaseMetaData.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.databaseMetaData.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.databaseMetaData.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.databaseMetaData.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.databaseMetaData.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.databaseMetaData.supportsMultipleOpenResults();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.databaseMetaData.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.databaseMetaData.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.databaseMetaData.supportsNamedParameters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.databaseMetaData.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.databaseMetaData.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.databaseMetaData.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.databaseMetaData.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.databaseMetaData.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.databaseMetaData.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.databaseMetaData.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.databaseMetaData.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.databaseMetaData.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        try {
            return this.databaseMetaData.supportsResultSetConcurrency(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        try {
            return this.databaseMetaData.supportsResultSetHoldability(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        try {
            return this.databaseMetaData.supportsResultSetType(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.databaseMetaData.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.databaseMetaData.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.databaseMetaData.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.databaseMetaData.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.databaseMetaData.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.databaseMetaData.supportsStatementPooling();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.databaseMetaData.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.databaseMetaData.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.databaseMetaData.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.databaseMetaData.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.databaseMetaData.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.databaseMetaData.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.databaseMetaData.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        try {
            return this.databaseMetaData.supportsTransactionIsolationLevel(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.databaseMetaData.supportsTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.databaseMetaData.supportsUnion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.databaseMetaData.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.databaseMetaData.getClass())) {
            return clazz.cast(this.databaseMetaData);
        }
        return this.databaseMetaData.unwrap(clazz);
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        try {
            return this.databaseMetaData.updatesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.databaseMetaData.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.databaseMetaData.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }
}

