/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Set;
import java.util.StringJoiner;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class MBeanDumper {
    private static final Log log = LogFactory.getLog(MBeanDumper.class);
    protected static final StringManager sm = StringManager.getManager(MBeanDumper.class);
    private static final String CRLF = "\r\n";

    public static String dumpBeans(MBeanServer mBeanServer, Set<ObjectName> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ObjectName objectName : set) {
            stringBuilder.append("Name: ");
            stringBuilder.append(objectName.toString());
            stringBuilder.append(CRLF);
            try {
                MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
                String string = mBeanInfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(string)) {
                    string = (String)mBeanServer.getAttribute(objectName, "modelerType");
                }
                stringBuilder.append("modelerType: ");
                stringBuilder.append(string);
                stringBuilder.append(CRLF);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                Object object = null;
                for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                    Serializable serializable;
                    String string2;
                    if (!mBeanAttributeInfo.isReadable() || "modelerType".equals(string2 = mBeanAttributeInfo.getName()) || string2.indexOf(61) >= 0 || string2.indexOf(58) >= 0 || string2.indexOf(32) >= 0) continue;
                    try {
                        object = mBeanServer.getAttribute(objectName, string2);
                    }
                    catch (JMRuntimeException jMRuntimeException) {
                        serializable = jMRuntimeException.getCause();
                        if (serializable instanceof UnsupportedOperationException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                            continue;
                        }
                        if (serializable instanceof NullPointerException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                            continue;
                        }
                        log.error((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.error((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), throwable);
                        continue;
                    }
                    if (object == null) continue;
                    try {
                        String string3;
                        Object object2;
                        serializable = object.getClass();
                        if (((Class)serializable).isArray()) {
                            int n = Array.getLength(object);
                            object2 = new StringBuilder("Array[" + ((Class)serializable).getComponentType().getName() + "] of length " + n);
                            if (n > 0) {
                                ((StringBuilder)object2).append(CRLF);
                            }
                            for (int i = 0; i < n; ++i) {
                                Object object3 = Array.get(object, i);
                                ((StringBuilder)object2).append(MBeanDumper.tableItemToString(object3));
                                if (i >= n - 1) continue;
                                ((StringBuilder)object2).append(CRLF);
                            }
                            string3 = ((StringBuilder)object2).toString();
                        } else if (TabularData.class.isInstance(object)) {
                            TabularData tabularData = (TabularData)TabularData.class.cast(object);
                            object2 = new StringJoiner(CRLF);
                            ((StringJoiner)object2).add("TabularData[" + tabularData.getTabularType().getRowType().getTypeName() + "] of length " + tabularData.size());
                            for (Object object3 : tabularData.values()) {
                                ((StringJoiner)object2).add(MBeanDumper.tableItemToString(object3));
                            }
                            string3 = ((StringJoiner)object2).toString();
                        } else {
                            string3 = MBeanDumper.valueToString(object);
                        }
                        stringBuilder.append(string2);
                        stringBuilder.append(": ");
                        stringBuilder.append(string3);
                        stringBuilder.append(CRLF);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            stringBuilder.append(CRLF);
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        int n = string.indexOf("\n");
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 0) {
            MBeanDumper.appendHead(stringBuilder, string, n2, n);
            stringBuilder.append("\\n\n ");
            n2 = n + 1;
            if (n == string.length() - 1) break;
            n = string.indexOf(10, n + 1);
        }
        if (n2 < string.length()) {
            MBeanDumper.appendHead(stringBuilder, string, n2, string.length());
        }
        return stringBuilder.toString();
    }

    private static void appendHead(StringBuilder stringBuilder, String string, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n;
        while (n2 - n3 > 78) {
            stringBuilder.append(string.substring(n3, n3 + 78));
            stringBuilder.append("\n ");
            n3 += 78;
        }
        stringBuilder.append(string.substring(n3, n2));
    }

    private static String tableItemToString(Object object) {
        if (object == null) {
            return "\tNULL VALUE";
        }
        try {
            return "\t" + MBeanDumper.valueToString(object);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            return "\tNON-STRINGABLE VALUE";
        }
    }

    private static String valueToString(Object object) {
        String string;
        if (CompositeData.class.isInstance(object)) {
            StringBuilder stringBuilder = new StringBuilder("{");
            String string2 = "";
            CompositeData compositeData = (CompositeData)CompositeData.class.cast(object);
            Set<String> set = compositeData.getCompositeType().keySet();
            for (String string3 : set) {
                stringBuilder.append(string2).append(string3).append('=').append(compositeData.get(string3));
                string2 = ", ";
            }
            stringBuilder.append('}');
            string = stringBuilder.toString();
        } else {
            string = object.toString();
        }
        return MBeanDumper.escape(string);
    }
}

