/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import mediathek.daten.DatenDownload;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVHttpClient;
import mediathek.tool.TimedTextMarkupLanguageParser;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MVSubtitle {
    private static final String SUFFIX_SRT = "srt";
    private static final String SUFFIX_TTML = "ttml";
    private static final String SUFFIX_VTT = "vtt";
    private static final Logger logger = LogManager.getLogger(MVSubtitle.class);

    private void createDirectory(String targetDirectory) {
        try {
            Files.createDirectory(Paths.get(targetDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNetworkData(InputStream is, Path ttmlPath) throws IOException {
        try (OutputStream fos = Files.newOutputStream(ttmlPath, new OpenOption[0]);){
            int n;
            byte[] buffer = new byte[65536];
            while ((n = is.read(buffer)) != -1) {
                fos.write(buffer, 0, n);
            }
            logger.info("Untertitel-Datei wurde geschrieben");
        }
    }

    public void writeSubtitle(@NotNull DatenDownload datenDownload) {
        block23: {
            String urlSubtitle = datenDownload.arr[23];
            String targetDirectory = datenDownload.arr[30];
            if (urlSubtitle.isEmpty()) {
                return;
            }
            Request request = new Request.Builder().url(urlSubtitle).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (body != null && response.isSuccessful()) {
                    logger.info("Untertitel {} schreiben nach {}", (Object)urlSubtitle, (Object)targetDirectory);
                    try (InputStream is = body.byteStream();){
                        String suffix = GuiFunktionen.getSuffixFromUrl(urlSubtitle);
                        if (!suffix.endsWith(SUFFIX_SRT) && !suffix.endsWith(SUFFIX_VTT)) {
                            suffix = SUFFIX_TTML;
                        }
                        this.createDirectory(targetDirectory);
                        String strSubtitleFile = datenDownload.getFileNameWithoutSuffix() + "." + suffix;
                        Path ttmlPath = Paths.get(strSubtitleFile, new String[0]);
                        this.writeNetworkData(is, ttmlPath);
                        this.convertSubtitle(datenDownload, ttmlPath, strSubtitleFile);
                        break block23;
                    }
                }
                logger.error("HTTP Response Code {} for URL: {}", (Object)response.code(), (Object)urlSubtitle);
            }
            catch (IOException ex) {
                logger.error("Subtitle exception occured:", (Throwable)ex);
            }
        }
    }

    private void convertSubtitle(DatenDownload datenDownload, Path ttmlPath, String strSubtitleFile) {
        try (TimedTextMarkupLanguageParser ttmlp = new TimedTextMarkupLanguageParser();){
            if (!strSubtitleFile.endsWith(".srt") && !strSubtitleFile.endsWith(".vtt")) {
                Path srt = Paths.get(datenDownload.getFileNameWithoutSuffix() + ".srt", new String[0]);
                if (ttmlp.parse(ttmlPath)) {
                    ttmlp.toSrt(srt);
                } else if (ttmlp.parseXmlFlash(ttmlPath)) {
                    ttmlp.toSrt(srt);
                }
                logger.info("Untertitel-Datei wurde konvertiert.");
            }
        }
        catch (Exception ex) {
            logger.error("Fehler bei Untertitel schreiben:", (Throwable)ex);
        }
    }
}

