/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.PatternReplace;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;

public class SortSettings {
    private String sortMethod = null;
    private String sortField = "sort";
    private String collationRule = null;
    private String dateLocale = "locale";
    private String dateFormat = null;
    private String numberLocale = "locale";
    private String numberFormat = null;
    private String docLocale;
    private int letterNumberRule = 2;
    private int letterNumberPuncRule = 0;
    private int collatorStrength = 0;
    private int collatorDecomposition = 1;
    private int breakPoint = 1;
    private String breakPointMarker = "|";
    private int sortSuffixOption = 0;
    private String sortSuffixMarker = "";
    private String sortSuffixField = null;
    private boolean trim = true;
    public static final int SORT_SUFFIX_NONE = 0;
    public static final int SORT_SUFFIX_NON_UNIQUE = 1;
    public static final int SORT_SUFFIX_FIELD = 2;
    public static final int IDENTICAL_SORT_NO_ACTION = 0;
    public static final int IDENTICAL_SORT_USE_ID = 1;
    public static final int IDENTICAL_SORT_USE_FIELD = 2;
    public static final int IDENTICAL_SORT_USE_ORIGINAL_ID = 3;
    public static final int IDENTICAL_SORT_USE_DEF = 4;
    public static final int IDENTICAL_SORT_USE_RECORD = 5;
    private int identicalSortAction = 1;
    public static final int GROUP_DEFAULT = 0;
    public static final int GROUP_UNICODE_CODEPOINT = 1;
    public static final int GROUP_UNICODE_CATEGORY = 2;
    public static final int GROUP_UNICODE_SCRIPT = 3;
    public static final int GROUP_UNICODE_CATEGORY_SCRIPT = 4;
    private int groupFormation = 0;
    private String identicalSortField = null;
    private int numberPad = 0;
    private String padMinus = "<";
    private String padPlus = ">";
    private String missingFieldFallback = null;
    private Vector<PatternReplace> regexList = null;
    private Bib2Gls bib2gls;

    public SortSettings(Bib2Gls bib2Gls) {
        this(null, bib2Gls);
    }

    public SortSettings(String string, Bib2Gls bib2Gls) {
        this.setMethod(string);
        this.bib2gls = bib2Gls;
    }

    public static boolean isValidSortMethod(String string) {
        if (string == null || "unsrt".equals(string) || "none".equals(string) || "random".equals(string) || "combine".equals(string)) {
            return true;
        }
        if (string.endsWith("-reverse")) {
            string = string.substring(0, string.lastIndexOf("-reverse"));
        }
        if (string.equals("use") || string.equals("doc") || string.equals("locale") || string.equals("custom")) {
            return true;
        }
        if (string.equals("letter-case") || string.equals("letter-nocase") || string.equals("letter-lowerupper") || string.equals("letter-upperlower")) {
            return true;
        }
        if (string.equals("letternumber-case") || string.equals("letternumber-nocase") || string.equals("letternumber-lowerupper") || string.equals("letternumber-upperlower")) {
            return true;
        }
        if (string.equals("integer") || string.equals("hex") || string.equals("octal") || string.equals("binary") || string.equals("float") || string.equals("double") || string.equals("numeric") || string.equals("currency") || string.equals("percent") || string.equals("numberformat") || string.equals("recordcount")) {
            return true;
        }
        if (string.equals("date") || string.equals("datetime") || string.equals("time")) {
            return true;
        }
        try {
            Locale locale = new Locale.Builder().setLanguageTag(string).build();
            try {
                String string2 = locale.getISO3Language();
            }
            catch (MissingResourceException missingResourceException) {
                return false;
            }
        }
        catch (IllformedLocaleException illformedLocaleException) {
            return false;
        }
        return true;
    }

    public boolean requiresSorting() {
        return this.sortMethod != null && !this.sortMethod.startsWith("use") && !this.sortMethod.equals("none");
    }

    public boolean requiresSortField() {
        return this.requiresSorting() && !this.sortMethod.startsWith("recordcount");
    }

    public boolean isOrderOfRecords() {
        return "use".equals(this.sortMethod) || "use-reverse".equals(this.sortMethod);
    }

    public boolean isUnsrt() {
        return "none".equals(this.sortMethod);
    }

    public boolean isDateTimeSort() {
        return this.sortMethod != null && this.sortMethod.startsWith("datetime");
    }

    public boolean isDateOrTimeSort() {
        return this.sortMethod != null && (this.sortMethod.startsWith("date") || this.sortMethod.startsWith("time"));
    }

    public boolean isDateSort() {
        return "date".equals(this.sortMethod) || "date-reverse".equals(this.sortMethod);
    }

    public boolean isTimeSort() {
        return "time".equals(this.sortMethod) || "time-reverse".equals(this.sortMethod);
    }

    public boolean isLetter() {
        return this.sortMethod != null && this.sortMethod.startsWith("letter-");
    }

    public boolean isLetterNumber() {
        return this.sortMethod != null && this.sortMethod.startsWith("letternumber-");
    }

    public boolean isNumeric() {
        return this.isNonLocaleNumeric() || this.isLocaleNumeric();
    }

    public boolean isLocaleNumeric() {
        if (this.sortMethod == null) {
            return false;
        }
        return this.sortMethod.startsWith("numeric") || this.sortMethod.startsWith("currency") || this.sortMethod.startsWith("percent") || this.sortMethod.startsWith("numberformat");
    }

    public boolean isNonLocaleNumeric() {
        if (this.sortMethod == null) {
            return false;
        }
        return this.sortMethod.startsWith("integer") || this.sortMethod.startsWith("float") || this.sortMethod.startsWith("double") || this.sortMethod.startsWith("hex") || this.sortMethod.startsWith("octal") || this.sortMethod.startsWith("binary");
    }

    public boolean isRecordCount() {
        if (this.sortMethod == null) {
            return false;
        }
        return this.sortMethod.startsWith("recordcount");
    }

    public boolean isReverse() {
        return this.sortMethod != null && this.sortMethod.endsWith("-reverse");
    }

    public int caseStyle() {
        if (this.sortMethod.contains("-nocase")) {
            return 1;
        }
        if (this.sortMethod.contains("-upperlower")) {
            return 2;
        }
        if (this.sortMethod.contains("-lowerupper")) {
            return 3;
        }
        return 0;
    }

    public boolean isRandom() {
        return "random".equals(this.sortMethod);
    }

    public boolean isCustom() {
        return "custom".equals(this.sortMethod) || "custom-reverse".equals(this.sortMethod);
    }

    public boolean hasCustomRule() {
        return this.collationRule != null;
    }

    public boolean isCustomNumeric() {
        return this.sortMethod != null && this.sortMethod.startsWith("numberformat");
    }

    public boolean hasCustomNumericRule() {
        return this.numberFormat != null;
    }

    public void setMethod(String string) {
        if (!SortSettings.isValidSortMethod(string)) {
            throw new IllegalArgumentException("Invalid sort method:" + string);
        }
        this.sortMethod = "unsrt".equals(string) ? "none" : string;
    }

    public String getMethod() {
        return this.sortMethod;
    }

    public String getMethodName() {
        return this.sortMethod == null ? "none" : this.sortMethod;
    }

    public String getUnderlyingMethod() {
        if (this.sortMethod == null) {
            return null;
        }
        if (this.sortMethod.endsWith("-reverse")) {
            return this.sortMethod.substring(0, this.sortMethod.length() - 8);
        }
        return this.sortMethod;
    }

    public void setSortField(String string) {
        this.sortField = string;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setCollationRule(String string) {
        this.collationRule = string;
    }

    public String getCollationRule() {
        return this.collationRule;
    }

    public void setLetterNumberRule(int n) {
        this.letterNumberRule = n;
    }

    public int getLetterNumberRule() {
        return this.letterNumberRule;
    }

    public void setLetterNumberPuncRule(int n) {
        this.letterNumberPuncRule = n;
    }

    public int getLetterNumberPuncRule() {
        return this.letterNumberPuncRule;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateLocale(String string) {
        this.dateLocale = string;
    }

    public String getDateLocaleSetting() {
        return this.dateLocale;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateFormat getDateFormat(Locale locale, String string, boolean bl, boolean bl2) {
        void var4_13;
        int n = 2;
        if (string == null || "default".equals(string)) {
            n = 2;
            string = null;
        } else if (string.equals("full")) {
            n = 0;
            string = null;
        } else if (string.equals("long")) {
            n = 1;
            string = null;
        } else if (string.equals("medium")) {
            n = 2;
            string = null;
        } else if (string.equals("short")) {
            n = 3;
            string = null;
        }
        if (string == null) {
            if (bl && bl2) {
                if (locale == null) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n);
                    return var4_13;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n, locale);
                }
                return var4_13;
            } else if (bl) {
                if (locale == null) {
                    DateFormat dateFormat = DateFormat.getDateInstance(n);
                    return var4_13;
                } else {
                    DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
                }
                return var4_13;
            } else {
                if (!bl2) throw new IllegalArgumentException("Can't have both date=false and time=false");
                if (locale == null) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(n);
                    return var4_13;
                } else {
                    DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
                }
            }
            return var4_13;
        } else if (locale == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            return var4_13;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        }
        return var4_13;
    }

    public Locale getLocale() {
        if (this.sortMethod.equals("locale") || this.sortMethod.equals("locale-reverse")) {
            return Locale.getDefault();
        }
        String string = this.sortMethod;
        int n = string.lastIndexOf("-reverse");
        if (n > -1) {
            string = string.substring(0, n);
        }
        return this.bib2gls.getLocale(string);
    }

    public Locale getDateLocale() {
        if (this.dateLocale.equals("locale")) {
            return Locale.getDefault();
        }
        return this.bib2gls.getLocale(this.dateLocale);
    }

    public void setNumberLocale(String string) {
        this.numberLocale = string;
    }

    public Locale getNumberLocale() {
        if (this.numberLocale.equals("locale")) {
            return Locale.getDefault();
        }
        return this.bib2gls.getLocale(this.numberLocale);
    }

    public void setDocLocale(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if ("doc".equals(this.sortMethod)) {
            this.sortMethod = string;
        } else if ("doc-reverse".equals(this.sortMethod)) {
            this.sortMethod = string + "-reverse";
        }
        if ("doc".equals(this.dateLocale)) {
            this.dateLocale = string;
        }
        if ("doc".equals(this.numberLocale)) {
            this.numberLocale = string;
        }
        this.docLocale = string;
    }

    public String getDocLocaleTag() {
        return this.docLocale;
    }

    public void setNumberFormat(String string) {
        this.numberFormat = string;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void verboseMessages(Bib2Gls bib2Gls) {
        this.verboseMessages(bib2Gls, "sort");
    }

    public void verboseMessages(Bib2Gls bib2Gls, String string) {
        bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.mode", string), this.sortMethod == null ? "none" : this.sortMethod));
        bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.field", string), this.sortField));
        if (this.isDateOrTimeSort()) {
            bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.date.locale", string), this.getDateLocale().toLanguageTag()));
            if (this.dateFormat != null) {
                bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.date.format", string), this.dateFormat));
            }
        } else if (this.isLocaleNumeric()) {
            bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.numeric.locale", string), this.getNumberLocale().toLanguageTag()));
            if (this.numberFormat != null) {
                bib2Gls.verbose(bib2Gls.getMessage(String.format("message.%s.numeric.format", string), this.numberFormat));
            }
        }
    }

    public void setCollatorStrength(int n) {
        this.collatorStrength = n;
    }

    public int getCollatorStrength() {
        return this.collatorStrength;
    }

    public void setCollatorDecomposition(int n) {
        this.collatorDecomposition = n;
    }

    public int getCollatorDecomposition() {
        return this.collatorDecomposition;
    }

    public void setBreakPoint(int n) {
        this.breakPoint = n;
    }

    public int getBreakPoint() {
        return this.breakPoint;
    }

    public void setBreakPointMarker(String string) {
        this.breakPointMarker = string;
    }

    public String getBreakPointMarker() {
        return this.breakPointMarker;
    }

    public void setSuffixOption(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.sortSuffixOption = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identical sort suffix option: " + n);
            }
        }
    }

    public int getSuffixOption() {
        return this.sortSuffixOption;
    }

    public void setSuffixMarker(String string) {
        this.sortSuffixMarker = string;
    }

    public String getSuffixMarker() {
        return this.sortSuffixMarker;
    }

    public void setSuffixField(String string) {
        this.sortSuffixField = string;
    }

    public String getSuffixField() {
        return this.sortSuffixField;
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public boolean isTrimOn() {
        return this.trim;
    }

    public int getIdenticalSortAction() {
        return this.identicalSortAction;
    }

    public void setIdenticalSortAction(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.identicalSortAction = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identical sort action: " + n);
            }
        }
    }

    public void setIdenticalSortField(String string) {
        this.identicalSortField = string;
    }

    public String getIdenticalSortField() {
        return this.identicalSortField;
    }

    public void setNumberPad(int n) {
        this.numberPad = n;
    }

    public int getNumberPad() {
        return this.numberPad;
    }

    public void setPadPlus(String string) {
        this.padPlus = string;
    }

    public String getPadPlus() {
        return this.padPlus;
    }

    public void setPadMinus(String string) {
        this.padMinus = string;
    }

    public String getPadMinus() {
        return this.padMinus;
    }

    public String getMissingFieldFallback() {
        return this.missingFieldFallback;
    }

    public void setMissingFieldFallback(String string) {
        this.missingFieldFallback = "".equals(string) ? null : string;
    }

    public void setGroupFormation(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.groupFormation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid group formation: " + n);
            }
        }
    }

    public int getGroupFormation() {
        return this.groupFormation;
    }

    public void setRegexList(Vector<PatternReplace> vector) {
        this.regexList = vector;
    }

    public Vector<PatternReplace> getRegexList() {
        return this.regexList;
    }

    public SortSettings copy(String string, String string2) {
        if (this.docLocale != null) {
            if ("doc".equals(string)) {
                string = this.docLocale;
            } else if ("doc-reverse".equals(string)) {
                string = this.docLocale + "-reverse";
            }
        }
        SortSettings sortSettings = new SortSettings(string, this.bib2gls);
        sortSettings.setSortField(string2);
        sortSettings.collationRule = this.collationRule;
        sortSettings.dateLocale = this.dateLocale;
        sortSettings.dateFormat = this.dateFormat;
        sortSettings.numberLocale = this.numberLocale;
        sortSettings.numberFormat = this.numberFormat;
        sortSettings.letterNumberRule = this.letterNumberRule;
        sortSettings.letterNumberPuncRule = this.letterNumberPuncRule;
        sortSettings.collatorStrength = this.collatorStrength;
        sortSettings.collatorDecomposition = this.collatorDecomposition;
        sortSettings.breakPoint = this.breakPoint;
        sortSettings.breakPointMarker = this.breakPointMarker;
        sortSettings.sortSuffixOption = this.sortSuffixOption;
        sortSettings.sortSuffixMarker = this.sortSuffixMarker;
        sortSettings.sortSuffixField = this.sortSuffixField;
        sortSettings.trim = this.trim;
        sortSettings.identicalSortAction = this.identicalSortAction;
        sortSettings.groupFormation = this.groupFormation;
        sortSettings.identicalSortField = this.identicalSortField;
        sortSettings.numberPad = this.numberPad;
        sortSettings.padMinus = this.padMinus;
        sortSettings.padPlus = this.padPlus;
        sortSettings.missingFieldFallback = this.missingFieldFallback;
        sortSettings.regexList = this.regexList;
        sortSettings.docLocale = this.docLocale;
        return sortSettings;
    }
}

