/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.catalina.Context;
import org.apache.catalina.util.ParameterMap;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationFilterRegistration
implements FilterRegistration.Dynamic {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private final FilterDef filterDef;
    private final Context context;

    public ApplicationFilterRegistration(FilterDef filterDef, Context context) {
        this.filterDef = filterDef;
        this.context = context;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> enumSet, boolean bl, String ... stringArray) {
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (enumSet != null) {
            for (DispatcherType dispatcherType : enumSet) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (stringArray != null) {
            for (String string : stringArray) {
                filterMap.addServletName(string);
            }
            if (bl) {
                this.context.addFilterMap(filterMap);
            } else {
                this.context.addFilterMapBefore(filterMap);
            }
        }
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> enumSet, boolean bl, String ... stringArray) {
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (enumSet != null) {
            for (DispatcherType dispatcherType : enumSet) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (stringArray != null) {
            for (String string : stringArray) {
                filterMap.addURLPattern(string);
            }
            if (bl) {
                this.context.addFilterMap(filterMap);
            } else {
                this.context.addFilterMapBefore(filterMap);
            }
        }
    }

    public Collection<String> getServletNameMappings() {
        FilterMap[] filterMapArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (FilterMap filterMap : filterMapArray = this.context.findFilterMaps()) {
            if (!filterMap.getFilterName().equals(this.filterDef.getFilterName())) continue;
            hashSet.addAll(Arrays.asList(filterMap.getServletNames()));
        }
        return hashSet;
    }

    public Collection<String> getUrlPatternMappings() {
        FilterMap[] filterMapArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (FilterMap filterMap : filterMapArray = this.context.findFilterMaps()) {
            if (!filterMap.getFilterName().equals(this.filterDef.getFilterName())) continue;
            hashSet.addAll(Arrays.asList(filterMap.getURLPatterns()));
        }
        return hashSet;
    }

    public String getClassName() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String string) {
        return (String)this.filterDef.getParameterMap().get(string);
    }

    public Map<String, String> getInitParameters() {
        ParameterMap<String, String> parameterMap = new ParameterMap<String, String>();
        parameterMap.putAll(this.filterDef.getParameterMap());
        parameterMap.setLocked(true);
        return parameterMap;
    }

    public String getName() {
        return this.filterDef.getFilterName();
    }

    public boolean setInitParameter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParam", new Object[]{string, string2}));
        }
        if (this.getInitParameter(string) != null) {
            return false;
        }
        this.filterDef.addInitParameter(string, string2);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParams", new Object[]{entry.getKey(), entry.getValue()}));
            }
            if (this.getInitParameter(entry.getKey()) == null) continue;
            hashSet.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setInitParameter(entry.getKey(), entry.getValue());
        }
        return hashSet;
    }

    public void setAsyncSupported(boolean bl) {
        this.filterDef.setAsyncSupported(Boolean.valueOf(bl).toString());
    }
}

