/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.GenericFilter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class RequestDumperFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    private static final String NON_HTTP_REQ_MSG = "Not available. Non-http request.";
    private static final String NON_HTTP_RES_MSG = "Not available. Non-http response.";
    private static final ThreadLocal<Timestamp> timestamp = new ThreadLocal<Timestamp>(){

        @Override
        protected Timestamp initialValue() {
            return new Timestamp();
        }
    };
    private transient Log log = LogFactory.getLog(RequestDumperFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        Object object2;
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        if (servletRequest instanceof HttpServletRequest) {
            httpServletRequest = (HttpServletRequest)servletRequest;
        }
        if (servletResponse instanceof HttpServletResponse) {
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        this.doLog("START TIME        ", this.getTimestamp());
        if (httpServletRequest == null) {
            this.doLog("        requestURI", NON_HTTP_REQ_MSG);
            this.doLog("          authType", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("        requestURI", httpServletRequest.getRequestURI());
            this.doLog("          authType", httpServletRequest.getAuthType());
        }
        this.doLog(" characterEncoding", servletRequest.getCharacterEncoding());
        this.doLog("     contentLength", Long.toString(servletRequest.getContentLengthLong()));
        this.doLog("       contentType", servletRequest.getContentType());
        if (httpServletRequest == null) {
            this.doLog("       contextPath", NON_HTTP_REQ_MSG);
            this.doLog("            cookie", NON_HTTP_REQ_MSG);
            this.doLog("            header", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("       contextPath", httpServletRequest.getContextPath());
            object2 = httpServletRequest.getCookies();
            if (object2 != null) {
                for (Object object3 : object2) {
                    this.doLog("            cookie", object3.getName() + "=" + object3.getValue());
                }
            }
            object = httpServletRequest.getHeaderNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Enumeration enumeration = httpServletRequest.getHeaders(string);
                while (enumeration.hasMoreElements()) {
                    Object object3;
                    object3 = (String)enumeration.nextElement();
                    this.doLog("            header", string + "=" + (String)object3);
                }
            }
        }
        this.doLog("            locale", servletRequest.getLocale().toString());
        if (httpServletRequest == null) {
            this.doLog("            method", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("            method", httpServletRequest.getMethod());
        }
        object2 = servletRequest.getParameterNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String[] stringArray = servletRequest.getParameterValues((String)object);
            StringBuilder stringBuilder = new StringBuilder((String)object);
            stringBuilder.append('=');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
            this.doLog("         parameter", stringBuilder.toString());
        }
        if (httpServletRequest == null) {
            this.doLog("          pathInfo", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("          pathInfo", httpServletRequest.getPathInfo());
        }
        this.doLog("          protocol", servletRequest.getProtocol());
        if (httpServletRequest == null) {
            this.doLog("       queryString", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("       queryString", httpServletRequest.getQueryString());
        }
        this.doLog("        remoteAddr", servletRequest.getRemoteAddr());
        this.doLog("        remoteHost", servletRequest.getRemoteHost());
        if (httpServletRequest == null) {
            this.doLog("        remoteUser", NON_HTTP_REQ_MSG);
            this.doLog("requestedSessionId", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("        remoteUser", httpServletRequest.getRemoteUser());
            this.doLog("requestedSessionId", httpServletRequest.getRequestedSessionId());
        }
        this.doLog("            scheme", servletRequest.getScheme());
        this.doLog("        serverName", servletRequest.getServerName());
        this.doLog("        serverPort", Integer.toString(servletRequest.getServerPort()));
        if (httpServletRequest == null) {
            this.doLog("       servletPath", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("       servletPath", httpServletRequest.getServletPath());
        }
        this.doLog("          isSecure", Boolean.valueOf(servletRequest.isSecure()).toString());
        this.doLog("------------------", "--------------------------------------------");
        filterChain.doFilter(servletRequest, servletResponse);
        this.doLog("------------------", "--------------------------------------------");
        if (httpServletRequest == null) {
            this.doLog("          authType", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("          authType", httpServletRequest.getAuthType());
        }
        this.doLog("       contentType", servletResponse.getContentType());
        if (httpServletResponse == null) {
            this.doLog("            header", NON_HTTP_RES_MSG);
        } else {
            object = httpServletResponse.getHeaderNames();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Collection collection = httpServletResponse.getHeaders(string);
                for (String string2 : collection) {
                    this.doLog("            header", string + "=" + string2);
                }
            }
        }
        if (httpServletRequest == null) {
            this.doLog("        remoteUser", NON_HTTP_REQ_MSG);
        } else {
            this.doLog("        remoteUser", httpServletRequest.getRemoteUser());
        }
        if (httpServletResponse == null) {
            this.doLog("            status", NON_HTTP_RES_MSG);
        } else {
            this.doLog("            status", Integer.toString(httpServletResponse.getStatus()));
        }
        this.doLog("END TIME          ", this.getTimestamp());
        this.doLog("==================", "============================================");
    }

    private void doLog(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append(' ');
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
        this.log.info((Object)stringBuilder.toString());
    }

    private String getTimestamp() {
        Timestamp timestamp = RequestDumperFilter.timestamp.get();
        long l = System.currentTimeMillis();
        if (timestamp.date.getTime() + 999L < l) {
            timestamp.date.setTime(l - l % 1000L);
            timestamp.update();
        }
        return timestamp.dateString;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog(RequestDumperFilter.class);
    }

    private static final class Timestamp {
        private final Date date = new Date(0L);
        private final SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        private String dateString = this.format.format(this.date);

        private Timestamp() {
        }

        private void update() {
            this.dateString = this.format.format(this.date);
        }
    }
}

